/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.net.InetAddress;
import java.util.Properties;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.MembershipListener;
import org.apache.catalina.cluster.MembershipService;
import org.apache.catalina.cluster.mcast.McastMember;
import org.apache.catalina.cluster.mcast.McastServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class McastService
implements MembershipService,
MembershipListener {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$mcast$McastService == null ? (class$org$apache$catalina$cluster$mcast$McastService = McastService.class$("org.apache.catalina.cluster.mcast.McastService")) : class$org$apache$catalina$cluster$mcast$McastService));
    protected Properties properties;
    protected McastServiceImpl impl;
    protected MembershipListener listener;
    protected McastMember localMember;
    static /* synthetic */ Class class$org$apache$catalina$cluster$mcast$McastService;

    public void setProperties(Properties properties) {
        this.hasProperty(properties, "mcastPort");
        this.hasProperty(properties, "mcastAddress");
        this.hasProperty(properties, "memberDropTime");
        this.hasProperty(properties, "msgFrequency");
        this.hasProperty(properties, "tcpListenPort");
        this.hasProperty(properties, "tcpListenHost");
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Member getLocalMember() {
        this.localMember.setMemberAliveTime(System.currentTimeMillis() - this.impl.getServiceStartTime());
        return this.localMember;
    }

    protected void hasProperty(Properties properties, String name) {
        if (properties.getProperty(name) == null) {
            throw new IllegalArgumentException("Required property \"" + name + "\" is missing.");
        }
    }

    public void start() throws Exception {
        if (this.impl != null) {
            return;
        }
        String host = this.getProperties().getProperty("tcpListenHost");
        int port = Integer.parseInt(this.getProperties().getProperty("tcpListenPort"));
        String name = "tcp://" + host + ":" + port;
        this.localMember = new McastMember(name, host, port, 0L);
        this.impl = new McastServiceImpl(this.localMember, Long.parseLong(this.properties.getProperty("msgFrequency")), Long.parseLong(this.properties.getProperty("memberDropTime")), Integer.parseInt(this.properties.getProperty("mcastPort")), null, InetAddress.getByName(this.properties.getProperty("mcastAddress")), this);
        this.impl.start();
    }

    public void stop() {
        try {
            if (this.impl != null) {
                this.impl.stop();
            }
        }
        catch (Exception x) {
            log.error((Object)"Unable to stop the mcast service.", (Throwable)x);
        }
        this.impl = null;
    }

    public Member[] getMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return null;
        }
        return this.impl.membership.getMembers();
    }

    public void addMembershipListener(MembershipListener listener) {
        this.listener = listener;
    }

    public void removeMembershipListener() {
        this.listener = null;
    }

    public void memberAdded(Member member) {
        if (this.listener != null) {
            this.listener.memberAdded(member);
        }
    }

    public void memberDisappeared(Member member) {
        if (this.listener != null) {
            this.listener.memberDisappeared(member);
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Usage McastService hostname tcpport");
        McastService service = new McastService();
        Properties p = new Properties();
        p.setProperty("mcastPort", "5555");
        p.setProperty("mcastAddress", "224.10.10.10");
        p.setProperty("bindAddress", "localhost");
        p.setProperty("memberDropTime", "3000");
        p.setProperty("msgFrequency", "500");
        p.setProperty("tcpListenPort", args[1]);
        p.setProperty("tcpListenHost", args[0]);
        service.setProperties(p);
        service.start();
        Thread.currentThread();
        Thread.sleep(3600000L);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

