/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.io.XByteBuffer;

public class ObjectReader {
    private SocketChannel channel;
    private Selector selector;
    private ListenCallback callback;
    private XByteBuffer buffer;

    public ObjectReader(SocketChannel channel, Selector selector, ListenCallback callback) {
        this.channel = channel;
        this.selector = selector;
        this.callback = callback;
        this.buffer = new XByteBuffer();
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public boolean append(byte[] data, int off, int len) {
        boolean result = false;
        this.buffer.append(data, off, len);
        if (this.buffer.doesPackageExist()) {
            byte[] b = this.buffer.extractPackage(true);
            this.callback.messageDataReceived(b);
            result = true;
        }
        return result;
    }

    public boolean execute() {
        boolean result = false;
        if (this.buffer.doesPackageExist()) {
            byte[] data = this.buffer.extractPackage(true);
            this.callback.messageDataReceived(data);
            result = true;
        }
        return result;
    }

    public int write(ByteBuffer buf) throws IOException {
        return this.getChannel().write(buf);
    }
}

