/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.jdbc2pool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.dbcp.jdbc2pool.CPDSConnectionFactory;
import org.apache.commons.dbcp.jdbc2pool.KeyedCPDSConnectionFactory;
import org.apache.commons.dbcp.jdbc2pool.PoolKey;
import org.apache.commons.dbcp.jdbc2pool.UserPassKey;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.StackObjectPool;

public class Jdbc2PoolDataSource
implements DataSource,
Referenceable,
Serializable,
ObjectFactory {
    private static final String GET_CONNECTION_CALLED = "A Connection was already requested from this source, further initialization is not allowed.";
    private static Map dsInstanceMap;
    private static ObjectPool userPassKeyPool;
    private static ObjectPool poolKeyPool;
    private boolean getConnectionCalled = false;
    private ConnectionPoolDataSource cpds;
    private String dataSourceName;
    private boolean defaultAutoCommit = true;
    private int defaultMaxActive = 0;
    private int defaultMaxIdle = 0;
    private int defaultMaxWait = -1;
    private boolean defaultReadOnly;
    private String description;
    private Properties jndiEnvironment;
    private int loginTimeout;
    private PrintWriter logWriter;
    private Map perUserDefaultAutoCommit;
    private Map perUserMaxActive;
    private Map perUserMaxIdle;
    private Map perUserMaxWait;
    private Map perUserDefaultReadOnly;
    private boolean _testOnBorrow;
    private boolean _testOnReturn;
    private int _timeBetweenEvictionRunsMillis;
    private int _numTestsPerEvictionRun;
    private int _minEvictableIdleTimeMillis;
    private boolean _testWhileIdle;
    private String validationQuery = null;
    private boolean testPositionSet;
    private boolean isNew = true;
    private Integer instanceKey;

    private void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.cpds;
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource v) {
        this.assertInitializationAllowed();
        if (this.dataSourceName != null) {
            throw new IllegalStateException("Cannot set the DataSource, if JNDI is used.");
        }
        this.cpds = v;
        if (this.isNew) {
            this.registerInstance();
        }
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String v) {
        this.assertInitializationAllowed();
        if (this.cpds != null) {
            throw new IllegalStateException("Cannot set the JNDI name for the DataSource, if already set using setConnectionPoolDataSource.");
        }
        this.dataSourceName = v;
        if (this.isNew) {
            this.registerInstance();
        }
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean v) {
        this.assertInitializationAllowed();
        this.defaultAutoCommit = v;
    }

    public int getDefaultMaxActive() {
        return this.defaultMaxActive;
    }

    public void setDefaultMaxActive(int maxActive) {
        this.assertInitializationAllowed();
        this.defaultMaxActive = maxActive;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public void setDefaultMaxIdle(int defaultMaxIdle) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = defaultMaxIdle;
    }

    public int getDefaultMaxWait() {
        return this.defaultMaxWait;
    }

    public void setDefaultMaxWait(int defaultMaxWait) {
        this.assertInitializationAllowed();
        this.defaultMaxWait = defaultMaxWait;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean v) {
        this.assertInitializationAllowed();
        this.defaultReadOnly = v;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    public String getJndiEnvironment(String key) {
        String value = null;
        if (this.jndiEnvironment != null) {
            value = this.jndiEnvironment.getProperty(key);
        }
        return value;
    }

    public void setJndiEnvironment(String key, String value) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        }
        this.jndiEnvironment.setProperty(key, value);
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int v) {
        this.loginTimeout = v;
    }

    public PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(System.out);
        }
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter v) {
        this.logWriter = v;
    }

    public Boolean getPerUserDefaultAutoCommit(String key) {
        Boolean value = null;
        if (this.perUserDefaultAutoCommit != null) {
            value = (Boolean)this.perUserDefaultAutoCommit.get(key);
        }
        return value;
    }

    public void setPerUserDefaultAutoCommit(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = new HashMap();
        }
        this.perUserDefaultAutoCommit.put(username, value);
    }

    public Integer getPerUserMaxActive(String username) {
        Integer value = null;
        if (this.perUserMaxActive != null) {
            value = (Integer)this.perUserMaxActive.get(username);
        }
        return value;
    }

    public void setPerUserMaxActive(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxActive == null) {
            this.perUserMaxActive = new HashMap();
        }
        this.perUserMaxActive.put(username, value);
    }

    public Integer getPerUserMaxIdle(String username) {
        Integer value = null;
        if (this.perUserMaxIdle != null) {
            value = (Integer)this.perUserMaxIdle.get(username);
        }
        return value;
    }

    public void setPerUserMaxIdle(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap();
        }
        this.perUserMaxIdle.put(username, value);
    }

    public Integer getPerUserMaxWait(String username) {
        Integer value = null;
        if (this.perUserMaxWait != null) {
            value = (Integer)this.perUserMaxWait.get(username);
        }
        return value;
    }

    public void setPerUserMaxWait(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWait == null) {
            this.perUserMaxWait = new HashMap();
        }
        this.perUserMaxWait.put(username, value);
    }

    public Boolean getPerUserDefaultReadOnly(String username) {
        Boolean value = null;
        if (this.perUserDefaultReadOnly != null) {
            value = (Boolean)this.perUserDefaultReadOnly.get(username);
        }
        return value;
    }

    public void setPerUserDefaultReadOnly(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = new HashMap();
        }
        this.perUserDefaultReadOnly.put(username, value);
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.assertInitializationAllowed();
        this._testOnBorrow = testOnBorrow;
        this.testPositionSet = true;
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.assertInitializationAllowed();
        this._testOnReturn = testOnReturn;
        this.testPositionSet = true;
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.assertInitializationAllowed();
        this._timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.assertInitializationAllowed();
        this._numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public int getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.assertInitializationAllowed();
        this._minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.assertInitializationAllowed();
        this._testWhileIdle = testWhileIdle;
        this.testPositionSet = true;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.assertInitializationAllowed();
        this.validationQuery = validationQuery;
        if (!this.testPositionSet) {
            this.setTestOnBorrow(true);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public synchronized Connection getConnection(String username, String password) throws SQLException {
        Boolean userMax;
        Boolean userMax2;
        PoolKey key;
        if (this.isNew) {
            throw new SQLException("Must set the ConnectionPoolDataSource through setDataSourceName or setConnectionPoolDataSource before calling getConnection.");
        }
        this.getConnectionCalled = true;
        Map pools = (Map)dsInstanceMap.get(this.instanceKey);
        Object pool = pools.get(key = this.getPoolKey(username));
        if (pool == null) {
            try {
                this.registerPool(username, password);
                pool = pools.get(key);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        this.returnPoolKey(key);
        PooledConnection pc = null;
        if (pool instanceof ObjectPool) {
            try {
                pc = (PooledConnection)((ObjectPool)pool).borrowObject();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new SQLException(e.getMessage());
            }
        }
        try {
            UserPassKey upkey = this.getPCKey(username, password);
            pc = (PooledConnection)((KeyedObjectPool)pool).borrowObject((Object)upkey);
            this.returnPCKey(upkey);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new SQLException(e.getMessage());
        }
        boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (username != null && (userMax2 = this.getPerUserDefaultAutoCommit(username)) != null) {
            defaultAutoCommit = userMax2;
        }
        boolean defaultReadOnly = this.isDefaultReadOnly();
        if (username != null && (userMax = this.getPerUserDefaultReadOnly(username)) != null) {
            defaultReadOnly = userMax;
        }
        Connection con = pc.getConnection();
        con.setAutoCommit(defaultAutoCommit);
        con.setReadOnly(defaultReadOnly);
        return con;
    }

    private UserPassKey getPCKey(String username, String password) {
        UserPassKey upk = null;
        try {
            upk = (UserPassKey)userPassKeyPool.borrowObject();
        }
        catch (Exception e) {
            this.getLogWriter().println("[WARN] Jdbc2PoolDataSource::getPCKey could not get key from pool. Created a new instance. " + e.getMessage());
            upk = new UserPassKey();
        }
        upk.init(username, password);
        return upk;
    }

    private void returnPCKey(UserPassKey key) {
        if (key.isReusable()) {
            try {
                userPassKeyPool.returnObject((Object)key);
            }
            catch (Exception e) {
                this.getLogWriter().println("[WARN] Jdbc2PoolDataSource::returnPCKey could not return key to pool. " + e.getMessage());
            }
        }
    }

    private PoolKey getPoolKey(String username) {
        PoolKey key = null;
        try {
            key = (PoolKey)poolKeyPool.borrowObject();
        }
        catch (Exception e) {
            this.getLogWriter().println("[WARN] Jdbc2PoolDataSource::getPoolKey could not get key from pool. Created a new instance. " + e.getMessage());
            key = new PoolKey();
        }
        if (!(username == null || this.perUserMaxActive != null && this.perUserMaxActive.containsKey(username))) {
            username = null;
        }
        key.init(this.getDataSourceName(), username);
        return key;
    }

    private void returnPoolKey(PoolKey key) {
        try {
            poolKeyPool.returnObject((Object)key);
        }
        catch (Exception e) {
            this.getLogWriter().println("[WARN] Jdbc2PoolDataSource::returnPoolKey could not return key to pool. " + e.getMessage());
        }
    }

    private synchronized void registerInstance() {
        if (this.isNew) {
            int max = 0;
            Iterator i = dsInstanceMap.keySet().iterator();
            while (i.hasNext()) {
                int key = (Integer)i.next();
                max = Math.max(max, key);
            }
            this.instanceKey = new Integer(max + 1);
            FastHashMap fhm = new FastHashMap();
            fhm.setFast(true);
            dsInstanceMap.put(this.instanceKey, fhm);
            this.isNew = false;
        }
    }

    private synchronized void registerPool(String username, String password) throws NamingException {
        PoolKey key;
        Map pools = (Map)dsInstanceMap.get(this.instanceKey);
        if (!pools.containsKey(key = this.getPoolKey(username))) {
            int maxActive = this.getDefaultMaxActive();
            int maxIdle = this.getDefaultMaxIdle();
            int maxWait = this.getDefaultMaxWait();
            ConnectionPoolDataSource cpds = this.cpds;
            if (cpds == null) {
                InitialContext ctx = null;
                ctx = this.jndiEnvironment == null ? new InitialContext() : new InitialContext(this.jndiEnvironment);
                cpds = (ConnectionPoolDataSource)ctx.lookup(this.dataSourceName);
            }
            GenericKeyedObjectPool whicheverPool = null;
            if (this.perUserMaxActive != null && this.perUserMaxActive.containsKey(username)) {
                Integer userMax = this.getPerUserMaxActive(username);
                if (userMax != null) {
                    maxActive = userMax;
                }
                if ((userMax = this.getPerUserMaxIdle(username)) != null) {
                    maxIdle = userMax;
                }
                if ((userMax = this.getPerUserMaxWait(username)) != null) {
                    maxWait = userMax;
                }
                GenericObjectPool pool = new GenericObjectPool(null);
                pool.setMaxActive(maxActive);
                pool.setMaxIdle(maxIdle);
                pool.setMaxWait((long)maxWait);
                pool.setWhenExhaustedAction(this.getWhenExhausted(maxActive, maxWait));
                pool.setTestOnBorrow(this.getTestOnBorrow());
                pool.setTestOnReturn(this.getTestOnReturn());
                pool.setTimeBetweenEvictionRunsMillis((long)this.getTimeBetweenEvictionRunsMillis());
                pool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
                pool.setMinEvictableIdleTimeMillis((long)this.getMinEvictableIdleTimeMillis());
                pool.setTestWhileIdle(this.getTestWhileIdle());
                new CPDSConnectionFactory(cpds, (ObjectPool)pool, this.validationQuery, username, password);
                whicheverPool = pool;
            } else {
                GenericKeyedObjectPool pool = new GenericKeyedObjectPool(null);
                pool.setMaxActive(maxActive);
                pool.setMaxIdle(maxIdle);
                pool.setMaxWait((long)maxWait);
                pool.setWhenExhaustedAction(this.getWhenExhausted(maxActive, maxWait));
                pool.setTestOnBorrow(this.getTestOnBorrow());
                pool.setTestOnReturn(this.getTestOnReturn());
                pool.setTimeBetweenEvictionRunsMillis((long)this.getTimeBetweenEvictionRunsMillis());
                pool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
                pool.setMinEvictableIdleTimeMillis((long)this.getMinEvictableIdleTimeMillis());
                pool.setTestWhileIdle(this.getTestWhileIdle());
                new KeyedCPDSConnectionFactory(cpds, (KeyedObjectPool)pool, this.validationQuery);
                whicheverPool = pool;
            }
            pools.put(key, whicheverPool);
        }
    }

    private byte getWhenExhausted(int maxActive, int maxWait) {
        byte whenExhausted = 1;
        if (maxActive <= 0) {
            whenExhausted = 2;
        } else if (maxWait == 0) {
            whenExhausted = 0;
        }
        return whenExhausted;
    }

    public Reference getReference() throws NamingException {
        String factory = this.getClass().getName();
        Reference ref = new Reference(this.getClass().getName(), factory, null);
        ref.add(new StringRefAddr("isNew", String.valueOf(this.isNew)));
        ref.add(new StringRefAddr("instanceKey", this.instanceKey == null ? null : this.instanceKey.toString()));
        ref.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        ref.add(new StringRefAddr("defaultAutoCommit", String.valueOf(this.isDefaultAutoCommit())));
        ref.add(new StringRefAddr("defaultMaxActive", String.valueOf(this.getDefaultMaxActive())));
        ref.add(new StringRefAddr("defaultMaxIdle", String.valueOf(this.getDefaultMaxIdle())));
        ref.add(new StringRefAddr("defaultMaxWait", String.valueOf(this.getDefaultMaxWait())));
        ref.add(new StringRefAddr("defaultReadOnly", String.valueOf(this.isDefaultReadOnly())));
        ref.add(new StringRefAddr("description", this.getDescription()));
        byte[] ser = null;
        if (this.jndiEnvironment != null) {
            try {
                ser = Jdbc2PoolDataSource.serialize(this.jndiEnvironment);
                ref.add(new BinaryRefAddr("jndiEnvironment", ser));
            }
            catch (IOException ioe) {
                throw new NamingException("An IOException prevented serializing the jndiEnvironment properties.");
            }
        }
        ref.add(new StringRefAddr("loginTimeout", String.valueOf(this.getLoginTimeout())));
        if (this.perUserDefaultAutoCommit != null) {
            try {
                ser = Jdbc2PoolDataSource.serialize((Serializable)((Object)this.perUserDefaultAutoCommit));
                ref.add(new BinaryRefAddr("perUserDefaultAutoCommit", ser));
            }
            catch (IOException ioe) {
                throw new NamingException("An IOException prevented serializing the perUserDefaultAutoCommit properties.");
            }
        }
        if (this.perUserMaxActive != null) {
            try {
                ser = Jdbc2PoolDataSource.serialize((Serializable)((Object)this.perUserMaxActive));
                ref.add(new BinaryRefAddr("perUserMaxActive", ser));
            }
            catch (IOException ioe) {
                throw new NamingException("An IOException prevented serializing the perUserMaxActive properties.");
            }
        }
        if (this.perUserMaxIdle != null) {
            try {
                ser = Jdbc2PoolDataSource.serialize((Serializable)((Object)this.perUserMaxIdle));
                ref.add(new BinaryRefAddr("perUserMaxIdle", ser));
            }
            catch (IOException ioe) {
                throw new NamingException("An IOException prevented serializing the perUserMaxIdle properties.");
            }
        }
        if (this.perUserMaxWait != null) {
            try {
                ser = Jdbc2PoolDataSource.serialize((Serializable)((Object)this.perUserMaxWait));
                ref.add(new BinaryRefAddr("perUserMaxWait", ser));
            }
            catch (IOException ioe) {
                throw new NamingException("An IOException prevented serializing the perUserMaxWait properties.");
            }
        }
        if (this.perUserDefaultReadOnly != null) {
            try {
                ser = Jdbc2PoolDataSource.serialize((Serializable)((Object)this.perUserDefaultReadOnly));
                ref.add(new BinaryRefAddr("perUserDefaultReadOnly", ser));
            }
            catch (IOException ioe) {
                throw new NamingException("An IOException prevented serializing the perUserDefaultReadOnly properties.");
            }
        }
        ref.add(new StringRefAddr("testOnBorrow", String.valueOf(this.getTestOnBorrow())));
        ref.add(new StringRefAddr("testOnReturn", String.valueOf(this.getTestOnReturn())));
        ref.add(new StringRefAddr("timeBetweenEvictionRunsMillis", String.valueOf(this.getTimeBetweenEvictionRunsMillis())));
        ref.add(new StringRefAddr("numTestsPerEvictionRun", String.valueOf(this.getNumTestsPerEvictionRun())));
        ref.add(new StringRefAddr("minEvictableIdleTimeMillis", String.valueOf(this.getMinEvictableIdleTimeMillis())));
        ref.add(new StringRefAddr("testWhileIdle", String.valueOf(this.getTestWhileIdle())));
        ref.add(new StringRefAddr("validationQuery", this.getValidationQuery()));
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] serialize(Serializable obj) throws IOException {
        byte[] byteArray = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            byteArray = baos.toByteArray();
            Object var5_4 = null;
            if (out == null) return byteArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
        return byteArray;
    }

    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable env) throws Exception {
        Reference ref;
        Jdbc2PoolDataSource ds = null;
        if (refObj instanceof Reference && (ref = (Reference)refObj).getClassName().equals(this.getClass().getName())) {
            byte[] serialized;
            RefAddr ra = ref.get("isNew");
            if (ra != null && ra.getContent() != null) {
                this.isNew = Boolean.getBoolean(ra.getContent().toString());
            }
            if ((ra = ref.get("instanceKey")) != null && ra.getContent() != null) {
                this.instanceKey = new Integer(ra.getContent().toString());
            }
            if ((ra = ref.get("dataSourceName")) != null && ra.getContent() != null) {
                this.setDataSourceName(ra.getContent().toString());
            }
            if ((ra = ref.get("defaultAutoCommit")) != null && ra.getContent() != null) {
                this.setDefaultAutoCommit(Boolean.getBoolean(ra.getContent().toString()));
            }
            if ((ra = ref.get("defaultMaxActive")) != null && ra.getContent() != null) {
                this.setDefaultMaxActive(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("defaultMaxIdle")) != null && ra.getContent() != null) {
                this.setDefaultMaxIdle(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("defaultMaxWait")) != null && ra.getContent() != null) {
                this.setDefaultMaxWait(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("defaultReadOnly")) != null && ra.getContent() != null) {
                this.setDefaultReadOnly(Boolean.getBoolean(ra.getContent().toString()));
            }
            if ((ra = ref.get("description")) != null && ra.getContent() != null) {
                this.setDescription(ra.getContent().toString());
            }
            if ((ra = ref.get("jndiEnvironment")) != null && ra.getContent() != null) {
                serialized = (byte[])ra.getContent();
                this.jndiEnvironment = (Properties)SerializationUtils.deserialize((byte[])serialized);
            }
            if ((ra = ref.get("loginTimeout")) != null && ra.getContent() != null) {
                this.setLoginTimeout(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("perUserDefaultAutoCommit")) != null && ra.getContent() != null) {
                serialized = (byte[])ra.getContent();
                this.perUserDefaultAutoCommit = (Map)SerializationUtils.deserialize((byte[])serialized);
            }
            if ((ra = ref.get("perUserMaxActive")) != null && ra.getContent() != null) {
                serialized = (byte[])ra.getContent();
                this.perUserMaxActive = (Map)SerializationUtils.deserialize((byte[])serialized);
            }
            if ((ra = ref.get("perUserMaxIdle")) != null && ra.getContent() != null) {
                serialized = (byte[])ra.getContent();
                this.perUserMaxIdle = (Map)SerializationUtils.deserialize((byte[])serialized);
            }
            if ((ra = ref.get("perUserMaxWait")) != null && ra.getContent() != null) {
                serialized = (byte[])ra.getContent();
                this.perUserMaxWait = (Map)SerializationUtils.deserialize((byte[])serialized);
            }
            if ((ra = ref.get("perUserDefaultReadOnly")) != null && ra.getContent() != null) {
                serialized = (byte[])ra.getContent();
                this.perUserDefaultReadOnly = (Map)SerializationUtils.deserialize((byte[])serialized);
            }
            if ((ra = ref.get("testOnBorrow")) != null && ra.getContent() != null) {
                this.setTestOnBorrow(Boolean.getBoolean(ra.getContent().toString()));
            }
            if ((ra = ref.get("testOnReturn")) != null && ra.getContent() != null) {
                this.setTestOnReturn(Boolean.getBoolean(ra.getContent().toString()));
            }
            if ((ra = ref.get("timeBetweenEvictionRunsMillis")) != null && ra.getContent() != null) {
                this.setTimeBetweenEvictionRunsMillis(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("numTestsPerEvictionRun")) != null && ra.getContent() != null) {
                this.setNumTestsPerEvictionRun(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("minEvictableIdleTimeMillis")) != null && ra.getContent() != null) {
                this.setMinEvictableIdleTimeMillis(Integer.parseInt(ra.getContent().toString()));
            }
            if ((ra = ref.get("testWhileIdle")) != null && ra.getContent() != null) {
                this.setTestWhileIdle(Boolean.getBoolean(ra.getContent().toString()));
            }
            if ((ra = ref.get("validationQuery")) != null && ra.getContent() != null) {
                this.setValidationQuery(ra.getContent().toString());
            }
            ds = this;
        }
        return ds;
    }

    static {
        GET_CONNECTION_CALLED = GET_CONNECTION_CALLED;
        dsInstanceMap = new HashMap();
        userPassKeyPool = new StackObjectPool((PoolableObjectFactory)new UserPassKey.Factory(), 256);
        poolKeyPool = new StackObjectPool((PoolableObjectFactory)new PoolKey.Factory(), 256);
    }
}

