/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.jdbc2pool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

class CPDSConnectionFactory
implements PoolableObjectFactory,
ConnectionEventListener {
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected String _username = null;
    protected String _password = null;
    private Map validatingMap = new HashMap();

    public CPDSConnectionFactory(ConnectionPoolDataSource cpds, ObjectPool pool, String validationQuery, String username, String password) {
        this._cpds = cpds;
        this._pool = pool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._validationQuery = validationQuery;
        this._username = username;
        this._password = password;
    }

    public synchronized void setCPDS(ConnectionPoolDataSource cpds) {
        this._cpds = cpds;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(ObjectPool pool) throws SQLException {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new SQLException(e.getMessage());
            }
        }
        this._pool = pool;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject() {
        PooledConnection pc = null;
        try {
            pc = this._username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(this._username, this._password);
            pc.addConnectionEventListener(this);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return pc;
    }

    public void destroyObject(Object obj) {
        if (obj instanceof PooledConnection) {
            try {
                ((PooledConnection)obj).close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean validateObject(Object obj) {
        boolean valid;
        block24: {
            valid = false;
            if (obj instanceof PooledConnection) {
                PooledConnection pconn = (PooledConnection)obj;
                String query = this._validationQuery;
                if (null != query) {
                    ResultSet rset;
                    Statement stmt;
                    Connection conn;
                    block20: {
                        conn = null;
                        stmt = null;
                        rset = null;
                        this.validatingMap.put(pconn, null);
                        conn = pconn.getConnection();
                        stmt = conn.createStatement();
                        rset = stmt.executeQuery(query);
                        if (rset.next()) {
                            valid = true;
                            break block20;
                        }
                        valid = false;
                    }
                    Object var10_8 = null;
                    try {
                        rset.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        stmt.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.validatingMap.remove(pconn);
                    {
                        break block24;
                        catch (Exception e) {
                            valid = false;
                            Object var10_9 = null;
                            try {
                                rset.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            try {
                                stmt.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            try {
                                conn.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            this.validatingMap.remove(pconn);
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        try {
                            rset.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            conn.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        this.validatingMap.remove(pconn);
                        throw throwable;
                    }
                }
                valid = true;
            } else {
                valid = false;
            }
        }
        return valid;
    }

    public void passivateObject(Object obj) {
    }

    public void activateObject(Object obj) {
    }

    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingMap.containsKey(pc)) {
            try {
                this._pool.returnObject((Object)pc);
            }
            catch (Exception e) {
                this.destroyObject(pc);
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR");
            pc.removeConnectionEventListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.destroyObject(pc);
    }
}

