/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.realm.User;
import org.apache.catalina.util.Base64;

public class JNDIRealm
extends RealmBase {
    protected String authentication = null;
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected DirContext context = null;
    protected String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    protected static final String info = "org.apache.catalina.realm.JNDIRealm/1.0";
    protected static final String name = "JNDIRealm";
    protected String protocol = null;
    protected String referrals = null;
    protected String userBase = "";
    protected String userSearch = null;
    protected MessageFormat userSearchFormat = null;
    protected boolean userSubtree = false;
    protected String userPassword = null;
    protected String userPattern = null;
    protected MessageFormat userPatternFormat = null;
    protected String roleBase = "";
    protected MessageFormat roleFormat = null;
    protected String userRoleName = null;
    protected String roleName = null;
    protected String roleSearch = null;
    protected boolean roleSubtree = false;
    protected String alternateURL;
    protected int connectionAttempt = 0;

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getReferrals() {
        return this.referrals;
    }

    public void setReferrals(String referrals) {
        this.referrals = referrals;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserBase(String userBase) {
        this.userBase = userBase;
    }

    public String getUserSearch() {
        return this.userSearch;
    }

    public void setUserSearch(String userSearch) {
        this.userSearch = userSearch;
        this.userSearchFormat = userSearch == null ? null : new MessageFormat(userSearch);
    }

    public boolean getUserSubtree() {
        return this.userSubtree;
    }

    public void setUserSubtree(boolean userSubtree) {
        this.userSubtree = userSubtree;
    }

    public String getUserRoleName() {
        return this.userRoleName;
    }

    public void setUserRoleName(String userRoleName) {
        this.userRoleName = userRoleName;
    }

    public String getRoleBase() {
        return this.roleBase;
    }

    public void setRoleBase(String roleBase) {
        this.roleBase = roleBase;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleSearch() {
        return this.roleSearch;
    }

    public void setRoleSearch(String roleSearch) {
        this.roleSearch = roleSearch;
        this.roleFormat = roleSearch == null ? null : new MessageFormat(roleSearch);
    }

    public boolean getRoleSubtree() {
        return this.roleSubtree;
    }

    public void setRoleSubtree(boolean roleSubtree) {
        this.roleSubtree = roleSubtree;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public String getUserPattern() {
        return this.userPattern;
    }

    public void setUserPattern(String userPattern) {
        this.userPattern = userPattern;
        this.userPatternFormat = userPattern == null ? null : new MessageFormat(userPattern);
    }

    public String getAlternateURL() {
        return this.alternateURL;
    }

    public void setAlternateURL(String alternateURL) {
        this.alternateURL = alternateURL;
    }

    public Principal authenticate(String username, String credentials) {
        DirContext context = null;
        Principal principal = null;
        try {
            context = this.open();
            try {
                principal = this.authenticate(context, username, credentials);
            }
            catch (CommunicationException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("closed") < 0) {
                    throw e;
                }
                this.log(sm.getString("jndiRealm.exception"), e);
                if (context != null) {
                    this.close(context);
                }
                context = this.open();
                principal = this.authenticate(context, username, credentials);
            }
            this.release(context);
            return principal;
        }
        catch (NamingException e) {
            this.log(sm.getString("jndiRealm.exception"), e);
            if (context != null) {
                this.close(context);
            }
            return null;
        }
    }

    public synchronized Principal authenticate(DirContext context, String username, String credentials) throws NamingException {
        if (username == null || username.equals("") || credentials == null || credentials.equals("")) {
            return null;
        }
        User user = this.getUser(context, username);
        if (user == null) {
            return null;
        }
        if (!this.checkCredentials(context, user, credentials)) {
            return null;
        }
        List roles = this.getRoles(context, user);
        return new GenericPrincipal((Realm)this, username, credentials, roles);
    }

    protected User getUser(DirContext context, String username) throws NamingException {
        User user = null;
        ArrayList<String> list = new ArrayList<String>();
        if (this.userPassword != null) {
            list.add(this.userPassword);
        }
        if (this.userRoleName != null) {
            list.add(this.userRoleName);
        }
        String[] attrIds = new String[list.size()];
        list.toArray(attrIds);
        user = this.userPatternFormat != null ? this.getUserByPattern(context, username, attrIds) : this.getUserBySearch(context, username, attrIds);
        return user;
    }

    protected User getUserByPattern(DirContext context, String username, String[] attrIds) throws NamingException {
        if (this.debug >= 2) {
            this.log("lookupUser(" + username + ")");
        }
        if (username == null || this.userPatternFormat == null) {
            return null;
        }
        String dn = this.userPatternFormat.format(new String[]{username});
        if (this.debug >= 3) {
            this.log("  dn=" + dn);
        }
        if (attrIds == null || attrIds.length == 0) {
            return new User(username, dn, null, null);
        }
        Attributes attrs = null;
        try {
            attrs = context.getAttributes(dn, attrIds);
        }
        catch (NameNotFoundException e) {
            return null;
        }
        if (attrs == null) {
            return null;
        }
        String password = null;
        if (this.userPassword != null) {
            password = this.getAttributeValue(this.userPassword, attrs);
        }
        ArrayList roles = null;
        if (this.userRoleName != null) {
            roles = this.addAttributeValues(this.userRoleName, attrs, roles);
        }
        return new User(username, dn, password, roles);
    }

    protected User getUserBySearch(DirContext context, String username, String[] attrIds) throws NamingException {
        Attributes attrs;
        NamingEnumeration<SearchResult> results;
        if (username == null || this.userSearchFormat == null) {
            return null;
        }
        String filter = this.userSearchFormat.format(new String[]{username});
        SearchControls constraints = new SearchControls();
        if (this.userSubtree) {
            constraints.setSearchScope(2);
        } else {
            constraints.setSearchScope(1);
        }
        if (attrIds == null) {
            attrIds = new String[]{};
        }
        constraints.setReturningAttributes(attrIds);
        if (this.debug > 3) {
            this.log("  Searching for " + username);
            this.log("  base: " + this.userBase + "  filter: " + filter);
        }
        if ((results = context.search(this.userBase, filter, constraints)) == null || !results.hasMore()) {
            if (this.debug > 2) {
                this.log("  username not found");
            }
            return null;
        }
        SearchResult result = results.next();
        if (results.hasMore()) {
            this.log("username " + username + " has multiple entries");
            return null;
        }
        NameParser parser = context.getNameParser("");
        Name contextName = parser.parse(context.getNameInNamespace());
        Name baseName = parser.parse(this.userBase);
        Name entryName = parser.parse(result.getName());
        Name name = contextName.addAll(baseName);
        name = name.addAll(entryName);
        String dn = name.toString();
        if (this.debug > 2) {
            this.log("  entry found for " + username + " with dn " + dn);
        }
        if ((attrs = result.getAttributes()) == null) {
            return null;
        }
        String password = null;
        if (this.userPassword != null) {
            password = this.getAttributeValue(this.userPassword, attrs);
        }
        ArrayList roles = null;
        if (this.userRoleName != null) {
            roles = this.addAttributeValues(this.userRoleName, attrs, roles);
        }
        return new User(username, dn, password, roles);
    }

    protected boolean checkCredentials(DirContext context, User user, String credentials) throws NamingException {
        boolean validated = false;
        validated = this.userPassword == null ? this.bindAsUser(context, user, credentials) : this.compareCredentials(context, user, credentials);
        if (this.debug >= 2) {
            if (validated) {
                this.log(sm.getString("jndiRealm.authenticateSuccess", (Object)user.username));
            } else {
                this.log(sm.getString("jndiRealm.authenticateFailure", (Object)user.username));
            }
        }
        return validated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compareCredentials(DirContext context, User info, String credentials) throws NamingException {
        if (info == null || credentials == null) {
            return false;
        }
        String password = info.password;
        if (password == null) {
            return false;
        }
        if (this.debug >= 3) {
            this.log("  validating credentials");
        }
        boolean validated = false;
        if (this.hasMessageDigest()) {
            if (password.startsWith("{SHA}")) {
                JNDIRealm jNDIRealm = this;
                synchronized (jNDIRealm) {
                    password = password.substring(5);
                    this.md.reset();
                    this.md.update(credentials.getBytes());
                    String digestedPassword = new String(Base64.encode((byte[])this.md.digest()));
                    validated = password.equals(digestedPassword);
                }
            } else {
                validated = this.digest(credentials).equalsIgnoreCase(password);
            }
        } else {
            validated = this.digest(credentials).equals(password);
        }
        return validated;
    }

    protected boolean bindAsUser(DirContext context, User user, String credentials) throws NamingException {
        boolean validated;
        block10: {
            if (credentials == null || user == null) {
                return false;
            }
            String dn = user.dn;
            if (dn == null) {
                return false;
            }
            if (this.debug >= 3) {
                this.log("  validating credentials by binding as the user");
            }
            context.addToEnvironment("java.naming.security.principal", dn);
            context.addToEnvironment("java.naming.security.credentials", credentials);
            validated = false;
            try {
                if (this.debug > 2) {
                    this.log("  binding as " + dn);
                }
                Attributes attr = context.getAttributes("", null);
                validated = true;
            }
            catch (AuthenticationException e) {
                if (this.debug <= 2) break block10;
                this.log("  bind attempt failed");
            }
        }
        if (this.connectionName != null) {
            context.addToEnvironment("java.naming.security.principal", this.connectionName);
        } else {
            context.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.connectionPassword != null) {
            context.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
        } else {
            context.removeFromEnvironment("java.naming.security.credentials");
        }
        return validated;
    }

    protected List getRoles(DirContext context, User user) throws NamingException {
        NamingEnumeration<SearchResult> results;
        ArrayList list;
        if (user == null) {
            return null;
        }
        String dn = user.dn;
        String username = user.username;
        if (dn == null || username == null) {
            return null;
        }
        if (this.debug >= 2) {
            this.log("  getRoles(" + dn + ")");
        }
        if ((list = user.roles) == null) {
            list = new ArrayList();
        }
        if (this.roleFormat == null || this.roleName == null) {
            return list;
        }
        String filter = this.roleFormat.format(new String[]{dn, username});
        SearchControls controls = new SearchControls();
        if (this.roleSubtree) {
            controls.setSearchScope(2);
        } else {
            controls.setSearchScope(1);
        }
        controls.setReturningAttributes(new String[]{this.roleName});
        if (this.debug >= 3) {
            this.log("  Searching role base '" + this.roleBase + "' for attribute '" + this.roleName + "'");
            this.log("  With filter expression '" + filter + "'");
        }
        if ((results = context.search(this.roleBase, filter, controls)) == null) {
            return list;
        }
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes attrs = result.getAttributes();
            if (attrs == null) continue;
            list = this.addAttributeValues(this.roleName, attrs, list);
        }
        if (this.debug >= 2) {
            if (list != null) {
                this.log("  Returning " + list.size() + " roles");
                for (int i = 0; i < list.size(); ++i) {
                    this.log("  Found role " + list.get(i));
                }
            } else {
                this.log("  getRoles about to return null ");
            }
        }
        return list;
    }

    private String getAttributeValue(String attrId, Attributes attrs) throws NamingException {
        if (this.debug >= 3) {
            this.log("  retrieving attribute " + attrId);
        }
        if (attrId == null || attrs == null) {
            return null;
        }
        Attribute attr = attrs.get(attrId);
        if (attr == null) {
            return null;
        }
        Object value = attr.get();
        if (value == null) {
            return null;
        }
        String valueString = null;
        valueString = value instanceof byte[] ? new String((byte[])value) : value.toString();
        return valueString;
    }

    private ArrayList addAttributeValues(String attrId, Attributes attrs, ArrayList values) throws NamingException {
        Attribute attr;
        if (this.debug >= 3) {
            this.log("  retrieving values for attribute " + attrId);
        }
        if (attrId == null || attrs == null) {
            return values;
        }
        if (values == null) {
            values = new ArrayList<String>();
        }
        if ((attr = attrs.get(attrId)) == null) {
            return values;
        }
        NamingEnumeration<?> e = attr.getAll();
        while (e.hasMore()) {
            String value = (String)e.next();
            values.add(value);
        }
        return values;
    }

    protected void close(DirContext context) {
        if (context == null) {
            return;
        }
        try {
            if (this.debug >= 1) {
                this.log("Closing directory context");
            }
            context.close();
        }
        catch (NamingException e) {
            this.log(sm.getString("jndiRealm.close"), e);
        }
        this.context = null;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirContext open() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        try {
            this.context = new InitialDirContext(this.getDirectoryContextEnvironment());
        }
        catch (NamingException e) {
            this.connectionAttempt = 1;
            this.log(sm.getString("jndiRealm.exception"), e);
            this.context = new InitialDirContext(this.getDirectoryContextEnvironment());
        }
        finally {
            this.connectionAttempt = 0;
        }
        return this.context;
    }

    protected Hashtable getDirectoryContextEnvironment() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.debug >= 1 && this.connectionAttempt == 0) {
            this.log("Connecting to URL " + this.connectionURL);
        } else if (this.debug >= 1 && this.connectionAttempt > 0) {
            this.log("Connecting to URL " + this.alternateURL);
        }
        env.put("java.naming.factory.initial", this.contextFactory);
        if (this.connectionName != null) {
            env.put("java.naming.security.principal", this.connectionName);
        }
        if (this.connectionPassword != null) {
            env.put("java.naming.security.credentials", this.connectionPassword);
        }
        if (this.connectionURL != null && this.connectionAttempt == 0) {
            env.put("java.naming.provider.url", this.connectionURL);
        } else if (this.alternateURL != null && this.connectionAttempt > 0) {
            env.put("java.naming.provider.url", this.alternateURL);
        }
        if (this.authentication != null) {
            env.put("java.naming.security.authentication", this.authentication);
        }
        if (this.protocol != null) {
            env.put("java.naming.security.protocol", this.protocol);
        }
        if (this.referrals != null) {
            env.put("java.naming.referral", this.referrals);
        }
        return env;
    }

    protected void release(DirContext context) {
    }

    public void start() throws LifecycleException {
        try {
            this.open();
        }
        catch (NamingException e) {
            throw new LifecycleException(sm.getString("jndiRealm.open"), (Throwable)e);
        }
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.close(this.context);
    }
}

