/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.primitives.AbstractShortArrayList;

public class ShortArrayList
extends AbstractShortArrayList
implements List,
Serializable {
    private transient short[] _data = null;
    private int _size = 0;

    public ShortArrayList() {
        this(8);
    }

    public ShortArrayList(int n) {
        this._data = new short[n];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public short getShort(int n) {
        this.checkRange(n);
        return this._data[n];
    }

    public boolean containsShort(short s) {
        return -1 != this.indexOfShort(s);
    }

    public int indexOfShort(short s) {
        int n = 0;
        while (n < this._size) {
            if (s == this._data[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOfShort(short s) {
        int n = this._size - 1;
        while (n >= 0) {
            if (s == this._data[n]) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public short setShort(int n, short s) {
        this.checkRange(n);
        short s2 = this._data[n];
        this._data[n] = s;
        return s2;
    }

    public boolean addShort(short s) {
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = s;
        return true;
    }

    public void addShort(int n, short s) {
        this.checkRangeIncludingEndpoint(n);
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = s;
        ++this._size;
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public short removeShortAt(int n) {
        this.checkRange(n);
        ++this.modCount;
        short s = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return s;
    }

    public boolean removeShort(short s) {
        int n = this.indexOfShort(s);
        if (-1 == n) {
            return false;
        }
        this.removeShortAt(n);
        return true;
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            short[] sArray = this._data;
            this._data = new short[n2 < n ? n : n2];
            System.arraycopy(sArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            short[] sArray = this._data;
            this._data = new short[this._size];
            System.arraycopy(sArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        int n = 0;
        while (n < this._size) {
            objectOutputStream.writeShort(this._data[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new short[objectInputStream.readInt()];
        int n = 0;
        while (n < this._size) {
            this._data[n] = objectInputStream.readShort();
            ++n;
        }
    }

    private final void checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

