/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.primitives.AbstractLongArrayList;

public class LongArrayList
extends AbstractLongArrayList
implements List,
Serializable {
    private transient long[] _data = null;
    private int _size = 0;

    public LongArrayList() {
        this(8);
    }

    public LongArrayList(int n) {
        this._data = new long[n];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public long getLong(int n) {
        this.checkRange(n);
        return this._data[n];
    }

    public boolean containsLong(long l) {
        return -1 != this.indexOfLong(l);
    }

    public int indexOfLong(long l) {
        int n = 0;
        while (n < this._size) {
            if (l == this._data[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOfLong(long l) {
        int n = this._size - 1;
        while (n >= 0) {
            if (l == this._data[n]) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public long setLong(int n, long l) {
        this.checkRange(n);
        long l2 = this._data[n];
        this._data[n] = l;
        return l2;
    }

    public boolean addLong(long l) {
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = l;
        return true;
    }

    public void addLong(int n, long l) {
        this.checkRangeIncludingEndpoint(n);
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = l;
        ++this._size;
    }

    public void add(int n, Object object) {
        this.addLong(n, (Long)object);
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public long removeLongAt(int n) {
        this.checkRange(n);
        ++this.modCount;
        long l = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return l;
    }

    public boolean removeLong(long l) {
        int n = this.indexOfLong(l);
        if (-1 == n) {
            return false;
        }
        this.removeLongAt(n);
        return true;
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            long[] lArray = this._data;
            this._data = new long[n2 < n ? n : n2];
            System.arraycopy(lArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            long[] lArray = this._data;
            this._data = new long[this._size];
            System.arraycopy(lArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        int n = 0;
        while (n < this._size) {
            objectOutputStream.writeLong(this._data[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new long[objectInputStream.readInt()];
        int n = 0;
        while (n < this._size) {
            this._data[n] = objectInputStream.readLong();
            ++n;
        }
    }

    private final void checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

