/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.primitives.AbstractIntArrayList;

public class IntArrayList
extends AbstractIntArrayList
implements List,
Serializable {
    private transient int[] _data = null;
    private int _size = 0;

    public IntArrayList() {
        this(8);
    }

    public IntArrayList(int n) {
        this._data = new int[n];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public int getInt(int n) {
        this.checkRange(n);
        return this._data[n];
    }

    public boolean containsInt(int n) {
        return -1 != this.indexOfInt(n);
    }

    public int indexOfInt(int n) {
        int n2 = 0;
        while (n2 < this._size) {
            if (n == this._data[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexOfInt(int n) {
        int n2 = this._size - 1;
        while (n2 >= 0) {
            if (n == this._data[n2]) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public int setInt(int n, int n2) {
        this.checkRange(n);
        int n3 = this._data[n];
        this._data[n] = n2;
        return n3;
    }

    public boolean addInt(int n) {
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = n;
        return true;
    }

    public void addInt(int n, int n2) {
        this.checkRangeIncludingEndpoint(n);
        this.ensureCapacity(this._size + 1);
        int n3 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n3);
        this._data[n] = n2;
        ++this._size;
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public int removeIntAt(int n) {
        this.checkRange(n);
        ++this.modCount;
        int n2 = this._data[n];
        int n3 = this._size - n - 1;
        if (n3 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n3);
        }
        --this._size;
        return n2;
    }

    public boolean removeInt(int n) {
        int n2 = this.indexOfInt(n);
        if (-1 == n2) {
            return false;
        }
        this.removeIntAt(n2);
        return true;
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            int[] nArray = this._data;
            this._data = new int[n2 < n ? n : n2];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            int[] nArray = this._data;
            this._data = new int[this._size];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        int n = 0;
        while (n < this._size) {
            objectOutputStream.writeInt(this._data[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new int[objectInputStream.readInt()];
        int n = 0;
        while (n < this._size) {
            this._data[n] = objectInputStream.readInt();
            ++n;
        }
    }

    private final void checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

