/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class StaticBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private final Node[] m_buckets;
    private final Object[] m_locks;

    public StaticBucketMap() {
        this(255);
    }

    public StaticBucketMap(int n) {
        int n2 = Math.max(17, n);
        if (n2 % 2 == 0) {
            --n2;
        }
        this.m_buckets = new Node[n2];
        this.m_locks = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.m_locks[n3] = new Object();
            ++n3;
        }
    }

    private final int getHash(Object object) {
        if (object == null) {
            return 0;
        }
        int n = object.hashCode() % this.m_buckets.length;
        return n < 0 ? n * -1 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < this.m_buckets.length) {
            Object object = this.m_locks[n];
            synchronized (object) {
                Node node = this.m_buckets[n];
                while (node != null) {
                    hashSet.add(node.key);
                    node = node.next;
                }
            }
            ++n;
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            Object object = this.m_locks[n2];
            synchronized (object) {
                Node node = this.m_buckets[n2];
                while (node != null) {
                    ++n;
                    node = node.next;
                }
            }
            ++n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object put(Object object, Object object2) {
        int n = this.getHash(object);
        Object object3 = this.m_locks[n];
        synchronized (object3) {
            Node node = this.m_buckets[n];
            if (node == null) {
                node = new Node();
                node.key = object;
                node.value = object2;
                this.m_buckets[n] = node;
                return null;
            }
            Node node2 = node;
            while (node2 != null) {
                node = node2;
                if (node.key == object || node.key != null && node.key.equals(object)) {
                    Object object4 = node.value;
                    node.value = object2;
                    return object4;
                }
                node2 = node2.next;
            }
            Node node3 = new Node();
            node3.key = object;
            node3.value = object2;
            node.next = node3;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object object) {
        int n = this.getHash(object);
        Object object2 = this.m_locks[n];
        synchronized (object2) {
            Node node = this.m_buckets[n];
            while (node != null) {
                if (node.key == object) return node.value;
                if (node.key != null && node.key.equals(object)) {
                    return node.value;
                }
                node = node.next;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsKey(Object object) {
        int n = this.getHash(object);
        Object object2 = this.m_locks[n];
        synchronized (object2) {
            Node node = this.m_buckets[n];
            while (node != null) {
                if (node.key == null) return true;
                if (node.key != null && node.key.equals(object)) {
                    return true;
                }
                node = node.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsValue(Object object) {
        int n = 0;
        while (n < this.m_buckets.length) {
            Object object2 = this.m_locks[n];
            synchronized (object2) {
                Node node = this.m_buckets[n];
                while (node != null) {
                    if (node.value == object) return true;
                    if (node.value != null && node.value.equals(object)) {
                        return true;
                    }
                    node = node.next;
                }
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.m_buckets.length) {
            Object object = this.m_locks[n];
            synchronized (object) {
                Node node = this.m_buckets[n];
                while (node != null) {
                    arrayList.add(node.value);
                    node = node.next;
                }
            }
            ++n;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        HashSet<Node> hashSet = new HashSet<Node>();
        int n = 0;
        while (n < this.m_buckets.length) {
            Object object = this.m_locks[n];
            synchronized (object) {
                Node node = this.m_buckets[n];
                while (node != null) {
                    hashSet.add(node);
                    node = node.next;
                }
            }
            ++n;
        }
        return hashSet;
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object remove(Object object) {
        int n = this.getHash(object);
        Object object2 = this.m_locks[n];
        synchronized (object2) {
            Node node = this.m_buckets[n];
            Node node2 = null;
            while (node != null) {
                if (node.key == null || node.key != null && node.key.equals(object)) {
                    if (null == node2) {
                        this.m_buckets[n] = node.next;
                        return node.value;
                    } else {
                        node2.next = node.next;
                    }
                    return node.value;
                }
                node2 = node;
                node = node.next;
            }
            return null;
        }
    }

    public final boolean isEmpty() {
        int n = 0;
        while (n < this.m_buckets.length) {
            if (this.m_buckets[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final void clear() {
        int n = 0;
        while (n < this.m_buckets.length) {
            this.m_buckets[n] = null;
            ++n;
        }
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        return this.entrySet().equals(map.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_buckets.length) {
            Object object = this.m_locks[n2];
            synchronized (object) {
                Node node = this.m_buckets[n2];
                while (node != null) {
                    n += node.hashCode();
                    node = node.next;
                }
            }
            ++n2;
        }
        return n;
    }

    private final class Node
    implements Map.Entry {
        protected Object key;
        protected Object value;
        protected Node next;

        private Node() {
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }
}

