/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.SortedBag;

public class PredicateUtils {
    public static final Predicate TRUE_PREDICATE = new TruePredicate();
    public static final Predicate FALSE_PREDICATE = new FalsePredicate();

    private PredicateUtils() {
    }

    public static Collection predicateCollection(Collection collection, Predicate predicate) {
        return new PredicateCollection(collection, predicate);
    }

    public static List predicateList(List list, Predicate predicate) {
        return new PredicateList(list, predicate);
    }

    public static Set predicateSet(Set set, Predicate predicate) {
        return new PredicateSet(set, predicate);
    }

    public static SortedSet predicateSortedSet(SortedSet sortedSet, Predicate predicate) {
        return new PredicateSortedSet(sortedSet, predicate);
    }

    public static Bag predicateBag(Bag bag, Predicate predicate) {
        return new PredicateBag(bag, predicate);
    }

    public static SortedBag predicateSortedBag(SortedBag sortedBag, Predicate predicate) {
        return new PredicateSortedBag(sortedBag, predicate);
    }

    public static Map predicateMap(Map map, Predicate predicate, Predicate predicate2) {
        return new PredicateMap(map, predicate, predicate2);
    }

    public static SortedMap predicateSortedMap(SortedMap sortedMap, Predicate predicate, Predicate predicate2) {
        return new PredicateSortedMap(sortedMap, predicate, predicate2);
    }

    public static Predicate andPredicate(Predicate predicate, Predicate predicate2) {
        return new AndPredicate(predicate, predicate2);
    }

    public static Predicate orPredicate(Predicate predicate, Predicate predicate2) {
        return new OrPredicate(predicate, predicate2);
    }

    public static Predicate notPredicate(Predicate predicate) {
        return new NotPredicate(predicate);
    }

    public static Predicate instanceofPredicate(Class clazz) {
        return new InstanceofPredicate(clazz);
    }

    private static void validate(Predicate predicate, Object object) {
        if (!predicate.evaluate(object)) {
            throw new IllegalArgumentException("Predicate validation: " + object + " cannot be added to the list");
        }
    }

    public static class InstanceofPredicate
    implements Predicate {
        private final Class iType;

        public InstanceofPredicate(Class clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException("Type to be checked for must not be null");
            }
            this.iType = clazz;
        }

        public boolean evaluate(Object object) {
            return this.iType.isInstance(object);
        }
    }

    private static class NotPredicate
    implements Predicate {
        private final Predicate iPredicate;

        private NotPredicate(Predicate predicate) {
            if (predicate == null) {
                throw new IllegalArgumentException("Predicate must not be null");
            }
            this.iPredicate = predicate;
        }

        public boolean evaluate(Object object) {
            return !this.iPredicate.evaluate(object);
        }
    }

    private static class OrPredicate
    implements Predicate {
        private final Predicate iPredicate1;
        private final Predicate iPredicate2;

        private OrPredicate(Predicate predicate, Predicate predicate2) {
            if (predicate == null || predicate2 == null) {
                throw new IllegalArgumentException("Predicate must not be null");
            }
            this.iPredicate1 = predicate;
            this.iPredicate2 = predicate2;
        }

        public boolean evaluate(Object object) {
            return this.iPredicate1.evaluate(object) || this.iPredicate2.evaluate(object);
        }
    }

    private static class AndPredicate
    implements Predicate {
        private final Predicate iPredicate1;
        private final Predicate iPredicate2;

        private AndPredicate(Predicate predicate, Predicate predicate2) {
            if (predicate == null || predicate2 == null) {
                throw new IllegalArgumentException("Predicate must not be null");
            }
            this.iPredicate1 = predicate;
            this.iPredicate2 = predicate2;
        }

        public boolean evaluate(Object object) {
            return this.iPredicate1.evaluate(object) && this.iPredicate2.evaluate(object);
        }
    }

    private static class FalsePredicate
    implements Predicate {
        private FalsePredicate() {
        }

        public boolean evaluate(Object object) {
            return false;
        }
    }

    private static class TruePredicate
    implements Predicate {
        private TruePredicate() {
        }

        public boolean evaluate(Object object) {
            return true;
        }
    }

    public static class PredicateMapEntry
    implements Map.Entry {
        private final Map.Entry iEntry;
        private final Predicate iValuePredicate;

        private PredicateMapEntry(Map.Entry entry, Predicate predicate) {
            this.iEntry = entry;
            this.iValuePredicate = predicate;
        }

        public Object getKey() {
            return this.iEntry.getKey();
        }

        public Object getValue() {
            return this.iEntry.getValue();
        }

        public Object setValue(Object object) {
            PredicateUtils.validate(this.iValuePredicate, object);
            return this.iEntry.setValue(object);
        }
    }

    public static class PredicateMapEntrySetIterator
    implements Iterator {
        private final Iterator iIterator;
        private final Predicate iValuePredicate;

        private PredicateMapEntrySetIterator(Iterator iterator, Predicate predicate) {
            this.iIterator = iterator;
            this.iValuePredicate = predicate;
        }

        public Object next() {
            Object e = this.iIterator.next();
            return new PredicateMapEntry((Map.Entry)e, this.iValuePredicate);
        }

        public boolean hasNext() {
            return this.iIterator.hasNext();
        }

        public void remove() {
            this.iIterator.remove();
        }
    }

    public static class PredicateMapEntrySet
    extends AbstractSet {
        private final Set iSet;
        private final Predicate iValuePredicate;

        private PredicateMapEntrySet(Set set, Predicate predicate) {
            this.iSet = set;
            this.iValuePredicate = predicate;
        }

        public void clear() {
            this.iSet.clear();
        }

        public Iterator iterator() {
            return new PredicateMapEntrySetIterator(this.iSet.iterator(), this.iValuePredicate);
        }

        public boolean remove(Object object) {
            return this.iSet.remove(object);
        }

        public int size() {
            return this.iSet.size();
        }
    }

    private static class PredicateSortedMap
    extends PredicateMap
    implements SortedMap {
        public PredicateSortedMap(SortedMap sortedMap, Predicate predicate, Predicate predicate2) {
            super(sortedMap, predicate, predicate2);
        }

        public Comparator comparator() {
            return ((SortedMap)this.iMap).comparator();
        }

        public Object firstKey() {
            return ((SortedMap)this.iMap).firstKey();
        }

        public Object lastKey() {
            return ((SortedMap)this.iMap).lastKey();
        }

        public SortedMap headMap(Object object) {
            return new PredicateSortedMap(((SortedMap)this.iMap).headMap(object), this.iKeyPredicate, this.iValuePredicate);
        }

        public SortedMap tailMap(Object object) {
            return new PredicateSortedMap(((SortedMap)this.iMap).tailMap(object), this.iKeyPredicate, this.iValuePredicate);
        }

        public SortedMap subMap(Object object, Object object2) {
            return new PredicateSortedMap(((SortedMap)this.iMap).subMap(object, object2), this.iKeyPredicate, this.iValuePredicate);
        }
    }

    private static class PredicateMap
    implements Map {
        protected final Predicate iKeyPredicate;
        protected final Predicate iValuePredicate;
        protected final Map iMap;

        public PredicateMap(Map map, Predicate predicate, Predicate predicate2) {
            if (map == null) {
                throw new IllegalArgumentException("Collection to be wrapped must not be null");
            }
            if (predicate == null) {
                throw new IllegalArgumentException("Key Predicate must not be null");
            }
            if (predicate2 == null) {
                throw new IllegalArgumentException("Value Predicate must not be null");
            }
            this.iKeyPredicate = predicate;
            this.iValuePredicate = predicate2;
            this.iMap = map;
            Iterator iterator = this.iMap.keySet().iterator();
            while (iterator.hasNext()) {
                PredicateUtils.validate(this.iKeyPredicate, iterator.next());
            }
            Iterator iterator2 = this.iMap.values().iterator();
            while (iterator2.hasNext()) {
                PredicateUtils.validate(this.iValuePredicate, iterator2.next());
            }
        }

        public Object put(Object object, Object object2) {
            PredicateUtils.validate(this.iKeyPredicate, object);
            PredicateUtils.validate(this.iValuePredicate, object2);
            return this.iMap.put(object, object2);
        }

        public void putAll(Map map) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                PredicateUtils.validate(this.iKeyPredicate, entry.getKey());
                PredicateUtils.validate(this.iValuePredicate, entry.getValue());
            }
            this.iMap.putAll(map);
        }

        public Set entrySet() {
            return new PredicateMapEntrySet(this.iMap.entrySet(), this.iValuePredicate);
        }

        public Set keySet() {
            return new PredicateSet(this.iMap.keySet(), this.iKeyPredicate);
        }

        public Collection values() {
            return new PredicateCollection(this.iMap.values(), this.iValuePredicate);
        }

        public Object get(Object object) {
            return this.iMap.get(object);
        }

        public int size() {
            return this.iMap.size();
        }

        public void clear() {
            this.iMap.clear();
        }

        public boolean isEmpty() {
            return this.iMap.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.iMap.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.iMap.containsValue(object);
        }

        public Object remove(Object object) {
            return this.iMap.remove(object);
        }

        public boolean equals(Object object) {
            return this.iMap.equals(object);
        }

        public int hashCode() {
            return this.iMap.hashCode();
        }

        public String toString() {
            return this.iMap.toString();
        }
    }

    private static class PredicateSortedBag
    extends PredicateBag
    implements SortedBag {
        public PredicateSortedBag(SortedBag sortedBag, Predicate predicate) {
            super(sortedBag, predicate);
        }

        public Comparator comparator() {
            return ((SortedBag)this.iCollection).comparator();
        }

        public Object first() {
            return ((SortedBag)this.iCollection).first();
        }

        public Object last() {
            return ((SortedBag)this.iCollection).last();
        }
    }

    private static class PredicateBag
    extends PredicateCollection
    implements Bag {
        public PredicateBag(Bag bag, Predicate predicate) {
            super(bag, predicate);
        }

        public boolean add(Object object, int n) {
            PredicateUtils.validate(this.iPredicate, object);
            return ((Bag)this.iCollection).add(object, n);
        }

        public int getCount(Object object) {
            return ((Bag)this.iCollection).getCount(object);
        }

        public boolean remove(Object object, int n) {
            return ((Bag)this.iCollection).remove(object, n);
        }

        public Set uniqueSet() {
            return ((Bag)this.iCollection).uniqueSet();
        }
    }

    private static class PredicateSortedSet
    extends PredicateSet
    implements SortedSet {
        public PredicateSortedSet(SortedSet sortedSet, Predicate predicate) {
            super(sortedSet, predicate);
        }

        public SortedSet headSet(Object object) {
            return new PredicateSortedSet(((SortedSet)this.iCollection).headSet(object), this.iPredicate);
        }

        public SortedSet subSet(Object object, Object object2) {
            return new PredicateSortedSet(((SortedSet)this.iCollection).subSet(object, object2), this.iPredicate);
        }

        public SortedSet tailSet(Object object) {
            return new PredicateSortedSet(((SortedSet)this.iCollection).tailSet(object), this.iPredicate);
        }

        public Object first() {
            return ((SortedSet)this.iCollection).first();
        }

        public Object last() {
            return ((SortedSet)this.iCollection).last();
        }

        public Comparator comparator() {
            return ((SortedSet)this.iCollection).comparator();
        }
    }

    private static class PredicateSet
    extends PredicateCollection
    implements Set {
        public PredicateSet(Set set, Predicate predicate) {
            super(set, predicate);
        }
    }

    private static class PredicateListIterator
    implements ListIterator {
        private final ListIterator iIterator;
        private final Predicate iPredicate;

        private PredicateListIterator(ListIterator listIterator, Predicate predicate) {
            this.iIterator = listIterator;
            this.iPredicate = predicate;
        }

        public boolean hasNext() {
            return this.iIterator.hasNext();
        }

        public boolean hasPrevious() {
            return this.iIterator.hasPrevious();
        }

        public Object next() {
            return this.iIterator.next();
        }

        public int nextIndex() {
            return this.iIterator.nextIndex();
        }

        public Object previous() {
            return this.iIterator.previous();
        }

        public int previousIndex() {
            return this.iIterator.previousIndex();
        }

        public void remove() {
            this.iIterator.remove();
        }

        public void add(Object object) {
            PredicateUtils.validate(this.iPredicate, object);
            this.iIterator.add(object);
        }

        public void set(Object object) {
            PredicateUtils.validate(this.iPredicate, object);
            this.iIterator.set(object);
        }
    }

    private static class PredicateList
    extends PredicateCollection
    implements List {
        public PredicateList(List list, Predicate predicate) {
            super(list, predicate);
        }

        public void add(int n, Object object) {
            PredicateUtils.validate(this.iPredicate, object);
            ((List)this.iCollection).add(n, object);
        }

        public boolean addAll(int n, Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                PredicateUtils.validate(this.iPredicate, iterator.next());
            }
            return ((List)this.iCollection).addAll(n, collection);
        }

        public Object set(int n, Object object) {
            PredicateUtils.validate(this.iPredicate, object);
            return ((List)this.iCollection).set(n, object);
        }

        public ListIterator listIterator() {
            return new PredicateListIterator(((List)this.iCollection).listIterator(), this.iPredicate);
        }

        public ListIterator listIterator(int n) {
            return new PredicateListIterator(((List)this.iCollection).listIterator(n), this.iPredicate);
        }

        public List subList(int n, int n2) {
            return new PredicateList(((List)this.iCollection).subList(n, n2), this.iPredicate);
        }

        public Object get(int n) {
            return ((List)this.iCollection).get(n);
        }

        public int indexOf(Object object) {
            return ((List)this.iCollection).indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return ((List)this.iCollection).lastIndexOf(object);
        }

        public Object remove(int n) {
            return ((List)this.iCollection).remove(n);
        }
    }

    private static class PredicateCollection
    implements Collection,
    Serializable {
        protected final Predicate iPredicate;
        protected final Collection iCollection;

        public PredicateCollection(Collection collection, Predicate predicate) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection to be wrapped must not be null");
            }
            if (predicate == null) {
                throw new IllegalArgumentException("Predicate must not be null");
            }
            this.iPredicate = predicate;
            this.iCollection = collection;
            Iterator iterator = this.iCollection.iterator();
            while (iterator.hasNext()) {
                PredicateUtils.validate(this.iPredicate, iterator.next());
            }
        }

        public boolean add(Object object) {
            PredicateUtils.validate(this.iPredicate, object);
            return this.iCollection.add(object);
        }

        public boolean addAll(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                PredicateUtils.validate(this.iPredicate, iterator.next());
            }
            return this.iCollection.addAll(collection);
        }

        public Iterator iterator() {
            return this.iCollection.iterator();
        }

        public int size() {
            return this.iCollection.size();
        }

        public void clear() {
            this.iCollection.clear();
        }

        public boolean isEmpty() {
            return this.iCollection.isEmpty();
        }

        public boolean contains(Object object) {
            return this.iCollection.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.iCollection.containsAll(collection);
        }

        public boolean remove(Object object) {
            return this.iCollection.remove(object);
        }

        public boolean removeAll(Collection collection) {
            return this.iCollection.remove(collection);
        }

        public boolean retainAll(Collection collection) {
            return this.iCollection.retainAll(collection);
        }

        public Object[] toArray() {
            return this.iCollection.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.iCollection.toArray(objectArray);
        }

        public boolean equals(Object object) {
            return this.iCollection.equals(object);
        }

        public int hashCode() {
            return this.iCollection.hashCode();
        }

        public String toString() {
            return this.iCollection.toString();
        }
    }
}

