/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IteratorChain
implements Iterator {
    protected List iteratorChain = null;
    protected int currentIteratorIndex = 0;
    protected Iterator currentIterator = null;
    protected Iterator lastUsedIterator = null;
    protected boolean isLocked = false;

    public IteratorChain() {
        this(new ArrayList());
    }

    public IteratorChain(Iterator iterator) {
        this.iteratorChain = new ArrayList();
        this.iteratorChain.add(iterator);
    }

    public IteratorChain(List list) {
        this.iteratorChain = list;
    }

    public void addIterator(Iterator iterator) {
        this.checkLocked();
        this.iteratorChain.add(iterator);
    }

    public void setIterator(int n, Iterator iterator) throws IndexOutOfBoundsException {
        this.checkLocked();
        this.iteratorChain.set(n, iterator);
    }

    public int size() {
        return this.iteratorChain.size();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("IteratorChain cannot be changed after the first use of a method from the Iterator interface");
        }
    }

    private void checkChainIntegrity() {
        if (this.iteratorChain.size() == 0) {
            throw new UnsupportedOperationException("IteratorChains must contain at least one Iterator");
        }
    }

    private void lockChain() {
        if (!this.isLocked) {
            this.checkChainIntegrity();
            this.isLocked = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.lastUsedIterator = this.currentIterator = (Iterator)this.iteratorChain.get(0);
            return;
        }
        if (this.currentIteratorIndex != this.iteratorChain.size() - 1) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            ++this.currentIteratorIndex;
            this.currentIterator = (Iterator)this.iteratorChain.get(this.currentIteratorIndex);
            if (this.currentIteratorIndex != this.iteratorChain.size() - 1) continue;
            return;
lbl10:
            // 2 sources

            ** while (!this.currentIterator.hasNext())
        }
lbl11:
        // 1 sources

    }

    public boolean hasNext() throws UnsupportedOperationException {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    public Object next() throws NoSuchElementException, UnsupportedOperationException {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    public void remove() throws UnsupportedOperationException, IllegalStateException {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator.remove();
    }
}

