/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Comparator;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.collections.comparators.TransformingComparator;

public class ComparatorUtils {
    public static final Comparator NATURAL = ComparableComparator.getInstance();

    public static Comparator reverse(Comparator comparator) {
        if (comparator == null) {
            comparator = NATURAL;
        }
        return new ReverseComparator(comparator);
    }

    public static Comparator nullLow(Comparator comparator) {
        if (comparator == null) {
            comparator = NATURAL;
        }
        return new NullComparator(comparator, false);
    }

    public static Comparator nullHigh(Comparator comparator) {
        if (comparator == null) {
            comparator = NATURAL;
        }
        return new NullComparator(comparator, true);
    }

    public static Comparator transform(Comparator comparator, Transformer transformer) {
        if (comparator == null) {
            comparator = NATURAL;
        }
        return new TransformingComparator(transformer, comparator);
    }

    public static Object min(Object object, Object object2, Comparator comparator) {
        int n;
        if (comparator == null) {
            comparator = NATURAL;
        }
        return (n = comparator.compare(object, object2)) < 0 ? object : object2;
    }

    public static Object max(Object object, Object object2, Comparator comparator) {
        int n;
        if (comparator == null) {
            comparator = NATURAL;
        }
        return (n = comparator.compare(object, object2)) > 0 ? object : object2;
    }
}

