/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.Predicate;

public class BufferUtils {
    public static Buffer synchronizedBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer);
    }

    public static Buffer blockingBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer){

            public synchronized boolean add(Object object) {
                boolean bl = this.b.add(object);
                this.notify();
                return bl;
            }

            public synchronized boolean addAll(Collection collection) {
                boolean bl = this.b.addAll(collection);
                this.notifyAll();
                return bl;
            }

            public synchronized Object get() {
                while (this.b.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BufferUnderflowException();
                    }
                }
                return this.b.get();
            }

            public synchronized Object remove() {
                while (this.b.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BufferUnderflowException();
                    }
                }
                return this.b.remove();
            }
        };
    }

    public static Buffer unmodifiableBuffer(Buffer buffer) {
        return new BufferDecorator(buffer){

            public boolean addAll(Collection collection) {
                throw new UnsupportedOperationException();
            }

            public boolean removeAll(Collection collection) {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection collection) {
                throw new UnsupportedOperationException();
            }

            public boolean add(Object object) {
                throw new UnsupportedOperationException();
            }

            public boolean remove(Object object) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public Object remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Buffer predicatedBuffer(Buffer buffer, final Predicate predicate) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer must not be null.");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate must not be null.");
        }
        return new BufferDecorator(buffer){

            public boolean add(Object object) {
                this.test(object);
                return this.b.add(object);
            }

            public boolean addAll(Collection collection) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    this.test(iterator.next());
                }
                return this.b.addAll(collection);
            }

            private void test(Object object) {
                if (!predicate.evaluate(object)) {
                    throw new IllegalArgumentException("Invalid: " + object);
                }
            }
        };
    }

    private static class BufferDecorator
    implements Buffer {
        Buffer b;

        BufferDecorator(Buffer buffer) {
            this.b = buffer;
        }

        public int size() {
            return this.b.size();
        }

        public boolean isEmpty() {
            return this.b.isEmpty();
        }

        public boolean contains(Object object) {
            return this.b.contains(object);
        }

        public Iterator iterator() {
            return this.b.iterator();
        }

        public Object[] toArray() {
            return this.b.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.b.toArray(objectArray);
        }

        public boolean add(Object object) {
            return this.b.add(object);
        }

        public boolean remove(Object object) {
            return this.b.remove(object);
        }

        public boolean containsAll(Collection collection) {
            return this.b.containsAll(collection);
        }

        public boolean addAll(Collection collection) {
            return this.b.addAll(collection);
        }

        public boolean removeAll(Collection collection) {
            return this.b.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            return this.b.retainAll(collection);
        }

        public void clear() {
            this.b.clear();
        }

        public boolean equals(Object object) {
            return this.b.equals(object);
        }

        public int hashCode() {
            return this.b.hashCode();
        }

        public String toString() {
            return this.b.toString();
        }

        public Object get() {
            return this.b.get();
        }

        public Object remove() {
            return this.b.remove();
        }
    }

    private static class SynchronizedBuffer
    implements Buffer {
        Buffer b;

        public SynchronizedBuffer(Buffer buffer) {
            this.b = buffer;
        }

        public synchronized int size() {
            return this.b.size();
        }

        public synchronized boolean isEmpty() {
            return this.b.isEmpty();
        }

        public synchronized boolean contains(Object object) {
            return this.b.contains(object);
        }

        public Iterator iterator() {
            return this.b.iterator();
        }

        public synchronized Object[] toArray() {
            return this.b.toArray();
        }

        public synchronized Object[] toArray(Object[] objectArray) {
            return this.b.toArray(objectArray);
        }

        public synchronized boolean add(Object object) {
            return this.b.add(object);
        }

        public synchronized boolean remove(Object object) {
            return this.b.remove(object);
        }

        public synchronized boolean containsAll(Collection collection) {
            return this.b.containsAll(collection);
        }

        public synchronized boolean addAll(Collection collection) {
            return this.b.addAll(collection);
        }

        public synchronized boolean removeAll(Collection collection) {
            return this.b.removeAll(collection);
        }

        public synchronized boolean retainAll(Collection collection) {
            return this.b.retainAll(collection);
        }

        public synchronized void clear() {
            this.b.clear();
        }

        public synchronized boolean equals(Object object) {
            return this.b.equals(object);
        }

        public synchronized int hashCode() {
            return this.b.hashCode();
        }

        public synchronized String toString() {
            return this.b.toString();
        }

        public synchronized Object get() {
            return this.b.get();
        }

        public synchronized Object remove() {
            return this.b.remove();
        }
    }
}

