/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.util.MessageResources;

public class StrutsValidatorUtil {
    public static String SERVLET_CONTEXT_KEY = "javax.servlet.ServletContext";
    public static String HTTP_SERVLET_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
    public static String ACTION_ERRORS_KEY = "org.apache.struts.action.ActionErrors";
    private static Locale defaultLocale = Locale.getDefault();

    public static ValidatorResources getValidatorResources(ServletContext application) {
        return (ValidatorResources)application.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES");
    }

    public static MessageResources getMessageResources(ServletContext application) {
        return (MessageResources)application.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public static MessageResources getMessageResources(HttpServletRequest request) {
        return (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
    }

    public static Locale getLocale(HttpServletRequest request) {
        Locale locale = null;
        try {
            locale = (Locale)request.getSession().getAttribute("org.apache.struts.action.LOCALE");
        }
        catch (IllegalStateException e) {
            locale = null;
        }
        if (locale == null) {
            locale = defaultLocale;
        }
        return locale;
    }

    public static String getMessage(MessageResources messages, Locale locale, String key) {
        String message = null;
        if (messages != null) {
            message = messages.getMessage(locale, key);
        }
        if (message == null) {
            message = "";
        }
        return message;
    }

    public static String getMessage(HttpServletRequest request, String key) {
        MessageResources messages = StrutsValidatorUtil.getMessageResources(request);
        return StrutsValidatorUtil.getMessage(messages, StrutsValidatorUtil.getLocale(request), key);
    }

    public static String getMessage(MessageResources messages, Locale locale, ValidatorAction va, Field field) {
        String[] arg = StrutsValidatorUtil.getArgs(va.getName(), messages, locale, field);
        String msg = field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
        return messages.getMessage(locale, msg, arg[0], arg[1], arg[2], arg[3]);
    }

    public static ActionError getActionError(HttpServletRequest request, ValidatorAction va, Field field) {
        String[] arg = StrutsValidatorUtil.getArgs(va.getName(), StrutsValidatorUtil.getMessageResources(request), StrutsValidatorUtil.getLocale(request), field);
        String msg = field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
        return new ActionError(msg, arg[0], arg[1], arg[2], arg[3]);
    }

    public static String[] getArgs(String actionName, MessageResources messages, Locale locale, Field field) {
        Arg arg0 = field.getArg0(actionName);
        Arg arg1 = field.getArg1(actionName);
        Arg arg2 = field.getArg2(actionName);
        Arg arg3 = field.getArg3(actionName);
        String sArg0 = null;
        String sArg1 = null;
        String sArg2 = null;
        String sArg3 = null;
        if (arg0 != null) {
            sArg0 = arg0.getResource() ? StrutsValidatorUtil.getMessage(messages, locale, arg0.getKey()) : arg0.getKey();
        }
        if (arg1 != null) {
            sArg1 = arg1.getResource() ? StrutsValidatorUtil.getMessage(messages, locale, arg1.getKey()) : arg1.getKey();
        }
        if (arg2 != null) {
            sArg2 = arg2.getResource() ? StrutsValidatorUtil.getMessage(messages, locale, arg2.getKey()) : arg2.getKey();
        }
        if (arg3 != null) {
            sArg3 = arg3.getResource() ? StrutsValidatorUtil.getMessage(messages, locale, arg3.getKey()) : arg3.getKey();
        }
        return new String[]{sArg0, sArg1, sArg2, sArg3};
    }

    public static void log(ServletContext application, String message) {
        MessageResources messages = StrutsValidatorUtil.getMessageResources(application);
        if (messages != null) {
            messages.log(message);
        }
    }

    public static void log(ServletContext application, String message, Throwable t) {
        MessageResources messages = StrutsValidatorUtil.getMessageResources(application);
        if (messages != null) {
            messages.log(message, t);
        }
    }

    public static Validator initValidator(String key, Object bean, ServletContext application, HttpServletRequest request, ActionErrors errors, int page) {
        ValidatorResources resources = StrutsValidatorUtil.getValidatorResources(application);
        Locale locale = StrutsValidatorUtil.getLocale(request);
        Validator validator = new Validator(resources, key);
        validator.setUseContextClassLoader(true);
        validator.setPage(page);
        validator.addResource(SERVLET_CONTEXT_KEY, (Object)application);
        validator.addResource(HTTP_SERVLET_REQUEST_KEY, (Object)request);
        validator.addResource(Validator.LOCALE_KEY, (Object)locale);
        validator.addResource(ACTION_ERRORS_KEY, (Object)errors);
        validator.addResource(Validator.BEAN_KEY, bean);
        return validator;
    }
}

