/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ActionServletWrapper;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ApplicationConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.struts.util.ErrorMessages;
import org.apache.struts.util.MessageResources;

public class RequestUtils {
    protected static Log LOG = LogFactory.getLog((Class)(class$org$apache$struts$util$RequestUtils == null ? (class$org$apache$struts$util$RequestUtils = RequestUtils.class$("org.apache.struts.util.RequestUtils")) : class$org$apache$struts$util$RequestUtils));
    private static final Locale defaultLocale = Locale.getDefault();
    private static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.util.LocalStrings");
    private static final String PREFIXES_KEY = "org.apache.struts.util.PREFIXES";
    static /* synthetic */ Class class$org$apache$struts$util$RequestUtils;

    public static URL absoluteURL(HttpServletRequest request, String path) throws MalformedURLException {
        return new URL(RequestUtils.serverURL(request), request.getContextPath() + path);
    }

    public static Class applicationClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$apache$struts$util$RequestUtils == null ? (class$org$apache$struts$util$RequestUtils = RequestUtils.class$("org.apache.struts.util.RequestUtils")) : class$org$apache$struts$util$RequestUtils).getClassLoader();
        }
        return classLoader.loadClass(className);
    }

    public static Object applicationInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return RequestUtils.applicationClass(className).newInstance();
    }

    public static Map computeParameters(PageContext pageContext, String paramId, String paramName, String paramProperty, String paramScope, String name, String property, String scope, boolean transaction) throws JspException {
        if (paramId == null && name == null && !transaction) {
            return null;
        }
        Map map = null;
        try {
            if (name != null) {
                map = (Map)RequestUtils.lookup(pageContext, name, property, scope);
            }
        }
        catch (ClassCastException e) {
            RequestUtils.saveException(pageContext, e);
            throw new JspException(messages.getMessage("parameters.multi", (Object)name, (Object)property, (Object)scope));
        }
        catch (JspException e) {
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        HashMap<String, Object> results = null;
        results = map != null ? new HashMap(map) : new HashMap<String, Object>();
        if (paramId != null && paramName != null) {
            Object paramValue = null;
            try {
                paramValue = RequestUtils.lookup(pageContext, paramName, paramProperty, paramScope);
            }
            catch (JspException e) {
                RequestUtils.saveException(pageContext, e);
                throw e;
            }
            if (paramValue != null) {
                String paramString = null;
                paramString = paramValue instanceof String ? (String)paramValue : paramValue.toString();
                Object mapValue = results.get(paramId);
                if (mapValue == null) {
                    results.put(paramId, paramString);
                } else if (mapValue instanceof String) {
                    String[] newValues = new String[]{(String)mapValue, paramString};
                    results.put(paramId, newValues);
                } else {
                    String[] oldValues = (String[])mapValue;
                    String[] newValues = new String[oldValues.length + 1];
                    System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                    newValues[oldValues.length] = paramString;
                    results.put(paramId, newValues);
                }
            }
        }
        if (transaction) {
            HttpSession session = pageContext.getSession();
            String token = null;
            if (session != null) {
                token = (String)session.getAttribute("org.apache.struts.action.TOKEN");
            }
            if (token != null) {
                results.put("org.apache.struts.taglib.html.TOKEN", token);
            }
        }
        return results;
    }

    public static String computeURL(PageContext pageContext, String forward, String href, String page, Map params, String anchor, boolean redirect) throws MalformedURLException {
        int hash;
        String temp;
        int n = 0;
        if (forward != null) {
            ++n;
        }
        if (href != null) {
            ++n;
        }
        if (page != null) {
            ++n;
        }
        if (n != 1) {
            throw new MalformedURLException(messages.getMessage("computeURL.specifier"));
        }
        ApplicationConfig config = (ApplicationConfig)pageContext.getRequest().getAttribute("org.apache.struts.action.APPLICATION");
        if (config == null) {
            config = (ApplicationConfig)pageContext.getServletContext().getAttribute("org.apache.struts.action.APPLICATION");
            pageContext.getRequest().setAttribute("org.apache.struts.action.APPLICATION", (Object)config);
        }
        StringBuffer url = new StringBuffer();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        if (forward != null) {
            ForwardConfig fc = config.findForwardConfig(forward);
            if (fc == null) {
                throw new MalformedURLException(messages.getMessage("computeURL.forward", (Object)forward));
            }
            if (fc.getRedirect()) {
                redirect = true;
            }
            if (fc.getPath().startsWith("/")) {
                url.append(request.getContextPath());
                url.append(RequestUtils.forwardURL(request, fc));
            } else {
                url.append(fc.getPath());
            }
        } else if (href != null) {
            url.append(href);
        } else {
            url.append(request.getContextPath());
            url.append(RequestUtils.pageURL(request, page));
        }
        if (anchor != null) {
            temp = url.toString();
            hash = temp.indexOf(35);
            if (hash >= 0) {
                url.setLength(hash);
            }
            url.append('#');
            url.append(URLEncoder.encode(anchor));
        }
        if (params != null && params.size() > 0) {
            temp = url.toString();
            hash = temp.indexOf(35);
            if (hash >= 0) {
                anchor = temp.substring(hash + 1);
                url.setLength(hash);
                temp = url.toString();
            } else {
                anchor = null;
            }
            boolean question = temp.indexOf(63) >= 0;
            Iterator keys = params.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = params.get(key);
                if (value == null) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append("&");
                    }
                    url.append(URLEncoder.encode(key));
                    url.append('=');
                    continue;
                }
                if (value instanceof String) {
                    if (!question) {
                        url.append('?');
                        question = true;
                    } else {
                        url.append("&");
                    }
                    url.append(URLEncoder.encode(key));
                    url.append('=');
                    url.append(URLEncoder.encode((String)value));
                    continue;
                }
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    int i = 0;
                    while (i < values.length) {
                        if (!question) {
                            url.append('?');
                            question = true;
                        } else {
                            url.append("&");
                        }
                        url.append(URLEncoder.encode(key));
                        url.append('=');
                        url.append(URLEncoder.encode(values[i]));
                        ++i;
                    }
                    continue;
                }
                if (!question) {
                    url.append('?');
                    question = true;
                } else {
                    url.append("&");
                }
                url.append(URLEncoder.encode(key));
                url.append('=');
                url.append(URLEncoder.encode(value.toString()));
            }
            if (anchor != null) {
                url.append('#');
                url.append(URLEncoder.encode(anchor));
            }
        }
        if (pageContext.getSession() != null) {
            HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
            if (redirect) {
                return response.encodeRedirectURL(url.toString());
            }
            return response.encodeURL(url.toString());
        }
        return url.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static ActionForm createActionForm(HttpServletRequest request, ActionMapping mapping, ApplicationConfig appConfig, ActionServlet servlet) {
        attribute = mapping.getAttribute();
        if (attribute == null) {
            return null;
        }
        name = mapping.getName();
        config = appConfig.findFormBeanConfig(name);
        if (config == null) {
            return null;
        }
        if (RequestUtils.LOG.isDebugEnabled()) {
            RequestUtils.LOG.debug((Object)(" Looking for ActionForm bean instance in scope '" + mapping.getScope() + "' under attribute key '" + attribute + "'"));
        }
        instance = null;
        session = null;
        if ("request".equals(mapping.getScope())) {
            instance = (ActionForm)request.getAttribute(attribute);
        } else {
            session = request.getSession();
            instance = (ActionForm)session.getAttribute(attribute);
        }
        if (instance != null) {
            if (config.getDynamic()) {
                className = ((DynaBean)instance).getDynaClass().getName();
                if (className.equals(config.getName())) {
                    if (RequestUtils.LOG.isDebugEnabled()) {
                        RequestUtils.LOG.debug((Object)(" Recycling existing DynaActionForm instance of type '" + className + "'"));
                        RequestUtils.LOG.trace((Object)(" --> " + instance));
                    }
                    return instance;
                }
            } else {
                try {
                    configClass = RequestUtils.applicationClass(config.getType());
                    if (configClass.isAssignableFrom(instance.getClass())) {
                        if (RequestUtils.LOG.isDebugEnabled()) {
                            RequestUtils.LOG.debug((Object)(" Recycling existing ActionForm instance of class '" + instance.getClass().getName() + "'"));
                            RequestUtils.LOG.trace((Object)(" --> " + instance));
                        }
                        return instance;
                    }
                    return instance;
                }
                catch (Throwable t) {
                    RequestUtils.LOG.error((Object)servlet.getInternal().getMessage("formBean", (Object)config.getName()), t);
                    return null;
                }
            }
        }
        if (config.getDynamic()) {
            try {
                dynaClass = DynaActionFormClass.createDynaActionFormClass(config);
                instance = (ActionForm)dynaClass.newInstance();
                if (!RequestUtils.LOG.isDebugEnabled()) ** GOTO lbl57
                RequestUtils.LOG.debug((Object)(" Creating new DynaActionForm instance of type '" + config.getType() + "'"));
                RequestUtils.LOG.trace((Object)(" --> " + instance));
            }
            catch (Throwable t) {
                RequestUtils.LOG.error((Object)servlet.getInternal().getMessage("formBean", (Object)config.getName()), t);
                return null;
            }
        } else {
            try {
                instance = (ActionForm)RequestUtils.applicationInstance(config.getType());
                if (RequestUtils.LOG.isDebugEnabled()) {
                    RequestUtils.LOG.debug((Object)(" Creating new ActionForm instance of type '" + config.getType() + "'"));
                    RequestUtils.LOG.trace((Object)(" --> " + instance));
                }
            }
            catch (Throwable t) {
                RequestUtils.LOG.error((Object)servlet.getInternal().getMessage("formBean", (Object)config.getName()), t);
                return null;
            }
        }
lbl57:
        // 3 sources

        instance.setServlet(servlet);
        return instance;
    }

    public static Object lookup(PageContext pageContext, String name, String scope) throws JspException {
        Object bean = null;
        if (scope == null) {
            bean = pageContext.findAttribute(name);
        } else if (scope.equalsIgnoreCase("page")) {
            bean = pageContext.getAttribute(name, 1);
        } else if (scope.equalsIgnoreCase("request")) {
            bean = pageContext.getAttribute(name, 2);
        } else if (scope.equalsIgnoreCase("session")) {
            bean = pageContext.getAttribute(name, 3);
        } else if (scope.equalsIgnoreCase("application")) {
            bean = pageContext.getAttribute(name, 4);
        } else {
            JspException e = new JspException(messages.getMessage("lookup.scope", (Object)scope));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        return bean;
    }

    public static Object lookup(PageContext pageContext, String name, String property, String scope) throws JspException {
        Object bean = RequestUtils.lookup(pageContext, name, scope);
        if (bean == null) {
            JspException e = null;
            e = scope == null ? new JspException(messages.getMessage("lookup.bean.any", (Object)name)) : new JspException(messages.getMessage("lookup.bean", (Object)name, (Object)scope));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        if (property == null) {
            return bean;
        }
        try {
            return PropertyUtils.getProperty(bean, property);
        }
        catch (IllegalAccessException e) {
            RequestUtils.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.access", (Object)property, (Object)name));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                t = e;
            }
            RequestUtils.saveException(pageContext, t);
            throw new JspException(messages.getMessage("lookup.target", (Object)property, (Object)name));
        }
        catch (NoSuchMethodException e) {
            RequestUtils.saveException(pageContext, e);
            throw new JspException(messages.getMessage("lookup.method", (Object)property, (Object)name));
        }
    }

    public static Locale retrieveUserLocale(PageContext pageContext, String locale) {
        Locale userLocale;
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        if ((userLocale = (Locale)pageContext.getAttribute(locale, 3)) == null) {
            userLocale = defaultLocale;
        }
        return userLocale;
    }

    public static String message(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        return RequestUtils.message(pageContext, bundle, locale, key, null);
    }

    public static String message(PageContext pageContext, String bundle, String locale, String key, Object[] args) throws JspException {
        MessageResources resources = null;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
            resources = (MessageResources)pageContext.getAttribute(bundle, 2);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 4);
        }
        if (resources == null) {
            JspException e = new JspException(messages.getMessage("message.bundle", (Object)bundle));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        Locale userLocale = RequestUtils.retrieveUserLocale(pageContext, locale);
        if (args == null) {
            return resources.getMessage(userLocale, key);
        }
        return resources.getMessage(userLocale, key, args);
    }

    public static void populate(Object bean, HttpServletRequest request) throws ServletException {
        RequestUtils.populate(bean, null, null, request);
    }

    public static void populate(Object bean, String prefix, String suffix, HttpServletRequest request) throws ServletException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Enumeration names = null;
        Hashtable multipartElements = null;
        String contentType = request.getContentType();
        String method = request.getMethod();
        boolean isMultipart = false;
        if (contentType != null && contentType.startsWith("multipart/form-data") && method.equalsIgnoreCase("POST")) {
            if (!(bean instanceof ActionForm)) {
                throw new ServletException("bean that's supposed to be populated from a multipart request is not of type \"org.apache.struts.action.ActionForm\", but type \"" + bean.getClass().getName() + "\"");
            }
            ActionServletWrapper servlet = ((ActionForm)bean).getServletWrapper();
            MultipartRequestHandler multipartHandler = RequestUtils.getMultipartHandler(request, servlet);
            ((ActionForm)bean).setMultipartRequestHandler(multipartHandler);
            if (multipartHandler != null) {
                isMultipart = true;
                servlet.setServletFor(multipartHandler);
                multipartHandler.setMapping((ActionMapping)request.getAttribute("org.apache.struts.action.mapping.instance"));
                multipartHandler.handleRequest(request);
                Boolean maxLengthExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
                if (maxLengthExceeded != null && maxLengthExceeded.booleanValue()) {
                    return;
                }
                multipartElements = multipartHandler.getAllElements();
                names = multipartElements.keys();
            }
            request.removeAttribute("org.apache.struts.action.mapping.instance");
        }
        if (!isMultipart) {
            names = request.getParameterNames();
        }
        while (names.hasMoreElements()) {
            String name;
            String stripped = name = (String)names.nextElement();
            int subscript = stripped.lastIndexOf("[");
            if (prefix != null) {
                if (!stripped.startsWith(prefix)) continue;
                stripped = stripped.substring(prefix.length());
            }
            if (suffix != null) {
                if (!stripped.endsWith(suffix)) continue;
                stripped = stripped.substring(0, stripped.length() - suffix.length());
            }
            if (isMultipart) {
                properties.put(stripped, multipartElements.get(name));
                continue;
            }
            properties.put(stripped, request.getParameterValues(name));
        }
        try {
            BeanUtils.populate(bean, properties);
        }
        catch (Exception e) {
            throw new ServletException("BeanUtils.populate", (Throwable)e);
        }
    }

    private static MultipartRequestHandler getMultipartHandler(HttpServletRequest request, ActionServletWrapper servlet) throws ServletException {
        ApplicationConfig appConfig;
        MultipartRequestHandler multipartHandler = null;
        String multipartClass = (String)request.getAttribute("org.apache.struts.action.mapping.multipartclass");
        request.removeAttribute("org.apache.struts.action.mapping.multipartclass");
        if (multipartClass != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error((Object)("MultipartRequestHandler class \"" + multipartClass + "\" in mapping class not found, " + "defaulting to global multipart class"));
            }
            catch (InstantiationException ie) {
                LOG.error((Object)("InstantiaionException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + ie.getMessage()));
            }
            catch (IllegalAccessException iae) {
                LOG.error((Object)("IllegalAccessException when instantiating MultipartRequestHandler \"" + multipartClass + "\", " + "defaulting to global multipart class, exception: " + iae.getMessage()));
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        if ((multipartClass = (appConfig = (ApplicationConfig)request.getAttribute("org.apache.struts.action.APPLICATION")).getControllerConfig().getMultipartClass()) != null) {
            try {
                multipartHandler = (MultipartRequestHandler)RequestUtils.applicationInstance(multipartClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ServletException("Cannot find multipart class \"" + multipartClass + "\"" + ", exception: " + cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                throw new ServletException("InstantiaionException when instantiating multipart class \"" + multipartClass + "\", exception: " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ServletException("IllegalAccessException when instantiating multipart class \"" + multipartClass + "\", exception: " + iae.getMessage());
            }
            if (multipartHandler != null) {
                return multipartHandler;
            }
        }
        return multipartHandler;
    }

    public static boolean present(PageContext pageContext, String bundle, String locale, String key) throws JspException {
        Locale userLocale;
        MessageResources resources = null;
        if (bundle == null) {
            bundle = "org.apache.struts.action.MESSAGE";
            resources = (MessageResources)pageContext.getAttribute(bundle);
        }
        if (resources == null) {
            resources = (MessageResources)pageContext.getAttribute(bundle, 4);
        }
        if (resources == null) {
            JspException e = new JspException(messages.getMessage("message.bundle", (Object)bundle));
            RequestUtils.saveException(pageContext, e);
            throw e;
        }
        if (locale == null) {
            locale = "org.apache.struts.action.LOCALE";
        }
        if ((userLocale = (Locale)pageContext.getAttribute(locale, 3)) == null) {
            userLocale = defaultLocale;
        }
        return resources.isPresent(userLocale, key);
    }

    public static String printableURL(URL url) {
        if (url.getHost() != null) {
            return url.toString();
        }
        String file = url.getFile();
        String ref = url.getRef();
        if (ref == null) {
            return file;
        }
        StringBuffer sb = new StringBuffer(file);
        sb.append('#');
        sb.append(ref);
        return sb.toString();
    }

    public static String actionURL(HttpServletRequest request, ActionConfig action, String pattern) {
        StringBuffer sb = new StringBuffer();
        if (pattern.endsWith("/*")) {
            sb.append(pattern.substring(0, pattern.length() - 2));
            sb.append(action.getPath());
        } else if (pattern.startsWith("*.")) {
            ApplicationConfig appConfig = (ApplicationConfig)request.getAttribute("org.apache.struts.action.APPLICATION");
            sb.append(appConfig.getPrefix());
            sb.append(action.getPath());
            sb.append(pattern.substring(1));
        } else {
            throw new IllegalArgumentException(pattern);
        }
        return sb.toString();
    }

    public static String forwardURL(HttpServletRequest request, ForwardConfig forward) {
        String path = forward.getPath();
        StringBuffer sb = new StringBuffer();
        if (forward.getContextRelative()) {
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
            return sb.toString();
        }
        ApplicationConfig appConfig = (ApplicationConfig)request.getAttribute("org.apache.struts.action.APPLICATION");
        String forwardPattern = appConfig.getControllerConfig().getForwardPattern();
        if (forwardPattern == null) {
            sb.append(appConfig.getPrefix());
            if (!path.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
        } else {
            boolean dollar = false;
            int i = 0;
            while (i < forwardPattern.length()) {
                char ch = forwardPattern.charAt(i);
                if (dollar) {
                    switch (ch) {
                        case 'M': {
                            sb.append(appConfig.getPrefix());
                            break;
                        }
                        case 'P': {
                            if (!path.startsWith("/")) {
                                sb.append("/");
                            }
                            sb.append(path);
                            break;
                        }
                        case '$': {
                            sb.append('$');
                            break;
                        }
                    }
                    dollar = false;
                } else if (ch == '$') {
                    dollar = true;
                } else {
                    sb.append(ch);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static String pageURL(HttpServletRequest request, String page) {
        StringBuffer sb = new StringBuffer();
        ApplicationConfig appConfig = (ApplicationConfig)request.getAttribute("org.apache.struts.action.APPLICATION");
        String pagePattern = appConfig.getControllerConfig().getPagePattern();
        if (pagePattern == null) {
            sb.append(appConfig.getPrefix());
            sb.append(page);
        } else {
            boolean dollar = false;
            int i = 0;
            while (i < pagePattern.length()) {
                char ch = pagePattern.charAt(i);
                if (dollar) {
                    switch (ch) {
                        case 'M': {
                            sb.append(appConfig.getPrefix());
                            break;
                        }
                        case 'P': {
                            sb.append(page);
                            break;
                        }
                        case '$': {
                            sb.append('$');
                            break;
                        }
                    }
                    dollar = false;
                } else if (ch == '$') {
                    dollar = true;
                } else {
                    sb.append(ch);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static URL requestURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = new StringBuffer();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(request.getRequestURI());
        return new URL(url.toString());
    }

    public static URL serverURL(HttpServletRequest request) throws MalformedURLException {
        StringBuffer url = new StringBuffer();
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        return new URL(url.toString());
    }

    public static void saveException(PageContext pageContext, Throwable exception) {
        pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)exception, 2);
    }

    public static void selectApplication(String prefix, HttpServletRequest request, ServletContext context) {
        ApplicationConfig config = (ApplicationConfig)context.getAttribute("org.apache.struts.action.APPLICATION" + prefix);
        if (config != null) {
            request.setAttribute("org.apache.struts.action.APPLICATION", (Object)config);
        } else {
            request.removeAttribute("org.apache.struts.action.APPLICATION");
        }
        MessageResources resources = (MessageResources)context.getAttribute("org.apache.struts.action.MESSAGE" + prefix);
        if (resources != null) {
            request.setAttribute("org.apache.struts.action.MESSAGE", (Object)resources);
        } else {
            request.removeAttribute("org.apache.struts.action.MESSAGE");
        }
    }

    public static void selectApplication(HttpServletRequest request, ServletContext context) {
        String matchPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (matchPath == null) {
            matchPath = request.getServletPath();
        }
        String prefix = "";
        String[] prefixes = RequestUtils.getApplicationPrefixes(context);
        int i = 0;
        while (i < prefixes.length) {
            if (matchPath.startsWith(prefixes[i])) {
                prefix = prefixes[i];
                break;
            }
            ++i;
        }
        RequestUtils.selectApplication(prefix, request, context);
    }

    public static String[] getApplicationPrefixes(ServletContext context) {
        String[] prefixes = (String[])context.getAttribute(PREFIXES_KEY);
        if (prefixes != null) {
            return prefixes;
        }
        ArrayList<String> list = new ArrayList<String>();
        Enumeration names = context.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("org.apache.struts.action.APPLICATION")) continue;
            ApplicationConfig config = (ApplicationConfig)context.getAttribute(name);
            String prefix = name.substring("org.apache.struts.action.APPLICATION".length());
            if (prefix.length() <= 0) continue;
            list.add(prefix);
        }
        prefixes = list.toArray(new String[list.size()]);
        context.setAttribute(PREFIXES_KEY, (Object)prefixes);
        return prefixes;
    }

    public static ActionMessages getActionMessages(PageContext pageContext, String paramName) throws JspException {
        ActionMessages am;
        block10: {
            am = new ActionMessages();
            Object value = pageContext.getAttribute(paramName, 2);
            try {
                if (value == null) break block10;
                if (value instanceof String) {
                    am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage((String)value));
                    break block10;
                }
                if (value instanceof String[]) {
                    String[] keys = (String[])value;
                    int i = 0;
                    while (i < keys.length) {
                        am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(keys[i]));
                        ++i;
                    }
                    break block10;
                }
                if (value instanceof ErrorMessages) {
                    String[] keys = ((ErrorMessages)value).getErrors();
                    if (keys == null) {
                        keys = new String[]{};
                    }
                    int i = 0;
                    while (i < keys.length) {
                        am.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(keys[i]));
                        ++i;
                    }
                    break block10;
                }
                if (value instanceof ActionMessages) {
                    am = (ActionMessages)value;
                    break block10;
                }
                throw new JspException(messages.getMessage("actionMessages.errors", (Object)value.getClass().getName()));
            }
            catch (JspException e) {
                throw e;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return am;
    }

    public static ActionErrors getActionErrors(PageContext pageContext, String paramName) throws JspException {
        ActionErrors errors;
        block10: {
            errors = new ActionErrors();
            Object value = pageContext.getAttribute(paramName, 2);
            try {
                if (value == null) break block10;
                if (value instanceof String) {
                    errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError((String)value));
                    break block10;
                }
                if (value instanceof String[]) {
                    String[] keys = (String[])value;
                    int i = 0;
                    while (i < keys.length) {
                        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(keys[i]));
                        ++i;
                    }
                    break block10;
                }
                if (value instanceof ErrorMessages) {
                    String[] keys = ((ErrorMessages)value).getErrors();
                    if (keys == null) {
                        keys = new String[]{};
                    }
                    int i = 0;
                    while (i < keys.length) {
                        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError(keys[i]));
                        ++i;
                    }
                    break block10;
                }
                if (value instanceof ActionErrors) {
                    errors = (ActionErrors)value;
                    break block10;
                }
                throw new JspException(messages.getMessage("actionErrors.errors", (Object)value.getClass().getName()));
            }
            catch (JspException e) {
                throw e;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return errors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PREFIXES_KEY = PREFIXES_KEY;
    }
}

