/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;

public class JspConfig {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jasper$compiler$JspConfig == null ? (class$org$apache$jasper$compiler$JspConfig = JspConfig.class$("org.apache.jasper.compiler.JspConfig")) : class$org$apache$jasper$compiler$JspConfig));
    private Vector jspProperties = null;
    private ServletContext ctxt;
    private boolean initialized = false;
    private String defaultIsXml = null;
    private String defaultIsELIgnored = null;
    private String defaultIsScriptingInvalid = "false";
    private JspProperty defaultJspProperty;
    static /* synthetic */ Class class$org$apache$jasper$compiler$JspConfig;

    public JspConfig(ServletContext ctxt) {
        this.ctxt = ctxt;
    }

    private void processWebDotXml(ServletContext ctxt) throws JasperException {
        InputStream is = ctxt.getResourceAsStream(WEB_XML);
        if (is == null) {
            return;
        }
        ParserUtils pu = new ParserUtils();
        TreeNode webApp = pu.parseXMLDocument(WEB_XML, is);
        if (webApp == null || !"2.4".equals(webApp.findAttribute("version"))) {
            this.defaultIsELIgnored = "true";
            return;
        }
        TreeNode jspConfig = webApp.findChild("jsp-config");
        if (jspConfig == null) {
            return;
        }
        this.jspProperties = new Vector();
        Iterator jspPropertyList = jspConfig.findChildren("jsp-property-group");
        while (jspPropertyList.hasNext()) {
            TreeNode element = (TreeNode)jspPropertyList.next();
            Iterator list = element.findChildren();
            Vector<String> urlPatterns = new Vector<String>();
            String pageEncoding = null;
            String scriptingInvalid = null;
            String elIgnored = null;
            String isXml = null;
            Vector<String> includePrelude = new Vector<String>();
            Vector<String> includeCoda = new Vector<String>();
            while (list.hasNext()) {
                element = (TreeNode)list.next();
                String tname = element.getName();
                if ("url-pattern".equals(tname)) {
                    urlPatterns.addElement(element.getBody());
                    continue;
                }
                if ("page-encoding".equals(tname)) {
                    pageEncoding = element.getBody();
                    continue;
                }
                if ("is-xml".equals(tname)) {
                    isXml = element.getBody();
                    continue;
                }
                if ("el-ignored".equals(tname)) {
                    elIgnored = element.getBody();
                    continue;
                }
                if ("scripting-invalid".equals(tname)) {
                    scriptingInvalid = element.getBody();
                    continue;
                }
                if ("include-prelude".equals(tname)) {
                    includePrelude.addElement(element.getBody());
                    continue;
                }
                if (!"include-coda".equals(tname)) continue;
                includeCoda.addElement(element.getBody());
            }
            if (urlPatterns.size() == 0) continue;
            for (int p = 0; p < urlPatterns.size(); ++p) {
                String urlPattern = (String)urlPatterns.elementAt(p);
                String path = null;
                String extension = null;
                if (urlPattern.indexOf(42) < 0) {
                    path = urlPattern;
                } else {
                    String file;
                    int i = urlPattern.lastIndexOf(47);
                    if (i >= 0) {
                        path = urlPattern.substring(0, i + 1);
                        file = urlPattern.substring(i + 1);
                    } else {
                        file = urlPattern;
                    }
                    if (file.equals("*")) {
                        extension = "*";
                    } else if (file.startsWith("*.")) {
                        extension = file.substring(file.indexOf(46) + 1);
                    } else {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)Localizer.getMessage("jsp.warning.bad.urlpattern.propertygroup", urlPattern));
                        continue;
                    }
                }
                JspProperty property = new JspProperty(isXml, elIgnored, scriptingInvalid, pageEncoding, includePrelude, includeCoda);
                JspPropertyGroup propertyGroup = new JspPropertyGroup(path, extension, property);
                this.jspProperties.addElement(propertyGroup);
            }
        }
    }

    private void init() throws JasperException {
        if (!this.initialized) {
            this.processWebDotXml(this.ctxt);
            this.defaultJspProperty = new JspProperty(this.defaultIsXml, this.defaultIsELIgnored, this.defaultIsScriptingInvalid, null, null, null);
            this.initialized = true;
        }
    }

    public JspProperty findJspProperty(String uri) throws JasperException {
        this.init();
        if (this.jspProperties == null || uri.endsWith(".tag") || uri.endsWith(".tagx")) {
            return this.defaultJspProperty;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        Vector includePreludes = new Vector();
        Vector includeCodas = new Vector();
        JspPropertyGroup isXmlMatch = null;
        JspPropertyGroup elIgnoredMatch = null;
        JspPropertyGroup scriptingInvalidMatch = null;
        JspPropertyGroup pageEncodingMatch = null;
        Iterator iter = this.jspProperties.iterator();
        while (iter.hasNext()) {
            JspPropertyGroup jpg = (JspPropertyGroup)iter.next();
            JspProperty jp = jpg.getJspProperty();
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (extension == null) {
                if (!uri.equals(path)) continue;
                if (jp.getIncludePrelude() != null) {
                    includePreludes.addAll(jp.getIncludePrelude());
                }
                if (jp.getIncludeCoda() != null) {
                    includeCodas.addAll(jp.getIncludeCoda());
                }
                if (jp.isXml() != null) {
                    isXmlMatch = jpg;
                }
                if (jp.isELIgnored() != null) {
                    elIgnoredMatch = jpg;
                }
                if (jp.isScriptingInvalid() != null) {
                    scriptingInvalidMatch = jpg;
                }
                if (jp.getPageEncoding() == null) continue;
                pageEncodingMatch = jpg;
                continue;
            }
            if (path != null && !path.equals(uriPath) || !extension.equals("*") && !extension.equals(uriExtension)) continue;
            if (jp.getIncludePrelude() != null) {
                includePreludes.addAll(jp.getIncludePrelude());
            }
            if (jp.getIncludeCoda() != null) {
                includeCodas.addAll(jp.getIncludeCoda());
            }
            if (jp.isXml() != null && (isXmlMatch == null || isXmlMatch.getExtension() != null && isXmlMatch.getExtension().equals("*"))) {
                isXmlMatch = jpg;
            }
            if (jp.isELIgnored() != null && (elIgnoredMatch == null || elIgnoredMatch.getExtension() != null && elIgnoredMatch.getExtension().equals("*"))) {
                elIgnoredMatch = jpg;
            }
            if (jp.isScriptingInvalid() != null && (scriptingInvalidMatch == null || scriptingInvalidMatch.getExtension() != null && scriptingInvalidMatch.getExtension().equals("*"))) {
                scriptingInvalidMatch = jpg;
            }
            if (jp.getPageEncoding() == null || pageEncodingMatch != null && (pageEncodingMatch.getExtension() == null || !pageEncodingMatch.getExtension().equals("*"))) continue;
            pageEncodingMatch = jpg;
        }
        String isXml = this.defaultIsXml;
        String isELIgnored = this.defaultIsELIgnored;
        String isScriptingInvalid = this.defaultIsScriptingInvalid;
        String pageEncoding = null;
        if (isXmlMatch != null) {
            isXml = isXmlMatch.getJspProperty().isXml();
        }
        if (elIgnoredMatch != null) {
            isELIgnored = elIgnoredMatch.getJspProperty().isELIgnored();
        }
        if (scriptingInvalidMatch != null) {
            isScriptingInvalid = scriptingInvalidMatch.getJspProperty().isScriptingInvalid();
        }
        if (pageEncodingMatch != null) {
            pageEncoding = pageEncodingMatch.getJspProperty().getPageEncoding();
        }
        return new JspProperty(isXml, isELIgnored, isScriptingInvalid, pageEncoding, includePreludes, includeCodas);
    }

    public boolean isJspPage(String uri) throws JasperException {
        this.init();
        if (this.jspProperties == null) {
            return false;
        }
        String uriPath = null;
        int index = uri.lastIndexOf(47);
        if (index >= 0) {
            uriPath = uri.substring(0, index + 1);
        }
        String uriExtension = null;
        index = uri.lastIndexOf(46);
        if (index >= 0) {
            uriExtension = uri.substring(index + 1);
        }
        Iterator iter = this.jspProperties.iterator();
        while (iter.hasNext()) {
            JspPropertyGroup jpg = (JspPropertyGroup)iter.next();
            JspProperty jp = jpg.getJspProperty();
            String extension = jpg.getExtension();
            String path = jpg.getPath();
            if (!(extension == null ? uri.equals(path) : !(path != null && !path.equals(uriPath) || !extension.equals("*") && !extension.equals(uriExtension)))) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class JspProperty {
        private String isXml;
        private String elIgnored;
        private String scriptingInvalid;
        private String pageEncoding;
        private Vector includePrelude;
        private Vector includeCoda;

        public JspProperty(String isXml, String elIgnored, String scriptingInvalid, String pageEncoding, Vector includePrelude, Vector includeCoda) {
            this.isXml = isXml;
            this.elIgnored = elIgnored;
            this.scriptingInvalid = scriptingInvalid;
            this.pageEncoding = pageEncoding;
            this.includePrelude = includePrelude;
            this.includeCoda = includeCoda;
        }

        public String isXml() {
            return this.isXml;
        }

        public String isELIgnored() {
            return this.elIgnored;
        }

        public String isScriptingInvalid() {
            return this.scriptingInvalid;
        }

        public String getPageEncoding() {
            return this.pageEncoding;
        }

        public Vector getIncludePrelude() {
            return this.includePrelude;
        }

        public Vector getIncludeCoda() {
            return this.includeCoda;
        }
    }

    static class JspPropertyGroup {
        private String path;
        private String extension;
        private JspProperty jspProperty;

        JspPropertyGroup(String path, String extension, JspProperty jspProperty) {
            this.path = path;
            this.extension = extension;
            this.jspProperty = jspProperty;
        }

        public String getPath() {
            return this.path;
        }

        public String getExtension() {
            return this.extension;
        }

        public JspProperty getJspProperty() {
            return this.jspProperty;
        }
    }
}

