/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.trace;

import com.sun.jmx.trace.Trace;
import com.sun.jmx.trace.TraceDestination;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TraceImplementation
implements TraceDestination {
    private PrintWriter out;
    private int level;

    static TraceImplementation newDestination(int n) {
        try {
            TraceImplementation traceImplementation = new TraceImplementation();
            traceImplementation.level = n;
            return traceImplementation;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void init() throws IOException {
        Trace.setDestination(new TraceImplementation());
    }

    public static void init(int n) throws IOException {
        TraceImplementation traceImplementation = new TraceImplementation();
        traceImplementation.level = n;
        Trace.setDestination(traceImplementation);
    }

    public TraceImplementation() throws IOException {
        String string = System.getProperty("com.sun.jmx.trace.file");
        this.out = string != null ? new PrintWriter(new FileOutputStream(string), true) : new PrintWriter(System.err, true);
        String string2 = System.getProperty("com.sun.jmx.trace.level");
        this.level = string2 != null ? (string2.equals("DEBUG") ? 2 : (string2.equals("TRACE") ? 1 : 0)) : 0;
    }

    public boolean isSelected(int n, int n2) {
        return n <= this.level;
    }

    public boolean send(int n, int n2, String string, String string2, String string3) {
        if (this.isSelected(n, n2)) {
            this.out.println((string != null ? "Class:  " + string : "") + (string2 != null ? "\nMethod: " + string2 : "") + "\n\tlevel:   " + TraceImplementation.getLevel(n) + "\n\ttype:    " + TraceImplementation.getType(n2) + "\n\tmessage: " + string3);
            return true;
        }
        return false;
    }

    public boolean send(int n, int n2, String string, String string2, Throwable throwable) {
        boolean bl = this.send(n, n2, string, string2, throwable.toString());
        if (bl) {
            throwable.printStackTrace(this.out);
        }
        return bl;
    }

    public void reset() throws IOException {
    }

    private static String getType(int n) {
        switch (n) {
            case 1: {
                return "INFO_MBEANSERVER";
            }
            case 2: {
                return "INFO_MLET";
            }
            case 4: {
                return "INFO_MONITOR";
            }
            case 8: {
                return "INFO_TIMER";
            }
            case 16: {
                return "INFO_MISC";
            }
            case 32: {
                return "INFO_NOTIFICATION";
            }
            case 64: {
                return "INFO_RELATION";
            }
            case 128: {
                return "INFO_MODELMBEAN";
            }
        }
        return "UNKNOWN_TRACE_TYPE";
    }

    private static String getLevel(int n) {
        switch (n) {
            case 0: {
                return "LEVEL_ERROR";
            }
            case 1: {
                return "LEVEL_TRACE";
            }
            case 2: {
                return "LEVEL_DEBUG";
            }
        }
        return "UNKNOWN_TRACE_LEVEL";
    }
}

