/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.generic.SynchroMessageConnection;
import com.sun.jmx.remote.opt.internal.ServerCommunicatorAdmin;
import com.sun.jmx.remote.opt.internal.ServerNotifForwarder;
import com.sun.jmx.remote.opt.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.opt.util.CacheMap;
import com.sun.jmx.remote.opt.util.ClassLoaderWithRepository;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.OrderClassLoaders;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.JMXServerErrorException;
import javax.management.remote.NotificationResult;
import javax.management.remote.SubjectDelegationPermission;
import javax.management.remote.TargetedNotification;
import javax.management.remote.generic.ConnectionClosedException;
import javax.management.remote.generic.GenericConnectorServer;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.NotificationRequestMessage;
import javax.management.remote.message.NotificationResponseMessage;
import javax.security.auth.Subject;

class ServerIntermediary {
    private final MBeanServer mbeanServer;
    private final GenericConnectorServer myServer;
    private final SynchroMessageConnection connection;
    private final String clientId;
    private final RequestHandler requestHandler = new RequestHandler();
    private final ObjectWrapping serialization;
    private final AccessControlContext acc;
    private final Subject subject;
    private final CacheMap accCache;
    private final CacheMap principalsCache;
    private final ClassLoader defaultClassLoader;
    private final ClassLoaderWithRepository clr;
    private final ServerNotifForwarder serverNotifForwarder;
    private GenericServerCommunicatorAdmin serverCommunicatorAdmin;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.generic", "ServerIntermediary");
    private static final int RUNNING = 0;
    private static final int FAILED = 1;
    private static final int TERMINATED = 2;
    private int state = 0;
    private final int[] stateLock = new int[0];

    public ServerIntermediary(MBeanServer mBeanServer, GenericConnectorServer genericConnectorServer, SynchroMessageConnection synchroMessageConnection, ObjectWrapping objectWrapping, Subject subject, ClassLoader classLoader, Map map) {
        if (logger.traceOn()) {
            logger.trace("constructor", "Create a ServerIntermediary object.");
        }
        if (mBeanServer == null) {
            throw new NullPointerException("Null mbeaser server.");
        }
        if (synchroMessageConnection == null) {
            throw new NullPointerException("Null connection.");
        }
        this.mbeanServer = mBeanServer;
        this.myServer = genericConnectorServer;
        this.connection = synchroMessageConnection;
        this.clientId = synchroMessageConnection.getConnectionId();
        this.serialization = objectWrapping;
        this.accCache = new CacheMap(10);
        this.principalsCache = new CacheMap(10);
        this.subject = subject;
        this.acc = subject == null ? null : new AccessControlContext(AccessController.getContext(), new JMXSubjectDomainCombiner(subject));
        this.defaultClassLoader = classLoader;
        final ClassLoader classLoader2 = classLoader;
        this.clr = (ClassLoaderWithRepository)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ClassLoaderWithRepository(ServerIntermediary.this.getClassLoaderRepository(), classLoader2);
            }
        });
        long l = EnvHelp.getServerConnectionTimeout(map);
        this.serverCommunicatorAdmin = new GenericServerCommunicatorAdmin(l);
        this.serverNotifForwarder = new ServerNotifForwarder(mBeanServer, map);
        this.connection.setCallback(this.requestHandler);
    }

    public Object handleRequest(MBeanServerRequestMessage mBeanServerRequestMessage) throws Exception {
        if (logger.traceOn()) {
            logger.trace("handleRequest", "Handle a request: " + mBeanServerRequestMessage);
        }
        if (mBeanServerRequestMessage == null) {
            return null;
        }
        Object[] objectArray = mBeanServerRequestMessage.getParams();
        switch (mBeanServerRequestMessage.getMethodId()) {
            case 3: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a CREATE_MBEAN request.");
                }
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1]);
            }
            case 5: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a CREATE_MBEAN_LOADER request.");
                }
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (ObjectName)objectArray[2]);
            }
            case 4: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a CREATE_MBEAN_PARAMS request.");
                }
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (Object[])this.serialization.unwrap(objectArray[2], this.clr), (String[])objectArray[3]);
            }
            case 6: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a CREATE_MBEAN_LOADER_PARAMS request.");
                }
                return this.mbeanServer.createMBean((String)objectArray[0], (ObjectName)objectArray[1], (ObjectName)objectArray[2], (Object[])this.unwrapWithDefault(objectArray[3], this.getClassLoader((ObjectName)objectArray[2])), (String[])objectArray[4]);
            }
            case 7: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_ATTRIBUTE request.");
                }
                return this.mbeanServer.getAttribute((ObjectName)objectArray[0], (String)objectArray[1]);
            }
            case 8: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_ATTRIBUTES request.");
                }
                return this.mbeanServer.getAttributes((ObjectName)objectArray[0], (String[])objectArray[1]);
            }
            case 9: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_DEFAULT_DOMAIN request.");
                }
                return this.mbeanServer.getDefaultDomain();
            }
            case 10: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_DOMAINS request.");
                }
                return this.mbeanServer.getDomains();
            }
            case 11: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_MBEAN_COUNT request.");
                }
                return this.mbeanServer.getMBeanCount();
            }
            case 12: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_MBEAN_INFO request.");
                }
                return this.mbeanServer.getMBeanInfo((ObjectName)objectArray[0]);
            }
            case 13: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a GET_OBJECT_INSTANCE request.");
                }
                return this.mbeanServer.getObjectInstance((ObjectName)objectArray[0]);
            }
            case 14: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a INVOKE request.");
                }
                return this.mbeanServer.invoke((ObjectName)objectArray[0], (String)objectArray[1], (Object[])this.unwrapWithDefault(objectArray[2], this.getClassLoaderFor((ObjectName)objectArray[0])), (String[])objectArray[3]);
            }
            case 15: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a IS_INSTANCE_OF request.");
                }
                return this.mbeanServer.isInstanceOf((ObjectName)objectArray[0], (String)objectArray[1]);
            }
            case 16: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a IS_REGISTERED request.");
                }
                return this.mbeanServer.isRegistered((ObjectName)objectArray[0]);
            }
            case 17: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a QUERY_MBEANS request.");
                }
                return this.mbeanServer.queryMBeans((ObjectName)objectArray[0], (QueryExp)this.serialization.unwrap(objectArray[1], this.defaultClassLoader));
            }
            case 18: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a QUERY_NAMES request.");
                }
                return this.mbeanServer.queryNames((ObjectName)objectArray[0], (QueryExp)this.serialization.unwrap(objectArray[1], this.defaultClassLoader));
            }
            case 23: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a SET_ATTRIBUTE request.");
                }
                this.mbeanServer.setAttribute((ObjectName)objectArray[0], (Attribute)this.unwrapWithDefault(objectArray[1], this.getClassLoaderFor((ObjectName)objectArray[0])));
                return null;
            }
            case 24: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a SET_ATTRIBUTES request.");
                }
                return this.mbeanServer.setAttributes((ObjectName)objectArray[0], (AttributeList)this.unwrapWithDefault(objectArray[1], this.getClassLoaderFor((ObjectName)objectArray[0])));
            }
            case 25: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a UNREGISTER_MBEAN request.");
                }
                this.mbeanServer.unregisterMBean((ObjectName)objectArray[0]);
                return null;
            }
            case 2: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a ADD_NOTIFICATION_LISTENER_OBJECTNAME request.");
                }
                ClassLoader classLoader = this.getClassLoaderFor((ObjectName)objectArray[0]);
                this.mbeanServer.addNotificationListener((ObjectName)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)this.unwrapWithDefault(objectArray[2], classLoader), this.unwrapWithDefault(objectArray[3], classLoader));
                return null;
            }
            case 21: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER_OBJECTNAME request.");
                }
                this.mbeanServer.removeNotificationListener((ObjectName)objectArray[0], (ObjectName)objectArray[1]);
                return null;
            }
            case 22: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER_OBJECTNAME_FILTER_HANDBACK request.");
                }
                ClassLoader classLoader = this.getClassLoaderFor((ObjectName)objectArray[0]);
                this.mbeanServer.removeNotificationListener((ObjectName)objectArray[0], (ObjectName)objectArray[1], (NotificationFilter)this.unwrapWithDefault(objectArray[2], classLoader), this.unwrapWithDefault(objectArray[3], classLoader));
                return null;
            }
            case 1: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a ADD_NOTIFICATION_LISTENERS request.");
                }
                ObjectName objectName = ((ObjectName[])objectArray[0])[0];
                ClassLoader classLoader = this.getClassLoaderFor(objectName);
                Object object = ((Object[])objectArray[1])[0];
                return this.serverNotifForwarder.addNotificationListener(objectName, (NotificationFilter)this.unwrapWithDefault(object, classLoader));
            }
            case 20: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER_FILTER_HANDBACK request.");
                }
                this.serverNotifForwarder.removeNotificationListener((ObjectName)objectArray[0], new Integer[]{(Integer)objectArray[1]});
                return null;
            }
            case 19: {
                if (logger.traceOn()) {
                    logger.trace("handleRequest", "Handle a REMOVE_NOTIFICATION_LISTENER request.");
                }
                this.serverNotifForwarder.removeNotificationListener((ObjectName)objectArray[0], (Integer[])objectArray[1]);
                return null;
            }
        }
        logger.error("handleRequest", "Unknown request id: " + mBeanServerRequestMessage.getMethodId());
        throw new IllegalArgumentException("The specified method is not found [MethodId=" + mBeanServerRequestMessage.getMethodId() + "]");
    }

    public void terminate() {
        this.terminate(false, "The server is stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(boolean bl, String string) {
        if (logger.traceOn()) {
            logger.trace("terminate", "Terminating....");
        }
        Object object = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 2) {
                // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                return;
            }
            this.state = 2;
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            if (!bl) {
                if (logger.traceOn()) {
                    logger.trace("terminate", "Send a CloseMessage to the client.");
                }
                try {
                    SynchroMessageConnection synchroMessageConnection = this.connection;
                    object = synchroMessageConnection;
                    synchronized (synchroMessageConnection) {
                        this.connection.sendOneWay(new CloseMessage(string));
                        // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    if (logger.traceOn()) {
                        logger.trace("terminate", "The transport level does not support the method sendOneWay: " + unsupportedOperationException);
                    }
                }
                catch (IOException iOException) {
                    logger.error("terminate", "Failed to inform the client: " + iOException);
                }
            }
            {
                if (this.serverNotifForwarder != null) {
                    this.serverNotifForwarder.terminate();
                }
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.serverCommunicatorAdmin != null) {
                    this.serverCommunicatorAdmin.terminate();
                }
                this.myServer.clientClosing(this, this.clientId, "The method terminate is called.", null);
                if (logger.traceOn()) {
                    logger.trace("terminate", "Terminated.");
                }
                return;
            }
        }
    }

    SynchroMessageConnection getTransport() {
        return this.connection;
    }

    private ClassLoaderRepository getClassLoaderRepository() {
        return (ClassLoaderRepository)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ServerIntermediary.this.mbeanServer.getClassLoaderRepository();
            }
        });
    }

    private ClassLoader getClassLoader(final ObjectName objectName) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return ServerIntermediary.this.mbeanServer.getClassLoader(objectName);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (InstanceNotFoundException)this.extractException(privilegedActionException);
        }
    }

    private ClassLoader getClassLoaderFor(final ObjectName objectName) throws InstanceNotFoundException {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return ServerIntermediary.this.mbeanServer.getClassLoaderFor(objectName);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (InstanceNotFoundException)this.extractException(privilegedActionException);
        }
    }

    private Exception extractException(Exception exception) {
        while (exception instanceof PrivilegedActionException) {
            exception = ((PrivilegedActionException)exception).getException();
        }
        return exception;
    }

    private Object unwrapWithDefault(final Object object, final ClassLoader classLoader) throws IOException, ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, ClassNotFoundException {
                    return ServerIntermediary.this.serialization.unwrap(object, new OrderClassLoaders(classLoader, ServerIntermediary.this.defaultClassLoader));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = this.extractException(privilegedActionException);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            return null;
        }
    }

    private class PrivilegedRequestJob
    implements PrivilegedExceptionAction {
        private MBeanServerRequestMessage request;

        public PrivilegedRequestJob(MBeanServerRequestMessage mBeanServerRequestMessage) {
            this.request = mBeanServerRequestMessage;
        }

        public Object run() throws Exception {
            return ServerIntermediary.this.serialization.wrap(ServerIntermediary.this.handleRequest(this.request));
        }
    }

    private class GenericServerCommunicatorAdmin
    extends ServerCommunicatorAdmin {
        public GenericServerCommunicatorAdmin(long l) {
            super(l);
        }

        protected void doStop() {
            ServerIntermediary.this.terminate();
        }

        public void reqIncoming() throws IOException {
            try {
                super.reqIncoming();
            }
            catch (IOException iOException) {
                throw new ConnectionClosedException(iOException.getMessage());
            }
        }
    }

    private class RequestHandler
    implements SynchroCallback {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public Message execute(Message message) {
            block28: {
                try {
                    ServerIntermediary.this.serverCommunicatorAdmin.reqIncoming();
                    if (logger.traceOn()) {
                        logger.trace("RequestHandler-execute", "Execute the request: " + message);
                    }
                    if (message instanceof CloseMessage) {
                        if (logger.traceOn()) {
                            logger.trace("RequestHandler-execute", "Receive a CloseMessage.");
                        }
                        ServerIntermediary.this.terminate(true, null);
                        Message message2 = null;
                        return message2;
                    }
                    if (message instanceof NotificationRequestMessage) {
                        if (logger.traceOn()) {
                            logger.trace("RequestHandler-execute", "Receive a NotificationRequestMessage.");
                        }
                        NotificationRequestMessage notificationRequestMessage = (NotificationRequestMessage)message;
                        long l = notificationRequestMessage.getClientSequenceNumber();
                        long l2 = notificationRequestMessage.getTimeout();
                        int n = notificationRequestMessage.getMaxNotifications();
                        NotificationResult notificationResult = ServerIntermediary.this.serverNotifForwarder.fetchNotifs(l, l2, n);
                        try {
                            Object object = ServerIntermediary.this.serialization.wrap(notificationResult);
                            NotificationResponseMessage notificationResponseMessage = new NotificationResponseMessage(object);
                            return notificationResponseMessage;
                        }
                        catch (Exception exception) {
                            logger.error("RequestHandler-execute", "Failed to fetch notifications", exception);
                            long l3 = notificationResult.getEarliestSequenceNumber();
                            long l4 = notificationResult.getNextSequenceNumber();
                            TargetedNotification[] targetedNotificationArray = new TargetedNotification[]{};
                            notificationResult = new NotificationResult(l3, l4, targetedNotificationArray);
                            Object object = ServerIntermediary.this.serialization.wrap(notificationResult);
                            NotificationResponseMessage notificationResponseMessage = new NotificationResponseMessage(object);
                            ServerIntermediary.this.serverCommunicatorAdmin.rspOutgoing();
                            return notificationResponseMessage;
                        }
                    }
                    if (message instanceof MBeanServerRequestMessage) {
                        MBeanServerResponseMessage mBeanServerResponseMessage;
                        Serializable serializable;
                        if (logger.traceOn()) {
                            logger.trace("RequestHandler-execute", "Receive a MBeanServerRequestMessage.");
                        }
                        MBeanServerRequestMessage mBeanServerRequestMessage = (MBeanServerRequestMessage)message;
                        try {
                            serializable = null;
                            Subject subject = mBeanServerRequestMessage.getDelegationSubject();
                            if (subject != null) {
                                Principal[] principalArray;
                                AccessControlContext accessControlContext;
                                if (ServerIntermediary.this.subject == null) {
                                    throw new SecurityException("Subject delegation cannot be enabled unless an authenticated subject is put in place");
                                }
                                Principal[] principalArray2 = (Principal[])ServerIntermediary.this.principalsCache.get(subject);
                                if (principalArray2 == null) {
                                    principalArray2 = subject.getPrincipals().toArray(new Principal[0]);
                                    ServerIntermediary.this.principalsCache.put(subject, principalArray2);
                                }
                                if ((accessControlContext = (AccessControlContext)ServerIntermediary.this.accCache.get(subject)) == null) {
                                    principalArray = new JMXSubjectDomainCombiner(subject);
                                    accessControlContext = new AccessControlContext(AccessController.getContext(), (DomainCombiner)principalArray);
                                    ServerIntermediary.this.accCache.put(subject, accessControlContext);
                                }
                                principalArray = principalArray2;
                                AccessController.doPrivileged(new PrivilegedAction(this, principalArray){
                                    private final /* synthetic */ Principal[] val$dp;
                                    private final /* synthetic */ RequestHandler this$1;
                                    {
                                        this.this$1 = requestHandler;
                                        this.val$dp = principalArray;
                                    }

                                    public Object run() {
                                        for (int i = 0; i < this.val$dp.length; ++i) {
                                            SubjectDelegationPermission subjectDelegationPermission = new SubjectDelegationPermission(this.val$dp[i].getClass().getName() + "." + this.val$dp[i].getName());
                                            AccessController.checkPermission(subjectDelegationPermission);
                                        }
                                        return null;
                                    }
                                }, ServerIntermediary.this.acc);
                                serializable = AccessController.doPrivileged(new PrivilegedRequestJob(mBeanServerRequestMessage), accessControlContext);
                            } else {
                                serializable = AccessController.doPrivileged(new PrivilegedRequestJob(mBeanServerRequestMessage), ServerIntermediary.this.acc);
                            }
                            mBeanServerResponseMessage = new MBeanServerResponseMessage(mBeanServerRequestMessage.getMessageId(), serializable, false);
                        }
                        catch (Exception exception) {
                            serializable = ServerIntermediary.this.extractException(exception);
                            if (logger.traceOn()) {
                                logger.trace("RequestHandler-execute", "Got an exception: " + serializable, (Throwable)serializable);
                            }
                            mBeanServerResponseMessage = new MBeanServerResponseMessage(mBeanServerRequestMessage.getMessageId(), ServerIntermediary.this.serialization.wrap(serializable), true);
                        }
                        catch (Error error) {
                            if (logger.traceOn()) {
                                logger.trace("RequestHandler-execute", "Got an error: " + error, error);
                            }
                            JMXServerErrorException jMXServerErrorException = new JMXServerErrorException(error.toString(), error);
                            mBeanServerResponseMessage = new MBeanServerResponseMessage(mBeanServerRequestMessage.getMessageId(), ServerIntermediary.this.serialization.wrap(jMXServerErrorException), true);
                        }
                        serializable = mBeanServerResponseMessage;
                        return serializable;
                    }
                    logger.error("RequestHandler-execute", "Got unknown message: " + message);
                    ServerIntermediary.this.myServer.failedConnectionNotif(ServerIntermediary.this.clientId, "Got unknown message: " + message, message);
                    ServerIntermediary.this.terminate(false, "Got unknown message: " + message);
                    break block28;
                    {
                        catch (IOException iOException) {
                            break block28;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    ServerIntermediary.this.serverCommunicatorAdmin.rspOutgoing();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionException(Exception exception) {
            Object object = ServerIntermediary.this.stateLock;
            synchronized (object) {
                if (ServerIntermediary.this.state != 0) {
                    return;
                }
                ServerIntermediary.this.state = 1;
            }
            logger.error("RequestHandler-connectionException", "The transport level gets an exception when reading input message: " + exception, exception);
            object = null;
            object = exception instanceof ClassNotFoundException ? (Object)("The client " + ServerIntermediary.this.clientId + "got an unknown message: " + exception) : (Object)("The client " + ServerIntermediary.this.clientId + " has failed: " + exception);
            ServerIntermediary.this.myServer.failedConnectionNotif(ServerIntermediary.this.clientId, (String)object, exception);
            ServerIntermediary.this.terminate(true, null);
        }
    }
}

