/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ObjectWrappingImpl;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.SynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroMessageConnectionImpl;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServerImpl;
import com.sun.jmx.remote.opt.security.MBeanServerFileAccessController;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.generic.MessageConnectionServer;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.generic.ServerIntermediary;
import javax.security.auth.Subject;

public class GenericConnectorServer
extends JMXConnectorServer {
    public static final String OBJECT_WRAPPING = "jmx.remote.object.wrapping";
    public static final String MESSAGE_CONNECTION_SERVER = "jmx.remote.message.connection.server";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.generic", "GenericConnectorServer");
    private Receiver receiver;
    private SynchroMessageConnectionServer sMsgServer;
    private final ServerAdmin serverAdmin;
    private ObjectWrapping objectWrapping;
    private Map env;
    private ClassLoader defaultClassLoader = null;
    private ThreadService threads = new ThreadService(0, 10);
    private ArrayList clientList = new ArrayList();
    private static final int DEFAULT_NOTIF_BUFFER_SIZE = 1000;
    private static final int CREATED = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private int state = 0;
    private int[] lock = new int[0];
    private static long clientIDCount = 0L;
    private static final int[] clientIDCountLock = new int[0];

    public GenericConnectorServer(Map map, MBeanServer mBeanServer) {
        super(mBeanServer);
        this.env = map == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(map);
        this.serverAdmin = DefaultConfig.getServerAdmin(this.env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientClosing(ServerIntermediary serverIntermediary, String string, String string2, Object object) {
        try {
            ArrayList arrayList = this.clientList;
            synchronized (arrayList) {
                this.clientList.remove(this.clientList.indexOf(serverIntermediary));
            }
            if (serverIntermediary.getTransport() instanceof SynchroMessageConnectionImpl) {
                this.serverAdmin.connectionClosed(((SynchroMessageConnectionImpl)serverIntermediary.getTransport()).getAsynchroConnection());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        super.connectionClosed(string, string2, object);
    }

    public JMXServiceURL getAddress() {
        if (!this.isActive()) {
            return null;
        }
        return this.sMsgServer.getAddress();
    }

    public Map getAttributes() {
        Map map = EnvHelp.serializableAttributes(this.env);
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            Object object;
            Object object2;
            MBeanServer mBeanServer;
            if (this.state == 1) {
                if (logger.traceOn()) {
                    logger.trace("start", "already started");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 2) {
                if (logger.traceOn()) {
                    logger.trace("start", "already stopped");
                }
                throw new IOException("The server has been stopped.");
            }
            if (logger.traceOn()) {
                logger.trace("start", "starting...");
            }
            if (logger.traceOn()) {
                logger.trace("start", "setting MBeanServer...");
            }
            if ((mBeanServer = this.getMBeanServer()) == null) {
                throw new IllegalStateException("This connector server is not attached to an MBean server");
            }
            if (this.env != null && (object2 = (String)this.env.get("jmx.remote.x.access.file")) != null) {
                object = null;
                try {
                    object = new MBeanServerFileAccessController((String)object2);
                }
                catch (IOException iOException) {
                    throw (IllegalArgumentException)EnvHelp.initCause(new IllegalArgumentException(iOException.getMessage()), iOException);
                }
                this.setMBeanServerForwarder((MBeanServerForwarder)object);
                mBeanServer = this.getMBeanServer();
            }
            if (logger.traceOn()) {
                logger.trace("start", "setting default ClassLoader...");
            }
            try {
                this.defaultClassLoader = EnvHelp.resolveServerClassLoader(this.env, mBeanServer);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (logger.debugOn()) {
                    logger.debug("start", "ClassLoader not found: " + instanceNotFoundException);
                }
                object = new IllegalArgumentException("ClassLoader not found: " + instanceNotFoundException);
                throw (IllegalArgumentException)EnvHelp.initCause((Throwable)object, instanceNotFoundException);
            }
            if (logger.traceOn()) {
                logger.trace("start", "setting ObjectWrapping...");
            }
            this.objectWrapping = (ObjectWrapping)this.env.get(OBJECT_WRAPPING);
            if (this.objectWrapping == null) {
                this.objectWrapping = new ObjectWrappingImpl();
            }
            if ((object2 = (MessageConnectionServer)this.env.get(MESSAGE_CONNECTION_SERVER)) == null) {
                this.sMsgServer = DefaultConfig.getSynchroMessageConnectionServer(this.env);
                if (this.sMsgServer == null) {
                    throw new IllegalArgumentException("No message connection server");
                }
            } else {
                this.sMsgServer = new SynchroMessageConnectionServerImpl((MessageConnectionServer)object2, this.env);
            }
            this.sMsgServer.start(this.env);
            this.state = 1;
            if (logger.traceOn()) {
                logger.trace("start", "started.");
            }
            this.receiver = new Receiver();
            this.receiver.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        boolean bl = logger.traceOn();
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 2) {
                if (bl) {
                    logger.trace("stop", "already stopped.");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.state == 0 && bl) {
                logger.trace("stop", "not started yet.");
            }
            this.state = 2;
            boolean bl2 = logger.debugOn();
            if (bl) {
                logger.trace("stop", "stoping.");
            }
            Object var4_4 = null;
            if (bl) {
                logger.trace("stop", "stop MessageConnectionServer...");
            }
            if (this.sMsgServer != null) {
                this.sMsgServer.stop();
            }
            if (bl) {
                logger.trace("stop", "stop accepting connection...");
            }
            if (this.receiver != null) {
                this.receiver.terminate();
            }
            if (bl) {
                logger.trace("stop", "stop clients...");
            }
            ArrayList arrayList = this.clientList;
            synchronized (arrayList) {
                if (bl) {
                    logger.trace("stop", this.clientList.size() + "client(s) found...");
                }
                while (this.clientList.size() > 0) {
                    try {
                        ServerIntermediary serverIntermediary = (ServerIntermediary)this.clientList.remove(0);
                        serverIntermediary.terminate();
                    }
                    catch (Exception exception) {
                        logger.error("stop", "Failed to stop client: " + exception);
                        if (!bl2) continue;
                        logger.debug("stop", exception);
                    }
                }
            }
            this.threads.terminate();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (bl) {
                logger.trace("stop", "stopped.");
            }
            return;
        }
    }

    void failedConnectionNotif(String string, String string2, Object object) {
        super.connectionFailed(string, string2, object);
    }

    private class ClientCreation
    implements Runnable {
        private SynchroMessageConnection connection;

        public ClientCreation(SynchroMessageConnection synchroMessageConnection) {
            this.connection = synchroMessageConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            Object object2;
            boolean bl = logger.traceOn();
            Subject subject = null;
            try {
                this.connection.connect(GenericConnectorServer.this.env);
                if (bl) {
                    logger.trace("ClientCreation.run", "opening connection.");
                }
                if (this.connection instanceof SynchroMessageConnectionImpl) {
                    object2 = (SynchroMessageConnectionImpl)this.connection;
                    object = ((SynchroMessageConnectionImpl)object2).getAsynchroConnection();
                    MessageConnection messageConnection = GenericConnectorServer.this.serverAdmin.connectionOpen((MessageConnection)object);
                    if (((SynchroMessageConnectionImpl)object2).getAsynchroConnection() != messageConnection) {
                        object2 = new SynchroMessageConnectionImpl(messageConnection, null, GenericConnectorServer.this.env);
                    }
                    if (bl) {
                        logger.trace("ClientCreation.run", "getting subject.");
                    }
                    subject = GenericConnectorServer.this.serverAdmin.getSubject(messageConnection);
                    ((SynchroMessageConnectionImpl)object2).setSubject(subject);
                    this.connection = object2;
                } else {
                    subject = this.connection.getSubject();
                }
            }
            catch (Exception exception) {
                block25: {
                    logger.error("ClientCreation.run", "Failed to open connection: " + exception);
                    if (bl) {
                        logger.debug("ClientCreation.run", exception);
                    }
                    try {
                        if (bl) {
                            logger.debug("ClientCreation.run", "cleaning up...");
                        }
                        this.connection.close();
                    }
                    catch (Exception exception2) {
                        if (logger.debugOn()) {
                            logger.debug("ClientCreation.run", "Failed to cleanup: " + exception2);
                        }
                        if (!logger.debugOn()) break block25;
                        logger.debug("ClientCreation.run", exception2);
                    }
                }
                return;
            }
            if (bl) {
                logger.trace("ClientCreation.run", "connection opened.");
            }
            object2 = new ServerIntermediary(GenericConnectorServer.this.getMBeanServer(), GenericConnectorServer.this, this.connection, GenericConnectorServer.this.objectWrapping, subject, GenericConnectorServer.this.defaultClassLoader, GenericConnectorServer.this.env);
            int[] nArray = GenericConnectorServer.this.lock;
            object = nArray;
            synchronized (nArray) {
                if (GenericConnectorServer.this.state != 1) {
                    try {
                        if (logger.debugOn()) {
                            logger.debug("ClientCreation.run", "connector already stopped.");
                        }
                        if (bl) {
                            logger.trace("ClientCreation.run", "cleaning up...");
                        }
                        ((ServerIntermediary)object2).terminate();
                    }
                    catch (Exception exception) {
                        if (logger.debugOn()) {
                            logger.debug("ClientCreation.run", "Failed to cleanup: " + exception);
                        }
                        if (logger.debugOn()) {
                            logger.debug("ClientCreation.run", exception);
                        }
                    }
                } else {
                    if (bl) {
                        logger.trace("ClientCreation.run", "adding connection to client list.");
                    }
                    GenericConnectorServer.this.clientList.add(object2);
                    GenericConnectorServer.this.connectionOpened(this.connection.getConnectionId(), "New client connection " + this.connection.getConnectionId() + " has been established", null);
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return;
            }
        }
    }

    private class Receiver
    extends Thread {
        private boolean terminated = false;

        private Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (logger.debugOn()) {
                logger.debug("Receiver.run", "starting receiver.");
            }
            try {
                while (GenericConnectorServer.this.state == 1 && !this.terminated) {
                    boolean bl;
                    SynchroMessageConnection synchroMessageConnection;
                    boolean bl2;
                    block14: {
                        block13: {
                            bl2 = logger.traceOn();
                            synchroMessageConnection = null;
                            bl = logger.debugOn();
                            if (bl2) {
                                logger.trace("Receiver.run", "waiting for connection.");
                            }
                            synchroMessageConnection = GenericConnectorServer.this.sMsgServer.accept();
                            if (GenericConnectorServer.this.state != 1) break block13;
                            if (!this.terminated) break block14;
                        }
                        Object var7_4 = null;
                        this.terminated = true;
                        if (!logger.debugOn()) return;
                        logger.debug("Receiver.run", "receiver terminated");
                        return;
                    }
                    try {
                        if (bl2) {
                            logger.trace("Receiver.run", "received connection request.");
                        }
                        GenericConnectorServer.this.threads.handoff(new ClientCreation(synchroMessageConnection));
                    }
                    catch (IOException iOException) {
                        if (GenericConnectorServer.this.state == 1) {
                            logger.error("Receiver.run", "Unexpected IOException: " + iOException);
                            if (bl) {
                                logger.debug("Receiver.run", iOException);
                            }
                            try {
                                logger.error("Receiver.run", "stopping server.");
                                GenericConnectorServer.this.stop();
                            }
                            catch (IOException iOException2) {
                                logger.error("Receiver.run", "Failed to stop server: " + iOException2);
                                if (!bl) break;
                                logger.debug("Receiver.run", iOException2);
                            }
                            break;
                        }
                        if (!bl2) break;
                        logger.trace("Receiver.run", "interrupted: " + iOException);
                        break;
                    }
                }
                Object var7_5 = null;
                this.terminated = true;
                if (!logger.debugOn()) return;
                logger.debug("Receiver.run", "receiver terminated");
                return;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                this.terminated = true;
                if (!logger.debugOn()) throw throwable;
                logger.debug("Receiver.run", "receiver terminated");
                throw throwable;
            }
        }

        public void terminate() {
            if (!this.terminated) {
                this.terminated = true;
                if (Thread.currentThread() != this) {
                    this.interrupt();
                    try {
                        this.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

