/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ObjectWrappingImpl;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.generic.SynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroMessageConnectionImpl;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.generic.ClientIntermediary;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.Message;
import javax.security.auth.Subject;

public class GenericConnector
implements JMXConnector {
    public static final String OBJECT_WRAPPING = "jmx.remote.object.wrapping";
    public static final String MESSAGE_CONNECTION = "jmx.remote.message.connection";
    private transient SynchroMessageConnection connection;
    private transient ObjectWrapping objectWrapping;
    private transient Map env;
    private transient ClientAdmin connAdmin;
    private transient ClientIntermediary clientMBeanServer;
    private transient WeakHashMap rmbscMap;
    private transient String connectionId;
    private final transient RequestHandler requestHandler = new RequestHandler();
    private transient NotificationBroadcasterSupport connectionBroadcaster = new NotificationBroadcasterSupport();
    private static final int CREATED = 1;
    private static final int CONNECTED = 2;
    private static final int CLOSED = 3;
    private transient int state = 1;
    private transient int[] lock;
    private transient long clientNotifID = 0L;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.generic", "GenericConenctor");

    public GenericConnector() {
        this(null);
    }

    public GenericConnector(Map map) {
        this.rmbscMap = new WeakHashMap();
        this.lock = new int[0];
        this.env = map == null ? new HashMap() : map;
    }

    public void connect() throws IOException {
        this.connect((Map)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map map) throws IOException {
        boolean bl = logger.traceOn();
        String string = bl ? "[" + this.toString() + "]" : null;
        int[] nArray = this.lock;
        synchronized (this.lock) {
            MessageConnection messageConnection;
            switch (this.state) {
                case 1: {
                    break;
                }
                case 2: {
                    if (bl) {
                        logger.trace("connect", string + " already connected.");
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                case 3: {
                    if (bl) {
                        logger.trace("connect", string + " already closed.");
                    }
                    throw new IOException("Connector already closed.");
                }
                default: {
                    if (bl) {
                        logger.trace("connect", string + " unknown state: " + this.state);
                    }
                    throw new IllegalStateException("Invalid state (" + this.state + ")");
                }
            }
            this.env = new HashMap(this.env);
            if (map != null) {
                this.env.putAll(map);
            }
            if ((messageConnection = (MessageConnection)(map = this.env).get(MESSAGE_CONNECTION)) == null) {
                this.connection = DefaultConfig.getSynchroMessageConnection(map);
                if (this.connection == null) {
                    if (bl) {
                        logger.trace("connect", string + " No MessageConnection");
                    }
                    throw new IllegalArgumentException("No MessageConnection");
                }
                if (bl) {
                    logger.trace("connect", "The connection uses a user specific Synchronous message connection.");
                }
            } else {
                this.connection = new SynchroMessageConnectionImpl(messageConnection, null, map, ThreadService.getShared());
                if (bl) {
                    logger.trace("connect", "The connection uses a user specific Asynchronous message connection.");
                }
            }
            this.connection.connect(map);
            this.objectWrapping = (ObjectWrapping)map.get(OBJECT_WRAPPING);
            if (this.objectWrapping == null) {
                this.objectWrapping = new ObjectWrappingImpl();
            }
            this.connAdmin = DefaultConfig.getClientAdmin(map);
            if (bl) {
                logger.trace("connect", string + " Opening connection.");
            }
            if (this.connection instanceof SynchroMessageConnectionImpl) {
                SynchroMessageConnectionImpl synchroMessageConnectionImpl = (SynchroMessageConnectionImpl)this.connection;
                MessageConnection messageConnection2 = this.connAdmin.connectionOpen(synchroMessageConnectionImpl.getAsynchroConnection());
                if (synchroMessageConnectionImpl.getAsynchroConnection() != messageConnection2) {
                    this.connection = new SynchroMessageConnectionImpl(messageConnection2, null, map, ThreadService.getShared());
                }
                this.connectionId = this.connAdmin.getConnectionId();
            }
            if (bl) {
                logger.trace("connect", string + " ConnectionID=" + this.connectionId);
            }
            this.clientMBeanServer = new ClientIntermediary(this.connection, this.objectWrapping, this, map);
            this.connection.setCallback(this.requestHandler);
            this.state = 2;
            if (bl) {
                logger.trace("connect", string + " Connected.");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.sendNotification(new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, this.clientNotifID++, null, null));
            return;
        }
    }

    public String getConnectionId() throws IOException {
        this.checkState();
        return this.connectionId;
    }

    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    public MBeanServerConnection getMBeanServerConnection(Subject subject) throws IOException {
        this.checkState();
        if (this.rmbscMap.containsKey(subject)) {
            return (MBeanServerConnection)this.rmbscMap.get(subject);
        }
        RemoteMBeanServerConnection remoteMBeanServerConnection = new RemoteMBeanServerConnection(this.clientMBeanServer, subject);
        this.rmbscMap.put(subject, remoteMBeanServerConnection);
        return remoteMBeanServerConnection;
    }

    public void close() throws IOException {
        this.close(false, "The connection is closed by a user.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean bl, String string) throws IOException {
        boolean bl2 = logger.traceOn();
        boolean bl3 = logger.debugOn();
        String string2 = bl2 ? "[" + this.toString() + "]" : null;
        Object object = this.lock;
        synchronized (this.lock) {
            SynchroMessageConnection synchroMessageConnection;
            Exception exception;
            boolean bl4;
            block26: {
                if (this.state == 3) {
                    if (bl2) {
                        logger.trace("close", string2 + " already closed.");
                    }
                    // ** MonitorExit[var8_6 /* !! */ ] (shouldn't be in output)
                    return;
                }
                bl4 = this.state == 1;
                this.state = 3;
                exception = null;
                if (bl2) {
                    logger.trace("close", string2 + " closing.");
                }
                if (!bl4) {
                    block25: {
                        if (!bl) {
                            try {
                                synchroMessageConnection = this.connection;
                                synchronized (synchroMessageConnection) {
                                    this.connection.sendOneWay(new CloseMessage(string));
                                    Thread.sleep(100L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (Exception exception2) {
                                exception = exception2;
                                if (bl2) {
                                    logger.trace("close", string2 + " failed to send close message: " + exception2);
                                }
                                if (!bl3) break block25;
                                logger.debug("close", exception2);
                            }
                        }
                    }
                    try {
                        this.connection.close();
                    }
                    catch (Exception exception3) {
                        exception = exception3;
                        if (bl2) {
                            logger.trace("close", string2 + " failed to close MessageConnection: " + exception3);
                        }
                        if (!bl3) break block26;
                        logger.debug("close", exception3);
                    }
                }
            }
            if (this.clientMBeanServer != null) {
                this.clientMBeanServer.terminate();
            }
            this.rmbscMap.clear();
            if (this.connection instanceof SynchroMessageConnectionImpl && this.connAdmin != null) {
                synchroMessageConnection = (SynchroMessageConnectionImpl)this.connection;
                this.connAdmin.connectionClosed(((SynchroMessageConnectionImpl)synchroMessageConnection).getAsynchroConnection());
            }
            // ** MonitorExit[var8_6 /* !! */ ] (shouldn't be in output)
            if (!bl4) {
                this.sendNotification(new JMXConnectionNotification("jmx.remote.connection.closed", this, this.connectionId, this.clientNotifID++, "The client has been closed.", null));
            }
            if (exception != null) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                object = new IOException("Failed to close: " + exception);
                throw (IOException)EnvHelp.initCause((Throwable)object, exception);
            }
            if (bl2) {
                logger.trace("close", string2 + " closed.");
            }
            return;
        }
    }

    public void addConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.connectionBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    public void removeConnectionNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.connectionBroadcaster.removeNotificationListener(notificationListener);
    }

    public void removeConnectionNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.connectionBroadcaster.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    protected void sendNotification(Notification notification) {
        this.connectionBroadcaster.sendNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SynchroMessageConnection reconnect() throws IOException {
        Object object = this.lock;
        synchronized (this.lock) {
            if (this.state != 2) {
                throw new IOException("The connector is not at the connection state.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.sendNotification(new JMXConnectionNotification("jmx.remote.connection.failed", this, this.connectionId, this.clientNotifID++, "The client has got connection exception.", null));
            this.connection.connect(this.env);
            if (this.connection instanceof SynchroMessageConnectionImpl) {
                object = (SynchroMessageConnectionImpl)this.connection;
                MessageConnection messageConnection = this.connAdmin.connectionOpen(((SynchroMessageConnectionImpl)object).getAsynchroConnection());
                if (((SynchroMessageConnectionImpl)object).getAsynchroConnection() != messageConnection) {
                    this.connection = new SynchroMessageConnectionImpl(messageConnection, null, this.env, ThreadService.getShared());
                }
                this.connectionId = this.connAdmin.getConnectionId();
                this.connection.setCallback(this.requestHandler);
            }
            this.sendNotification(new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, this.clientNotifID++, "The client has succesfully reconnected to the server.", null));
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 1) {
                throw new IOException("The client has not been connected.");
            }
            if (this.state == 3) {
                throw new IOException("The client has been closed.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class ResponseMsgWrapper {
        public boolean got = false;
        public Message msg = null;

        public void setMsg(Message message) {
            this.got = true;
            this.msg = message;
        }
    }

    private class RequestHandler
    implements SynchroCallback {
        private RequestHandler() {
        }

        public Message execute(Message message) {
            if (message instanceof CloseMessage) {
                if (logger.traceOn()) {
                    logger.trace("RequestHandler-execute", "got Message REMOTE_TERMINATION");
                }
                try {
                    ClientIntermediary.GenericClientCommunicatorAdmin genericClientCommunicatorAdmin = GenericConnector.this.clientMBeanServer.getCommunicatorAdmin();
                    genericClientCommunicatorAdmin.gotIOException(new IOException(""));
                    return null;
                }
                catch (IOException iOException) {
                    try {
                        GenericConnector.this.close(true, null);
                    }
                    catch (IOException iOException2) {}
                }
            } else {
                String string = (message == null ? "null" : message.getClass().getName()) + ": Bad message type.";
                logger.error("RequestHandler-execute", string);
                try {
                    GenericConnector.this.close(false, null);
                }
                catch (IOException iOException) {
                    logger.error("RequestHandler-execute", iOException);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionException(Exception exception) {
            if (GenericConnector.this.state == 2 && exception instanceof IOException) {
                try {
                    ClientIntermediary.GenericClientCommunicatorAdmin genericClientCommunicatorAdmin = GenericConnector.this.clientMBeanServer.getCommunicatorAdmin();
                    genericClientCommunicatorAdmin.gotIOException((IOException)exception);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            int[] nArray = GenericConnector.this.lock;
            synchronized (nArray) {
                if (GenericConnector.this.state == 2) {
                    logger.error("RequestHandler-connectionException", exception);
                    try {
                        GenericConnector.this.close(true, null);
                    }
                    catch (IOException iOException) {
                        logger.error("RequestHandler-execute", iOException);
                    }
                }
            }
        }
    }

    private static class RemoteMBeanServerConnection
    implements MBeanServerConnection {
        private ClientIntermediary ci;
        private Subject ds;

        public RemoteMBeanServerConnection(ClientIntermediary clientIntermediary) {
            this(clientIntermediary, null);
        }

        public RemoteMBeanServerConnection(ClientIntermediary clientIntermediary, Subject subject) {
            this.ci = clientIntermediary;
            this.ds = subject;
        }

        public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            return this.ci.createMBean(string, objectName, this.ds);
        }

        public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            return this.ci.createMBean(string, objectName, objectName2, this.ds);
        }

        public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            return this.ci.createMBean(string, objectName, objectArray, stringArray, this.ds);
        }

        public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            return this.ci.createMBean(string, objectName, objectName2, objectArray, stringArray, this.ds);
        }

        public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            this.ci.unregisterMBean(objectName, this.ds);
        }

        public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException, IOException {
            return this.ci.getObjectInstance(objectName, this.ds);
        }

        public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws IOException {
            return this.ci.queryMBeans(objectName, queryExp, this.ds);
        }

        public Set queryNames(ObjectName objectName, QueryExp queryExp) throws IOException {
            return this.ci.queryNames(objectName, queryExp, this.ds);
        }

        public boolean isRegistered(ObjectName objectName) throws IOException {
            return this.ci.isRegistered(objectName, this.ds);
        }

        public Integer getMBeanCount() throws IOException {
            return this.ci.getMBeanCount(this.ds);
        }

        public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            return this.ci.getAttribute(objectName, string, this.ds);
        }

        public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
            return this.ci.getAttributes(objectName, stringArray, this.ds);
        }

        public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            this.ci.setAttribute(objectName, attribute, this.ds);
        }

        public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, IOException {
            return this.ci.setAttributes(objectName, attributeList, this.ds);
        }

        public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            return this.ci.invoke(objectName, string, objectArray, stringArray, this.ds);
        }

        public String getDefaultDomain() throws IOException {
            return this.ci.getDefaultDomain(this.ds);
        }

        public String[] getDomains() throws IOException {
            return this.ci.getDomains(this.ds);
        }

        public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
            this.ci.addNotificationListener(objectName, notificationListener, notificationFilter, object, this.ds);
        }

        public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, IOException {
            this.ci.addNotificationListener(objectName, objectName2, notificationFilter, object, this.ds);
        }

        public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.ci.removeNotificationListener(objectName, objectName2, this.ds);
        }

        public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.ci.removeNotificationListener(objectName, objectName2, notificationFilter, object, this.ds);
        }

        public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.ci.removeNotificationListener(objectName, notificationListener, this.ds);
        }

        public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.ci.removeNotificationListener(objectName, notificationListener, notificationFilter, object, this.ds);
        }

        public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            return this.ci.getMBeanInfo(objectName, this.ds);
        }

        public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, IOException {
            return this.ci.isInstanceOf(objectName, string, this.ds);
        }
    }
}

