/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.ObjectWrappingImpl;
import com.sun.jmx.remote.generic.SynchroMessageConnection;
import com.sun.jmx.remote.opt.internal.ClientCommunicatorAdmin;
import com.sun.jmx.remote.opt.internal.ClientNotifForwarder;
import com.sun.jmx.remote.opt.internal.ListenerInfo;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.NotificationResult;
import javax.management.remote.generic.GenericConnector;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.NotificationRequestMessage;
import javax.management.remote.message.NotificationResponseMessage;
import javax.security.auth.Subject;

class ClientIntermediary {
    private SynchroMessageConnection connection;
    private GenericConnector client;
    private ObjectWrapping serialization;
    private ClassLoader myloader;
    private GenericClientNotifForwarder notifForwarder;
    private GenericClientCommunicatorAdmin communicatorAdmin;
    private long lostNotifCounter = 0L;
    private boolean terminated;
    private static final ObjectName delegateName;
    private static final ClassLogger logger;

    public ClientIntermediary(SynchroMessageConnection synchroMessageConnection, ObjectWrapping objectWrapping, GenericConnector genericConnector, Map map) {
        logger.trace("constructor", "Create a ClientIntermediary object.");
        if (synchroMessageConnection == null) {
            throw new NullPointerException("Null connection.");
        }
        this.connection = synchroMessageConnection;
        if (objectWrapping == null) {
            logger.trace("constructor", "Use a default ObjectWrapping implementation.");
            this.serialization = new ObjectWrappingImpl();
        } else {
            this.serialization = objectWrapping;
        }
        this.myloader = EnvHelp.resolveClientClassLoader(map);
        this.client = genericConnector;
        this.communicatorAdmin = new GenericClientCommunicatorAdmin(EnvHelp.getConnectionCheckPeriod(map));
        this.notifForwarder = new GenericClientNotifForwarder(map);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        logger.trace("createMBean", "called");
        try {
            return (ObjectInstance)this.mBeanServerRequest(3, new Object[]{string, objectName}, subject);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray, Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        logger.trace("createMBean", "called");
        try {
            return (ObjectInstance)this.mBeanServerRequest(4, new Object[]{string, objectName, this.serialization.wrap(objectArray), stringArray}, subject);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        logger.trace("createMBean", "called");
        try {
            return (ObjectInstance)this.mBeanServerRequest(5, new Object[]{string, objectName, objectName2}, subject);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray, Subject subject) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        logger.trace("createMBean", "called");
        try {
            int n = 6;
            return (ObjectInstance)this.mBeanServerRequest(n, new Object[]{string, objectName, objectName2, this.serialization.wrap(objectArray), stringArray}, subject);
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw instanceAlreadyExistsException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw notCompliantMBeanException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public void unregisterMBean(ObjectName objectName, Subject subject) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        logger.trace("unregisterMBean", "called");
        try {
            this.mBeanServerRequest(25, new Object[]{objectName}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw mBeanRegistrationException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName, Subject subject) throws InstanceNotFoundException, IOException {
        logger.trace("getObjectInstance", "called");
        try {
            return (ObjectInstance)this.mBeanServerRequest(13, new Object[]{objectName}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp, Subject subject) throws IOException {
        logger.trace("queryMBeans", "called");
        try {
            return (Set)this.mBeanServerRequest(17, new Object[]{objectName, this.serialization.wrap(queryExp)}, subject);
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp, Subject subject) throws IOException {
        logger.trace("queryNames", "called");
        try {
            return (Set)this.mBeanServerRequest(18, new Object[]{objectName, this.serialization.wrap(queryExp)}, subject);
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public boolean isRegistered(ObjectName objectName, Subject subject) throws IOException {
        logger.trace("isRegistered", "called");
        try {
            Boolean bl = (Boolean)this.mBeanServerRequest(16, new Object[]{objectName}, subject);
            return bl;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public Integer getMBeanCount(Subject subject) throws IOException {
        logger.trace("getMBeanCount", "called");
        try {
            return (Integer)this.mBeanServerRequest(11, null, subject);
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public Object getAttribute(ObjectName objectName, String string, Subject subject) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        logger.trace("getAttribute", "called");
        try {
            return this.mBeanServerRequest(7, new Object[]{objectName, string}, subject);
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray, Subject subject) throws InstanceNotFoundException, ReflectionException, IOException {
        logger.trace("getAttributes", "called");
        try {
            return (AttributeList)this.mBeanServerRequest(8, new Object[]{objectName, stringArray}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public void setAttribute(ObjectName objectName, Attribute attribute, Subject subject) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        logger.trace("setAttribute", "called");
        try {
            this.mBeanServerRequest(23, new Object[]{objectName, this.serialization.wrap(attribute)}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw invalidAttributeValueException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList, Subject subject) throws InstanceNotFoundException, ReflectionException, IOException {
        logger.trace("setAttributes", "called");
        try {
            Object object = this.serialization.wrap(attributeList);
            return (AttributeList)this.mBeanServerRequest(24, new Object[]{objectName, object}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray, Subject subject) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        logger.trace("invoke", "called");
        try {
            return this.mBeanServerRequest(14, new Object[]{objectName, string, this.serialization.wrap(objectArray), stringArray}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (MBeanException mBeanException) {
            throw mBeanException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public String getDefaultDomain(Subject subject) throws IOException {
        logger.trace("getDefaultDomain", "called");
        try {
            int n = 9;
            return (String)this.mBeanServerRequest(n, null, subject);
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public String[] getDomains(Subject subject) throws IOException {
        logger.trace("getDomains", "called");
        try {
            return (String[])this.mBeanServerRequest(10, null, subject);
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName, Subject subject) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        logger.trace("getMBeanInfo", "called");
        try {
            return (MBeanInfo)this.mBeanServerRequest(12, new Object[]{objectName}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (IntrospectionException introspectionException) {
            throw introspectionException;
        }
        catch (ReflectionException reflectionException) {
            throw reflectionException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public boolean isInstanceOf(ObjectName objectName, String string, Subject subject) throws InstanceNotFoundException, IOException {
        logger.trace("isInstanceOf", "called");
        try {
            Boolean bl = (Boolean)this.mBeanServerRequest(15, new Object[]{objectName, string}, subject);
            return bl;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, Subject subject) throws InstanceNotFoundException, IOException {
        this.myAddListener(objectName, notificationListener, notificationFilter, object, subject, true);
    }

    private void myAddListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, Subject subject, boolean bl) throws InstanceNotFoundException, IOException {
        Integer n;
        logger.trace("addNotificationListener", "called");
        ObjectName[] objectNameArray = new ObjectName[]{objectName};
        Object[] objectArray = new Object[]{this.serialization.wrap(notificationFilter)};
        Object[] objectArray2 = new Object[]{objectNameArray, objectArray};
        try {
            n = (Integer)this.mBeanServerRequest(1, objectArray2, subject, bl);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
        this.notifForwarder.addNotificationListener(n, objectName, notificationListener, notificationFilter, object, subject);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object, Subject subject) throws InstanceNotFoundException, IOException {
        logger.trace("addNotificationListener", "called");
        try {
            int n = 2;
            this.mBeanServerRequest(n, new Object[]{objectName, objectName2, this.serialization.wrap(notificationFilter), this.serialization.wrap(object)}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        logger.trace("removeNotificationListener", "called");
        Integer[] integerArray = this.notifForwarder.removeNotificationListener(objectName, notificationListener);
        try {
            int n = 19;
            this.mBeanServerRequest(n, new Object[]{objectName, integerArray}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        logger.trace("removeNotificationListener", "called");
        Integer n = this.notifForwarder.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
        try {
            int n2 = 20;
            this.mBeanServerRequest(n2, new Object[]{objectName, n}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        logger.trace("removeNotificationListener", "called");
        try {
            int n = 21;
            this.mBeanServerRequest(n, new Object[]{objectName, objectName2}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object, Subject subject) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        logger.trace("removeNotificationListener", "called");
        try {
            int n = 22;
            this.mBeanServerRequest(n, new Object[]{objectName, objectName2, this.serialization.wrap(notificationFilter), this.serialization.wrap(object)}, subject);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw instanceNotFoundException;
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw listenerNotFoundException;
        }
        catch (Exception exception) {
            throw ClientIntermediary.appropriateException(exception);
        }
    }

    public void terminate() {
        logger.trace("terminate", "Terminated.");
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.communicatorAdmin.terminate();
        this.notifForwarder.terminate();
    }

    public GenericClientCommunicatorAdmin getCommunicatorAdmin() {
        return this.communicatorAdmin;
    }

    private Object mBeanServerRequest(int n, Object[] objectArray, Subject subject) throws Exception {
        return this.mBeanServerRequest(n, objectArray, subject, true);
    }

    private Object mBeanServerRequest(int n, Object[] objectArray, Subject subject, boolean bl) throws Exception {
        Object object;
        MBeanServerResponseMessage mBeanServerResponseMessage;
        MBeanServerRequestMessage mBeanServerRequestMessage = new MBeanServerRequestMessage(n, objectArray, subject);
        try {
            mBeanServerResponseMessage = (MBeanServerResponseMessage)this.connection.sendWithReturn(mBeanServerRequestMessage);
        }
        catch (IOException iOException) {
            if (this.terminated || !bl || iOException instanceof InterruptedIOException) {
                throw iOException;
            }
            this.communicatorAdmin.gotIOException(iOException);
            mBeanServerResponseMessage = (MBeanServerResponseMessage)this.connection.sendWithReturn(mBeanServerRequestMessage);
        }
        Object object2 = mBeanServerResponseMessage.getWrappedResult();
        try {
            object = this.serialization.unwrap(object2, this.myloader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException(classNotFoundException.toString());
            EnvHelp.initCause(iOException, classNotFoundException);
            throw iOException;
        }
        if (mBeanServerResponseMessage.isException()) {
            throw (Exception)object;
        }
        return object;
    }

    private static IOException appropriateException(Exception exception) throws IOException {
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        IOException iOException = new IOException("Unexpected exception: " + exception);
        EnvHelp.initCause(iOException, exception);
        throw iOException;
    }

    static {
        try {
            delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new RuntimeException(malformedObjectNameException.toString());
        }
        logger = new ClassLogger("javax.management.remote.generic", "ClientIntermediary");
    }

    private class GenericClientNotifForwarder
    extends ClientNotifForwarder {
        public GenericClientNotifForwarder(Map map) {
            super(map);
        }

        protected NotificationResult fetchNotifs(long l, int n, long l2) throws IOException, ClassNotFoundException {
            logger.trace("GenericClientNotifForwarder-fetchNotifs", "fetching notifs...");
            NotificationRequestMessage notificationRequestMessage = new NotificationRequestMessage(l, n, l2);
            NotificationResponseMessage notificationResponseMessage = (NotificationResponseMessage)ClientIntermediary.this.connection.sendWithReturn(notificationRequestMessage);
            Object object = notificationResponseMessage.getWrappedNotificationResult();
            Object object2 = ClientIntermediary.this.serialization.unwrap(object, ClientIntermediary.this.myloader);
            if (!(object2 instanceof NotificationResult)) {
                String string = "Not a NotificationResult: " + object2.getClass();
                logger.error("Forwarder.fetchNotifs", string);
                ClientIntermediary.this.client.close();
            }
            return (NotificationResult)object2;
        }

        protected Integer addListenerForMBeanRemovedNotif() throws IOException {
            logger.trace("GenericClientNotifForwarder-addListenerForMBeanRemovedNotif", "Add a listener to receive UNREGISTRATION_NOTIFICATION");
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("JMX.mbean.unregistered");
            ObjectName[] objectNameArray = new ObjectName[]{delegateName};
            Object object = ClientIntermediary.this.serialization.wrap(notificationFilterSupport);
            Object[] objectArray = new Object[]{object};
            Object[] objectArray2 = new Object[]{objectNameArray, objectArray};
            try {
                int n = 1;
                return (Integer)ClientIntermediary.this.mBeanServerRequest(n, objectArray2, null);
            }
            catch (Exception exception) {
                throw ClientIntermediary.appropriateException(exception);
            }
        }

        protected void removeListenerForMBeanRemovedNotif(Integer n) throws IOException {
            logger.trace("GenericClientNotifForwarder-removeListenerForMBeanRemovedNotif", "Remove the listener used to receive UNREGISTRATION_NOTIFICATION.");
            try {
                int n2 = 20;
                ClientIntermediary.this.mBeanServerRequest(n2, new Object[]{delegateName, n}, null, false);
            }
            catch (Exception exception) {
                throw ClientIntermediary.appropriateException(exception);
            }
        }

        protected void lostNotifs(String string, long l) {
            JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification("jmx.remote.connection.notifs.lost", ClientIntermediary.this, ClientIntermediary.this.connection.getConnectionId(), ClientIntermediary.this.lostNotifCounter++, string, new Long(l));
            ClientIntermediary.this.client.sendNotification(jMXConnectionNotification);
        }
    }

    private class GenericClientCommunicatorAdmin
    extends ClientCommunicatorAdmin {
        public GenericClientCommunicatorAdmin(long l) {
            super(l);
        }

        protected void checkConnection() throws IOException {
            try {
                ClientIntermediary.this.mBeanServerRequest(9, null, null, false);
            }
            catch (Exception exception) {
                throw ClientIntermediary.appropriateException(exception);
            }
        }

        protected void doStart() throws IOException {
            ClientIntermediary.this.connection = ClientIntermediary.this.client.reconnect();
            ListenerInfo[] listenerInfoArray = ClientIntermediary.this.notifForwarder.getListenerInfo();
            ClientIntermediary.this.notifForwarder.restart();
            ArrayList<Exception> arrayList = new ArrayList<Exception>();
            for (int i = 0; i < listenerInfoArray.length; ++i) {
                try {
                    ClientIntermediary.this.myAddListener(listenerInfoArray[i].getObjectName(), listenerInfoArray[i].getListener(), listenerInfoArray[i].getNotificationFilter(), listenerInfoArray[i].getHandback(), listenerInfoArray[i].getDelegationSubject(), false);
                    continue;
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    continue;
                }
                catch (Exception exception) {
                    arrayList.add(exception);
                }
            }
            Exception[] exceptionArray = arrayList.toArray(new Exception[0]);
        }

        protected void doStop() {
            try {
                ClientIntermediary.this.client.close();
            }
            catch (IOException iOException) {
                logger.error("close", iOException);
            }
        }
    }
}

