/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.socket;

import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.generic.MessageConnectionServer;

public class SocketConnectionServer
implements MessageConnectionServer {
    private ServerSocket ss;
    private JMXServiceURL addr;
    private boolean wildcard;
    private Map env;
    private static final String DEFAULT_PROTOCOL = "jmxmp";
    private static final int DEFAULT_BACKLOG = 100;
    private final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SocketConnectionServer");

    public SocketConnectionServer(JMXServiceURL jMXServiceURL, Map map) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("constructor", "Constructs a SocketConnectionServer on " + jMXServiceURL);
        }
        if (jMXServiceURL == null) {
            throw new NullPointerException("Null address.");
        }
        if (!DEFAULT_PROTOCOL.equalsIgnoreCase(jMXServiceURL.getProtocol())) {
            throw new MalformedURLException("Unknown protocol: " + jMXServiceURL.getProtocol());
        }
        String string = null;
        if (map != null) {
            string = (String)map.get("jmx.remote.server.address.wildcard");
        }
        this.wildcard = string == null ? true : string.equalsIgnoreCase("true");
        this.addr = jMXServiceURL;
    }

    public void start(Map map) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("start", "Starts the server now.");
        }
        int n = this.addr.getPort();
        String string = this.addr.getHost();
        if (string.equals("")) {
            string = InetAddress.getLocalHost().getHostName();
        }
        this.ss = new ServerSocket(n, 100, InetAddress.getByName(string));
        if (this.wildcard) {
            this.ss.close();
            this.ss = new ServerSocket(this.addr.getPort(), 100);
        }
        this.addr = new JMXServiceURL(DEFAULT_PROTOCOL, string, this.ss.getLocalPort());
        this.env = map;
    }

    public MessageConnection accept() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("accept", "Waiting a new connection...");
        }
        SocketConnection socketConnection = new SocketConnection(this.ss.accept());
        return socketConnection;
    }

    public void stop() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("stop", "Stops the server now.");
        }
        this.ss.close();
    }

    public JMXServiceURL getAddress() {
        return this.addr;
    }
}

