/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.util;

import java.util.ArrayList;

class JobExecutor
extends Thread {
    private Runnable job = null;
    private int[] lock = new int[0];
    private boolean terminated = false;
    private static int poolSize = 20;
    private static ArrayList waitingList = new ArrayList(poolSize);
    private static boolean allTerminated = false;
    private static long counter = 0L;
    private static long waitingTime = 300000L;
    private static final ThreadGroup tgroup = new ThreadGroup("Job_Executor");
    private static final String tname = "Job_Executor";

    private JobExecutor(Runnable runnable) {
        super(tgroup, tname + counter++);
        this.setDaemon(true);
        this.job = runnable;
    }

    public static void setPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative size.");
        }
        poolSize = n;
    }

    public static int getPoolSize() {
        return poolSize;
    }

    public static void setWaitingTime(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative waiting time.");
        }
        waitingTime = l;
    }

    public static long getWaitingTime() {
        return waitingTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (!this.terminated) {
            if (allTerminated) return;
            if (this.job != null) {
                try {
                    this.job.run();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    this.job = null;
                }
            }
            Object object = waitingList;
            // MONITORENTER : object
            if (waitingList.size() >= poolSize) {
                this.terminated = true;
                // MONITOREXIT : object
                continue;
            }
            waitingList.add(this);
            // MONITOREXIT : object
            object = this.lock;
            // MONITORENTER : this.lock
            if (this.job == null) {
                try {
                    this.lock.wait(waitingTime);
                }
                catch (InterruptedException interruptedException) {
                    this.interrupted();
                    // MONITOREXIT : object
                    continue;
                }
            }
            if (this.job != null) {
                // MONITOREXIT : object
                continue;
            }
            this.terminated = true;
            // MONITOREXIT : object
            if (!this.terminated) continue;
            object = waitingList;
            // MONITORENTER : object
            try {
                waitingList.remove(waitingList.indexOf(this));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void handoff(Runnable runnable) {
        JobExecutor jobExecutor = null;
        Object object = waitingList;
        // MONITORENTER : object
        if (waitingList.size() > 0) {
            jobExecutor = (JobExecutor)waitingList.remove(0);
        }
        // MONITOREXIT : object
        if (jobExecutor != null) {
            object = jobExecutor.lock;
            // MONITORENTER : jobExecutor.lock
            if (!jobExecutor.terminated) {
                jobExecutor.job = runnable;
                jobExecutor.lock.notify();
            } else {
                jobExecutor = null;
            }
            // MONITOREXIT : object
        }
        if (jobExecutor != null) return;
        jobExecutor = new JobExecutor(runnable);
        jobExecutor.start();
    }
}

