/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import com.sun.jmx.remote.generic.ProfileServer;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.socket.SocketConnectionIf;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.ProfileMessage;
import javax.management.remote.message.TLSMessage;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;

public class TLSServerHandler
implements ProfileServer {
    protected SSLSocket ts = null;
    private boolean completed = false;
    private Map env = null;
    private MessageConnection mc = null;
    private String profile = null;
    private Subject subject = null;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "TLSServerHandler");

    public TLSServerHandler(String string, Map map) {
        this.profile = string;
        this.env = map;
    }

    public void initialize(MessageConnection messageConnection, Subject subject) throws IOException {
        String string;
        String string2;
        String string3;
        int n;
        Object object;
        String string4;
        this.mc = messageConnection;
        this.subject = subject;
        Socket socket = null;
        if (!(messageConnection instanceof SocketConnectionIf)) {
            throw new IOException("Not an instance of SocketConnectionIf");
        }
        socket = ((SocketConnectionIf)((Object)messageConnection)).getSocket();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)this.env.get("jmx.remote.tls.socket.factory");
        if (sSLSocketFactory == null) {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        String string5 = socket.getInetAddress().getHostName();
        int n2 = socket.getPort();
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Hostname = " + string5);
            logger.trace("initialize", "TLS: Port = " + n2);
        }
        this.ts = (SSLSocket)sSLSocketFactory.createSocket(socket, string5, n2, false);
        this.ts.setUseClientMode(false);
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Socket Client Mode = " + this.ts.getUseClientMode());
        }
        if ((string4 = (String)this.env.get("jmx.remote.tls.enabled.protocols")) != null) {
            object = new StringTokenizer(string4, " ");
            int n3 = ((StringTokenizer)object).countTokens();
            String[] stringArray = new String[n3];
            for (n = 0; n < n3; ++n) {
                stringArray[n] = ((StringTokenizer)object).nextToken();
            }
            this.ts.setEnabledProtocols(stringArray);
        }
        object = this.ts.getEnabledProtocols();
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Enabled Protocols");
        }
        if (object != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < ((Object)object).length; ++i) {
                stringBuffer.append((String)object[i]);
                if (i + 1 >= ((Object)object).length) continue;
                stringBuffer.append(", ");
            }
            if (logger.traceOn()) {
                logger.trace("initialize", "TLS: [" + stringBuffer + "]");
            }
        } else if (logger.traceOn()) {
            logger.trace("initialize", "TLS: []");
        }
        if ((string3 = (String)this.env.get("jmx.remote.tls.enabled.cipher.suites")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
            n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            this.ts.setEnabledCipherSuites(stringArray);
        }
        String[] stringArray = this.ts.getEnabledCipherSuites();
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Enabled Cipher Suites");
        }
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i + 1 >= stringArray.length) continue;
                stringBuffer.append(", ");
            }
            if (logger.traceOn()) {
                logger.trace("initialize", "TLS: [" + stringBuffer + "]");
            }
        } else if (logger.traceOn()) {
            logger.trace("initialize", "TLS: []");
        }
        if ((string2 = (String)this.env.get("jmx.remote.tls.need.client.authentication")) != null) {
            this.ts.setNeedClientAuth(Boolean.valueOf(string2));
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Socket Need Client Authentication = " + this.ts.getNeedClientAuth());
        }
        if ((string = (String)this.env.get("jmx.remote.tls.want.client.authentication")) != null) {
            this.ts.setWantClientAuth(Boolean.valueOf(string));
        }
        if (logger.traceOn()) {
            logger.trace("initialize", "TLS: Socket Want Client Authentication = " + this.ts.getWantClientAuth());
        }
    }

    public ProfileMessage produceMessage() throws IOException {
        TLSMessage tLSMessage = new TLSMessage(2);
        if (logger.traceOn()) {
            logger.trace("produceMessage", ">>>>> TLS server message <<<<<");
            logger.trace("produceMessage", "Profile Name : " + tLSMessage.getProfileName());
            logger.trace("produceMessage", "Status : " + tLSMessage.getStatus());
        }
        this.completed = true;
        return tLSMessage;
    }

    public void consumeMessage(ProfileMessage profileMessage) throws IOException {
        if (!(profileMessage instanceof TLSMessage)) {
            throw new IOException("Unexpected profile message type: " + profileMessage.getClass().getName());
        }
        TLSMessage tLSMessage = (TLSMessage)profileMessage;
        if (logger.traceOn()) {
            logger.trace("consumeMessage", ">>>>> TLS client message <<<<<");
            logger.trace("consumeMessage", "Profile Name : " + tLSMessage.getProfileName());
            logger.trace("consumeMessage", "Status : " + tLSMessage.getStatus());
        }
        if (tLSMessage.getStatus() != 1) {
            throw new IOException("Unexpected TLS status [" + tLSMessage.getStatus() + "]");
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public Subject activate() throws IOException {
        SSLSession sSLSession;
        if (logger.traceOn()) {
            logger.trace("activate", ">>>>> TLS handshake <<<<<");
            logger.trace("activate", "TLS: Start TLS Handshake");
        }
        this.ts.startHandshake();
        if (logger.traceOn() && (sSLSession = this.ts.getSession()) != null) {
            logger.trace("activate", "TLS: getCipherSuite = " + sSLSession.getCipherSuite());
            logger.trace("activate", "TLS: getPeerHost = " + sSLSession.getPeerHost());
            logger.trace("activate", "TLS: getProtocol = " + sSLSession.getProtocol());
        }
        if (logger.traceOn()) {
            logger.trace("activate", "TLS: Finish TLS Handshake");
        }
        ((SocketConnectionIf)((Object)this.mc)).setSocket(this.ts);
        return this.subject;
    }

    public void terminate() throws IOException {
    }

    public String getName() {
        return this.profile;
    }
}

