/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.internal;

import com.sun.jmx.remote.opt.util.ClassLogger;
import java.io.IOException;

public abstract class ServerCommunicatorAdmin {
    private final Adminor adminor;
    private boolean updated = false;
    private final int[] lock = new int[0];
    private int currentJobs = 0;
    private long timeout;
    private boolean terminated = false;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "ServerCommunicatorAdmin");

    public ServerCommunicatorAdmin(long l) {
        if (logger.traceOn()) {
            logger.trace("Constructor", "Creates a new ServerCommunicatorAdmin object with the timeout " + l);
        }
        this.timeout = l;
        this.adminor = new Adminor();
        Thread thread = new Thread(this.adminor);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reqIncoming() throws IOException {
        if (logger.traceOn()) {
            logger.trace("reqIncoming", "Receive a new request.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.terminated) {
                throw new IOException("The server has decided to close this client connection.");
            }
            this.updated = true;
            ++this.currentJobs;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rspOutgoing() {
        if (logger.traceOn()) {
            logger.trace("reqIncoming", "Finish a request.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (--this.currentJobs == 0) {
                this.lock.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected abstract void doStop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (logger.traceOn()) {
            logger.trace("terminate", "terminate the ServerCommunicatorAdmin object.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            this.lock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class Adminor
    implements Runnable {
        private Adminor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            boolean bl = false;
            int[] nArray = ServerCommunicatorAdmin.this.lock;
            // MONITORENTER : nArray
            while (!ServerCommunicatorAdmin.this.terminated) {
                try {
                    if (ServerCommunicatorAdmin.this.currentJobs != 0) {
                        if (logger.traceOn()) {
                            logger.trace("Adminor-run", "Waiting without timeout.");
                        }
                        ServerCommunicatorAdmin.this.lock.wait();
                        continue;
                    }
                    if (logger.traceOn()) {
                        logger.trace("Adminor-run", "Waiting with timeout " + ServerCommunicatorAdmin.this.timeout);
                    }
                    ServerCommunicatorAdmin.this.updated = false;
                    ServerCommunicatorAdmin.this.lock.wait(ServerCommunicatorAdmin.this.timeout);
                    if (ServerCommunicatorAdmin.this.terminated || ServerCommunicatorAdmin.this.updated) continue;
                    ServerCommunicatorAdmin.this.terminated = true;
                    bl = true;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // MONITOREXIT : nArray
                    return;
                }
            }
            // MONITOREXIT : nArray
            if (!bl) return;
            if (logger.traceOn()) {
                logger.trace("Adminor-run", "Call the doStop.");
            }
            ServerCommunicatorAdmin.this.doStop();
        }
    }
}

