/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.internal;

import com.sun.jmx.remote.opt.internal.ListenerInfo;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.security.auth.Subject;

public abstract class ClientNotifForwarder {
    private ClassLoader defaultClassLoader = null;
    private HashMap infoList = new HashMap();
    private long clientSequenceNumber = -1L;
    private final int maxNotifications;
    private final long timeout;
    private NotifFetcher notifFetcher;
    private Integer mbeanRemovedNotifID = null;
    private boolean inited = false;
    private boolean terminated = false;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "ClientNotifForwarder");

    public ClientNotifForwarder(Map map) {
        this(null, map);
    }

    public ClientNotifForwarder(ClassLoader classLoader, Map map) {
        this.maxNotifications = EnvHelp.getMaxFetchNotifNumber(map);
        this.timeout = EnvHelp.getFetchTimeout(map);
        this.defaultClassLoader = classLoader;
    }

    protected abstract NotificationResult fetchNotifs(long var1, int var3, long var4) throws IOException, ClassNotFoundException;

    protected abstract Integer addListenerForMBeanRemovedNotif() throws IOException, InstanceNotFoundException;

    protected abstract void removeListenerForMBeanRemovedNotif(Integer var1) throws IOException, InstanceNotFoundException, ListenerNotFoundException;

    protected abstract void lostNotifs(String var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(Integer n, ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, Subject subject) throws IOException, InstanceNotFoundException {
        if (logger.traceOn()) {
            logger.trace("addNotificationListener", "Add the listener " + notificationListener + " at " + objectName);
        }
        ClientNotifForwarder clientNotifForwarder = this;
        synchronized (clientNotifForwarder) {
            this.infoList.put(n, new ClientListenerInfo(n, objectName, notificationListener, notificationFilter, object, subject));
        }
        this.init();
    }

    public synchronized Integer[] removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove the listener " + notificationListener + " from " + objectName);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = new ArrayList(this.infoList.values());
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)arrayList2.get(i);
            if (!clientListenerInfo.sameAs(objectName, notificationListener)) continue;
            arrayList.add(clientListenerInfo.getListenerID());
            this.infoList.remove(clientListenerInfo.getListenerID());
        }
        if (arrayList.isEmpty()) {
            throw new ListenerNotFoundException("Listener not found");
        }
        if (this.infoList.isEmpty()) {
            this.unInit();
        }
        Integer[] integerArray = new Integer[arrayList.size()];
        arrayList.toArray(integerArray);
        return integerArray;
    }

    public synchronized Integer removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove the listener " + notificationListener + " from " + objectName);
        }
        Integer n = null;
        ArrayList arrayList = new ArrayList(this.infoList.values());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)arrayList.get(i);
            if (!clientListenerInfo.sameAs(objectName, notificationListener, notificationFilter, object)) continue;
            n = clientListenerInfo.getListenerID();
            this.infoList.remove(n);
            break;
        }
        if (n == null) {
            throw new ListenerNotFoundException("Listener not found");
        }
        if (this.infoList.isEmpty()) {
            this.unInit();
        }
        return n;
    }

    public synchronized Integer[] removeNotificationListener(ObjectName objectName) {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove all listeners registered at " + objectName);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = new ArrayList(this.infoList.values());
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            ClientListenerInfo clientListenerInfo = (ClientListenerInfo)arrayList2.get(i);
            if (!clientListenerInfo.sameAs(objectName)) continue;
            arrayList.add(clientListenerInfo.getListenerID());
            this.infoList.remove(clientListenerInfo.getListenerID());
        }
        if (this.infoList.isEmpty()) {
            this.unInit();
        }
        Integer[] integerArray = new Integer[arrayList.size()];
        arrayList.toArray(integerArray);
        return integerArray;
    }

    public synchronized ListenerInfo[] getListenerInfo() {
        return this.infoList.values().toArray(new ListenerInfo[0]);
    }

    public synchronized void restart() throws IOException {
        if (this.notifFetcher != null) {
            this.notifFetcher.stop();
        }
        this.infoList.clear();
        this.inited = false;
    }

    public synchronized void terminate() {
        if (logger.traceOn()) {
            logger.trace("terminate", "Terminating...");
        }
        if (!this.terminated) {
            block5: {
                this.terminated = true;
                if (this.notifFetcher != null) {
                    this.notifFetcher.stop();
                }
                try {
                    this.removeListenerForMBeanRemovedNotif(this.mbeanRemovedNotifID);
                }
                catch (Exception exception) {
                    if (!logger.debugOn()) break block5;
                    logger.debug("terminate", "Failed to remove a listener (this is OK)", exception);
                }
            }
            this.infoList.clear();
        }
    }

    private synchronized void init() throws IOException {
        if (!this.inited) {
            Object object;
            block6: {
                if (logger.traceOn()) {
                    logger.trace("init", "Initializing...");
                }
                this.inited = true;
                try {
                    object = this.fetchNotifs(-1L, 0, 0L);
                    this.clientSequenceNumber = ((NotificationResult)object).getNextSequenceNumber();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.error("init", "Impossible exception", classNotFoundException);
                }
                try {
                    this.mbeanRemovedNotifID = this.addListenerForMBeanRemovedNotif();
                }
                catch (Exception exception) {
                    if (!logger.traceOn()) break block6;
                    logger.trace("init", "Failed to register a listener to the mbean server: the client will not do clean when an MBean is unregistered", exception);
                }
            }
            this.notifFetcher = new NotifFetcher();
            object = new Thread(this.notifFetcher);
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void unInit() {
        if (this.infoList.isEmpty()) {
            if (this.notifFetcher != null) {
                this.notifFetcher.stop();
            }
            if (this.mbeanRemovedNotifID != null) {
                try {
                    this.removeListenerForMBeanRemovedNotif(this.mbeanRemovedNotifID);
                }
                catch (Exception exception) {
                    logger.error("Failed to remove the internal listener for receiving notifications from MBeanServer itself", exception);
                }
                finally {
                    this.mbeanRemovedNotifID = null;
                }
            }
            this.infoList.clear();
            this.inited = false;
        }
    }

    private static class ClientListenerInfo
    extends ListenerInfo {
        public ClientListenerInfo(Integer n, ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, Subject subject) {
            super(n, objectName, notificationListener, notificationFilter, object, subject);
        }

        public boolean sameAs(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            return this.getObjectName().equals(objectName) && this.getListener() == notificationListener && this.getNotificationFilter() == notificationFilter && this.getHandback() == object;
        }

        public boolean sameAs(ObjectName objectName, NotificationListener notificationListener) {
            return this.getObjectName().equals(objectName) && this.getListener() == notificationListener;
        }

        public boolean sameAs(ObjectName objectName) {
            return this.getObjectName().equals(objectName);
        }
    }

    private class NotifFetcher
    implements Runnable {
        private Thread myThread;
        private boolean fetchStopped = false;

        private NotifFetcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = ClientNotifForwarder.this;
            synchronized (object) {
                this.myThread = Thread.currentThread();
            }
            if (ClientNotifForwarder.this.defaultClassLoader != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        myThread.setContextClassLoader(ClientNotifForwarder.this.defaultClassLoader);
                        return null;
                    }
                });
            }
            while (!this.shouldStop()) {
                long l;
                object = this.fetchNotifs();
                if (object == null || this.shouldStop()) {
                    return;
                }
                if (ClientNotifForwarder.this.clientSequenceNumber >= 0L && (l = ((NotificationResult)object).getEarliestSequenceNumber() - ClientNotifForwarder.this.clientSequenceNumber) > 0L) {
                    String string = "May have lost up to " + l + " notification" + (l == 1L ? "" : "s");
                    ClientNotifForwarder.this.lostNotifs(string, l);
                    logger.trace("NotifFetcher.run", string);
                }
                ClientNotifForwarder.this.clientSequenceNumber = ((NotificationResult)object).getNextSequenceNumber();
                TargetedNotification[] targetedNotificationArray = ((NotificationResult)object).getTargetedNotifications();
                int n = targetedNotificationArray.length;
                for (int i = 0; i < n; ++i) {
                    TargetedNotification targetedNotification = targetedNotificationArray[i];
                    this.dispatchNotification(targetedNotification);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatchNotification(TargetedNotification targetedNotification) {
            ClientListenerInfo clientListenerInfo;
            Notification notification = targetedNotification.getNotification();
            Integer n = targetedNotification.getListenerID();
            Object object = ClientNotifForwarder.this;
            synchronized (object) {
                if (n.equals(ClientNotifForwarder.this.mbeanRemovedNotifID)) {
                    if (notification instanceof MBeanServerNotification && notification.getType().equals("JMX.mbean.unregistered")) {
                        MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                        ObjectName objectName = mBeanServerNotification.getMBeanName();
                        ClientNotifForwarder.this.removeNotificationListener(objectName);
                    }
                    return;
                }
                clientListenerInfo = (ClientListenerInfo)ClientNotifForwarder.this.infoList.get(n);
            }
            if (clientListenerInfo == null) {
                logger.trace("NotifFetcher.dispatch", "Listener ID not in map");
            } else {
                object = clientListenerInfo.getListener();
                Object object2 = clientListenerInfo.getHandback();
                try {
                    object.handleNotification(notification, object2);
                }
                catch (RuntimeException runtimeException) {
                    logger.trace("NotifFetcher-run", "Failed to forward a notification to a listener", runtimeException);
                }
            }
        }

        private NotificationResult fetchNotifs() {
            try {
                NotificationResult notificationResult = ClientNotifForwarder.this.fetchNotifs(ClientNotifForwarder.this.clientSequenceNumber, ClientNotifForwarder.this.maxNotifications, ClientNotifForwarder.this.timeout);
                if (logger.traceOn()) {
                    logger.trace("NotifFetcher-run", "Got notifications from the server: " + notificationResult);
                }
                return notificationResult;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.fetchOneNotif();
            }
            catch (IOException iOException) {
                if (!this.shouldStop()) {
                    logger.error("NotifFetcher-run", "Failed to fetch notification, stopping thread", iOException);
                }
                return null;
            }
        }

        private NotificationResult fetchOneNotif() {
            Object object;
            ClientNotifForwarder clientNotifForwarder = ClientNotifForwarder.this;
            long l = ClientNotifForwarder.this.clientSequenceNumber;
            int n = 0;
            NotificationResult notificationResult = null;
            while (notificationResult == null && !this.shouldStop()) {
                try {
                    object = clientNotifForwarder.fetchNotifs(l, 0, 0L);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.error("NotifFetcher.fetchOneNotif", "Impossible exception", classNotFoundException);
                    return null;
                }
                catch (IOException iOException) {
                    if (!this.shouldStop()) {
                        logger.trace("NotifFetcher.fetchOneNotif", iOException);
                    }
                    return null;
                }
                if (this.shouldStop()) {
                    return null;
                }
                l = ((NotificationResult)object).getNextSequenceNumber();
                try {
                    notificationResult = clientNotifForwarder.fetchNotifs(l, 1, 0L);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (logger.traceOn()) {
                        logger.trace("NotifFetcher.fetchOneNotif", classNotFoundException.toString());
                    }
                    ++n;
                    ++l;
                }
                catch (IOException iOException) {
                    if (!this.shouldStop()) {
                        logger.trace("NotifFetcher.fetchOneNotif", iOException);
                    }
                    return null;
                }
            }
            if (n > 0) {
                object = "Dropped " + n + " notification" + (n == 1 ? "" : "s") + " because classes were missing locally";
                ClientNotifForwarder.this.lostNotifs((String)object, n);
            }
            return notificationResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean shouldStop() {
            ClientNotifForwarder clientNotifForwarder = ClientNotifForwarder.this;
            synchronized (clientNotifForwarder) {
                return this.fetchStopped || ClientNotifForwarder.this.terminated;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            ClientNotifForwarder clientNotifForwarder = ClientNotifForwarder.this;
            synchronized (clientNotifForwarder) {
                this.fetchStopped = true;
                if (logger.traceOn()) {
                    logger.trace("NotifFetcher-run", "Stop running.");
                }
                if (Thread.currentThread() != this.myThread && this.myThread != null) {
                    this.myThread.interrupt();
                }
            }
        }
    }
}

