/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.internal;

import com.sun.jmx.remote.opt.internal.ArrayQueue;
import com.sun.jmx.remote.opt.internal.ListenerInfo;
import com.sun.jmx.remote.opt.internal.NotificationBuffer;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class ArrayNotificationBuffer
implements NotificationBuffer {
    private static final IdentityHashMap mbsToBuffer = new IdentityHashMap(1);
    private final Collection sharers = new HashSet(1);
    private final NotificationListener queryBufferListener = new BufferListener();
    private final NotificationListener creationBufferListener = new BufferListener();
    private static final QueryExp broadcasterQuery = new BroadcasterQuery();
    private static final NotificationFilter creationFilter;
    private final NotificationListener creationListener = new NotificationListener(){

        public void handleNotification(Notification notification, Object object) {
            logger.debug("creationListener", "handleNotification called");
            ArrayNotificationBuffer.this.createdNotification((MBeanServerNotification)notification);
        }
    };
    private static final ClassLogger logger;
    private static final ObjectName delegateName;
    private final MBeanServer mBeanServer;
    private final ArrayQueue queue;
    private int queueSize;
    private long earliestSequenceNumber;
    private long nextSequenceNumber;
    private boolean destroyed;
    static final String broadcasterClass;
    static /* synthetic */ Class class$javax$management$NotificationBroadcaster;

    public static synchronized NotificationBuffer getNotificationBuffer(MBeanServer mBeanServer, int n) {
        ArrayNotificationBuffer arrayNotificationBuffer = (ArrayNotificationBuffer)mbsToBuffer.get(mBeanServer);
        if (arrayNotificationBuffer == null) {
            arrayNotificationBuffer = new ArrayNotificationBuffer(mBeanServer, n);
            mbsToBuffer.put(mBeanServer, arrayNotificationBuffer);
        }
        ArrayNotificationBuffer arrayNotificationBuffer2 = arrayNotificationBuffer;
        arrayNotificationBuffer2.getClass();
        return arrayNotificationBuffer2.new ShareBuffer(n);
    }

    synchronized void addSharer(ShareBuffer shareBuffer) {
        if (shareBuffer.getSize() > this.queueSize) {
            this.resize(shareBuffer.getSize());
        }
        this.sharers.add(shareBuffer);
    }

    synchronized void removeSharer(ShareBuffer shareBuffer) {
        this.sharers.remove(shareBuffer);
        if (this.sharers.isEmpty()) {
            this.dispose();
        } else {
            int n = 0;
            Iterator iterator = this.sharers.iterator();
            while (iterator.hasNext()) {
                ShareBuffer shareBuffer2 = (ShareBuffer)iterator.next();
                int n2 = shareBuffer2.getSize();
                if (n2 <= n) continue;
                n = n2;
            }
            if (n < this.queueSize) {
                this.resize(n);
            }
        }
    }

    private void resize(int n) {
        if (n == this.queueSize) {
            return;
        }
        while (this.queue.size() > n) {
            this.dropNotification();
        }
        this.queue.resize(n);
        this.queueSize = n;
    }

    private ArrayNotificationBuffer(MBeanServer mBeanServer, int n) {
        if (logger.traceOn()) {
            logger.trace("Constructor", "queueSize=" + n);
        }
        if (mBeanServer == null || n < 1) {
            throw new IllegalArgumentException("Bad args");
        }
        this.mBeanServer = mBeanServer;
        this.queueSize = n;
        this.queue = new ArrayQueue(n);
        this.nextSequenceNumber = this.earliestSequenceNumber = System.currentTimeMillis();
        this.createListeners();
        logger.trace("Constructor", "ends");
    }

    public void dispose() {
        logger.trace("dispose", "starts");
        this.destroyListeners();
        logger.trace("dispose", "ends");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationResult fetchNotifications(Set set, long l, long l2, int n) throws InterruptedException {
        TargetedNotification[] targetedNotificationArray;
        logger.trace("fetchNotifications", "starts");
        if (l < 0L) {
            return new NotificationResult(this.nextSequenceNumber(), this.nextSequenceNumber(), new TargetedNotification[0]);
        }
        if (set == null || l < 0L || l2 < 0L || n < 0) {
            logger.trace("fetchNotifications", "Bad args");
            throw new IllegalArgumentException("Bad args to fetch");
        }
        if (logger.debugOn()) {
            logger.trace("fetchNotifications", "listener-length=" + set.size() + "; startSeq=" + l + "; timeout=" + l2 + "; max=" + n);
        }
        if (l > this.nextSequenceNumber()) {
            String string = "Start sequence number too big: " + l + " > " + this.nextSequenceNumber();
            logger.trace("fetchNotifications", string);
            throw new IllegalArgumentException(string);
        }
        long l3 = System.currentTimeMillis() + l2;
        if (l3 < 0L) {
            l3 = Long.MAX_VALUE;
        }
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", "endTime=" + l3);
        }
        long l4 = -1L;
        long l5 = l;
        ArrayList arrayList = new ArrayList();
        while (true) {
            NamedNotification namedNotification;
            logger.debug("fetchNotifications", "main loop starts");
            targetedNotificationArray = this;
            synchronized (targetedNotificationArray) {
                if (l4 < 0L) {
                    l4 = this.earliestSequenceNumber();
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "earliestSeq=" + l4);
                    }
                    if (l5 < l4) {
                        l5 = l4;
                        logger.debug("fetchNotifications", "nextSeq=earliestSeq");
                    }
                } else {
                    l4 = this.earliestSequenceNumber();
                }
                if (l5 < l4) {
                    logger.trace("fetchNotifications", "nextSeq=" + l5 + " < " + "earliestSeq=" + l4 + " so may have lost notifs");
                    break;
                }
                if (l5 < this.nextSequenceNumber()) {
                    namedNotification = this.notificationAt(l5);
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "candidate: " + namedNotification);
                        logger.debug("fetchNotifications", "nextSeq now " + l5);
                    }
                } else {
                    if (arrayList.size() > 0) {
                        logger.debug("fetchNotifications", "no more notifs but have some so don't wait");
                        break;
                    }
                    long l6 = l3 - System.currentTimeMillis();
                    if (l6 <= 0L) {
                        logger.debug("fetchNotifications", "timeout");
                        break;
                    }
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "wait(" + l6 + ")");
                    }
                    this.wait(l6);
                    continue;
                }
            }
            targetedNotificationArray = namedNotification.getObjectName();
            Notification notification = namedNotification.getNotification();
            ArrayList<TargetedNotification> arrayList2 = new ArrayList<TargetedNotification>();
            logger.debug("fetchNotifications", "applying filters to candidate");
            Set set2 = set;
            synchronized (set2) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ListenerInfo listenerInfo = (ListenerInfo)iterator.next();
                    ObjectName objectName = listenerInfo.getObjectName();
                    NotificationFilter notificationFilter = listenerInfo.getNotificationFilter();
                    if (logger.debugOn()) {
                        logger.debug("fetchNotifications", "pattern=<" + objectName + ">; filter=" + notificationFilter);
                    }
                    if (!objectName.apply((ObjectName)targetedNotificationArray)) continue;
                    logger.debug("fetchNotifications", "pattern matches");
                    if (notificationFilter != null && !notificationFilter.isNotificationEnabled(notification)) continue;
                    logger.debug("fetchNotifications", "filter matches");
                    Integer n2 = listenerInfo.getListenerID();
                    TargetedNotification targetedNotification = new TargetedNotification(notification, n2);
                    arrayList2.add(targetedNotification);
                }
            }
            if (arrayList2.size() > 0) {
                if (n <= 0) {
                    logger.debug("fetchNotifications", "reached maxNotifications");
                    break;
                }
                --n;
                if (logger.debugOn()) {
                    logger.debug("fetchNotifications", "add: " + arrayList2);
                }
                arrayList.addAll(arrayList2);
            }
            ++l5;
        }
        int n3 = arrayList.size();
        targetedNotificationArray = new TargetedNotification[n3];
        arrayList.toArray(targetedNotificationArray);
        NotificationResult notificationResult = new NotificationResult(l4, l5, targetedNotificationArray);
        if (logger.debugOn()) {
            logger.debug("fetchNotifications", notificationResult.toString());
        }
        logger.trace("fetchNotifications", "ends");
        return notificationResult;
    }

    synchronized long earliestSequenceNumber() {
        return this.earliestSequenceNumber;
    }

    synchronized long nextSequenceNumber() {
        return this.nextSequenceNumber;
    }

    synchronized void addNotification(NamedNotification namedNotification) {
        if (logger.traceOn()) {
            logger.trace("addNotification", namedNotification.toString());
        }
        while (this.queue.size() >= this.queueSize) {
            this.dropNotification();
            if (!logger.debugOn()) continue;
            logger.debug("addNotification", "dropped oldest notif, earliestSeq=" + this.earliestSequenceNumber);
        }
        this.queue.add(namedNotification);
        ++this.nextSequenceNumber;
        if (logger.debugOn()) {
            logger.debug("addNotification", "nextSeq=" + this.nextSequenceNumber);
        }
        this.notifyAll();
    }

    private void dropNotification() {
        this.queue.remove(0);
        ++this.earliestSequenceNumber;
    }

    synchronized NamedNotification notificationAt(long l) {
        long l2 = l - this.earliestSequenceNumber;
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            String string = "Bad sequence number: " + l + " (earliest " + this.earliestSequenceNumber + ")";
            logger.trace("notificationAt", string);
            throw new IllegalArgumentException(string);
        }
        return (NamedNotification)this.queue.get((int)l2);
    }

    private synchronized void createListeners() {
        Set set;
        logger.debug("createListeners", "starts");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.addNotificationListener(delegateName, ArrayNotificationBuffer.this.creationListener, creationFilter, null);
                    return null;
                }
            });
            logger.debug("createListeners", "added creationListener");
        }
        catch (Exception exception) {
            Exception exception2 = ArrayNotificationBuffer.extractException(exception);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Can't add listener to MBean server delegate: " + exception2);
            EnvHelp.initCause(illegalArgumentException, exception2);
            logger.error("createListeners", exception2);
            throw illegalArgumentException;
        }
        try {
            set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ArrayNotificationBuffer.this.mBeanServer.queryNames(null, broadcasterQuery);
                }
            });
        }
        catch (RuntimeException runtimeException) {
            logger.error("createListeners", runtimeException);
            throw runtimeException;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            this.addBufferListener(objectName, this.queryBufferListener);
        }
        logger.debug("createListeners", "ends");
    }

    private void addBufferListener(final ObjectName objectName, final NotificationListener notificationListener) {
        if (logger.debugOn()) {
            logger.debug("addBufferListener", objectName.toString());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.addNotificationListener(objectName, notificationListener, null, (Object)objectName);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            logger.trace("addBufferListener", ArrayNotificationBuffer.extractException(exception));
        }
    }

    private synchronized void createdNotification(MBeanServerNotification mBeanServerNotification) {
        if (this.destroyed) {
            logger.trace("createNotification", "NotificationBuffer was destroyed");
            return;
        }
        if (!mBeanServerNotification.getType().equals("JMX.mbean.registered")) {
            logger.error("createNotification", "bad type: " + mBeanServerNotification.getType());
            return;
        }
        final ObjectName objectName = mBeanServerNotification.getMBeanName();
        if (logger.debugOn()) {
            logger.debug("createdNotification", "for: " + objectName);
        }
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException {
                    return new Boolean(ArrayNotificationBuffer.this.mBeanServer.isInstanceOf(objectName, broadcasterClass));
                }
            });
            if (!bl.booleanValue()) {
                logger.debug("createdNotification", "not a NotificationBroadcaster");
                return;
            }
        }
        catch (Exception exception) {
            logger.trace("createdNotification", ArrayNotificationBuffer.extractException(exception));
            return;
        }
        this.addBufferListener(objectName, this.creationBufferListener);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstanceNotFoundException, ListenerNotFoundException {
                    ArrayNotificationBuffer.this.mBeanServer.removeNotificationListener(objectName, ArrayNotificationBuffer.this.queryBufferListener);
                    return null;
                }
            });
            logger.trace("createdNotification", "remove queryBufferListener worked!");
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = ArrayNotificationBuffer.extractException(privilegedActionException);
            if (exception instanceof ListenerNotFoundException) {
                logger.debug("createdNotification", "remove queryBufferListener got ListenerNotFoundException as expected");
            }
            logger.trace("createdNotification", exception);
        }
    }

    private synchronized void destroyListeners() {
        logger.debug("destroyListeners", "starts");
        this.destroyed = true;
        Set set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ArrayNotificationBuffer.this.mBeanServer.queryNames(null, broadcasterQuery);
            }
        });
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            final ObjectName objectName = (ObjectName)iterator.next();
            if (logger.debugOn()) {
                logger.debug("destroyListeners", "remove listener from " + objectName);
            }
            for (int i = 0; i < 2; ++i) {
                boolean bl = i == 0;
                final NotificationListener notificationListener = bl ? this.creationBufferListener : this.queryBufferListener;
                String string = bl ? "creationBufferListener" : "queryBufferListener";
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws InstanceNotFoundException, ListenerNotFoundException {
                            ArrayNotificationBuffer.this.mBeanServer.removeNotificationListener(objectName, notificationListener);
                            return null;
                        }
                    });
                    if (!logger.debugOn()) continue;
                    logger.debug("destroyListeners", "removed " + string);
                    continue;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = ArrayNotificationBuffer.extractException(privilegedActionException);
                    if (exception instanceof ListenerNotFoundException) {
                        if (!logger.debugOn()) continue;
                        logger.debug("destroyListeners", "ListenerNotFoundException for " + string + " (normal)");
                        continue;
                    }
                    logger.trace("destroyListeners", exception);
                }
            }
        }
        logger.debug("destroyListeners", "ends");
    }

    private static Exception extractException(Exception exception) {
        while (exception instanceof PrivilegedActionException) {
            exception = ((PrivilegedActionException)exception).getException();
        }
        return exception;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        notificationFilterSupport.enableType("JMX.mbean.registered");
        creationFilter = notificationFilterSupport;
        logger = new ClassLogger("javax.management.remote.misc", "ArrayNotificationBuffer");
        try {
            delegateName = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            RuntimeException runtimeException = new RuntimeException("Can't create delegate name: " + malformedObjectNameException);
            EnvHelp.initCause(runtimeException, malformedObjectNameException);
            logger.error("<init>", runtimeException);
            throw runtimeException;
        }
        broadcasterClass = (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = ArrayNotificationBuffer.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getName();
    }

    private static class BroadcasterQuery
    extends QueryEval
    implements QueryExp {
        private BroadcasterQuery() {
        }

        public boolean apply(ObjectName objectName) {
            MBeanServer mBeanServer = QueryEval.getMBeanServer();
            try {
                Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(this, mBeanServer, objectName){
                    private final /* synthetic */ MBeanServer val$mbs;
                    private final /* synthetic */ ObjectName val$name;
                    private final /* synthetic */ BroadcasterQuery this$0;
                    {
                        this.this$0 = broadcasterQuery;
                        this.val$mbs = mBeanServer;
                        this.val$name = objectName;
                    }

                    public Object run() throws InstanceNotFoundException {
                        return new Boolean(this.val$mbs.isInstanceOf(this.val$name, broadcasterClass));
                    }
                });
                if (logger.debugOn()) {
                    logger.debug("BroadcasterQuery", objectName + " -> " + bl);
                }
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                logger.debug("BroadcasterQuery", ArrayNotificationBuffer.extractException(privilegedActionException));
                return false;
            }
        }
    }

    private class BufferListener
    implements NotificationListener {
        private BufferListener() {
        }

        public void handleNotification(Notification notification, Object object) {
            if (logger.debugOn()) {
                logger.debug("BufferListener.handleNotification", "notif=" + notification + "; handback=" + object);
            }
            ObjectName objectName = (ObjectName)object;
            ArrayNotificationBuffer.this.addNotification(new NamedNotification(objectName, notification));
        }
    }

    private static class NamedNotification {
        private final ObjectName sender;
        private final Notification notification;

        NamedNotification(ObjectName objectName, Notification notification) {
            this.sender = objectName;
            this.notification = notification;
        }

        ObjectName getObjectName() {
            return this.sender;
        }

        Notification getNotification() {
            return this.notification;
        }

        public String toString() {
            return "NamedNotification(" + this.sender + ", " + this.notification + ")";
        }
    }

    private class ShareBuffer
    implements NotificationBuffer {
        private final int size;

        ShareBuffer(int n) {
            this.size = n;
            ArrayNotificationBuffer.this.addSharer(this);
        }

        public NotificationResult fetchNotifications(Set set, long l, long l2, int n) throws InterruptedException {
            ArrayNotificationBuffer arrayNotificationBuffer = ArrayNotificationBuffer.this;
            return arrayNotificationBuffer.fetchNotifications(set, l, l2, n);
        }

        public void dispose() {
            ArrayNotificationBuffer.this.removeSharer(this);
        }

        int getSize() {
            return this.size;
        }
    }
}

