/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.generic.SynchroMessageConnection;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.remote.generic.ConnectionClosedException;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.Message;
import javax.management.remote.message.NotificationRequestMessage;
import javax.management.remote.message.NotificationResponseMessage;
import javax.security.auth.Subject;

public class SynchroMessageConnectionImpl
implements SynchroMessageConnection {
    private transient MessageConnection connection;
    private transient Subject subject = null;
    private Map env;
    private transient SynchroCallback callback;
    private transient ThreadService threads;
    private transient MessageReader reader;
    private transient long wtimeout;
    private transient HashMap waitingList = new HashMap();
    private final transient int[] notifLock = new int[0];
    private transient Message notifResp = null;
    private static final int UNCONNECTED = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 4;
    private static final int FAILED = 8;
    private static final int TERMINATED = 16;
    private int state = 1;
    private int[] stateLock = new int[0];
    private long waitConnectedState;
    private final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "SynchroMessageConnectionImpl");

    public SynchroMessageConnectionImpl(MessageConnection messageConnection, SynchroCallback synchroCallback, Map map) {
        this(messageConnection, synchroCallback, map, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchroMessageConnectionImpl(MessageConnection messageConnection, SynchroCallback synchroCallback, Map map, ThreadService threadService) {
        if (messageConnection == null) {
            throw new IllegalArgumentException("Null message connection.");
        }
        this.env = map;
        this.threads = threadService;
        this.wtimeout = DefaultConfig.getRequestTimeout(map);
        this.waitConnectedState = DefaultConfig.getTimeoutForWaitConnectedState(map);
        this.connection = messageConnection;
        this.callback = synchroCallback;
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.callback != null) {
                this.reader = new MessageReader();
                threadService.handoff(this.reader);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map map) throws IOException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 1) {
                if (this.logger.traceOn()) {
                    this.logger.trace("connect", "Establishing the connection.");
                }
                this.state = 2;
                this.stateLock.notifyAll();
                this.connection.connect(map);
                this.state = 4;
                this.stateLock.notifyAll();
            } else if (this.state == 8 || this.state == 4) {
                Object object;
                if (this.logger.traceOn()) {
                    this.logger.trace("connect", "Re-establishing the connection...");
                }
                if (this.state == 4) {
                    this.state = 8;
                    this.stateLock.notifyAll();
                }
                this.state = 2;
                this.stateLock.notifyAll();
                this.connection.connect(map);
                this.callback = null;
                if (this.logger.traceOn()) {
                    object = "Wakeup the threads which are waiting a response frome the server to inform them of the connection failure.";
                    this.logger.trace("connect", (String)object);
                }
                object = new ConnectionClosedException("The connection has been closed by the server.");
                HashMap hashMap = this.waitingList;
                synchronized (hashMap) {
                    Iterator iterator = this.waitingList.keySet().iterator();
                    while (iterator.hasNext()) {
                        ResponseMsgWrapper responseMsgWrapper;
                        Long l = (Long)iterator.next();
                        ResponseMsgWrapper responseMsgWrapper2 = responseMsgWrapper = (ResponseMsgWrapper)this.waitingList.get(l);
                        synchronized (responseMsgWrapper2) {
                            if (!responseMsgWrapper.got) {
                                responseMsgWrapper.got = true;
                                responseMsgWrapper.msg = object;
                            }
                            responseMsgWrapper.notify();
                        }
                    }
                    this.waitingList.clear();
                }
                if (this.threads == null) {
                    this.threads = new ThreadService(DefaultConfig.getServerMinThreads(map), DefaultConfig.getServerMaxThreads(map));
                }
                this.state = 4;
                this.stateLock.notifyAll();
            } else {
                this.checkState();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.threads == null) {
                this.threads = new ThreadService(DefaultConfig.getServerMinThreads(map), DefaultConfig.getServerMaxThreads(map));
            }
            if (this.logger.traceOn()) {
                this.logger.trace("connect", "Done");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOneWay(Message message) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("sendOneWay", "Send a message without response.");
        }
        this.checkState();
        MessageConnection messageConnection = this.connection;
        synchronized (messageConnection) {
            this.connection.writeMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message sendWithReturn(Message message) throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("sendOneWay", "Send a message with response.");
        }
        this.checkState();
        Message message2 = null;
        if (message instanceof NotificationRequestMessage) {
            if (this.logger.traceOn()) {
                this.logger.trace("sendOneWay", "Send a NotificationRequestMessage.");
            }
            this.notifResp = null;
            Object object = this.connection;
            synchronized (object) {
                this.connection.writeMessage(message);
            }
            object = this.notifLock;
            synchronized (this.notifLock) {
                if (this.notifResp == null) {
                    try {
                        this.notifLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException("Interrupted.");
                    }
                }
                message2 = this.notifResp;
                this.notifResp = null;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return message2;
            }
        }
        if (!(message instanceof MBeanServerRequestMessage)) throw new IOException("Unknow message type: " + message);
        if (this.logger.traceOn()) {
            this.logger.trace("sendOneWay", "Send a MBeanServerRequestMessage.");
        }
        Long l = new Long(((MBeanServerRequestMessage)message).getMessageId());
        boolean bl = false;
        while (true) {
            ResponseMsgWrapper responseMsgWrapper = new ResponseMsgWrapper();
            Object object = this.waitingList;
            synchronized (object) {
                this.waitingList.put(l, responseMsgWrapper);
            }
            object = this.connection;
            synchronized (object) {
                this.connection.writeMessage(message);
            }
            object = responseMsgWrapper;
            synchronized (object) {
                if (!responseMsgWrapper.got) {
                    try {
                        responseMsgWrapper.wait(this.wtimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            object = this.waitingList;
            synchronized (object) {
                this.waitingList.remove(l);
            }
            if (!responseMsgWrapper.got) {
                if (this.isTerminated()) throw new IOException("The connection has been closed or broken.");
                throw new InterruptedIOException("Waiting response timeout: " + this.wtimeout);
            }
            if (responseMsgWrapper.msg instanceof MBeanServerResponseMessage) {
                return (MBeanServerResponseMessage)responseMsgWrapper.msg;
            }
            if (!(responseMsgWrapper.msg instanceof ConnectionClosedException)) throw new IOException("Got wrong response: " + responseMsgWrapper.msg);
            if (this.isTerminated()) throw (ConnectionClosedException)responseMsgWrapper.msg;
            if (bl) {
                throw (ConnectionClosedException)responseMsgWrapper.msg;
            }
            if (this.logger.traceOn()) {
                this.logger.trace("sendWithReturn", "Got a local ConnectionClosedException, retry.");
            }
            bl = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(SynchroCallback synchroCallback) {
        if (this.logger.traceOn()) {
            this.logger.trace("setCallback", "be called.");
        }
        if (synchroCallback == null) {
            throw new IllegalArgumentException("Null callback.");
        }
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            boolean bl = this.callback == null;
            this.callback = synchroCallback;
            if (bl && this.state != 16) {
                if (this.logger.traceOn()) {
                    this.logger.trace("setCallback", "Start the reader to wait to coming message.");
                }
                this.reader = new MessageReader();
                this.threads.handoff(this.reader);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.logger.traceOn()) {
            this.logger.trace("close", "Closing this SynchroMessageConnection.");
        }
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 16) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.state = 16;
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Close the callback reader.");
            }
            if (this.reader != null) {
                this.reader.terminate();
            }
            if (this.threads != ThreadService.getShared() && this.threads != null) {
                this.threads.terminate();
                this.threads = null;
            }
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Closing the underlying connection.");
            }
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.logger.traceOn()) {
                this.logger.trace("close", "Clean all threads waiting theire responses.");
            }
            HashMap hashMap = this.waitingList;
            synchronized (hashMap) {
                Iterator iterator = this.waitingList.values().iterator();
                while (iterator.hasNext()) {
                    ResponseMsgWrapper responseMsgWrapper = (ResponseMsgWrapper)iterator.next();
                    ConnectionClosedException connectionClosedException = new ConnectionClosedException("The connection has been closed by the server.");
                    ResponseMsgWrapper responseMsgWrapper2 = responseMsgWrapper;
                    synchronized (responseMsgWrapper2) {
                        if (!responseMsgWrapper.got) {
                            responseMsgWrapper.got = true;
                            responseMsgWrapper.msg = connectionClosedException;
                        }
                        responseMsgWrapper.notify();
                    }
                }
                this.waitingList.clear();
            }
            this.stateLock.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getConnectionId() {
        return this.connection.getConnectionId();
    }

    public MessageConnection getAsynchroConnection() {
        return this.connection;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    private void checkState() throws IllegalStateException {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            if (this.state == 4) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (this.state == 16) {
                throw new IllegalStateException("The connection has been closed.");
            }
            long l = this.waitConnectedState;
            long l2 = System.currentTimeMillis() + l;
            while (this.state != 4 && this.state != 16 && l > 0L) {
                try {
                    this.stateLock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                l = l2 - System.currentTimeMillis();
            }
            if (this.state == 4) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            throw new IllegalStateException("The connection is not currently established.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTerminated() {
        int[] nArray = this.stateLock;
        synchronized (this.stateLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 16;
        }
    }

    private class RemoteJob
    implements Runnable {
        private Message msg;

        public RemoteJob(Message message) {
            this.msg = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                if (SynchroMessageConnectionImpl.this.logger.traceOn()) {
                    SynchroMessageConnectionImpl.this.logger.trace("RemoteJob-run", "Receive a new request.");
                }
                try {
                    Message message = SynchroMessageConnectionImpl.this.callback.execute(this.msg);
                    if (message == null) break block10;
                    MessageConnection messageConnection = SynchroMessageConnectionImpl.this.connection;
                    synchronized (messageConnection) {
                        SynchroMessageConnectionImpl.this.connection.writeMessage(message);
                    }
                }
                catch (Exception exception) {
                    int[] nArray = SynchroMessageConnectionImpl.this.stateLock;
                    synchronized (nArray) {
                        if (SynchroMessageConnectionImpl.this.state != 4 && SynchroMessageConnectionImpl.this.callback != null) {
                            SynchroMessageConnectionImpl.this.callback.connectionException(exception);
                        }
                    }
                }
            }
        }
    }

    private static class ResponseMsgWrapper {
        public boolean got = false;
        public Object msg = null;

        public void setMsg(Message message) {
            this.got = true;
            this.msg = message;
        }
    }

    private class MessageReader
    implements Runnable {
        private Thread executingThread;
        private boolean executingThreadInterrupted = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Object object;
            this.executingThread = Thread.currentThread();
            while (!SynchroMessageConnectionImpl.this.isTerminated()) {
                Message message;
                block19: {
                    if (SynchroMessageConnectionImpl.this.logger.traceOn()) {
                        SynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "Waiting a coming message...");
                    }
                    message = null;
                    try {
                        message = SynchroMessageConnectionImpl.this.connection.readMessage();
                    }
                    catch (Exception exception) {
                        if (SynchroMessageConnectionImpl.this.isTerminated()) break;
                        if (SynchroMessageConnectionImpl.this.callback == null) continue;
                        SynchroMessageConnectionImpl.this.callback.connectionException(exception);
                        continue;
                    }
                    if (SynchroMessageConnectionImpl.this.isTerminated()) break;
                    if (message instanceof NotificationResponseMessage) {
                        object = SynchroMessageConnectionImpl.this.notifLock;
                        // MONITORENTER : object
                        SynchroMessageConnectionImpl.this.notifResp = (NotificationResponseMessage)message;
                        SynchroMessageConnectionImpl.this.notifLock.notify();
                        // MONITOREXIT : object
                    } else if (message instanceof MBeanServerResponseMessage) {
                        Object object2 = SynchroMessageConnectionImpl.this.waitingList;
                        // MONITORENTER : object2
                        object = (ResponseMsgWrapper)SynchroMessageConnectionImpl.this.waitingList.get(new Long(((MBeanServerResponseMessage)message).getMessageId()));
                        // MONITOREXIT : object2
                        if (object == null) {
                            if (SynchroMessageConnectionImpl.this.isTerminated()) break;
                            if (SynchroMessageConnectionImpl.this.callback == null) continue;
                            SynchroMessageConnectionImpl.this.callback.connectionException(new IOException("Receive a MBeanServerResponseMessage but no one is waiting it."));
                            continue;
                        }
                        Object object3 = object;
                        object2 = object3;
                        // MONITORENTER : object3
                        ((ResponseMsgWrapper)object).setMsg(message);
                        object.notify();
                        // MONITOREXIT : object2
                    } else {
                        try {
                            SynchroMessageConnectionImpl.this.threads.handoff(new RemoteJob(message));
                        }
                        catch (Exception exception) {
                            if (SynchroMessageConnectionImpl.this.isTerminated() || SynchroMessageConnectionImpl.this.callback == null) break block19;
                            SynchroMessageConnectionImpl.this.callback.connectionException(exception);
                        }
                    }
                }
                if (!(message instanceof CloseMessage)) continue;
            }
            object = SynchroMessageConnectionImpl.this.stateLock;
            // MONITORENTER : object
            this.executingThreadInterrupted = true;
            // MONITOREXIT : object
            if (!SynchroMessageConnectionImpl.this.logger.traceOn()) return;
            SynchroMessageConnectionImpl.this.logger.trace("MessageReader-run", "ended.");
        }

        public void terminate() {
            if (SynchroMessageConnectionImpl.this.logger.traceOn()) {
                SynchroMessageConnectionImpl.this.logger.trace("MessageReader-terminated", "be called.");
            }
            if (Thread.currentThread() != this.executingThread && this.executingThread != null && !this.executingThreadInterrupted) {
                this.executingThreadInterrupted = true;
                this.executingThread.interrupt();
            }
            if (SynchroMessageConnectionImpl.this.logger.traceOn()) {
                SynchroMessageConnectionImpl.this.logger.trace("MessageReader-terminated", "done.");
            }
        }
    }
}

