/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.generic;

import com.sun.jmx.remote.generic.ClientAdmin;
import com.sun.jmx.remote.generic.ServerAdmin;
import com.sun.jmx.remote.generic.SynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import com.sun.jmx.remote.opt.security.AdminClient;
import com.sun.jmx.remote.opt.security.AdminServer;
import com.sun.jmx.remote.opt.util.EnvHelp;
import java.util.Map;

public class DefaultConfig {
    public static final String SERVER_MAX_THREADS = "jmx.remote.x.server.max.threads";
    public static final String SERVER_MIN_THREADS = "jmx.remote.x.server.min.threads";
    public static final String REQUEST_WAITING_TIME = "jmx.remote.x.request.timeout";
    public static final String SERVER_ADMIN = "com.sun.jmx.remote.server.admin";
    public static final String CLIENT_ADMIN = "com.sun.jmx.remote.client.admin";
    public static final String SYNCHRO_MESSAGE_CONNECTION_SERVER = "com.sun.jmx.remote.generic.synchro.server";
    public static final String SYNCHRO_MESSAGE_CONNECTION_CLIENT = "com.sun.jmx.remote.generic.synchro.client";
    public static final String TIMEOUT_FOR_CONNECTED_STATE = "jmx.remote.x.client.connected.state.timeout";

    public static int getServerMaxThreads(Map map) {
        return (int)EnvHelp.getIntegerAttribute(map, SERVER_MAX_THREADS, 10L, 1L, Integer.MAX_VALUE);
    }

    public static int getServerMinThreads(Map map) {
        return (int)EnvHelp.getIntegerAttribute(map, SERVER_MIN_THREADS, 1L, 1L, Integer.MAX_VALUE);
    }

    public static long getRequestTimeout(Map map) {
        return EnvHelp.getIntegerAttribute(map, REQUEST_WAITING_TIME, Long.MAX_VALUE, 0L, Long.MAX_VALUE);
    }

    public static ServerAdmin getServerAdmin(Map map) {
        ServerAdmin serverAdmin;
        Object v = map.get(SERVER_ADMIN);
        if (v == null) {
            serverAdmin = new AdminServer(map);
        } else if (v instanceof ServerAdmin) {
            serverAdmin = (ServerAdmin)v;
        } else {
            throw new IllegalArgumentException("The specified attribute \"com.sun.jmx.remote.server.admin\" is not a ServerAdmin object.");
        }
        return serverAdmin;
    }

    public static ClientAdmin getClientAdmin(Map map) {
        ClientAdmin clientAdmin;
        Object v = map.get(CLIENT_ADMIN);
        if (v == null) {
            clientAdmin = new AdminClient(map);
        } else if (v instanceof ClientAdmin) {
            clientAdmin = (ClientAdmin)v;
        } else {
            throw new IllegalArgumentException("The specified attribute \"com.sun.jmx.remote.client.admin\" is not a ClientAdmin object.");
        }
        return clientAdmin;
    }

    public static SynchroMessageConnectionServer getSynchroMessageConnectionServer(Map map) {
        SynchroMessageConnectionServer synchroMessageConnectionServer = null;
        if (map != null) {
            synchroMessageConnectionServer = (SynchroMessageConnectionServer)map.get(SYNCHRO_MESSAGE_CONNECTION_SERVER);
        }
        return synchroMessageConnectionServer;
    }

    public static SynchroMessageConnection getSynchroMessageConnection(Map map) {
        SynchroMessageConnection synchroMessageConnection = null;
        if (map != null) {
            synchroMessageConnection = (SynchroMessageConnection)map.get(SYNCHRO_MESSAGE_CONNECTION_CLIENT);
        }
        return synchroMessageConnection;
    }

    public static long getTimeoutForWaitConnectedState(Map map) {
        return EnvHelp.getIntegerAttribute(map, TIMEOUT_FOR_CONNECTED_STATE, 1000L, 1L, Long.MAX_VALUE);
    }
}

