/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.Hashtable;
import org.w3c.tidy.CheckAttribsImpl;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.Dict;
import org.w3c.tidy.Node;
import org.w3c.tidy.Parser;
import org.w3c.tidy.ParserImpl;

public class TagTable {
    private Configuration configuration = null;
    private Hashtable tagHashtable = new Hashtable();
    private static TagTable defaultTagTable = null;
    private static Dict[] tags = new Dict[]{new Dict("html", 31, 0x208002, ParserImpl.getParseHTML(), CheckAttribsImpl.getCheckHTML()), new Dict("head", 31, 0x208002, ParserImpl.getParseHead(), null), new Dict("title", 31, 4, ParserImpl.getParseTitle(), null), new Dict("base", 31, 5, null, null), new Dict("link", 31, 5, null, CheckAttribsImpl.getCheckLINK()), new Dict("meta", 31, 5, null, null), new Dict("style", 30, 4, ParserImpl.getParseScript(), CheckAttribsImpl.getCheckSTYLE()), new Dict("script", 30, 131100, ParserImpl.getParseScript(), CheckAttribsImpl.getCheckSCRIPT()), new Dict("server", 64, 131100, ParserImpl.getParseScript(), null), new Dict("body", 31, 0x208002, ParserImpl.getParseBody(), null), new Dict("frameset", 16, 8194, ParserImpl.getParseFrameSet(), null), new Dict("p", 31, 32776, ParserImpl.getParseInline(), null), new Dict("h1", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h2", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h3", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h4", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h5", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h6", 31, 16392, ParserImpl.getParseInline(), null), new Dict("ul", 31, 8, ParserImpl.getParseList(), null), new Dict("ol", 31, 8, ParserImpl.getParseList(), null), new Dict("dl", 31, 8, ParserImpl.getParseDefList(), null), new Dict("dir", 26, 524296, ParserImpl.getParseList(), null), new Dict("menu", 26, 524296, ParserImpl.getParseList(), null), new Dict("pre", 31, 8, ParserImpl.getParsePre(), null), new Dict("listing", 31, 524296, ParserImpl.getParsePre(), null), new Dict("xmp", 31, 524296, ParserImpl.getParsePre(), null), new Dict("plaintext", 31, 524296, ParserImpl.getParsePre(), null), new Dict("address", 31, 8, ParserImpl.getParseBlock(), null), new Dict("blockquote", 31, 8, ParserImpl.getParseBlock(), null), new Dict("form", 31, 8, ParserImpl.getParseBlock(), null), new Dict("isindex", 26, 9, null, null), new Dict("fieldset", 28, 8, ParserImpl.getParseBlock(), null), new Dict("table", 30, 8, ParserImpl.getParseTableTag(), CheckAttribsImpl.getCheckTABLE()), new Dict("hr", 31, 9, null, CheckAttribsImpl.getCheckHR()), new Dict("div", 30, 8, ParserImpl.getParseBlock(), null), new Dict("multicol", 64, 8, ParserImpl.getParseBlock(), null), new Dict("nosave", 64, 8, ParserImpl.getParseBlock(), null), new Dict("layer", 64, 8, ParserImpl.getParseBlock(), null), new Dict("ilayer", 64, 16, ParserImpl.getParseInline(), null), new Dict("nolayer", 64, 131096, ParserImpl.getParseBlock(), null), new Dict("align", 64, 8, ParserImpl.getParseBlock(), null), new Dict("center", 26, 8, ParserImpl.getParseBlock(), null), new Dict("ins", 28, 131096, ParserImpl.getParseInline(), null), new Dict("del", 28, 131096, ParserImpl.getParseInline(), null), new Dict("li", 31, 294944, ParserImpl.getParseBlock(), null), new Dict("dt", 31, 294976, ParserImpl.getParseInline(), null), new Dict("dd", 31, 294976, ParserImpl.getParseBlock(), null), new Dict("caption", 30, 128, ParserImpl.getParseInline(), CheckAttribsImpl.getCheckCaption()), new Dict("colgroup", 28, 32896, ParserImpl.getParseColGroup(), null), new Dict("col", 28, 129, null, null), new Dict("thead", 28, 33152, ParserImpl.getParseRowGroup(), null), new Dict("tfoot", 28, 33152, ParserImpl.getParseRowGroup(), null), new Dict("tbody", 28, 33152, ParserImpl.getParseRowGroup(), null), new Dict("tr", 30, 32896, ParserImpl.getParseRow(), null), new Dict("td", 30, 295424, ParserImpl.getParseBlock(), CheckAttribsImpl.getCheckTableCell()), new Dict("th", 30, 295424, ParserImpl.getParseBlock(), CheckAttribsImpl.getCheckTableCell()), new Dict("q", 28, 16, ParserImpl.getParseInline(), null), new Dict("a", 31, 16, ParserImpl.getParseInline(), CheckAttribsImpl.getCheckAnchor()), new Dict("br", 31, 17, null, null), new Dict("img", 31, 65553, null, CheckAttribsImpl.getCheckIMG()), new Dict("object", 28, 71700, ParserImpl.getParseBlock(), null), new Dict("applet", 26, 71696, ParserImpl.getParseBlock(), null), new Dict("servlet", 256, 71696, ParserImpl.getParseBlock(), null), new Dict("param", 30, 17, null, null), new Dict("embed", 64, 65553, null, null), new Dict("noembed", 64, 16, ParserImpl.getParseInline(), null), new Dict("iframe", 8, 16, ParserImpl.getParseBlock(), null), new Dict("frame", 16, 8193, null, null), new Dict("noframes", 24, 8200, ParserImpl.getParseNoFrames(), null), new Dict("noscript", 28, 131096, ParserImpl.getParseBlock(), null), new Dict("b", 31, 16, ParserImpl.getParseInline(), null), new Dict("i", 31, 16, ParserImpl.getParseInline(), null), new Dict("u", 26, 16, ParserImpl.getParseInline(), null), new Dict("tt", 31, 16, ParserImpl.getParseInline(), null), new Dict("s", 26, 16, ParserImpl.getParseInline(), null), new Dict("strike", 26, 16, ParserImpl.getParseInline(), null), new Dict("big", 30, 16, ParserImpl.getParseInline(), null), new Dict("small", 30, 16, ParserImpl.getParseInline(), null), new Dict("sub", 30, 16, ParserImpl.getParseInline(), null), new Dict("sup", 30, 16, ParserImpl.getParseInline(), null), new Dict("em", 31, 16, ParserImpl.getParseInline(), null), new Dict("strong", 31, 16, ParserImpl.getParseInline(), null), new Dict("dfn", 31, 16, ParserImpl.getParseInline(), null), new Dict("code", 31, 16, ParserImpl.getParseInline(), null), new Dict("samp", 31, 16, ParserImpl.getParseInline(), null), new Dict("kbd", 31, 16, ParserImpl.getParseInline(), null), new Dict("var", 31, 16, ParserImpl.getParseInline(), null), new Dict("cite", 31, 16, ParserImpl.getParseInline(), null), new Dict("abbr", 28, 16, ParserImpl.getParseInline(), null), new Dict("acronym", 28, 16, ParserImpl.getParseInline(), null), new Dict("span", 30, 16, ParserImpl.getParseInline(), null), new Dict("blink", 448, 16, ParserImpl.getParseInline(), null), new Dict("nobr", 448, 16, ParserImpl.getParseInline(), null), new Dict("wbr", 448, 17, null, null), new Dict("marquee", 128, 32784, ParserImpl.getParseInline(), null), new Dict("bgsound", 128, 5, null, null), new Dict("comment", 128, 16, ParserImpl.getParseInline(), null), new Dict("spacer", 64, 17, null, null), new Dict("keygen", 64, 17, null, null), new Dict("nolayer", 64, 131096, ParserImpl.getParseBlock(), null), new Dict("ilayer", 64, 16, ParserImpl.getParseInline(), null), new Dict("map", 30, 16, ParserImpl.getParseBlock(), CheckAttribsImpl.getCheckMap()), new Dict("area", 31, 9, null, CheckAttribsImpl.getCheckAREA()), new Dict("input", 31, 65553, null, null), new Dict("select", 31, 1040, ParserImpl.getParseSelect(), null), new Dict("option", 31, 33792, ParserImpl.getParseText(), null), new Dict("optgroup", 28, 33792, ParserImpl.getParseOptGroup(), null), new Dict("textarea", 31, 1040, ParserImpl.getParseText(), null), new Dict("label", 28, 16, ParserImpl.getParseInline(), null), new Dict("legend", 28, 16, ParserImpl.getParseInline(), null), new Dict("button", 28, 16, ParserImpl.getParseInline(), null), new Dict("basefont", 26, 17, null, null), new Dict("font", 26, 16, ParserImpl.getParseInline(), null), new Dict("bdo", 28, 16, ParserImpl.getParseInline(), null)};
    public static Dict xmlTags = new Dict(null, 31, 8, null, null);
    public static Dict tagHtml = null;
    public static Dict tagHead = null;
    public static Dict tagBody = null;
    public static Dict tagFrameset = null;
    public static Dict tagFrame = null;
    public static Dict tagNoframes = null;
    public static Dict tagMeta = null;
    public static Dict tagTitle = null;
    public static Dict tagBase = null;
    public static Dict tagHr = null;
    public static Dict tagPre = null;
    public static Dict tagListing = null;
    public static Dict tagH1 = null;
    public static Dict tagH2 = null;
    public static Dict tagP = null;
    public static Dict tagUl = null;
    public static Dict tagOl = null;
    public static Dict tagDir = null;
    public static Dict tagLi = null;
    public static Dict tagDt = null;
    public static Dict tagDd = null;
    public static Dict tagDl = null;
    public static Dict tagTd = null;
    public static Dict tagTh = null;
    public static Dict tagTr = null;
    public static Dict tagCol = null;
    public static Dict tagBr = null;
    public static Dict tagA = null;
    public static Dict tagLink = null;
    public static Dict tagB = null;
    public static Dict tagI = null;
    public static Dict tagStrong = null;
    public static Dict tagEm = null;
    public static Dict tagBig = null;
    public static Dict tagSmall = null;
    public static Dict tagParam = null;
    public static Dict tagOption = null;
    public static Dict tagOptgroup = null;
    public static Dict tagImg = null;
    public static Dict tagMap = null;
    public static Dict tagArea = null;
    public static Dict tagNobr = null;
    public static Dict tagWbr = null;
    public static Dict tagFont = null;
    public static Dict tagSpacer = null;
    public static Dict tagLayer = null;
    public static Dict tagCenter = null;
    public static Dict tagStyle = null;
    public static Dict tagScript = null;
    public static Dict tagNoscript = null;
    public static Dict tagTable = null;
    public static Dict tagCaption = null;
    public static Dict tagForm = null;
    public static Dict tagTextarea = null;
    public static Dict tagBlockquote = null;
    public static Dict tagApplet = null;
    public static Dict tagObject = null;
    public static Dict tagDiv = null;
    public static Dict tagSpan = null;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Dict lookup(String name) {
        return (Dict)this.tagHashtable.get(name);
    }

    public Dict install(Dict dict) {
        Dict d = (Dict)this.tagHashtable.get(dict.name);
        if (d != null) {
            d.versions = dict.versions;
            d.model |= dict.model;
            d.parser = dict.parser;
            d.chkattrs = dict.chkattrs;
            return d;
        }
        this.tagHashtable.put(dict.name, dict);
        return dict;
    }

    public boolean findTag(Node node) {
        Dict np;
        if (this.configuration != null && this.configuration.XmlTags) {
            node.tag = xmlTags;
            return true;
        }
        if (node.element != null && (np = this.lookup(node.element)) != null) {
            node.tag = np;
            return true;
        }
        return false;
    }

    public Parser findParser(Node node) {
        Dict np;
        if (node.element != null && (np = this.lookup(node.element)) != null) {
            return np.parser;
        }
        return null;
    }

    public void defineInlineTag(String name) {
        this.install(new Dict(name, 448, 0x140010, ParserImpl.getParseBlock(), null));
    }

    public void defineBlockTag(String name) {
        this.install(new Dict(name, 448, 1310728, ParserImpl.getParseBlock(), null));
    }

    public void defineEmptyTag(String name) {
        this.install(new Dict(name, 448, 0x140001, ParserImpl.getParseBlock(), null));
    }

    public void definePreTag(String name) {
        this.install(new Dict(name, 448, 1310728, ParserImpl.getParsePre(), null));
    }

    public static TagTable getDefaultTagTable() {
        if (defaultTagTable == null) {
            defaultTagTable = new TagTable();
            int i = 0;
            while (i < tags.length) {
                defaultTagTable.install(tags[i]);
                ++i;
            }
            tagHtml = defaultTagTable.lookup("html");
            tagHead = defaultTagTable.lookup("head");
            tagBody = defaultTagTable.lookup("body");
            tagFrameset = defaultTagTable.lookup("frameset");
            tagFrame = defaultTagTable.lookup("frame");
            tagNoframes = defaultTagTable.lookup("noframes");
            tagMeta = defaultTagTable.lookup("meta");
            tagTitle = defaultTagTable.lookup("title");
            tagBase = defaultTagTable.lookup("base");
            tagHr = defaultTagTable.lookup("hr");
            tagPre = defaultTagTable.lookup("pre");
            tagListing = defaultTagTable.lookup("listing");
            tagH1 = defaultTagTable.lookup("h1");
            tagH2 = defaultTagTable.lookup("h2");
            tagP = defaultTagTable.lookup("p");
            tagUl = defaultTagTable.lookup("ul");
            tagOl = defaultTagTable.lookup("ol");
            tagDir = defaultTagTable.lookup("dir");
            tagLi = defaultTagTable.lookup("li");
            tagDt = defaultTagTable.lookup("dt");
            tagDd = defaultTagTable.lookup("dd");
            tagDl = defaultTagTable.lookup("dl");
            tagTd = defaultTagTable.lookup("td");
            tagTh = defaultTagTable.lookup("th");
            tagTr = defaultTagTable.lookup("tr");
            tagCol = defaultTagTable.lookup("col");
            tagBr = defaultTagTable.lookup("br");
            tagA = defaultTagTable.lookup("a");
            tagLink = defaultTagTable.lookup("link");
            tagB = defaultTagTable.lookup("b");
            tagI = defaultTagTable.lookup("i");
            tagStrong = defaultTagTable.lookup("strong");
            tagEm = defaultTagTable.lookup("em");
            tagBig = defaultTagTable.lookup("big");
            tagSmall = defaultTagTable.lookup("small");
            tagParam = defaultTagTable.lookup("param");
            tagOption = defaultTagTable.lookup("option");
            tagOptgroup = defaultTagTable.lookup("optgroup");
            tagImg = defaultTagTable.lookup("img");
            tagMap = defaultTagTable.lookup("map");
            tagArea = defaultTagTable.lookup("area");
            tagNobr = defaultTagTable.lookup("nobr");
            tagWbr = defaultTagTable.lookup("wbr");
            tagFont = defaultTagTable.lookup("font");
            tagSpacer = defaultTagTable.lookup("spacer");
            tagLayer = defaultTagTable.lookup("layer");
            tagCenter = defaultTagTable.lookup("center");
            tagStyle = defaultTagTable.lookup("style");
            tagScript = defaultTagTable.lookup("script");
            tagNoscript = defaultTagTable.lookup("noscript");
            tagTable = defaultTagTable.lookup("table");
            tagCaption = defaultTagTable.lookup("caption");
            tagForm = defaultTagTable.lookup("form");
            tagTextarea = defaultTagTable.lookup("textarea");
            tagBlockquote = defaultTagTable.lookup("blockquote");
            tagApplet = defaultTagTable.lookup("applet");
            tagObject = defaultTagTable.lookup("object");
            tagDiv = defaultTagTable.lookup("div");
            tagSpan = defaultTagTable.lookup("span");
        }
        return defaultTagTable;
    }
}

