/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.Node;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.TagTable;

public class Report {
    public static final String ACCESS_URL = "http://www.w3.org/WAI/GL";
    public static final String RELEASE_DATE = "4th August 2000";
    public static String currentFile;
    public static final short MISSING_SEMICOLON = 1;
    public static final short UNKNOWN_ENTITY = 2;
    public static final short UNESCAPED_AMPERSAND = 3;
    public static final short MISSING_ENDTAG_FOR = 1;
    public static final short MISSING_ENDTAG_BEFORE = 2;
    public static final short DISCARDING_UNEXPECTED = 3;
    public static final short NESTED_EMPHASIS = 4;
    public static final short NON_MATCHING_ENDTAG = 5;
    public static final short TAG_NOT_ALLOWED_IN = 6;
    public static final short MISSING_STARTTAG = 7;
    public static final short UNEXPECTED_ENDTAG = 8;
    public static final short USING_BR_INPLACE_OF = 9;
    public static final short INSERTING_TAG = 10;
    public static final short SUSPECTED_MISSING_QUOTE = 11;
    public static final short MISSING_TITLE_ELEMENT = 12;
    public static final short DUPLICATE_FRAMESET = 13;
    public static final short CANT_BE_NESTED = 14;
    public static final short OBSOLETE_ELEMENT = 15;
    public static final short PROPRIETARY_ELEMENT = 16;
    public static final short UNKNOWN_ELEMENT = 17;
    public static final short TRIM_EMPTY_ELEMENT = 18;
    public static final short COERCE_TO_ENDTAG = 19;
    public static final short ILLEGAL_NESTING = 20;
    public static final short NOFRAMES_CONTENT = 21;
    public static final short CONTENT_AFTER_BODY = 22;
    public static final short INCONSISTENT_VERSION = 23;
    public static final short MALFORMED_COMMENT = 24;
    public static final short BAD_COMMENT_CHARS = 25;
    public static final short BAD_XML_COMMENT = 26;
    public static final short BAD_CDATA_CONTENT = 27;
    public static final short INCONSISTENT_NAMESPACE = 28;
    public static final short DOCTYPE_AFTER_TAGS = 29;
    public static final short MALFORMED_DOCTYPE = 30;
    public static final short UNEXPECTED_END_OF_FILE = 31;
    public static final short DTYPE_NOT_UPPER_CASE = 32;
    public static final short TOO_MANY_ELEMENTS = 33;
    public static final short UNKNOWN_ATTRIBUTE = 1;
    public static final short MISSING_ATTRIBUTE = 2;
    public static final short MISSING_ATTR_VALUE = 3;
    public static final short BAD_ATTRIBUTE_VALUE = 4;
    public static final short UNEXPECTED_GT = 5;
    public static final short PROPRIETARY_ATTR_VALUE = 6;
    public static final short REPEATED_ATTRIBUTE = 7;
    public static final short MISSING_IMAGEMAP = 8;
    public static final short XML_ATTRIBUTE_VALUE = 9;
    public static final short UNEXPECTED_QUOTEMARK = 10;
    public static final short ID_NAME_MISMATCH = 11;
    public static final short MISSING_IMAGE_ALT = 1;
    public static final short MISSING_LINK_ALT = 2;
    public static final short MISSING_SUMMARY = 4;
    public static final short MISSING_IMAGE_MAP = 8;
    public static final short USING_FRAMES = 16;
    public static final short USING_NOFRAMES = 32;
    public static final short USING_SPACER = 1;
    public static final short USING_LAYER = 2;
    public static final short USING_NOBR = 4;
    public static final short USING_FONT = 8;
    public static final short USING_BODY = 16;
    public static final short WINDOWS_CHARS = 1;
    public static final short NON_ASCII = 2;
    public static final short FOUND_UTF16 = 4;
    private static short optionerrors;
    private static ResourceBundle res;

    public static void tidyPrint(PrintWriter p, String msg) {
        p.print(msg);
    }

    public static void tidyPrintln(PrintWriter p, String msg) {
        p.println(msg);
    }

    public static void tidyPrintln(PrintWriter p) {
        p.println();
    }

    public static void showVersion(PrintWriter p) {
        Report.tidyPrintln(p, "Java HTML Tidy release date: 4th August 2000");
        Report.tidyPrintln(p, "See http://www.w3.org/People/Raggett for details");
    }

    public static void tag(Lexer lexer, Node tag) {
        if (tag != null) {
            if (tag.type == 5) {
                Report.tidyPrint(lexer.errout, "<" + tag.element + ">");
            } else if (tag.type == 6) {
                Report.tidyPrint(lexer.errout, "</" + tag.element + ">");
            } else if (tag.type == 1) {
                Report.tidyPrint(lexer.errout, "<!DOCTYPE>");
            } else if (tag.type == 4) {
                Report.tidyPrint(lexer.errout, "plain text");
            } else {
                Report.tidyPrint(lexer.errout, tag.element);
            }
        }
    }

    public static void unknownOption(String option) {
        optionerrors = (short)(optionerrors + 1);
        try {
            System.err.println(MessageFormat.format(res.getString("unknown_option"), option));
        }
        catch (MissingResourceException e) {
            System.err.println(e.toString());
        }
    }

    public static void badArgument(String option) {
        optionerrors = (short)(optionerrors + 1);
        try {
            System.err.println(MessageFormat.format(res.getString("bad_argument"), option));
        }
        catch (MissingResourceException e) {
            System.err.println(e.toString());
        }
    }

    public static void position(Lexer lexer) {
        try {
            if (lexer.configuration.Emacs) {
                Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("emacs_format"), currentFile, new Integer(lexer.lines), new Integer(lexer.columns)));
                Report.tidyPrint(lexer.errout, " ");
            } else {
                Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("line_column"), new Integer(lexer.lines), new Integer(lexer.columns)));
            }
        }
        catch (MissingResourceException e) {
            lexer.errout.println(e.toString());
        }
    }

    public static void encodingError(Lexer lexer, short code, int c) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.configuration.ShowWarnings) {
            Report.position(lexer);
            if (code == 1) {
                lexer.badChars = (short)(lexer.badChars | 1);
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("illegal_char"), new Integer(c)));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            Report.tidyPrintln(lexer.errout);
        }
    }

    public static void entityError(Lexer lexer, short code, String entity, int c) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.configuration.ShowWarnings) {
            Report.position(lexer);
            if (code == 1) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_semicolon"), entity));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 2) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unknown_entity"), entity));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 3) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("unescaped_ampersand"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            Report.tidyPrintln(lexer.errout);
        }
    }

    public static void attrError(Lexer lexer, Node node, String attr, short code) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.errors > 6) {
            return;
        }
        if (lexer.configuration.ShowWarnings) {
            if (code == 31) {
                lexer.lines = lexer.in.curline;
                lexer.columns = lexer.in.curcol;
            }
            Report.position(lexer);
            if (code == 1) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unknown_attribute"), attr));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 2) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_attribute"), attr));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 3) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_attr_value"), attr));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 8) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("missing_imagemap"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                lexer.badAccess = (short)(lexer.badAccess | 8);
            } else if (code == 4) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("bad_attribute_value"), attr));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 9) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("xml_attribute_value"), attr));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 5) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("error"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("unexpected_gt"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                lexer.errors = (short)(lexer.errors + 1);
            } else if (code == 10) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("unexpected_quotemark"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 7) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("repeated_attribute"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 6) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("proprietary_attr_value"), attr));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 31) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("unexpected_end_of_file"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 11) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                    Report.tag(lexer, node);
                    Report.tidyPrint(lexer.errout, res.getString("id_name_mismatch"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            Report.tidyPrintln(lexer.errout);
        } else if (code == 5) {
            Report.position(lexer);
            try {
                Report.tidyPrint(lexer.errout, res.getString("error"));
                Report.tag(lexer, node);
                Report.tidyPrint(lexer.errout, res.getString("unexpected_gt"));
            }
            catch (MissingResourceException e) {
                lexer.errout.println(e.toString());
            }
            Report.tidyPrintln(lexer.errout);
            lexer.errors = (short)(lexer.errors + 1);
        }
    }

    public static void warning(Lexer lexer, Node element, Node node, short code) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.errors > 6) {
            return;
        }
        if (lexer.configuration.ShowWarnings) {
            if (code == 31) {
                lexer.lines = lexer.in.curline;
                lexer.columns = lexer.in.curcol;
            }
            Report.position(lexer);
            if (code == 1) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_endtag_for"), element.element));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 2) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_endtag_before"), element.element));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
            } else if (code == 3) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("discarding_unexpected"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
            } else if (code == 4) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("nested_emphasis"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
            } else if (code == 19) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("coerce_to_endtag"), element.element));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 5) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("non_matching_endtag_1"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("non_matching_endtag_2"), element.element));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 6) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("tag_not_allowed_in"), element.element));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 29) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("doctype_after_tags"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 7) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("missing_starttag"), node.element));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 8) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unexpected_endtag"), node.element));
                    if (element != null) {
                        Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unexpected_endtag_suffix"), element.element));
                    }
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 33) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("too_many_elements"), node.element));
                    if (element != null) {
                        Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("too_many_elements_suffix"), element.element));
                    }
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 9) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("using_br_inplace_of"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
            } else if (code == 10) {
                try {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("inserting_tag"), node.element));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 14) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("cant_be_nested"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 16) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("proprietary_element"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                if (node.tag == TagTable.tagLayer) {
                    lexer.badLayout = (short)(lexer.badLayout | 2);
                } else if (node.tag == TagTable.tagSpacer) {
                    lexer.badLayout = (short)(lexer.badLayout | 1);
                } else if (node.tag == TagTable.tagNobr) {
                    lexer.badLayout = (short)(lexer.badLayout | 4);
                }
            } else if (code == 15) {
                try {
                    if (element.tag != null && (element.tag.model & 0x80000) != 0) {
                        Report.tidyPrint(lexer.errout, res.getString("obsolete_element"));
                    } else {
                        Report.tidyPrint(lexer.errout, res.getString("replacing_element"));
                    }
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, element);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("by"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
            } else if (code == 18) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("trim_empty_element"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, element);
            } else if (code == 12) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("missing_title_element"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 20) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, element);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("illegal_nesting"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 21) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("warning"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, node);
                try {
                    Report.tidyPrint(lexer.errout, res.getString("noframes_content"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 23) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("inconsistent_version"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 30) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("malformed_doctype"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 22) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("content_after_body"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 24) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("malformed_comment"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 25) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("bad_comment_chars"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 26) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("bad_xml_comment"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 27) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("bad_cdata_content"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 28) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("inconsistent_namespace"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 32) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("dtype_not_upper_case"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            } else if (code == 31) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("unexpected_end_of_file"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
                Report.tag(lexer, element);
            }
            Report.tidyPrintln(lexer.errout);
        }
    }

    public static void error(Lexer lexer, Node element, Node node, short code) {
        lexer.warnings = (short)(lexer.warnings + 1);
        if (lexer.errors > 6) {
            return;
        }
        lexer.errors = (short)(lexer.errors + 1);
        Report.position(lexer);
        if (code == 11) {
            try {
                Report.tidyPrint(lexer.errout, res.getString("suspected_missing_quote"));
            }
            catch (MissingResourceException e) {
                lexer.errout.println(e.toString());
            }
        } else if (code == 13) {
            try {
                Report.tidyPrint(lexer.errout, res.getString("duplicate_frameset"));
            }
            catch (MissingResourceException e) {
                lexer.errout.println(e.toString());
            }
        } else if (code == 17) {
            try {
                Report.tidyPrint(lexer.errout, res.getString("error"));
            }
            catch (MissingResourceException e) {
                lexer.errout.println(e.toString());
            }
            Report.tag(lexer, node);
            try {
                Report.tidyPrint(lexer.errout, res.getString("unknown_element"));
            }
            catch (MissingResourceException e) {
                lexer.errout.println(e.toString());
            }
        } else if (code == 8) {
            try {
                Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unexpected_endtag"), node.element));
                if (element != null) {
                    Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("unexpected_endtag_suffix"), element.element));
                }
            }
            catch (MissingResourceException e) {
                lexer.errout.println(e.toString());
            }
        }
        Report.tidyPrintln(lexer.errout);
    }

    public static void errorSummary(Lexer lexer) {
        if ((lexer.badAccess & 0x30) != 0 && ((lexer.badAccess & 0x10) == 0 || (lexer.badAccess & 0x20) != 0)) {
            lexer.badAccess = (short)(lexer.badAccess & 0xFFFFFFCF);
        }
        if (lexer.badChars != 0 && (lexer.badChars & 1) != 0) {
            try {
                Report.tidyPrint(lexer.errout, res.getString("badchars_summary"));
            }
            catch (MissingResourceException e) {
                lexer.errout.println(e.toString());
            }
        }
        if (lexer.badForm != 0) {
            try {
                Report.tidyPrint(lexer.errout, res.getString("badform_summary"));
            }
            catch (MissingResourceException e) {
                lexer.errout.println(e.toString());
            }
        }
        if (lexer.badAccess != 0) {
            if ((lexer.badAccess & 4) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badaccess_missing_summary"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            if ((lexer.badAccess & 1) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badaccess_missing_image_alt"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            if ((lexer.badAccess & 8) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badaccess_missing_image_map"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            if ((lexer.badAccess & 2) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badaccess_missing_link_alt"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            if ((lexer.badAccess & 0x10) != 0 && (lexer.badAccess & 0x20) == 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badaccess_frames"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            try {
                Report.tidyPrint(lexer.errout, MessageFormat.format(res.getString("badaccess_summary"), ACCESS_URL));
            }
            catch (MissingResourceException e) {
                lexer.errout.println(e.toString());
            }
        }
        if (lexer.badLayout != 0) {
            if ((lexer.badLayout & 2) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_layer"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            if ((lexer.badLayout & 1) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_spacer"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            if ((lexer.badLayout & 8) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_font"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            if ((lexer.badLayout & 4) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_nobr"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
            if ((lexer.badLayout & 0x10) != 0) {
                try {
                    Report.tidyPrint(lexer.errout, res.getString("badlayout_using_body"));
                }
                catch (MissingResourceException e) {
                    lexer.errout.println(e.toString());
                }
            }
        }
    }

    public static void unknownOption(PrintWriter errout, char c) {
        try {
            Report.tidyPrintln(errout, MessageFormat.format(res.getString("unrecognized_option"), new String(new char[]{c})));
        }
        catch (MissingResourceException e) {
            errout.println(e.toString());
        }
    }

    public static void unknownFile(PrintWriter errout, String program, String file) {
        try {
            Report.tidyPrintln(errout, MessageFormat.format(res.getString("unknown_file"), program, file));
        }
        catch (MissingResourceException e) {
            errout.println(e.toString());
        }
    }

    public static void needsAuthorIntervention(PrintWriter errout) {
        try {
            Report.tidyPrintln(errout, res.getString("needs_author_intervention"));
        }
        catch (MissingResourceException e) {
            errout.println(e.toString());
        }
    }

    public static void missingBody(PrintWriter errout) {
        try {
            Report.tidyPrintln(errout, res.getString("missing_body"));
        }
        catch (MissingResourceException e) {
            errout.println(e.toString());
        }
    }

    public static void reportNumberOfSlides(PrintWriter errout, int count) {
        try {
            Report.tidyPrintln(errout, MessageFormat.format(res.getString("slides_found"), new Integer(count)));
        }
        catch (MissingResourceException e) {
            errout.println(e.toString());
        }
    }

    public static void generalInfo(PrintWriter errout) {
        try {
            Report.tidyPrintln(errout, res.getString("general_info"));
        }
        catch (MissingResourceException e) {
            errout.println(e.toString());
        }
    }

    public static void helloMessage(PrintWriter errout, String date, String filename) {
        currentFile = filename;
        try {
            Report.tidyPrintln(errout, MessageFormat.format(res.getString("hello_message"), date, filename));
        }
        catch (MissingResourceException e) {
            errout.println(e.toString());
        }
    }

    public static void reportVersion(PrintWriter errout, Lexer lexer, String filename, Node doctype) {
        int state = 0;
        String vers = lexer.HTMLVersionName();
        MutableInteger cc = new MutableInteger();
        try {
            if (doctype != null) {
                Report.tidyPrint(errout, MessageFormat.format(res.getString("doctype_given"), filename));
                int i = doctype.start;
                while (i < doctype.end) {
                    int c = doctype.textarray[i];
                    if (c < 0) {
                        i += PPrint.getUTF8(doctype.textarray, i, cc);
                        c = cc.value;
                    }
                    if (c == 34) {
                        ++state;
                    } else if (state == 1) {
                        errout.print((char)c);
                    }
                    ++i;
                }
                errout.print('\"');
            }
            Report.tidyPrintln(errout, MessageFormat.format(res.getString("report_version"), filename, vers != null ? vers : "HTML proprietary"));
        }
        catch (MissingResourceException e) {
            errout.println(e.toString());
        }
    }

    public static void reportNumWarnings(PrintWriter errout, Lexer lexer) {
        if (lexer.warnings > 0) {
            try {
                Report.tidyPrintln(errout, MessageFormat.format(res.getString("num_warnings"), new Integer(lexer.warnings)));
            }
            catch (MissingResourceException e) {
                errout.println(e.toString());
            }
        } else {
            try {
                Report.tidyPrintln(errout, res.getString("no_warnings"));
            }
            catch (MissingResourceException e) {
                errout.println(e.toString());
            }
        }
    }

    public static void helpText(PrintWriter out, String prog) {
        try {
            Report.tidyPrintln(out, MessageFormat.format(res.getString("help_text"), prog, RELEASE_DATE));
        }
        catch (MissingResourceException e) {
            out.println(e.toString());
        }
    }

    public static void badTree(PrintWriter errout) {
        try {
            Report.tidyPrintln(errout, res.getString("bad_tree"));
        }
        catch (MissingResourceException e) {
            errout.println(e.toString());
        }
    }

    static {
        res = null;
        try {
            res = ResourceBundle.getBundle("org/w3c/tidy/TidyMessages");
        }
        catch (MissingResourceException e) {
            throw new Error(e.toString());
        }
    }
}

