/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Parser;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class ParserImpl {
    private static Parser _parseHTML = new ParseHTML();
    private static Parser _parseHead = new ParseHead();
    private static Parser _parseTitle = new ParseTitle();
    private static Parser _parseScript = new ParseScript();
    private static Parser _parseBody = new ParseBody();
    private static Parser _parseFrameSet = new ParseFrameSet();
    private static Parser _parseInline = new ParseInline();
    private static Parser _parseList = new ParseList();
    private static Parser _parseDefList = new ParseDefList();
    private static Parser _parsePre = new ParsePre();
    private static Parser _parseBlock = new ParseBlock();
    private static Parser _parseTableTag = new ParseTableTag();
    private static Parser _parseColGroup = new ParseColGroup();
    private static Parser _parseRowGroup = new ParseRowGroup();
    private static Parser _parseRow = new ParseRow();
    private static Parser _parseNoFrames = new ParseNoFrames();
    private static Parser _parseSelect = new ParseSelect();
    private static Parser _parseText = new ParseText();
    private static Parser _parseOptGroup = new ParseOptGroup();

    private static void parseTag(Lexer lexer, Node node, short mode) {
        if ((node.tag.model & 1) != 0) {
            lexer.waswhite = false;
            return;
        }
        if ((node.tag.model & 0x10) == 0) {
            lexer.insertspace = false;
        }
        if (node.tag.parser == null || node.type == 7) {
            return;
        }
        node.tag.parser.parse(lexer, node, mode);
    }

    private static void moveToHead(Lexer lexer, Node element, Node node) {
        if (node.type == 5 || node.type == 7) {
            Report.warning(lexer, element, node, (short)6);
            while (element.tag != TagTable.tagHtml) {
                element = element.parent;
            }
            Node head = element.content;
            while (head != null) {
                if (head.tag == TagTable.tagHead) {
                    Node.insertNodeAtEnd(head, node);
                    break;
                }
                head = head.next;
            }
            if (node.tag.parser != null) {
                ParserImpl.parseTag(lexer, node, (short)0);
            }
        } else {
            Report.warning(lexer, element, node, (short)3);
        }
    }

    public static Parser getParseHTML() {
        return _parseHTML;
    }

    public static Parser getParseHead() {
        return _parseHead;
    }

    public static Parser getParseTitle() {
        return _parseTitle;
    }

    public static Parser getParseScript() {
        return _parseScript;
    }

    public static Parser getParseBody() {
        return _parseBody;
    }

    public static Parser getParseFrameSet() {
        return _parseFrameSet;
    }

    public static Parser getParseInline() {
        return _parseInline;
    }

    public static Parser getParseList() {
        return _parseList;
    }

    public static Parser getParseDefList() {
        return _parseDefList;
    }

    public static Parser getParsePre() {
        return _parsePre;
    }

    public static Parser getParseBlock() {
        return _parseBlock;
    }

    public static Parser getParseTableTag() {
        return _parseTableTag;
    }

    public static Parser getParseColGroup() {
        return _parseColGroup;
    }

    public static Parser getParseRowGroup() {
        return _parseRowGroup;
    }

    public static Parser getParseRow() {
        return _parseRow;
    }

    public static Parser getParseNoFrames() {
        return _parseNoFrames;
    }

    public static Parser getParseSelect() {
        return _parseSelect;
    }

    public static Parser getParseText() {
        return _parseText;
    }

    public static Parser getParseOptGroup() {
        return _parseOptGroup;
    }

    public static Node parseDocument(Lexer lexer) {
        Node node;
        Node doctype = null;
        Node document = lexer.newNode();
        document.type = 0;
        while ((node = lexer.getToken((short)0)) != null) {
            Node html;
            if (Node.insertMisc(document, node)) continue;
            if (node.type == 1) {
                if (doctype == null) {
                    Node.insertNodeAtEnd(document, node);
                    doctype = node;
                    continue;
                }
                Report.warning(lexer, document, node, (short)3);
                continue;
            }
            if (node.type == 6) {
                Report.warning(lexer, document, node, (short)3);
                continue;
            }
            if (node.type != 5 || node.tag != TagTable.tagHtml) {
                lexer.ungetToken();
                html = lexer.inferredTag("html");
            } else {
                html = node;
            }
            Node.insertNodeAtEnd(document, html);
            ParserImpl.getParseHTML().parse(lexer, html, (short)0);
            break;
        }
        return document;
    }

    public static boolean XMLPreserveWhiteSpace(Node element) {
        AttVal attribute = element.attributes;
        while (attribute != null) {
            if (attribute.attribute.equals("xml:space")) {
                return attribute.value.equals("preserve");
            }
            attribute = attribute.next;
        }
        if (Lexer.wstrcasecmp(element.element, "pre") == 0 || Lexer.wstrcasecmp(element.element, "script") == 0 || Lexer.wstrcasecmp(element.element, "style") == 0 || TagTable.getDefaultTagTable().findParser(element) == ParserImpl.getParsePre()) {
            return true;
        }
        return Lexer.wstrcasecmp(element.element, "xsl:text") == 0;
    }

    public static void parseXMLElement(Lexer lexer, Node element, short mode) {
        Node node;
        if (Lexer.wstrcasecmp(element.element, "xsl:text") == 0) {
            return;
        }
        if (ParserImpl.XMLPreserveWhiteSpace(element)) {
            mode = (short)2;
        }
        while ((node = lexer.getToken(mode)) != null) {
            if (node.type == 6 && node.element.equals(element.element)) {
                element.closed = true;
                break;
            }
            if (node.type == 6) {
                Report.error(lexer, element, node, (short)8);
                continue;
            }
            if (node.type == 5) {
                ParserImpl.parseXMLElement(lexer, node, mode);
            }
            Node.insertNodeAtEnd(element, node);
        }
        if ((node = element.content) != null && node.type == 4 && mode != 2 && node.textarray[node.start] == 32) {
            ++node.start;
            if (node.start >= node.end) {
                Node.discardElement(node);
            }
        }
        if ((node = element.last) != null && node.type == 4 && mode != 2 && node.textarray[node.end - 1] == 32) {
            --node.end;
            if (node.start >= node.end) {
                Node.discardElement(node);
            }
        }
    }

    public static Node parseXMLDocument(Lexer lexer) {
        Node node;
        Node document = lexer.newNode();
        document.type = 0;
        Node doctype = null;
        lexer.configuration.XmlTags = true;
        while ((node = lexer.getToken((short)0)) != null) {
            if (node.type == 6) {
                Report.warning(lexer, null, node, (short)8);
                continue;
            }
            if (Node.insertMisc(document, node)) continue;
            if (node.type == 1) {
                if (doctype == null) {
                    Node.insertNodeAtEnd(document, node);
                    doctype = node;
                    continue;
                }
                Report.warning(lexer, document, node, (short)3);
                continue;
            }
            if (node.type != 5) continue;
            Node.insertNodeAtEnd(document, node);
            ParserImpl.parseXMLElement(lexer, node, (short)0);
        }
        if (doctype != null && !lexer.checkDocTypeKeyWords(doctype)) {
            Report.warning(lexer, doctype, null, (short)32);
        }
        if (lexer.configuration.XmlPi) {
            lexer.fixXMLPI(document);
        }
        return document;
    }

    public static boolean isJavaScript(Node node) {
        boolean result = false;
        if (node.attributes == null) {
            return true;
        }
        AttVal attr = node.attributes;
        while (attr != null) {
            if ((Lexer.wstrcasecmp(attr.attribute, "language") == 0 || Lexer.wstrcasecmp(attr.attribute, "type") == 0) && Lexer.wsubstr(attr.value, "javascript")) {
                result = true;
            }
            attr = attr.next;
        }
        return result;
    }

    public static class ParseOptGroup
    implements Parser {
        public void parse(Lexer lexer, Node field, short mode) {
            Node node;
            lexer.insert = -1;
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == field.tag && node.type == 6) {
                    field.closed = true;
                    Node.trimSpaces(lexer, field);
                    return;
                }
                if (Node.insertMisc(field, node)) continue;
                if (node.type == 5 && (node.tag == TagTable.tagOption || node.tag == TagTable.tagOptgroup)) {
                    if (node.tag == TagTable.tagOptgroup) {
                        Report.warning(lexer, field, node, (short)14);
                    }
                    Node.insertNodeAtEnd(field, node);
                    ParserImpl.parseTag(lexer, node, (short)1);
                    continue;
                }
                Report.warning(lexer, field, node, (short)3);
            }
        }
    }

    public static class ParseText
    implements Parser {
        public void parse(Lexer lexer, Node field, short mode) {
            Node node;
            lexer.insert = -1;
            if (field.tag == TagTable.tagTextarea) {
                mode = (short)2;
            }
            while ((node = lexer.getToken(mode)) != null) {
                if (node.tag == field.tag && node.type == 6) {
                    field.closed = true;
                    Node.trimSpaces(lexer, field);
                    return;
                }
                if (Node.insertMisc(field, node)) continue;
                if (node.type == 4) {
                    if (field.content == null && (mode & 2) == 0) {
                        Node.trimSpaces(lexer, field);
                    }
                    if (node.start >= node.end) continue;
                    Node.insertNodeAtEnd(field, node);
                    continue;
                }
                if (node.tag == TagTable.tagFont) {
                    Report.warning(lexer, field, node, (short)3);
                    continue;
                }
                if ((field.tag.model & 0x8000) == 0) {
                    Report.warning(lexer, field, node, (short)2);
                }
                lexer.ungetToken();
                Node.trimSpaces(lexer, field);
                return;
            }
            if ((field.tag.model & 0x8000) == 0) {
                Report.warning(lexer, field, node, (short)1);
            }
        }
    }

    public static class ParseSelect
    implements Parser {
        public void parse(Lexer lexer, Node field, short mode) {
            Node node;
            lexer.insert = -1;
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == field.tag && node.type == 6) {
                    field.closed = true;
                    Node.trimSpaces(lexer, field);
                    return;
                }
                if (Node.insertMisc(field, node)) continue;
                if (node.type == 5 && (node.tag == TagTable.tagOption || node.tag == TagTable.tagOptgroup || node.tag == TagTable.tagScript)) {
                    Node.insertNodeAtEnd(field, node);
                    ParserImpl.parseTag(lexer, node, (short)0);
                    continue;
                }
                Report.warning(lexer, field, node, (short)3);
            }
            Report.warning(lexer, field, node, (short)1);
        }
    }

    public static class ParseNoFrames
    implements Parser {
        public void parse(Lexer lexer, Node noframes, short mode) {
            Node node;
            lexer.badAccess = (short)(lexer.badAccess | 0x20);
            mode = 0;
            boolean checkstack = true;
            while ((node = lexer.getToken(mode)) != null) {
                if (node.tag == noframes.tag && node.type == 6) {
                    noframes.closed = true;
                    Node.trimSpaces(lexer, noframes);
                    return;
                }
                if (node.tag == TagTable.tagFrame || node.tag == TagTable.tagFrameset) {
                    Report.warning(lexer, noframes, node, (short)2);
                    Node.trimSpaces(lexer, noframes);
                    lexer.ungetToken();
                    return;
                }
                if (node.tag == TagTable.tagHtml) {
                    if (node.type != 5 && node.type != 7) continue;
                    Report.warning(lexer, noframes, node, (short)3);
                    continue;
                }
                if (Node.insertMisc(noframes, node)) continue;
                if (node.tag == TagTable.tagBody && node.type == 5) {
                    Node.insertNodeAtEnd(noframes, node);
                    ParserImpl.parseTag(lexer, node, (short)0);
                    continue;
                }
                if (node.type == 4 || node.tag != null) {
                    lexer.ungetToken();
                    node = lexer.inferredTag("body");
                    if (lexer.configuration.XmlOut) {
                        Report.warning(lexer, noframes, node, (short)10);
                    }
                    Node.insertNodeAtEnd(noframes, node);
                    ParserImpl.parseTag(lexer, node, (short)0);
                    continue;
                }
                Report.warning(lexer, noframes, node, (short)3);
            }
            Report.warning(lexer, noframes, node, (short)1);
        }
    }

    public static class ParseRow
    implements Parser {
        public void parse(Lexer lexer, Node row, short mode) {
            Node node;
            if ((row.tag.model & 1) != 0) {
                return;
            }
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == row.tag) {
                    if (node.type == 6) {
                        row.closed = true;
                        Node.fixEmptyRow(lexer, row);
                        return;
                    }
                    lexer.ungetToken();
                    Node.fixEmptyRow(lexer, row);
                    return;
                }
                if (node.type == 6) {
                    if (node.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, row, node, (short)3);
                        continue;
                    }
                    if (node.tag == TagTable.tagTd || node.tag == TagTable.tagTh) {
                        Report.warning(lexer, row, node, (short)3);
                        continue;
                    }
                    Node parent = row.parent;
                    while (parent != null) {
                        if (node.tag == parent.tag) {
                            lexer.ungetToken();
                            Node.trimEmptyElement(lexer, row);
                            return;
                        }
                        parent = parent.parent;
                    }
                }
                if (Node.insertMisc(row, node)) continue;
                if (node.tag == null && node.type != 4) {
                    Report.warning(lexer, row, node, (short)3);
                    continue;
                }
                if (node.tag == TagTable.tagTable) {
                    Report.warning(lexer, row, node, (short)3);
                    continue;
                }
                if (node.tag != null && (node.tag.model & 0x100) != 0) {
                    lexer.ungetToken();
                    Node.trimEmptyElement(lexer, row);
                    return;
                }
                if (node.type == 6) {
                    Report.warning(lexer, row, node, (short)3);
                    continue;
                }
                if (node.type != 6) {
                    if (node.tag == TagTable.tagForm) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("td");
                        Report.warning(lexer, row, node, (short)7);
                    } else {
                        if (node.type == 4 || (node.tag.model & 0x18) != 0) {
                            Node.moveBeforeTable(row, node);
                            Report.warning(lexer, row, node, (short)6);
                            lexer.exiled = true;
                            if (node.type != 4) {
                                ParserImpl.parseTag(lexer, node, (short)0);
                            }
                            lexer.exiled = false;
                            continue;
                        }
                        if ((node.tag.model & 4) != 0) {
                            Report.warning(lexer, row, node, (short)6);
                            ParserImpl.moveToHead(lexer, row, node);
                            continue;
                        }
                    }
                }
                if (node.tag != TagTable.tagTd && node.tag != TagTable.tagTh) {
                    Report.warning(lexer, row, node, (short)6);
                    continue;
                }
                Node.insertNodeAtEnd(row, node);
                boolean exclude_state = lexer.excludeBlocks;
                lexer.excludeBlocks = false;
                ParserImpl.parseTag(lexer, node, (short)0);
                lexer.excludeBlocks = exclude_state;
                while (lexer.istack.size() > lexer.istackbase) {
                    lexer.popInline(null);
                }
            }
            Node.trimEmptyElement(lexer, row);
        }
    }

    public static class ParseRowGroup
    implements Parser {
        public void parse(Lexer lexer, Node rowgroup, short mode) {
            Node node;
            if ((rowgroup.tag.model & 1) != 0) {
                return;
            }
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == rowgroup.tag) {
                    if (node.type == 6) {
                        rowgroup.closed = true;
                        Node.trimEmptyElement(lexer, rowgroup);
                        return;
                    }
                    lexer.ungetToken();
                    return;
                }
                if (node.tag == TagTable.tagTable && node.type == 6) {
                    lexer.ungetToken();
                    Node.trimEmptyElement(lexer, rowgroup);
                    return;
                }
                if (Node.insertMisc(rowgroup, node)) continue;
                if (node.tag == null && node.type != 4) {
                    Report.warning(lexer, rowgroup, node, (short)3);
                    continue;
                }
                if (node.type != 6) {
                    if (node.tag == TagTable.tagTd || node.tag == TagTable.tagTh) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("tr");
                        Report.warning(lexer, rowgroup, node, (short)7);
                    } else {
                        if (node.type == 4 || (node.tag.model & 0x18) != 0) {
                            Node.moveBeforeTable(rowgroup, node);
                            Report.warning(lexer, rowgroup, node, (short)6);
                            lexer.exiled = true;
                            if (node.type != 4) {
                                ParserImpl.parseTag(lexer, node, (short)0);
                            }
                            lexer.exiled = false;
                            continue;
                        }
                        if ((node.tag.model & 4) != 0) {
                            Report.warning(lexer, rowgroup, node, (short)6);
                            ParserImpl.moveToHead(lexer, rowgroup, node);
                            continue;
                        }
                    }
                }
                if (node.type == 6) {
                    if (node.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, rowgroup, node, (short)3);
                        continue;
                    }
                    if (node.tag == TagTable.tagTr || node.tag == TagTable.tagTd || node.tag == TagTable.tagTh) {
                        Report.warning(lexer, rowgroup, node, (short)3);
                        continue;
                    }
                    Node parent = rowgroup.parent;
                    while (parent != null) {
                        if (node.tag == parent.tag) {
                            lexer.ungetToken();
                            Node.trimEmptyElement(lexer, rowgroup);
                            return;
                        }
                        parent = parent.parent;
                    }
                }
                if ((node.tag.model & 0x100) != 0) {
                    if (node.type != 6) {
                        lexer.ungetToken();
                    }
                    Node.trimEmptyElement(lexer, rowgroup);
                    return;
                }
                if (node.type == 6) {
                    Report.warning(lexer, rowgroup, node, (short)3);
                    continue;
                }
                if (node.tag != TagTable.tagTr) {
                    node = lexer.inferredTag("tr");
                    Report.warning(lexer, rowgroup, node, (short)7);
                    lexer.ungetToken();
                }
                Node.insertNodeAtEnd(rowgroup, node);
                ParserImpl.parseTag(lexer, node, (short)0);
            }
            Node.trimEmptyElement(lexer, rowgroup);
        }
    }

    public static class ParseColGroup
    implements Parser {
        public void parse(Lexer lexer, Node colgroup, short mode) {
            Node node;
            if ((colgroup.tag.model & 1) != 0) {
                return;
            }
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == colgroup.tag && node.type == 6) {
                    colgroup.closed = true;
                    return;
                }
                if (node.type == 6) {
                    if (node.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, colgroup, node, (short)3);
                        continue;
                    }
                    Node parent = colgroup.parent;
                    while (parent != null) {
                        if (node.tag == parent.tag) {
                            lexer.ungetToken();
                            return;
                        }
                        parent = parent.parent;
                    }
                }
                if (node.type == 4) {
                    lexer.ungetToken();
                    return;
                }
                if (Node.insertMisc(colgroup, node)) continue;
                if (node.tag == null) {
                    Report.warning(lexer, colgroup, node, (short)3);
                    continue;
                }
                if (node.tag != TagTable.tagCol) {
                    lexer.ungetToken();
                    return;
                }
                if (node.type == 6) {
                    Report.warning(lexer, colgroup, node, (short)3);
                    continue;
                }
                Node.insertNodeAtEnd(colgroup, node);
                ParserImpl.parseTag(lexer, node, (short)0);
            }
        }
    }

    public static class ParseTableTag
    implements Parser {
        public void parse(Lexer lexer, Node table, short mode) {
            Node node;
            lexer.deferDup();
            int istackbase = lexer.istackbase;
            lexer.istackbase = lexer.istack.size();
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == table.tag && node.type == 6) {
                    lexer.istackbase = istackbase;
                    table.closed = true;
                    Node.trimEmptyElement(lexer, table);
                    return;
                }
                if (Node.insertMisc(table, node)) continue;
                if (node.tag == null && node.type != 4) {
                    Report.warning(lexer, table, node, (short)3);
                    continue;
                }
                if (node.type != 6) {
                    if (node.tag == TagTable.tagTd || node.tag == TagTable.tagTh || node.tag == TagTable.tagTable) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("tr");
                        Report.warning(lexer, table, node, (short)7);
                    } else {
                        if (node.type == 4 || (node.tag.model & 0x18) != 0) {
                            Node.insertNodeBeforeElement(table, node);
                            Report.warning(lexer, table, node, (short)6);
                            lexer.exiled = true;
                            lexer.exiled = false;
                            continue;
                        }
                        if ((node.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, table, node);
                            continue;
                        }
                    }
                }
                if (node.type == 6) {
                    if (node.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, table, node, (short)3);
                        continue;
                    }
                    if (node.tag != null && (node.tag.model & 0x280) != 0) {
                        Report.warning(lexer, table, node, (short)3);
                        continue;
                    }
                    Node parent = table.parent;
                    while (parent != null) {
                        if (node.tag == parent.tag) {
                            Report.warning(lexer, table, node, (short)2);
                            lexer.ungetToken();
                            lexer.istackbase = istackbase;
                            Node.trimEmptyElement(lexer, table);
                            return;
                        }
                        parent = parent.parent;
                    }
                }
                if ((node.tag.model & 0x80) == 0) {
                    lexer.ungetToken();
                    Report.warning(lexer, table, node, (short)6);
                    lexer.istackbase = istackbase;
                    Node.trimEmptyElement(lexer, table);
                    return;
                }
                if (node.type == 5 || node.type == 7) {
                    Node.insertNodeAtEnd(table, node);
                    ParserImpl.parseTag(lexer, node, (short)0);
                    continue;
                }
                Report.warning(lexer, table, node, (short)3);
            }
            Report.warning(lexer, table, node, (short)1);
            Node.trimEmptyElement(lexer, table);
            lexer.istackbase = istackbase;
        }
    }

    public static class ParseBlock
    implements Parser {
        public void parse(Lexer lexer, Node element, short mode) {
            Node node;
            int istackbase = 0;
            boolean checkstack = true;
            if ((element.tag.model & 1) != 0) {
                return;
            }
            if (element.tag == TagTable.tagForm && element.isDescendantOf(TagTable.tagForm)) {
                Report.warning(lexer, element, null, (short)20);
            }
            if ((element.tag.model & 0x800) != 0) {
                istackbase = lexer.istackbase;
                lexer.istackbase = lexer.istack.size();
            }
            if ((element.tag.model & 0x20000) == 0) {
                lexer.inlineDup(null);
            }
            mode = 0;
            while ((node = lexer.getToken(mode)) != null) {
                if (node.type == 6 && node.tag != null && (node.tag == element.tag || element.was == node.tag)) {
                    if ((element.tag.model & 0x800) != 0) {
                        while (lexer.istack.size() > lexer.istackbase) {
                            lexer.popInline(null);
                        }
                        lexer.istackbase = istackbase;
                    }
                    element.closed = true;
                    Node.trimSpaces(lexer, element);
                    Node.trimEmptyElement(lexer, element);
                    return;
                }
                if (node.tag == TagTable.tagHtml || node.tag == TagTable.tagHead || node.tag == TagTable.tagBody) {
                    if (node.type != 5 && node.type != 7) continue;
                    Report.warning(lexer, element, node, (short)3);
                    continue;
                }
                if (node.type == 6) {
                    if (node.tag == null) {
                        Report.warning(lexer, element, node, (short)3);
                        continue;
                    }
                    if (node.tag == TagTable.tagBr) {
                        node.type = (short)5;
                    } else if (node.tag == TagTable.tagP) {
                        Node.coerceNode(lexer, node, TagTable.tagBr);
                        Node.insertNodeAtEnd(element, node);
                        node = lexer.inferredTag("br");
                    } else {
                        Node parent = element.parent;
                        while (parent != null) {
                            if (node.tag == parent.tag) {
                                if ((element.tag.model & 0x8000) == 0) {
                                    Report.warning(lexer, element, node, (short)2);
                                }
                                lexer.ungetToken();
                                if ((element.tag.model & 0x800) != 0) {
                                    while (lexer.istack.size() > lexer.istackbase) {
                                        lexer.popInline(null);
                                    }
                                    lexer.istackbase = istackbase;
                                }
                                Node.trimSpaces(lexer, element);
                                Node.trimEmptyElement(lexer, element);
                                return;
                            }
                            parent = parent.parent;
                        }
                        if (lexer.exiled && node.tag.model != 0 && (node.tag.model & 0x80) != 0) {
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, element);
                            Node.trimEmptyElement(lexer, element);
                            return;
                        }
                    }
                }
                if (node.type == 4) {
                    boolean iswhitenode = false;
                    if (node.type == 4 && node.end <= node.start + 1 && lexer.lexbuf[node.start] == 32) {
                        iswhitenode = true;
                    }
                    if (lexer.configuration.EncloseBlockText && !iswhitenode) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("p");
                        Node.insertNodeAtEnd(element, node);
                        ParserImpl.parseTag(lexer, node, (short)1);
                        continue;
                    }
                    if (checkstack) {
                        checkstack = false;
                        if ((element.tag.model & 0x20000) == 0 && lexer.inlineDup(node) > 0) continue;
                    }
                    Node.insertNodeAtEnd(element, node);
                    mode = 1;
                    lexer.versions = (short)(lexer.versions & 0xFFFFFFFB);
                    continue;
                }
                if (Node.insertMisc(element, node)) continue;
                if (node.tag == TagTable.tagParam) {
                    if ((element.tag.model & 0x1000) != 0 && (node.type == 5 || node.type == 7)) {
                        Node.insertNodeAtEnd(element, node);
                        continue;
                    }
                    Report.warning(lexer, element, node, (short)3);
                    continue;
                }
                if (node.tag == TagTable.tagArea) {
                    if (element.tag == TagTable.tagMap && (node.type == 5 || node.type == 7)) {
                        Node.insertNodeAtEnd(element, node);
                        continue;
                    }
                    Report.warning(lexer, element, node, (short)3);
                    continue;
                }
                if (node.tag == null) {
                    Report.warning(lexer, element, node, (short)3);
                    continue;
                }
                if ((node.tag.model & 0x10) == 0) {
                    if (node.type != 5 && node.type != 7) {
                        Report.warning(lexer, element, node, (short)3);
                        continue;
                    }
                    if (element.tag == TagTable.tagTd || element.tag == TagTable.tagTh) {
                        if ((node.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, element, node);
                            continue;
                        }
                        if ((node.tag.model & 0x20) != 0) {
                            lexer.ungetToken();
                            node = lexer.inferredTag("ul");
                            Node.addClass(node, "noindent");
                            lexer.excludeBlocks = true;
                        } else if ((node.tag.model & 0x40) != 0) {
                            lexer.ungetToken();
                            node = lexer.inferredTag("dl");
                            lexer.excludeBlocks = true;
                        }
                        if ((node.tag.model & 8) == 0) {
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, element);
                            Node.trimEmptyElement(lexer, element);
                            return;
                        }
                    } else if ((node.tag.model & 8) != 0) {
                        if (lexer.excludeBlocks) {
                            if ((element.tag.model & 0x8000) == 0) {
                                Report.warning(lexer, element, node, (short)2);
                            }
                            lexer.ungetToken();
                            if ((element.tag.model & 0x800) != 0) {
                                lexer.istackbase = istackbase;
                            }
                            Node.trimSpaces(lexer, element);
                            Node.trimEmptyElement(lexer, element);
                            return;
                        }
                    } else {
                        if ((element.tag.model & 0x8000) == 0 && !element.implicit) {
                            Report.warning(lexer, element, node, (short)2);
                        }
                        if ((node.tag.model & 4) != 0) {
                            ParserImpl.moveToHead(lexer, element, node);
                            continue;
                        }
                        lexer.ungetToken();
                        if ((node.tag.model & 0x20) != 0) {
                            if (element.parent != null && element.parent.tag != null && element.parent.tag.parser == ParserImpl.getParseList()) {
                                Node.trimSpaces(lexer, element);
                                Node.trimEmptyElement(lexer, element);
                                return;
                            }
                            node = lexer.inferredTag("ul");
                            Node.addClass(node, "noindent");
                        } else if ((node.tag.model & 0x40) != 0) {
                            if (element.parent.tag == TagTable.tagDl) {
                                Node.trimSpaces(lexer, element);
                                Node.trimEmptyElement(lexer, element);
                                return;
                            }
                            node = lexer.inferredTag("dl");
                        } else if ((node.tag.model & 0x80) != 0 || (node.tag.model & 0x200) != 0) {
                            node = lexer.inferredTag("table");
                        } else {
                            if ((element.tag.model & 0x800) != 0) {
                                while (lexer.istack.size() > lexer.istackbase) {
                                    lexer.popInline(null);
                                }
                                lexer.istackbase = istackbase;
                                Node.trimSpaces(lexer, element);
                                Node.trimEmptyElement(lexer, element);
                                return;
                            }
                            Node.trimSpaces(lexer, element);
                            Node.trimEmptyElement(lexer, element);
                            return;
                        }
                    }
                }
                if (node.type == 5 || node.type == 7) {
                    if ((node.tag.model & 0x10) != 0) {
                        if (checkstack && !node.implicit) {
                            checkstack = false;
                            if (lexer.inlineDup(node) > 0) continue;
                        }
                        mode = 1;
                    } else {
                        checkstack = true;
                        mode = 0;
                    }
                    if (node.tag == TagTable.tagBr) {
                        Node.trimSpaces(lexer, element);
                    }
                    Node.insertNodeAtEnd(element, node);
                    if (node.implicit) {
                        Report.warning(lexer, element, node, (short)10);
                    }
                    ParserImpl.parseTag(lexer, node, (short)0);
                    continue;
                }
                if (node.type == 6) {
                    lexer.popInline(node);
                }
                Report.warning(lexer, element, node, (short)3);
            }
            if ((element.tag.model & 0x8000) == 0) {
                Report.warning(lexer, element, node, (short)1);
            }
            if ((element.tag.model & 0x800) != 0) {
                while (lexer.istack.size() > lexer.istackbase) {
                    lexer.popInline(null);
                }
                lexer.istackbase = istackbase;
            }
            Node.trimSpaces(lexer, element);
            Node.trimEmptyElement(lexer, element);
        }
    }

    public static class ParsePre
    implements Parser {
        public void parse(Lexer lexer, Node pre, short mode) {
            Node node;
            if ((pre.tag.model & 1) != 0) {
                return;
            }
            if ((pre.tag.model & 0x80000) != 0) {
                Node.coerceNode(lexer, pre, TagTable.tagPre);
            }
            lexer.inlineDup(null);
            while ((node = lexer.getToken((short)2)) != null) {
                if (node.tag == pre.tag && node.type == 6) {
                    Node.trimSpaces(lexer, pre);
                    pre.closed = true;
                    Node.trimEmptyElement(lexer, pre);
                    return;
                }
                if (node.tag == TagTable.tagHtml) {
                    if (node.type != 5 && node.type != 7) continue;
                    Report.warning(lexer, pre, node, (short)3);
                    continue;
                }
                if (node.type == 4) {
                    if (pre.content == null) {
                        if (node.textarray[node.start] == 10) {
                            ++node.start;
                        }
                        if (node.start >= node.end) continue;
                    }
                    Node.insertNodeAtEnd(pre, node);
                    continue;
                }
                if (Node.insertMisc(pre, node)) continue;
                if (node.tag == null || node.tag == TagTable.tagParam) {
                    Report.warning(lexer, pre, node, (short)3);
                    continue;
                }
                if (node.tag == TagTable.tagP) {
                    if (node.type == 5) {
                        Report.warning(lexer, pre, node, (short)9);
                        Node.trimSpaces(lexer, pre);
                        Node.coerceNode(lexer, node, TagTable.tagBr);
                        Node.insertNodeAtEnd(pre, node);
                        continue;
                    }
                    Report.warning(lexer, pre, node, (short)3);
                    continue;
                }
                if ((node.tag.model & 4) != 0 && (node.tag.model & 8) == 0) {
                    ParserImpl.moveToHead(lexer, pre, node);
                    continue;
                }
                if (node.type == 6) {
                    if (node.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, pre, node, (short)3);
                        continue;
                    }
                    Node parent = pre.parent;
                    while (parent != null) {
                        if (node.tag == parent.tag) {
                            Report.warning(lexer, pre, node, (short)2);
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, pre);
                            Node.trimEmptyElement(lexer, pre);
                            return;
                        }
                        parent = parent.parent;
                    }
                }
                if ((node.tag.model & 0x10) == 0) {
                    if (node.type != 5) {
                        Report.warning(lexer, pre, node, (short)3);
                        continue;
                    }
                    Report.warning(lexer, pre, node, (short)2);
                    lexer.excludeBlocks = true;
                    if ((node.tag.model & 0x20) != 0) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("ul");
                        Node.addClass(node, "noindent");
                    } else if ((node.tag.model & 0x40) != 0) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("dl");
                    } else if ((node.tag.model & 0x80) != 0) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("table");
                    }
                    Node.insertNodeAfterElement(pre, node);
                    pre = lexer.inferredTag("pre");
                    Node.insertNodeAfterElement(node, pre);
                    ParserImpl.parseTag(lexer, node, (short)0);
                    lexer.excludeBlocks = false;
                    continue;
                }
                if (node.type == 5 || node.type == 7) {
                    if (node.tag == TagTable.tagBr) {
                        Node.trimSpaces(lexer, pre);
                    }
                    Node.insertNodeAtEnd(pre, node);
                    ParserImpl.parseTag(lexer, node, (short)2);
                    continue;
                }
                Report.warning(lexer, pre, node, (short)3);
            }
            Report.warning(lexer, pre, node, (short)1);
            Node.trimEmptyElement(lexer, pre);
        }
    }

    public static class ParseDefList
    implements Parser {
        public void parse(Lexer lexer, Node list, short mode) {
            Node node;
            if ((list.tag.model & 1) != 0) {
                return;
            }
            lexer.insert = -1;
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == list.tag && node.type == 6) {
                    list.closed = true;
                    Node.trimEmptyElement(lexer, list);
                    return;
                }
                if (Node.insertMisc(list, node)) continue;
                if (node.type == 4) {
                    lexer.ungetToken();
                    node = lexer.inferredTag("dt");
                    Report.warning(lexer, list, node, (short)7);
                }
                if (node.tag == null) {
                    Report.warning(lexer, list, node, (short)3);
                    continue;
                }
                if (node.type == 6) {
                    if (node.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, list, node, (short)3);
                        continue;
                    }
                    Node parent = list.parent;
                    while (parent != null) {
                        if (node.tag == parent.tag) {
                            Report.warning(lexer, list, node, (short)2);
                            lexer.ungetToken();
                            Node.trimEmptyElement(lexer, list);
                            return;
                        }
                        parent = parent.parent;
                    }
                }
                if (node.tag == TagTable.tagCenter) {
                    if (list.content != null) {
                        Node.insertNodeAfterElement(list, node);
                    } else {
                        Node.insertNodeBeforeElement(list, node);
                        Node.discardElement(list);
                    }
                    ParserImpl.parseTag(lexer, node, mode);
                    list = lexer.inferredTag("dl");
                    Node.insertNodeAfterElement(node, list);
                    continue;
                }
                if (node.tag != TagTable.tagDt && node.tag != TagTable.tagDd) {
                    lexer.ungetToken();
                    if ((node.tag.model & 0x18) == 0) {
                        Report.warning(lexer, list, node, (short)6);
                        Node.trimEmptyElement(lexer, list);
                        return;
                    }
                    if ((node.tag.model & 0x10) == 0 && lexer.excludeBlocks) {
                        Node.trimEmptyElement(lexer, list);
                        return;
                    }
                    node = lexer.inferredTag("dd");
                    Report.warning(lexer, list, node, (short)7);
                }
                if (node.type == 6) {
                    Report.warning(lexer, list, node, (short)3);
                    continue;
                }
                Node.insertNodeAtEnd(list, node);
                ParserImpl.parseTag(lexer, node, (short)0);
            }
            Report.warning(lexer, list, node, (short)1);
            Node.trimEmptyElement(lexer, list);
        }
    }

    public static class ParseList
    implements Parser {
        public void parse(Lexer lexer, Node list, short mode) {
            Node node;
            if ((list.tag.model & 1) != 0) {
                return;
            }
            lexer.insert = -1;
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == list.tag && node.type == 6) {
                    if ((list.tag.model & 0x80000) != 0) {
                        Node.coerceNode(lexer, list, TagTable.tagUl);
                    }
                    list.closed = true;
                    Node.trimEmptyElement(lexer, list);
                    return;
                }
                if (Node.insertMisc(list, node)) continue;
                if (node.type != 4 && node.tag == null) {
                    Report.warning(lexer, list, node, (short)3);
                    continue;
                }
                if (node.type == 6) {
                    if (node.tag == TagTable.tagForm) {
                        lexer.badForm = 1;
                        Report.warning(lexer, list, node, (short)3);
                        continue;
                    }
                    if (node.tag != null && (node.tag.model & 0x10) != 0) {
                        Report.warning(lexer, list, node, (short)3);
                        lexer.popInline(node);
                        continue;
                    }
                    Node parent = list.parent;
                    while (parent != null) {
                        if (node.tag == parent.tag) {
                            Report.warning(lexer, list, node, (short)2);
                            lexer.ungetToken();
                            if ((list.tag.model & 0x80000) != 0) {
                                Node.coerceNode(lexer, list, TagTable.tagUl);
                            }
                            Node.trimEmptyElement(lexer, list);
                            return;
                        }
                        parent = parent.parent;
                    }
                    Report.warning(lexer, list, node, (short)3);
                    continue;
                }
                if (node.tag != TagTable.tagLi) {
                    lexer.ungetToken();
                    if (node.tag != null && (node.tag.model & 8) != 0 && lexer.excludeBlocks) {
                        Report.warning(lexer, list, node, (short)2);
                        Node.trimEmptyElement(lexer, list);
                        return;
                    }
                    node = lexer.inferredTag("li");
                    node.addAttribute("style", "list-style: none");
                    Report.warning(lexer, list, node, (short)7);
                }
                Node.insertNodeAtEnd(list, node);
                ParserImpl.parseTag(lexer, node, (short)0);
            }
            if ((list.tag.model & 0x80000) != 0) {
                Node.coerceNode(lexer, list, TagTable.tagUl);
            }
            Report.warning(lexer, list, node, (short)1);
            Node.trimEmptyElement(lexer, list);
        }
    }

    public static class ParseInline
    implements Parser {
        public void parse(Lexer lexer, Node element, short mode) {
            Node node;
            if ((element.tag.model & 1) != 0) {
                return;
            }
            if (element.tag == TagTable.tagA && element.attributes == null) {
                Report.warning(lexer, element.parent, element, (short)3);
                Node.discardElement(element);
                return;
            }
            if ((element.tag.model & 8) != 0 || element.tag == TagTable.tagDt) {
                lexer.inlineDup(null);
            } else if ((element.tag.model & 0x10) != 0 && element.tag != TagTable.tagA && element.tag != TagTable.tagSpan) {
                lexer.pushInline(element);
            }
            if (element.tag == TagTable.tagNobr) {
                lexer.badLayout = (short)(lexer.badLayout | 4);
            } else if (element.tag == TagTable.tagFont) {
                lexer.badLayout = (short)(lexer.badLayout | 8);
            }
            if (mode != 2) {
                mode = 1;
            }
            while ((node = lexer.getToken(mode)) != null) {
                if (node.tag == element.tag && node.type == 6) {
                    if ((element.tag.model & 0x10) != 0 && element.tag != TagTable.tagA) {
                        lexer.popInline(node);
                    }
                    if ((mode & 2) == 0) {
                        Node.trimSpaces(lexer, element);
                    }
                    if (element.tag == TagTable.tagFont && element.content != null && element.content == element.last) {
                        Node child = element.content;
                        if (child.tag == TagTable.tagA) {
                            child.parent = element.parent;
                            child.next = element.next;
                            child.prev = element.prev;
                            if (child.prev != null) {
                                child.prev.next = child;
                            } else {
                                child.parent.content = child;
                            }
                            if (child.next != null) {
                                child.next.prev = child;
                            } else {
                                child.parent.last = child;
                            }
                            element.next = null;
                            element.prev = null;
                            element.parent = child;
                            element.content = child.content;
                            element.last = child.last;
                            child.content = element;
                            child.last = element;
                            child = element.content;
                            while (child != null) {
                                child.parent = element;
                                child = child.next;
                            }
                        }
                    }
                    element.closed = true;
                    Node.trimSpaces(lexer, element);
                    Node.trimEmptyElement(lexer, element);
                    return;
                }
                if (node.type == 5 && node.tag == element.tag && lexer.isPushed(node) && !node.implicit && !element.implicit && node.tag != null && (node.tag.model & 0x10) != 0 && node.tag != TagTable.tagA && node.tag != TagTable.tagFont && node.tag != TagTable.tagBig && node.tag != TagTable.tagSmall) {
                    if (element.content != null && node.attributes == null) {
                        Report.warning(lexer, element, node, (short)19);
                        node.type = (short)6;
                        lexer.ungetToken();
                        continue;
                    }
                    Report.warning(lexer, element, node, (short)4);
                }
                if (node.type == 4) {
                    if (element.content == null && (mode & 2) == 0) {
                        Node.trimSpaces(lexer, element);
                    }
                    if (node.start >= node.end) continue;
                    Node.insertNodeAtEnd(element, node);
                    continue;
                }
                if (Node.insertMisc(element, node)) continue;
                if (node.tag == TagTable.tagHtml) {
                    if (node.type == 5 || node.type == 7) {
                        Report.warning(lexer, element, node, (short)3);
                        continue;
                    }
                    lexer.ungetToken();
                    if ((mode & 2) == 0) {
                        Node.trimSpaces(lexer, element);
                    }
                    Node.trimEmptyElement(lexer, element);
                    return;
                }
                if (node.tag == TagTable.tagP && node.type == 5 && ((mode & 2) != 0 || element.tag == TagTable.tagDt || element.isDescendantOf(TagTable.tagDt))) {
                    node.tag = TagTable.tagBr;
                    node.element = new String("br");
                    Node.trimSpaces(lexer, element);
                    Node.insertNodeAtEnd(element, node);
                    continue;
                }
                if (node.tag == null || node.tag == TagTable.tagParam) {
                    Report.warning(lexer, element, node, (short)3);
                    continue;
                }
                if (node.tag == TagTable.tagBr && node.type == 6) {
                    node.type = (short)5;
                }
                if (node.type == 6) {
                    if (node.tag == TagTable.tagBr) {
                        node.type = (short)5;
                    } else if (node.tag == TagTable.tagP) {
                        if (!element.isDescendantOf(TagTable.tagP)) {
                            Node.coerceNode(lexer, node, TagTable.tagBr);
                            Node.trimSpaces(lexer, element);
                            Node.insertNodeAtEnd(element, node);
                            node = lexer.inferredTag("br");
                            continue;
                        }
                    } else {
                        if ((node.tag.model & 0x10) != 0 && node.tag != TagTable.tagA && (node.tag.model & 0x800) == 0 && (element.tag.model & 0x10) != 0) {
                            lexer.popInline(element);
                            if (element.tag != TagTable.tagA) {
                                if (node.tag == TagTable.tagA && node.tag != element.tag) {
                                    Report.warning(lexer, element, node, (short)2);
                                    lexer.ungetToken();
                                } else {
                                    Report.warning(lexer, element, node, (short)5);
                                }
                                if ((mode & 2) == 0) {
                                    Node.trimSpaces(lexer, element);
                                }
                                Node.trimEmptyElement(lexer, element);
                                return;
                            }
                            Report.warning(lexer, element, node, (short)3);
                            continue;
                        }
                        if (lexer.exiled && node.tag.model != 0 && (node.tag.model & 0x80) != 0) {
                            lexer.ungetToken();
                            Node.trimSpaces(lexer, element);
                            Node.trimEmptyElement(lexer, element);
                            return;
                        }
                    }
                }
                if ((node.tag.model & 0x4000) != 0 && (element.tag.model & 0x4000) != 0) {
                    if (node.tag == element.tag) {
                        Report.warning(lexer, element, node, (short)5);
                    } else {
                        Report.warning(lexer, element, node, (short)2);
                        lexer.ungetToken();
                    }
                    if ((mode & 2) == 0) {
                        Node.trimSpaces(lexer, element);
                    }
                    Node.trimEmptyElement(lexer, element);
                    return;
                }
                if (node.tag == TagTable.tagA && !node.implicit && lexer.isPushed(node)) {
                    if (node.attributes == null) {
                        node.type = (short)6;
                        Report.warning(lexer, element, node, (short)19);
                        lexer.popInline(node);
                        lexer.ungetToken();
                        continue;
                    }
                    lexer.ungetToken();
                    Report.warning(lexer, element, node, (short)2);
                    lexer.popInline(element);
                    if ((mode & 2) == 0) {
                        Node.trimSpaces(lexer, element);
                    }
                    Node.trimEmptyElement(lexer, element);
                    return;
                }
                if ((element.tag.model & 0x4000) != 0) {
                    if (node.tag == TagTable.tagCenter || node.tag == TagTable.tagDiv) {
                        if (node.type != 5 && node.type != 7) {
                            Report.warning(lexer, element, node, (short)3);
                            continue;
                        }
                        Report.warning(lexer, element, node, (short)6);
                        if (element.content == null) {
                            Node.insertNodeAsParent(element, node);
                            continue;
                        }
                        Node.insertNodeAfterElement(element, node);
                        if ((mode & 2) == 0) {
                            Node.trimSpaces(lexer, element);
                        }
                        element = lexer.cloneNode(element);
                        element.start = lexer.lexsize;
                        element.end = lexer.lexsize;
                        Node.insertNodeAtEnd(node, element);
                        continue;
                    }
                    if (node.tag == TagTable.tagHr) {
                        if (node.type != 5 && node.type != 7) {
                            Report.warning(lexer, element, node, (short)3);
                            continue;
                        }
                        Report.warning(lexer, element, node, (short)6);
                        if (element.content == null) {
                            Node.insertNodeBeforeElement(element, node);
                            continue;
                        }
                        Node.insertNodeAfterElement(element, node);
                        if ((mode & 2) == 0) {
                            Node.trimSpaces(lexer, element);
                        }
                        element = lexer.cloneNode(element);
                        element.start = lexer.lexsize;
                        element.end = lexer.lexsize;
                        Node.insertNodeAfterElement(node, element);
                        continue;
                    }
                }
                if (element.tag == TagTable.tagDt && node.tag == TagTable.tagHr) {
                    if (node.type != 5 && node.type != 7) {
                        Report.warning(lexer, element, node, (short)3);
                        continue;
                    }
                    Report.warning(lexer, element, node, (short)6);
                    Node dd = lexer.inferredTag("dd");
                    if (element.content == null) {
                        Node.insertNodeBeforeElement(element, dd);
                        Node.insertNodeAtEnd(dd, node);
                        continue;
                    }
                    Node.insertNodeAfterElement(element, dd);
                    Node.insertNodeAtEnd(dd, node);
                    if ((mode & 2) == 0) {
                        Node.trimSpaces(lexer, element);
                    }
                    element = lexer.cloneNode(element);
                    element.start = lexer.lexsize;
                    element.end = lexer.lexsize;
                    Node.insertNodeAfterElement(dd, element);
                    continue;
                }
                if (node.type == 6) {
                    Node parent = element.parent;
                    while (parent != null) {
                        if (node.tag == parent.tag) {
                            if ((element.tag.model & 0x8000) == 0 && !element.implicit) {
                                Report.warning(lexer, element, node, (short)2);
                            }
                            if (element.tag == TagTable.tagA) {
                                lexer.popInline(element);
                            }
                            lexer.ungetToken();
                            if ((mode & 2) == 0) {
                                Node.trimSpaces(lexer, element);
                            }
                            Node.trimEmptyElement(lexer, element);
                            return;
                        }
                        parent = parent.parent;
                    }
                }
                if ((node.tag.model & 0x10) == 0) {
                    if (node.type != 5) {
                        Report.warning(lexer, element, node, (short)3);
                        continue;
                    }
                    if ((element.tag.model & 0x8000) == 0) {
                        Report.warning(lexer, element, node, (short)2);
                    }
                    if ((node.tag.model & 4) != 0 && (node.tag.model & 8) == 0) {
                        ParserImpl.moveToHead(lexer, element, node);
                        continue;
                    }
                    if (element.tag == TagTable.tagA) {
                        if (node.tag != null && (node.tag.model & 0x4000) == 0) {
                            lexer.popInline(element);
                        } else if (element.content == null) {
                            Node.discardElement(element);
                            lexer.ungetToken();
                            return;
                        }
                    }
                    lexer.ungetToken();
                    if ((mode & 2) == 0) {
                        Node.trimSpaces(lexer, element);
                    }
                    Node.trimEmptyElement(lexer, element);
                    return;
                }
                if (node.type == 5 || node.type == 7) {
                    if (node.implicit) {
                        Report.warning(lexer, element, node, (short)10);
                    }
                    if (node.tag == TagTable.tagBr) {
                        Node.trimSpaces(lexer, element);
                    }
                    Node.insertNodeAtEnd(element, node);
                    ParserImpl.parseTag(lexer, node, mode);
                    continue;
                }
                Report.warning(lexer, element, node, (short)3);
            }
            if ((element.tag.model & 0x8000) == 0) {
                Report.warning(lexer, element, node, (short)1);
            }
            Node.trimEmptyElement(lexer, element);
        }
    }

    public static class ParseFrameSet
    implements Parser {
        public void parse(Lexer lexer, Node frameset, short mode) {
            Node node;
            lexer.badAccess = (short)(lexer.badAccess | 0x10);
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == frameset.tag && node.type == 6) {
                    frameset.closed = true;
                    Node.trimSpaces(lexer, frameset);
                    return;
                }
                if (Node.insertMisc(frameset, node)) continue;
                if (node.tag == null) {
                    Report.warning(lexer, frameset, node, (short)3);
                    continue;
                }
                if ((node.type == 5 || node.type == 7) && node.tag != null && (node.tag.model & 4) != 0) {
                    ParserImpl.moveToHead(lexer, frameset, node);
                    continue;
                }
                if (node.tag == TagTable.tagBody) {
                    lexer.ungetToken();
                    node = lexer.inferredTag("noframes");
                    Report.warning(lexer, frameset, node, (short)10);
                }
                if (node.type == 5 && (node.tag.model & 0x2000) != 0) {
                    Node.insertNodeAtEnd(frameset, node);
                    lexer.excludeBlocks = false;
                    ParserImpl.parseTag(lexer, node, (short)1);
                    continue;
                }
                if (node.type == 7 && (node.tag.model & 0x2000) != 0) {
                    Node.insertNodeAtEnd(frameset, node);
                    continue;
                }
                Report.warning(lexer, frameset, node, (short)3);
            }
            Report.warning(lexer, frameset, node, (short)1);
        }
    }

    public static class ParseBody
    implements Parser {
        public void parse(Lexer lexer, Node body, short mode) {
            Node node;
            mode = 0;
            boolean checkstack = true;
            while ((node = lexer.getToken(mode)) != null) {
                if (node.tag == body.tag && node.type == 6) {
                    body.closed = true;
                    Node.trimSpaces(lexer, body);
                    lexer.seenBodyEndTag = 1;
                    mode = 0;
                    if (body.parent.tag != TagTable.tagNoframes) continue;
                    break;
                }
                if (node.tag == TagTable.tagNoframes) {
                    if (node.type == 5) {
                        Node.insertNodeAtEnd(body, node);
                        ParserImpl.getParseBlock().parse(lexer, node, mode);
                        continue;
                    }
                    if (node.type == 6 && body.parent.tag == TagTable.tagNoframes) {
                        Node.trimSpaces(lexer, body);
                        lexer.ungetToken();
                        break;
                    }
                }
                if ((node.tag == TagTable.tagFrame || node.tag == TagTable.tagFrameset) && body.parent.tag == TagTable.tagNoframes) {
                    Node.trimSpaces(lexer, body);
                    lexer.ungetToken();
                    break;
                }
                if (node.tag == TagTable.tagHtml) {
                    if (node.type != 5 && node.type != 7) continue;
                    Report.warning(lexer, body, node, (short)3);
                    continue;
                }
                boolean iswhitenode = false;
                if (node.type == 4 && node.end <= node.start + 1 && node.textarray[node.start] == 32) {
                    iswhitenode = true;
                }
                if (Node.insertMisc(body, node)) continue;
                if (lexer.seenBodyEndTag == 1 && !iswhitenode) {
                    ++lexer.seenBodyEndTag;
                    Report.warning(lexer, body, node, (short)22);
                }
                if (node.type == 4) {
                    if (iswhitenode && mode == 0) continue;
                    if (lexer.configuration.EncloseBodyText && !iswhitenode) {
                        lexer.ungetToken();
                        Node para = lexer.inferredTag("p");
                        Node.insertNodeAtEnd(body, para);
                        ParserImpl.parseTag(lexer, para, mode);
                        mode = 1;
                        continue;
                    }
                    lexer.versions = (short)(lexer.versions & 0xFFFFFFFA);
                    if (checkstack) {
                        checkstack = false;
                        if (lexer.inlineDup(node) > 0) continue;
                    }
                    Node.insertNodeAtEnd(body, node);
                    mode = 1;
                    continue;
                }
                if (node.type == 1) {
                    Node.insertDocType(lexer, body, node);
                    continue;
                }
                if (node.tag == null || node.tag == TagTable.tagParam) {
                    Report.warning(lexer, body, node, (short)3);
                    continue;
                }
                lexer.excludeBlocks = false;
                if ((node.tag.model & 8) == 0 && (node.tag.model & 0x10) == 0) {
                    if ((node.tag.model & 4) == 0) {
                        Report.warning(lexer, body, node, (short)6);
                    }
                    if ((node.tag.model & 2) != 0) {
                        if (node.tag != TagTable.tagBody || !body.implicit || body.attributes != null) continue;
                        body.attributes = node.attributes;
                        node.attributes = null;
                        continue;
                    }
                    if ((node.tag.model & 4) != 0) {
                        ParserImpl.moveToHead(lexer, body, node);
                        continue;
                    }
                    if ((node.tag.model & 0x20) != 0) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("ul");
                        Node.addClass(node, "noindent");
                        lexer.excludeBlocks = true;
                    } else if ((node.tag.model & 0x40) != 0) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("dl");
                        lexer.excludeBlocks = true;
                    } else if ((node.tag.model & 0x380) != 0) {
                        lexer.ungetToken();
                        node = lexer.inferredTag("table");
                        lexer.excludeBlocks = true;
                    } else {
                        if ((node.tag.model & 0x600) != 0) continue;
                        lexer.ungetToken();
                        return;
                    }
                }
                if (node.type == 6) {
                    if (node.tag == TagTable.tagBr) {
                        node.type = (short)5;
                    } else if (node.tag == TagTable.tagP) {
                        Node.coerceNode(lexer, node, TagTable.tagBr);
                        Node.insertNodeAtEnd(body, node);
                        node = lexer.inferredTag("br");
                    } else if ((node.tag.model & 0x10) != 0) {
                        lexer.popInline(node);
                    }
                }
                if (node.type == 5 || node.type == 7) {
                    if ((node.tag.model & 0x10) != 0 && (node.tag.model & 0x20000) == 0) {
                        lexer.versions = node.tag == TagTable.tagImg ? (short)(lexer.versions & 0xFFFFFFFB) : (short)(lexer.versions & 0xFFFFFFFA);
                        if (checkstack && !node.implicit) {
                            checkstack = false;
                            if (lexer.inlineDup(node) > 0) continue;
                        }
                        mode = 1;
                    } else {
                        checkstack = true;
                        mode = 0;
                    }
                    if (node.implicit) {
                        Report.warning(lexer, body, node, (short)10);
                    }
                    Node.insertNodeAtEnd(body, node);
                    ParserImpl.parseTag(lexer, node, mode);
                    continue;
                }
                Report.warning(lexer, body, node, (short)3);
            }
        }
    }

    public static class ParseScript
    implements Parser {
        public void parse(Lexer lexer, Node script, short mode) {
            Node node = lexer.getCDATA(script);
            if (node != null) {
                Node.insertNodeAtEnd(script, node);
            }
        }
    }

    public static class ParseTitle
    implements Parser {
        public void parse(Lexer lexer, Node title, short mode) {
            Node node;
            while ((node = lexer.getToken((short)1)) != null) {
                if (node.tag == title.tag && node.type == 6) {
                    title.closed = true;
                    Node.trimSpaces(lexer, title);
                    return;
                }
                if (node.type == 4) {
                    if (title.content == null) {
                        Node.trimInitialSpace(lexer, title, node);
                    }
                    if (node.start >= node.end) continue;
                    Node.insertNodeAtEnd(title, node);
                    continue;
                }
                if (Node.insertMisc(title, node)) continue;
                if (node.tag == null) {
                    Report.warning(lexer, title, node, (short)3);
                    continue;
                }
                Report.warning(lexer, title, node, (short)2);
                lexer.ungetToken();
                Node.trimSpaces(lexer, title);
                return;
            }
            Report.warning(lexer, title, node, (short)1);
        }
    }

    public static class ParseHead
    implements Parser {
        public void parse(Lexer lexer, Node head, short mode) {
            Node node;
            int HasTitle = 0;
            int HasBase = 0;
            while ((node = lexer.getToken((short)0)) != null) {
                if (node.tag == head.tag && node.type == 6) {
                    head.closed = true;
                    break;
                }
                if (node.type == 4) {
                    lexer.ungetToken();
                    break;
                }
                if (Node.insertMisc(head, node)) continue;
                if (node.type == 1) {
                    Node.insertDocType(lexer, head, node);
                    continue;
                }
                if (node.tag == null) {
                    Report.warning(lexer, head, node, (short)3);
                    continue;
                }
                if ((node.tag.model & 4) == 0) {
                    lexer.ungetToken();
                    break;
                }
                if (node.type == 5 || node.type == 7) {
                    if (node.tag == TagTable.tagTitle) {
                        if (++HasTitle > 1) {
                            Report.warning(lexer, head, node, (short)33);
                        }
                    } else if (node.tag == TagTable.tagBase) {
                        if (++HasBase > 1) {
                            Report.warning(lexer, head, node, (short)33);
                        }
                    } else if (node.tag == TagTable.tagNoscript) {
                        Report.warning(lexer, head, node, (short)6);
                    }
                    Node.insertNodeAtEnd(head, node);
                    ParserImpl.parseTag(lexer, node, (short)0);
                    continue;
                }
                Report.warning(lexer, head, node, (short)3);
            }
            if (HasTitle == 0) {
                Report.warning(lexer, head, null, (short)12);
                Node.insertNodeAtEnd(head, lexer.inferredTag("title"));
            }
        }
    }

    public static class ParseHTML
    implements Parser {
        public void parse(Lexer lexer, Node html, short mode) {
            Node node;
            block25: {
                Node noframes;
                Node frameset;
                block24: {
                    frameset = null;
                    noframes = null;
                    lexer.configuration.XmlTags = false;
                    lexer.seenBodyEndTag = 0;
                    while (true) {
                        if ((node = lexer.getToken((short)0)) == null) {
                            node = lexer.inferredTag("head");
                            break block24;
                        }
                        if (node.tag == TagTable.tagHead) break block24;
                        if (node.tag == html.tag && node.type == 6) {
                            Report.warning(lexer, html, node, (short)3);
                            continue;
                        }
                        if (!Node.insertMisc(html, node)) break;
                    }
                    lexer.ungetToken();
                    node = lexer.inferredTag("head");
                }
                Node head = node;
                Node.insertNodeAtEnd(html, head);
                ParserImpl.getParseHead().parse(lexer, head, mode);
                block1: while (true) {
                    if ((node = lexer.getToken((short)0)) == null) {
                        if (frameset == null) {
                            node = lexer.inferredTag("body");
                        }
                        return;
                    }
                    if (node.tag == html.tag) {
                        if (node.type == 5 || frameset != null) continue;
                        Report.warning(lexer, html, node, (short)3);
                        continue;
                    }
                    if (Node.insertMisc(html, node)) continue;
                    if (node.tag == TagTable.tagBody) {
                        if (node.type != 5) {
                            Report.warning(lexer, html, node, (short)3);
                            continue;
                        }
                        if (frameset != null) {
                            lexer.ungetToken();
                            if (noframes == null) {
                                noframes = lexer.inferredTag("noframes");
                                Node.insertNodeAtEnd(frameset, noframes);
                                Report.warning(lexer, html, noframes, (short)10);
                            }
                            ParserImpl.parseTag(lexer, noframes, mode);
                            continue;
                        }
                        break block25;
                    }
                    if (node.tag == TagTable.tagFrameset) {
                        if (node.type != 5) {
                            Report.warning(lexer, html, node, (short)3);
                            continue;
                        }
                        if (frameset != null) {
                            Report.error(lexer, html, node, (short)13);
                        } else {
                            frameset = node;
                        }
                        Node.insertNodeAtEnd(html, node);
                        ParserImpl.parseTag(lexer, node, mode);
                        node = frameset.content;
                        while (true) {
                            if (node == null) continue block1;
                            if (node.tag == TagTable.tagNoframes) {
                                noframes = node;
                            }
                            node = node.next;
                        }
                    }
                    if (node.tag == TagTable.tagNoframes) {
                        if (node.type != 5) {
                            Report.warning(lexer, html, node, (short)3);
                            continue;
                        }
                        if (frameset == null) {
                            Report.warning(lexer, html, node, (short)3);
                            node = lexer.inferredTag("body");
                            break block25;
                        }
                        if (noframes == null) {
                            noframes = node;
                            Node.insertNodeAtEnd(frameset, noframes);
                        }
                        ParserImpl.parseTag(lexer, noframes, mode);
                        continue;
                    }
                    if ((node.type == 5 || node.type == 7) && node.tag != null && (node.tag.model & 4) != 0) {
                        ParserImpl.moveToHead(lexer, html, node);
                        continue;
                    }
                    lexer.ungetToken();
                    if (frameset == null) break;
                    if (noframes == null) {
                        noframes = lexer.inferredTag("noframes");
                        Node.insertNodeAtEnd(frameset, noframes);
                    } else {
                        Report.warning(lexer, html, node, (short)21);
                    }
                    ParserImpl.parseTag(lexer, noframes, mode);
                }
                node = lexer.inferredTag("body");
            }
            Node.insertNodeAtEnd(html, node);
            ParserImpl.parseTag(lexer, node, mode);
        }
    }
}

