/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class Configuration
implements Serializable {
    public static final int RAW = 0;
    public static final int ASCII = 1;
    public static final int LATIN1 = 2;
    public static final int UTF8 = 3;
    public static final int ISO2022 = 4;
    public static final int MACROMAN = 5;
    public static final int DOCTYPE_OMIT = 0;
    public static final int DOCTYPE_AUTO = 1;
    public static final int DOCTYPE_STRICT = 2;
    public static final int DOCTYPE_LOOSE = 3;
    public static final int DOCTYPE_USER = 4;
    protected int spaces = 2;
    protected int wraplen = 68;
    protected int CharEncoding = 1;
    protected int tabsize = 4;
    protected int docTypeMode = 1;
    protected String altText = null;
    protected String slidestyle = null;
    protected String docTypeStr = null;
    protected String errfile = null;
    protected boolean writeback = false;
    protected boolean OnlyErrors = false;
    protected boolean ShowWarnings = true;
    protected boolean Quiet = false;
    protected boolean IndentContent = false;
    protected boolean SmartIndent = false;
    protected boolean HideEndTags = false;
    protected boolean XmlTags = false;
    protected boolean XmlOut = false;
    protected boolean xHTML = false;
    protected boolean XmlPi = false;
    protected boolean RawOut = false;
    protected boolean UpperCaseTags = false;
    protected boolean UpperCaseAttrs = false;
    protected boolean MakeClean = false;
    protected boolean LogicalEmphasis = false;
    protected boolean DropFontTags = false;
    protected boolean DropEmptyParas = true;
    protected boolean FixComments = true;
    protected boolean BreakBeforeBR = false;
    protected boolean BurstSlides = false;
    protected boolean NumEntities = false;
    protected boolean QuoteMarks = false;
    protected boolean QuoteNbsp = true;
    protected boolean QuoteAmpersand = true;
    protected boolean WrapAttVals = false;
    protected boolean WrapScriptlets = false;
    protected boolean WrapSection = true;
    protected boolean WrapAsp = true;
    protected boolean WrapJste = true;
    protected boolean WrapPhp = true;
    protected boolean FixBackslash = true;
    protected boolean IndentAttributes = false;
    protected boolean XmlPIs = false;
    protected boolean XmlSpace = false;
    protected boolean EncloseBodyText = false;
    protected boolean EncloseBlockText = false;
    protected boolean KeepFileTimes = true;
    protected boolean Word2000 = false;
    protected boolean TidyMark = true;
    protected boolean Emacs = false;
    protected boolean LiteralAttribs = false;
    private transient Properties _properties = new Properties();

    public void addProps(Properties p) {
        Enumeration<?> enumeration = p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = p.getProperty(key);
            ((Hashtable)this._properties).put(key, value);
        }
        this.parseProps();
    }

    public void parseFile(String filename) {
        try {
            this._properties.load(new FileInputStream(filename));
        }
        catch (IOException e) {
            System.err.println(filename + e.toString());
            return;
        }
        this.parseProps();
    }

    private void parseProps() {
        String value = this._properties.getProperty("indent-spaces");
        if (value != null) {
            this.spaces = Configuration.parseInt(value);
        }
        if ((value = this._properties.getProperty("wrap")) != null) {
            this.wraplen = Configuration.parseInt(value);
        }
        if ((value = this._properties.getProperty("wrap-attributes")) != null) {
            this.WrapAttVals = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("wrap-script-literals")) != null) {
            this.WrapScriptlets = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("wrap-sections")) != null) {
            this.WrapSection = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("wrap-asp")) != null) {
            this.WrapAsp = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("wrap-jste")) != null) {
            this.WrapJste = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("wrap-php")) != null) {
            this.WrapPhp = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("literal-attributes")) != null) {
            this.LiteralAttribs = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("tab-size")) != null) {
            this.tabsize = Configuration.parseInt(value);
        }
        if ((value = this._properties.getProperty("markup")) != null) {
            this.OnlyErrors = Configuration.parseInvBool(value);
        }
        if ((value = this._properties.getProperty("quiet")) != null) {
            this.Quiet = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("tidy-mark")) != null) {
            this.TidyMark = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("indent")) != null) {
            this.IndentContent = this.parseIndent(value);
        }
        if ((value = this._properties.getProperty("indent-attributes")) != null) {
            this.IndentAttributes = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("hide-endtags")) != null) {
            this.HideEndTags = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("input-xml")) != null) {
            this.XmlTags = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("output-xml")) != null) {
            this.XmlOut = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("output-xhtml")) != null) {
            this.xHTML = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("add-xml-pi")) != null) {
            this.XmlPi = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("add-xml-decl")) != null) {
            this.XmlPi = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("assume-xml-procins")) != null) {
            this.XmlPIs = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("raw")) != null) {
            this.RawOut = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("uppercase-tags")) != null) {
            this.UpperCaseTags = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("uppercase-attributes")) != null) {
            this.UpperCaseAttrs = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("clean")) != null) {
            this.MakeClean = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("logical-emphasis")) != null) {
            this.LogicalEmphasis = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("word-2000")) != null) {
            this.Word2000 = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("drop-empty-paras")) != null) {
            this.DropEmptyParas = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("drop-font-tags")) != null) {
            this.DropFontTags = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("enclose-text")) != null) {
            this.EncloseBodyText = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("enclose-block-text")) != null) {
            this.EncloseBlockText = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("alt-text")) != null) {
            this.altText = new String(value);
        }
        if ((value = this._properties.getProperty("add-xml-space")) != null) {
            this.XmlSpace = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("fix-bad-comments")) != null) {
            this.FixComments = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("split")) != null) {
            this.BurstSlides = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("break-before-br")) != null) {
            this.BreakBeforeBR = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("numeric-entities")) != null) {
            this.NumEntities = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("quote-marks")) != null) {
            this.QuoteMarks = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("quote-nbsp")) != null) {
            this.QuoteNbsp = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("quote-ampersand")) != null) {
            this.QuoteAmpersand = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("write-back")) != null) {
            this.writeback = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("keep-time")) != null) {
            this.KeepFileTimes = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("show-warnings")) != null) {
            this.ShowWarnings = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("error-file")) != null) {
            this.errfile = Configuration.parseName(value);
        }
        if ((value = this._properties.getProperty("slide-style")) != null) {
            this.slidestyle = Configuration.parseName(value);
        }
        if ((value = this._properties.getProperty("new-inline-tags")) != null) {
            Configuration.parseInlineTagNames(value);
        }
        if ((value = this._properties.getProperty("new-blocklevel-tags")) != null) {
            Configuration.parseBlockTagNames(value);
        }
        if ((value = this._properties.getProperty("new-empty-tags")) != null) {
            Configuration.parseEmptyTagNames(value);
        }
        if ((value = this._properties.getProperty("new-pre-tags")) != null) {
            Configuration.parsePreTagNames(value);
        }
        if ((value = this._properties.getProperty("char-encoding")) != null) {
            this.CharEncoding = Configuration.parseCharEncoding(value);
        }
        if ((value = this._properties.getProperty("doctype")) != null) {
            this.docTypeStr = this.parseDocType(value);
        }
        if ((value = this._properties.getProperty("fix-backslash")) != null) {
            this.FixBackslash = Configuration.parseBool(value);
        }
        if ((value = this._properties.getProperty("gnu-emacs")) != null) {
            this.Emacs = Configuration.parseBool(value);
        }
    }

    public void adjust() {
        if (this.EncloseBlockText) {
            this.EncloseBodyText = true;
        }
        if (this.SmartIndent) {
            this.IndentContent = true;
        }
        if (this.wraplen == 0) {
            this.wraplen = Integer.MAX_VALUE;
        }
        if (this.Word2000) {
            TagTable.getDefaultTagTable().defineInlineTag("o:p");
        }
        if (this.xHTML) {
            this.XmlOut = true;
            this.UpperCaseTags = false;
            this.UpperCaseAttrs = false;
        }
        if (this.XmlTags) {
            this.XmlOut = true;
            this.XmlPIs = true;
        }
        if (this.XmlOut) {
            this.QuoteAmpersand = true;
            this.HideEndTags = false;
        }
    }

    private static int parseInt(String s) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            Report.badArgument(s);
            i = -1;
        }
        return i;
    }

    private static boolean parseBool(String s) {
        boolean b = false;
        if (s != null && s.length() > 0) {
            char c = s.charAt(0);
            if (c == 't' || c == 'T' || c == 'Y' || c == 'y' || c == '1') {
                b = true;
            } else if (c == 'f' || c == 'F' || c == 'N' || c == 'n' || c == '0') {
                b = false;
            } else {
                Report.badArgument(s);
            }
        }
        return b;
    }

    private static boolean parseInvBool(String s) {
        boolean b = false;
        if (s != null && s.length() > 0) {
            char c = s.charAt(0);
            if (c == 't' || c == 'T' || c == 'Y' || c == 'y') {
                b = true;
            } else if (c == 'f' || c == 'F' || c == 'N' || c == 'n') {
                b = false;
            } else {
                Report.badArgument(s);
            }
        }
        return !b;
    }

    private static String parseName(String s) {
        StringTokenizer t = new StringTokenizer(s);
        String rs = null;
        if (t.countTokens() >= 1) {
            rs = t.nextToken();
        } else {
            Report.badArgument(s);
        }
        return rs;
    }

    private static int parseCharEncoding(String s) {
        int result = 1;
        if (Lexer.wstrcasecmp(s, "ascii") == 0) {
            result = 1;
        } else if (Lexer.wstrcasecmp(s, "latin1") == 0) {
            result = 2;
        } else if (Lexer.wstrcasecmp(s, "raw") == 0) {
            result = 0;
        } else if (Lexer.wstrcasecmp(s, "utf8") == 0) {
            result = 3;
        } else if (Lexer.wstrcasecmp(s, "iso2022") == 0) {
            result = 4;
        } else if (Lexer.wstrcasecmp(s, "mac") == 0) {
            result = 5;
        } else {
            Report.badArgument(s);
        }
        return result;
    }

    private boolean parseIndent(String s) {
        boolean b = this.IndentContent;
        if (Lexer.wstrcasecmp(s, "yes") == 0) {
            b = true;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(s, "true") == 0) {
            b = true;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(s, "no") == 0) {
            b = false;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(s, "false") == 0) {
            b = false;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(s, "auto") == 0) {
            b = true;
            this.SmartIndent = true;
        } else {
            Report.badArgument(s);
        }
        return b;
    }

    private static void parseInlineTagNames(String s) {
        StringTokenizer t = new StringTokenizer(s, " \t\n\r,");
        while (t.hasMoreTokens()) {
            TagTable.getDefaultTagTable().defineInlineTag(t.nextToken());
        }
    }

    private static void parseBlockTagNames(String s) {
        StringTokenizer t = new StringTokenizer(s, " \t\n\r,");
        while (t.hasMoreTokens()) {
            TagTable.getDefaultTagTable().defineBlockTag(t.nextToken());
        }
    }

    private static void parseEmptyTagNames(String s) {
        StringTokenizer t = new StringTokenizer(s, " \t\n\r,");
        while (t.hasMoreTokens()) {
            TagTable.getDefaultTagTable().defineEmptyTag(t.nextToken());
        }
    }

    private static void parsePreTagNames(String s) {
        StringTokenizer t = new StringTokenizer(s, " \t\n\r,");
        while (t.hasMoreTokens()) {
            TagTable.getDefaultTagTable().definePreTag(t.nextToken());
        }
    }

    protected String parseDocType(String s) {
        if ((s = s.trim()).startsWith("\"")) {
            this.docTypeMode = 4;
            return s;
        }
        String word = "";
        StringTokenizer t = new StringTokenizer(s, " \t\n\r,");
        if (t.hasMoreTokens()) {
            word = t.nextToken();
        }
        this.docTypeMode = 1;
        if (Lexer.wstrcasecmp(word, "omit") == 0) {
            this.docTypeMode = 0;
        } else if (Lexer.wstrcasecmp(word, "strict") == 0) {
            this.docTypeMode = 2;
        } else if (Lexer.wstrcasecmp(word, "loose") == 0 || Lexer.wstrcasecmp(word, "transitional") == 0) {
            this.docTypeMode = 3;
        } else {
            Report.badArgument(s);
        }
        return null;
    }
}

