/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.MutableInteger;
import org.w3c.tidy.MutableObject;
import org.w3c.tidy.Node;
import org.w3c.tidy.PPrint;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.Style;
import org.w3c.tidy.StyleProp;
import org.w3c.tidy.TagTable;

public class Clean {
    private int classNum = 1;

    private static StyleProp insertProperty(StyleProp props, String name, String value) {
        StyleProp prev = null;
        StyleProp first = props;
        while (props != null) {
            int cmp = props.name.compareTo(name);
            if (cmp == 0) {
                return first;
            }
            if (cmp > 0) {
                StyleProp prop = new StyleProp(new String(name), new String(value), props);
                if (prev != null) {
                    prev.next = prop;
                } else {
                    first = prop;
                }
                return first;
            }
            prev = props;
            props = props.next;
        }
        StyleProp prop = new StyleProp(new String(name), new String(value));
        if (prev != null) {
            prev.next = prop;
        } else {
            first = prop;
        }
        return first;
    }

    /*
     * Unable to fully structure code
     */
    private static StyleProp createProps(StyleProp prop, String style) {
        value_start = 0;
        name_start = 0;
        name_start = 0;
        ** GOTO lbl30
        {
            ++name_start;
            do {
                if (name_start < style.length() && style.charAt(name_start) == ' ') continue block0;
                name_end = name_start;
                while (name_end < style.length()) {
                    if (style.charAt(name_end) == ':') {
                        value_start = name_end + 1;
                        break;
                    }
                    ++name_end;
                }
                if (name_end < style.length() && style.charAt(name_end) == ':') ** GOTO lbl18
                break block0;
lbl-1000:
                // 1 sources

                {
                    ++value_start;
lbl18:
                    // 2 sources

                    ** while (value_start < style.length() && style.charAt((int)value_start) == ' ')
                }
lbl19:
                // 1 sources

                value_end = value_start;
                more = false;
                while (value_end < style.length()) {
                    if (style.charAt(value_end) == ';') {
                        more = true;
                        break;
                    }
                    ++value_end;
                }
                prop = Clean.insertProperty(prop, style.substring(name_start, name_end), style.substring(value_start, value_end));
                if (!more) break block0;
                name_start = value_end + 1;
lbl30:
                // 2 sources

            } while (name_start < style.length());
        }
        return prop;
    }

    private static String createPropString(StyleProp props) {
        String style = "";
        int len = 0;
        StyleProp prop = props;
        while (prop != null) {
            len += prop.name.length() + 2;
            len += prop.value.length() + 2;
            prop = prop.next;
        }
        prop = props;
        while (prop != null) {
            style = style.concat(prop.name);
            style = style.concat(": ");
            style = style.concat(prop.value);
            if (prop.next == null) break;
            style = style.concat("; ");
            prop = prop.next;
        }
        return style;
    }

    private static String addProperty(String style, String property) {
        StyleProp prop = Clean.createProps(null, style);
        prop = Clean.createProps(prop, property);
        style = Clean.createPropString(prop);
        return style;
    }

    private String gensymClass(String tag) {
        String str = "c" + this.classNum;
        ++this.classNum;
        return str;
    }

    private String findStyle(Lexer lexer, String tag, String properties) {
        Style style = lexer.styles;
        while (style != null) {
            if (style.tag.equals(tag) && style.properties.equals(properties)) {
                return style.tagClass;
            }
            style = style.next;
        }
        lexer.styles = style = new Style(new String(tag), this.gensymClass(tag), new String(properties), lexer.styles);
        return style.tagClass;
    }

    private void style2Rule(Lexer lexer, Node node) {
        AttVal styleattr = node.getAttrByName("style");
        if (styleattr != null) {
            String classname = this.findStyle(lexer, node.element, styleattr.value);
            AttVal classattr = node.getAttrByName("class");
            if (classattr != null) {
                classattr.value = classattr.value + " " + classname;
                node.removeAttribute(styleattr);
            } else {
                styleattr.attribute = "class";
                styleattr.value = classname;
            }
        }
    }

    private static void addColorRule(Lexer lexer, String selector, String color) {
        if (color != null) {
            lexer.addStringLiteral(selector);
            lexer.addStringLiteral(" { color: ");
            lexer.addStringLiteral(color);
            lexer.addStringLiteral(" }\n");
        }
    }

    private static void cleanBodyAttrs(Lexer lexer, Node body) {
        String bgurl = null;
        String bgcolor = null;
        String color = null;
        AttVal attr = body.getAttrByName("background");
        if (attr != null) {
            bgurl = attr.value;
            attr.value = null;
            body.removeAttribute(attr);
        }
        if ((attr = body.getAttrByName("bgcolor")) != null) {
            bgcolor = attr.value;
            attr.value = null;
            body.removeAttribute(attr);
        }
        if ((attr = body.getAttrByName("text")) != null) {
            color = attr.value;
            attr.value = null;
            body.removeAttribute(attr);
        }
        if (bgurl != null || bgcolor != null || color != null) {
            lexer.addStringLiteral(" body {\n");
            if (bgurl != null) {
                lexer.addStringLiteral("  background-image: url(");
                lexer.addStringLiteral(bgurl);
                lexer.addStringLiteral(");\n");
            }
            if (bgcolor != null) {
                lexer.addStringLiteral("  background-color: ");
                lexer.addStringLiteral(bgcolor);
                lexer.addStringLiteral(";\n");
            }
            if (color != null) {
                lexer.addStringLiteral("  color: ");
                lexer.addStringLiteral(color);
                lexer.addStringLiteral(";\n");
            }
            lexer.addStringLiteral(" }\n");
        }
        if ((attr = body.getAttrByName("link")) != null) {
            Clean.addColorRule(lexer, " :link", attr.value);
            body.removeAttribute(attr);
        }
        if ((attr = body.getAttrByName("vlink")) != null) {
            Clean.addColorRule(lexer, " :visited", attr.value);
            body.removeAttribute(attr);
        }
        if ((attr = body.getAttrByName("alink")) != null) {
            Clean.addColorRule(lexer, " :active", attr.value);
            body.removeAttribute(attr);
        }
    }

    private static boolean niceBody(Lexer lexer, Node doc) {
        Node body = Node.findBody(doc);
        if (body != null && (body.getAttrByName("background") != null || body.getAttrByName("bgcolor") != null || body.getAttrByName("text") != null || body.getAttrByName("link") != null || body.getAttrByName("vlink") != null || body.getAttrByName("alink") != null)) {
            lexer.badLayout = (short)(lexer.badLayout | 0x10);
            return false;
        }
        return true;
    }

    private static void createStyleElement(Lexer lexer, Node doc) {
        if (lexer.styles == null && Clean.niceBody(lexer, doc)) {
            return;
        }
        Node node = lexer.newNode((short)5, null, 0, 0, new String("style"));
        node.implicit = true;
        AttVal av = new AttVal(null, null, 34, new String("type"), new String("text/css"));
        av.dict = AttributeTable.getDefaultAttributeTable().findAttribute(av);
        node.attributes = av;
        Node body = Node.findBody(doc);
        lexer.txtstart = lexer.lexsize;
        if (body != null) {
            Clean.cleanBodyAttrs(lexer, body);
        }
        Style style = lexer.styles;
        while (style != null) {
            lexer.addCharToLexer(32);
            lexer.addStringLiteral(style.tag);
            lexer.addCharToLexer(46);
            lexer.addStringLiteral(style.tagClass);
            lexer.addCharToLexer(32);
            lexer.addCharToLexer(123);
            lexer.addStringLiteral(style.properties);
            lexer.addCharToLexer(125);
            lexer.addCharToLexer(10);
            style = style.next;
        }
        lexer.txtend = lexer.lexsize;
        Node.insertNodeAtEnd(node, lexer.newNode((short)4, lexer.lexbuf, lexer.txtstart, lexer.txtend));
        Node head = Node.findHead(doc);
        if (head != null) {
            Node.insertNodeAtEnd(head, node);
        }
    }

    private static void fixNodeLinks(Node node) {
        if (node.prev != null) {
            node.prev.next = node;
        } else {
            node.parent.content = node;
        }
        if (node.next != null) {
            node.next.prev = node;
        } else {
            node.parent.last = node;
        }
        Node child = node.content;
        while (child != null) {
            child.parent = node;
            child = child.next;
        }
    }

    private static void stripOnlyChild(Node node) {
        Node child = node.content;
        node.content = child.content;
        node.last = child.last;
        child.content = null;
        child = node.content;
        while (child != null) {
            child.parent = node;
            child = child.next;
        }
    }

    private static void discardContainer(Node element, MutableObject pnode) {
        Node parent = element.parent;
        if (element.content != null) {
            element.last.next = element.next;
            if (element.next != null) {
                element.next.prev = element.last;
                element.last.next = element.next;
            } else {
                parent.last = element.last;
            }
            if (element.prev != null) {
                element.content.prev = element.prev;
                element.prev.next = element.content;
            } else {
                parent.content = element.content;
            }
            Node node = element.content;
            while (node != null) {
                node.parent = parent;
                node = node.next;
            }
            pnode.setObject(element.content);
        } else {
            if (element.next != null) {
                element.next.prev = element.prev;
            } else {
                parent.last = element.prev;
            }
            if (element.prev != null) {
                element.prev.next = element.next;
            } else {
                parent.content = element.next;
            }
            pnode.setObject(element.next);
        }
        element.next = null;
        element.content = null;
    }

    private static void addStyleProperty(Node node, String property) {
        AttVal av = node.attributes;
        while (av != null) {
            if (av.attribute.equals("style")) break;
            av = av.next;
        }
        if (av != null) {
            String s;
            av.value = s = Clean.addProperty(av.value, property);
        } else {
            av = new AttVal(node.attributes, null, 34, new String("style"), new String(property));
            av.dict = AttributeTable.getDefaultAttributeTable().findAttribute(av);
            node.attributes = av;
        }
    }

    private static String mergeProperties(String s1, String s2) {
        StyleProp prop = Clean.createProps(null, s1);
        prop = Clean.createProps(prop, s2);
        String s = Clean.createPropString(prop);
        return s;
    }

    private static void mergeStyles(Node node, Node child) {
        String s2 = null;
        AttVal av = child.attributes;
        while (av != null) {
            if (av.attribute.equals("style")) {
                s2 = av.value;
                break;
            }
            av = av.next;
        }
        String s1 = null;
        av = node.attributes;
        while (av != null) {
            if (av.attribute.equals("style")) {
                s1 = av.value;
                break;
            }
            av = av.next;
        }
        if (s1 != null) {
            if (s2 != null) {
                String style;
                av.value = style = Clean.mergeProperties(s1, s2);
            }
        } else if (s2 != null) {
            av = new AttVal(node.attributes, null, 34, new String("style"), new String(s2));
            av.dict = AttributeTable.getDefaultAttributeTable().findAttribute(av);
            node.attributes = av;
        }
    }

    private static String fontSize2Name(String size) {
        String[] sizes = new String[]{"60%", "70%", "80%", null, "120%", "150%", "200%"};
        if (size.length() > 0 && '0' <= size.charAt(0) && size.charAt(0) <= '6') {
            int n = size.charAt(0) - 48;
            return sizes[n];
        }
        if (size.length() > 0 && size.charAt(0) == '-') {
            if (size.length() > 1 && '0' <= size.charAt(1) && size.charAt(1) <= '6') {
                int n = size.charAt(1) - 48;
                double x = 1.0;
                while (n > 0) {
                    x *= 0.8;
                    --n;
                }
                String buf = "" + (int)(x *= 100.0) + "%";
                return buf;
            }
            return "smaller";
        }
        if (size.length() > 1 && '0' <= size.charAt(1) && size.charAt(1) <= '6') {
            int n = size.charAt(1) - 48;
            double x = 1.0;
            while (n > 0) {
                x *= 1.2;
                --n;
            }
            String buf = "" + (int)(x *= 100.0) + "%";
            return buf;
        }
        return "larger";
    }

    private static void addFontFace(Node node, String face) {
        Clean.addStyleProperty(node, "font-family: " + face);
    }

    private static void addFontSize(Node node, String size) {
        if (size.equals("6") && node.tag == TagTable.tagP) {
            node.element = new String("h1");
            TagTable.getDefaultTagTable().findTag(node);
            return;
        }
        if (size.equals("5") && node.tag == TagTable.tagP) {
            node.element = new String("h2");
            TagTable.getDefaultTagTable().findTag(node);
            return;
        }
        if (size.equals("4") && node.tag == TagTable.tagP) {
            node.element = new String("h3");
            TagTable.getDefaultTagTable().findTag(node);
            return;
        }
        String value = Clean.fontSize2Name(size);
        if (value != null) {
            Clean.addStyleProperty(node, "font-size: " + value);
        }
    }

    private static void addFontColor(Node node, String color) {
        Clean.addStyleProperty(node, "color: " + color);
    }

    private static void addAlign(Node node, String align) {
        Clean.addStyleProperty(node, "text-align: " + align.toLowerCase());
    }

    private static void addFontStyles(Node node, AttVal av) {
        while (av != null) {
            if (av.attribute.equals("face")) {
                Clean.addFontFace(node, av.value);
            } else if (av.attribute.equals("size")) {
                Clean.addFontSize(node, av.value);
            } else if (av.attribute.equals("color")) {
                Clean.addFontColor(node, av.value);
            }
            av = av.next;
        }
    }

    private static void textAlign(Lexer lexer, Node node) {
        AttVal prev = null;
        AttVal av = node.attributes;
        while (av != null) {
            if (av.attribute.equals("align")) {
                if (prev != null) {
                    prev.next = av.next;
                } else {
                    node.attributes = av.next;
                }
                if (av.value == null) break;
                Clean.addAlign(node, av.value);
                break;
            }
            prev = av;
            av = av.next;
        }
    }

    private static boolean dir2Div(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag == TagTable.tagDir || node.tag == TagTable.tagUl || node.tag == TagTable.tagOl) {
            Node child = node.content;
            if (child == null) {
                return false;
            }
            if (child.next != null) {
                return false;
            }
            if (child.tag != TagTable.tagLi) {
                return false;
            }
            if (!child.implicit) {
                return false;
            }
            node.tag = TagTable.tagDiv;
            node.element = new String("div");
            Clean.addStyleProperty(node, "margin-left: 2em");
            Clean.stripOnlyChild(node);
            return true;
        }
        return false;
    }

    private static boolean center2Div(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag == TagTable.tagCenter) {
            if (lexer.configuration.DropFontTags) {
                if (node.content != null) {
                    Node last = node.last;
                    Node parent = node.parent;
                    Clean.discardContainer(node, pnode);
                    node = lexer.inferredTag("br");
                    if (last.next != null) {
                        last.next.prev = node;
                    }
                    node.next = last.next;
                    last.next = node;
                    node.prev = last;
                    if (parent.last == last) {
                        parent.last = node;
                    }
                    node.parent = parent;
                } else {
                    Node prev = node.prev;
                    Node next = node.next;
                    Node parent = node.parent;
                    Clean.discardContainer(node, pnode);
                    node = lexer.inferredTag("br");
                    node.next = next;
                    node.prev = prev;
                    node.parent = parent;
                    if (next != null) {
                        next.prev = node;
                    } else {
                        parent.last = node;
                    }
                    if (prev != null) {
                        prev.next = node;
                    } else {
                        parent.content = node;
                    }
                }
                return true;
            }
            node.tag = TagTable.tagDiv;
            node.element = new String("div");
            Clean.addStyleProperty(node, "text-align: center");
            return true;
        }
        return false;
    }

    private static boolean mergeDivs(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag != TagTable.tagDiv) {
            return false;
        }
        Node child = node.content;
        if (child == null) {
            return false;
        }
        if (child.tag != TagTable.tagDiv) {
            return false;
        }
        if (child.next != null) {
            return false;
        }
        Clean.mergeStyles(node, child);
        Clean.stripOnlyChild(node);
        return true;
    }

    private static boolean nestedList(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag == TagTable.tagUl || node.tag == TagTable.tagOl) {
            Node child = node.content;
            if (child == null) {
                return false;
            }
            if (child.next != null) {
                return false;
            }
            Node list = child.content;
            if (list == null) {
                return false;
            }
            if (list.tag != node.tag) {
                return false;
            }
            pnode.setObject(node.next);
            list.prev = node.prev;
            list.next = node.next;
            list.parent = node.parent;
            Clean.fixNodeLinks(list);
            child.content = null;
            node.content = null;
            node.next = null;
            if (list.prev != null) {
                node = list;
                list = node.prev;
                if (list.tag == TagTable.tagUl || list.tag == TagTable.tagOl) {
                    list.next = node.next;
                    if (list.next != null) {
                        list.next.prev = list;
                    }
                    node.parent = child = list.last;
                    node.next = null;
                    node.prev = child.last;
                    Clean.fixNodeLinks(node);
                }
            }
            Clean.cleanNode(lexer, node);
            return true;
        }
        return false;
    }

    private static boolean blockStyle(Lexer lexer, Node node, MutableObject pnode) {
        if ((node.tag.model & 0xE8) != 0 && node.tag != TagTable.tagTable && node.tag != TagTable.tagTr && node.tag != TagTable.tagLi) {
            Node child;
            if (node.tag != TagTable.tagCaption) {
                Clean.textAlign(lexer, node);
            }
            if ((child = node.content) == null) {
                return false;
            }
            if (child.next != null) {
                return false;
            }
            if (child.tag == TagTable.tagB) {
                Clean.mergeStyles(node, child);
                Clean.addStyleProperty(node, "font-weight: bold");
                Clean.stripOnlyChild(node);
                return true;
            }
            if (child.tag == TagTable.tagI) {
                Clean.mergeStyles(node, child);
                Clean.addStyleProperty(node, "font-style: italic");
                Clean.stripOnlyChild(node);
                return true;
            }
            if (child.tag == TagTable.tagFont) {
                Clean.mergeStyles(node, child);
                Clean.addFontStyles(node, child.attributes);
                Clean.stripOnlyChild(node);
                return true;
            }
        }
        return false;
    }

    private static boolean inlineStyle(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag != TagTable.tagFont && (node.tag.model & 0x210) != 0) {
            Node child = node.content;
            if (child == null) {
                return false;
            }
            if (child.next != null) {
                return false;
            }
            if (child.tag == TagTable.tagB && lexer.configuration.LogicalEmphasis) {
                Clean.mergeStyles(node, child);
                Clean.addStyleProperty(node, "font-weight: bold");
                Clean.stripOnlyChild(node);
                return true;
            }
            if (child.tag == TagTable.tagI && lexer.configuration.LogicalEmphasis) {
                Clean.mergeStyles(node, child);
                Clean.addStyleProperty(node, "font-style: italic");
                Clean.stripOnlyChild(node);
                return true;
            }
            if (child.tag == TagTable.tagFont) {
                Clean.mergeStyles(node, child);
                Clean.addFontStyles(node, child.attributes);
                Clean.stripOnlyChild(node);
                return true;
            }
        }
        return false;
    }

    private static boolean font2Span(Lexer lexer, Node node, MutableObject pnode) {
        if (node.tag == TagTable.tagFont) {
            if (lexer.configuration.DropFontTags) {
                Clean.discardContainer(node, pnode);
                return false;
            }
            if (node.parent.content == node && node.next == null) {
                return false;
            }
            Clean.addFontStyles(node, node.attributes);
            AttVal av = node.attributes;
            AttVal style = null;
            while (av != null) {
                AttVal next = av.next;
                if (av.attribute.equals("style")) {
                    av.next = null;
                    style = av;
                }
                av = next;
            }
            node.attributes = style;
            node.tag = TagTable.tagSpan;
            node.element = new String("span");
            return true;
        }
        return false;
    }

    private static Node cleanNode(Lexer lexer, Node node) {
        Node next = null;
        MutableObject o = new MutableObject();
        boolean b = false;
        next = node;
        while (node.isElement()) {
            o.setObject(next);
            b = Clean.dir2Div(lexer, node, o);
            next = (Node)o.getObject();
            if (!b) {
                b = Clean.nestedList(lexer, node, o);
                next = (Node)o.getObject();
                if (!b) {
                    b = Clean.center2Div(lexer, node, o);
                    next = (Node)o.getObject();
                    if (!b) {
                        b = Clean.mergeDivs(lexer, node, o);
                        next = (Node)o.getObject();
                        if (!b) {
                            b = Clean.blockStyle(lexer, node, o);
                            next = (Node)o.getObject();
                            if (!b) {
                                b = Clean.inlineStyle(lexer, node, o);
                                next = (Node)o.getObject();
                                if (!b) {
                                    b = Clean.font2Span(lexer, node, o);
                                    next = (Node)o.getObject();
                                    if (!b) break;
                                }
                            }
                        }
                    }
                }
            }
            node = next;
        }
        return next;
    }

    private static Node createStyleProperties(Lexer lexer, Node node) {
        if (node.content != null) {
            Node child = node.content;
            while (child != null) {
                child = Clean.createStyleProperties(lexer, child);
                child = child.next;
            }
        }
        return Clean.cleanNode(lexer, node);
    }

    private void defineStyleRules(Lexer lexer, Node node) {
        if (node.content != null) {
            Node child = node.content;
            while (child != null) {
                this.defineStyleRules(lexer, child);
                child = child.next;
            }
        }
        this.style2Rule(lexer, node);
    }

    public void cleanTree(Lexer lexer, Node doc) {
        doc = Clean.createStyleProperties(lexer, doc);
        if (!lexer.configuration.MakeClean) {
            this.defineStyleRules(lexer, doc);
            Clean.createStyleElement(lexer, doc);
        }
    }

    public static void nestedEmphasis(Node node) {
        MutableObject o = new MutableObject();
        while (node != null) {
            Node next = node.next;
            if ((node.tag == TagTable.tagB || node.tag == TagTable.tagI) && node.parent != null && node.parent.tag == node.tag) {
                o.setObject(next);
                Clean.discardContainer(node, o);
                node = next = (Node)o.getObject();
                continue;
            }
            if (node.content != null) {
                Clean.nestedEmphasis(node.content);
            }
            node = next;
        }
    }

    public static void emFromI(Node node) {
        while (node != null) {
            if (node.tag == TagTable.tagI) {
                node.element = new String(TagTable.tagEm.name);
                node.tag = TagTable.tagEm;
            } else if (node.tag == TagTable.tagB) {
                node.element = new String(TagTable.tagStrong.name);
                node.tag = TagTable.tagStrong;
            }
            if (node.content != null) {
                Clean.emFromI(node.content);
            }
            node = node.next;
        }
    }

    public static void list2BQ(Node node) {
        while (node != null) {
            if (node.content != null) {
                Clean.list2BQ(node.content);
            }
            if (node.tag != null && node.tag.parser == ParserImpl.getParseList() && node.hasOneChild() && node.content.implicit) {
                Clean.stripOnlyChild(node);
                node.element = new String(TagTable.tagBlockquote.name);
                node.tag = TagTable.tagBlockquote;
                node.implicit = true;
            }
            node = node.next;
        }
    }

    public static void bQ2Div(Node node) {
        while (node != null) {
            if (node.tag == TagTable.tagBlockquote && node.implicit) {
                int indent = 1;
                while (node.hasOneChild() && node.content.tag == TagTable.tagBlockquote && node.implicit) {
                    ++indent;
                    Clean.stripOnlyChild(node);
                }
                if (node.content != null) {
                    Clean.bQ2Div(node.content);
                }
                String indent_buf = "margin-left: " + new Integer(2 * indent).toString() + "em";
                node.element = new String(TagTable.tagDiv.name);
                node.tag = TagTable.tagDiv;
                node.addAttribute("style", indent_buf);
            } else if (node.content != null) {
                Clean.bQ2Div(node.content);
            }
            node = node.next;
        }
    }

    public static Node pruneSection(Lexer lexer, Node node) {
        while (true) {
            if ((node = Node.discardElement(node)) == null) {
                return null;
            }
            if (node.type != 9) continue;
            if (Lexer.getString(node.textarray, node.start, 2).equals("if")) {
                node = Clean.pruneSection(lexer, node);
                continue;
            }
            if (Lexer.getString(node.textarray, node.start, 5).equals("endif")) break;
        }
        node = Node.discardElement(node);
        return node;
    }

    public static void dropSections(Lexer lexer, Node node) {
        while (node != null) {
            if (node.type == 9) {
                if (Lexer.getString(node.textarray, node.start, 2).equals("if")) {
                    node = Clean.pruneSection(lexer, node);
                    continue;
                }
                node = Node.discardElement(node);
                continue;
            }
            if (node.content != null) {
                Clean.dropSections(lexer, node.content);
            }
            node = node.next;
        }
    }

    public static void purgeAttributes(Node node) {
        AttVal attr = node.attributes;
        AttVal next = null;
        AttVal prev = null;
        while (attr != null) {
            next = attr.next;
            if (attr.attribute != null && attr.value != null && attr.attribute.equals("class") && attr.value.equals("Code")) {
                prev = attr;
            } else if (attr.attribute != null && (attr.attribute.equals("class") || attr.attribute.equals("style") || attr.attribute.equals("lang") || attr.attribute.startsWith("x:") || (attr.attribute.equals("height") || attr.attribute.equals("width")) && (node.tag == TagTable.tagTd || node.tag == TagTable.tagTr || node.tag == TagTable.tagTh))) {
                if (prev != null) {
                    prev.next = next;
                } else {
                    node.attributes = next;
                }
            } else {
                prev = attr;
            }
            attr = next;
        }
    }

    public static Node stripSpan(Lexer lexer, Node span) {
        Node node;
        Node prev = null;
        Clean.cleanWord2000(lexer, span.content);
        Node content = span.content;
        if (span.prev != null) {
            prev = span.prev;
        } else if (content != null) {
            node = content;
            content = content.next;
            Node.removeNode(node);
            Node.insertNodeBeforeElement(span, node);
            prev = node;
        }
        while (content != null) {
            node = content;
            content = content.next;
            Node.removeNode(node);
            Node.insertNodeAfterElement(prev, node);
            prev = node;
        }
        if (span.next == null) {
            span.parent.last = prev;
        }
        node = span.next;
        span.content = null;
        Node.discardElement(span);
        return node;
    }

    private static void normalizeSpaces(Lexer lexer, Node node) {
        while (node != null) {
            if (node.content != null) {
                Clean.normalizeSpaces(lexer, node.content);
            }
            if (node.type == 4) {
                MutableInteger c = new MutableInteger();
                int p = node.start;
                int i = node.start;
                while (i < node.end) {
                    c.value = node.textarray[i];
                    if (c.value > 127) {
                        i += PPrint.getUTF8(node.textarray, i, c);
                    }
                    if (c.value == 160) {
                        c.value = 32;
                    }
                    p = PPrint.putUTF8(node.textarray, p, c.value);
                    ++i;
                }
            }
            node = node.next;
        }
    }

    public static void cleanWord2000(Lexer lexer, Node node) {
        Node list = null;
        while (node != null) {
            AttVal attr;
            if (node.tag == TagTable.tagStyle || node.tag == TagTable.tagMeta || node.type == 2) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.tag == TagTable.tagSpan) {
                node = Clean.stripSpan(lexer, node);
                continue;
            }
            if (node.tag == TagTable.tagHtml && node.getAttrByName("xmlns:o") == null) {
                return;
            }
            if (node.tag == TagTable.tagLink && (attr = node.getAttrByName("rel")) != null && attr.value != null && attr.value.equals("File-List")) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.content == null && node.tag == TagTable.tagP) {
                node = Node.discardElement(node);
                continue;
            }
            if (node.tag == TagTable.tagP) {
                attr = node.getAttrByName("class");
                if (attr != null && attr.value != null && attr.value.equals("MsoListBullet")) {
                    Node.coerceNode(lexer, node, TagTable.tagLi);
                    if (list == null || list.tag != TagTable.tagUl) {
                        list = lexer.inferredTag("ul");
                        Node.insertNodeBeforeElement(node, list);
                    }
                    Clean.purgeAttributes(node);
                    if (node.content != null) {
                        Clean.cleanWord2000(lexer, node.content);
                    }
                    Node.removeNode(node);
                    Node.insertNodeAtEnd(list, node);
                    node = list.next;
                } else if (attr != null && attr.value != null && attr.value.equals("Code")) {
                    Node br = lexer.newLineNode();
                    Clean.normalizeSpaces(lexer, node);
                    if (list == null || list.tag != TagTable.tagPre) {
                        list = lexer.inferredTag("pre");
                        Node.insertNodeBeforeElement(node, list);
                    }
                    Node.removeNode(node);
                    Node.insertNodeAtEnd(list, node);
                    Clean.stripSpan(lexer, node);
                    Node.insertNodeAtEnd(list, br);
                    node = list.next;
                } else {
                    list = null;
                }
            } else {
                list = null;
            }
            if (node.type == 5 || node.type == 7) {
                Clean.purgeAttributes(node);
            }
            if (node.content != null) {
                Clean.cleanWord2000(lexer, node.content);
            }
            node = node.next;
        }
    }

    public static boolean isWord2000(Node root) {
        Node html = root.findHTML();
        return html != null && html.getAttrByName("xmlns:o") != null;
    }
}

