/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.commons.lang.exception.Nestable;
import org.apache.commons.lang.exception.NestableDelegate;

public class NestableRuntimeException
extends RuntimeException
implements Nestable {
    protected NestableDelegate delegate = new NestableDelegate(this);
    private Throwable cause = null;

    public NestableRuntimeException() {
    }

    public NestableRuntimeException(String msg) {
        super(msg);
    }

    public NestableRuntimeException(Throwable cause) {
        this.cause = cause;
    }

    public NestableRuntimeException(String msg, Throwable cause) {
        super(msg);
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public int getLength() {
        return this.delegate.getThrowableCount();
    }

    public String getMessage() {
        String causeMsg;
        StringBuffer msg = new StringBuffer();
        String ourMsg = super.getMessage();
        if (ourMsg != null) {
            msg.append(ourMsg);
        }
        if (this.cause != null && (causeMsg = this.cause.getMessage()) != null) {
            if (ourMsg != null) {
                msg.append(": ");
            }
            msg.append(causeMsg);
        }
        return msg.length() > 0 ? msg.toString() : null;
    }

    public String getMessage(int index) {
        if (index == 0) {
            return super.getMessage();
        }
        return this.delegate.getMessage(index);
    }

    public String[] getMessages() {
        return this.delegate.getMessages();
    }

    public Throwable getThrowable(int index) {
        return this.delegate.getThrowable(index);
    }

    public int getThrowableCount() {
        return this.delegate.getThrowableCount();
    }

    public Throwable[] getThrowables() {
        return this.delegate.getThrowables();
    }

    public int indexOfThrowable(Class type) {
        return this.delegate.indexOfThrowable(type, 0);
    }

    public int indexOfThrowable(Class type, int fromIndex) {
        return this.delegate.indexOfThrowable(type, fromIndex);
    }

    public int indexOfThrowable(int pos, Class type) {
        if (pos < 0) {
            pos = 0;
        } else if (pos >= this.getThrowableCount()) {
            pos = this.getThrowableCount() - 1;
        }
        return this.delegate.indexOfThrowable(type, pos);
    }

    public void printStackTrace() {
        this.delegate.printStackTrace();
    }

    public void printStackTrace(PrintStream out) {
        this.delegate.printStackTrace(out);
    }

    public void printStackTrace(PrintWriter out) {
        this.delegate.printStackTrace(out);
    }

    public final void printPartialStackTrace(PrintWriter out) {
        super.printStackTrace(out);
    }
}

