/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.util;

public class NoCallStackClassLoader
extends ClassLoader {
    private final String[] classNames;
    private final byte[][] byteCodes;
    private final String[] referencedClassNames;
    private final ClassLoader referencedClassLoader;

    public NoCallStackClassLoader(String string, byte[] byArray, String[] stringArray, ClassLoader classLoader) {
        this(new String[]{string}, new byte[][]{byArray}, stringArray, classLoader);
    }

    public NoCallStackClassLoader(String[] stringArray, byte[][] byArray, String[] stringArray2, ClassLoader classLoader) {
        super(null);
        int n;
        if (stringArray == null || stringArray.length == 0 || byArray == null || stringArray.length != byArray.length || stringArray2 == null || classLoader == null) {
            throw new IllegalArgumentException();
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null && byArray[n] != null) continue;
            throw new IllegalArgumentException();
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (stringArray2[n] != null) continue;
            throw new IllegalArgumentException();
        }
        this.classNames = stringArray;
        this.byteCodes = byArray;
        this.referencedClassNames = stringArray2;
        this.referencedClassLoader = classLoader;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        int n;
        for (n = 0; n < this.classNames.length; ++n) {
            if (!string.equals(this.classNames[n])) continue;
            return this.defineClass(this.classNames[n], this.byteCodes[n], 0, this.byteCodes[n].length);
        }
        for (n = 0; n < this.referencedClassNames.length; ++n) {
            if (!string.equals(this.referencedClassNames[n])) continue;
            return this.referencedClassLoader.loadClass(string);
        }
        throw new ClassNotFoundException(string);
    }

    public static byte[] stringToBytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }
}

