/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.DefaultSVGContext;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.renderer.StaticRendererFactory;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscoderSupport;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.transcoder.keys.StringKey;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFImageElementBridge;
import org.apache.fop.svg.PDFTextPainter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PDFTranscoder
extends XMLAbstractTranscoder {
    public static final TranscodingHints.Key KEY_STROKE_TEXT = new StringKey();
    protected UserAgent userAgent = new ImageTranscoderUserAgent();
    protected static final Set FEATURES = new HashSet();

    static {
        FEATURES.add("org.w3c.svg");
        FEATURES.add("org.w3c.svg.lang");
        FEATURES.add("org.w3c.svg.static");
    }

    public PDFTranscoder() {
        ((TranscoderSupport)this).hints.put((Object)XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, (Object)"http://www.w3.org/2000/svg");
        ((TranscoderSupport)this).hints.put((Object)XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT, (Object)"svg");
        ((TranscoderSupport)this).hints.put((Object)XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION, (Object)SVGDOMImplementation.getDOMImplementation());
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation, String string) {
        return new SAXSVGDocumentFactory(string);
    }

    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        AffineTransform affineTransform;
        float f;
        float f2;
        GraphicsNode graphicsNode;
        if (!(document instanceof SVGOMDocument)) {
            throw new TranscoderException(Messages.formatMessage((String)"notsvg", null));
        }
        SVGDocument sVGDocument = (SVGDocument)document;
        SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
        String string2 = (String)((TranscoderSupport)this).hints.get((Object)XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
        DefaultSVGContext defaultSVGContext = new DefaultSVGContext();
        defaultSVGContext.setPixelToMM(this.userAgent.getPixelToMM());
        ((SVGOMDocument)document).setSVGContext((SVGContext)defaultSVGContext);
        boolean bl = true;
        if (((TranscoderSupport)this).hints.containsKey((Object)KEY_STROKE_TEXT)) {
            bl = (Boolean)((TranscoderSupport)this).hints.get((Object)KEY_STROKE_TEXT);
        }
        GVTBuilder gVTBuilder = new GVTBuilder();
        StaticRendererFactory staticRendererFactory = new StaticRendererFactory();
        BridgeContext bridgeContext = new BridgeContext(this.userAgent);
        Object object = null;
        object = new StrokingTextPainter();
        bridgeContext.setTextPainter((TextPainter)object);
        PDFAElementBridge pDFAElementBridge = new PDFAElementBridge();
        AffineTransform affineTransform2 = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        pDFAElementBridge.setCurrentTransform(affineTransform2);
        bridgeContext.putBridge((Bridge)pDFAElementBridge);
        bridgeContext.putBridge((Bridge)new PDFImageElementBridge());
        try {
            graphicsNode = gVTBuilder.build(bridgeContext, (Document)sVGDocument);
        }
        catch (BridgeException bridgeException) {
            throw new TranscoderException((Exception)((Object)bridgeException));
        }
        float f3 = (float)bridgeContext.getDocumentSize().getWidth();
        float f4 = (float)bridgeContext.getDocumentSize().getHeight();
        bridgeContext = null;
        gVTBuilder = null;
        float f5 = -1.0f;
        if (((TranscoderSupport)this).hints.containsKey((Object)ImageTranscoder.KEY_WIDTH)) {
            f5 = ((Float)((TranscoderSupport)this).hints.get((Object)ImageTranscoder.KEY_WIDTH)).floatValue();
        }
        float f6 = -1.0f;
        if (((TranscoderSupport)this).hints.containsKey((Object)ImageTranscoder.KEY_HEIGHT)) {
            f6 = ((Float)((TranscoderSupport)this).hints.get((Object)ImageTranscoder.KEY_HEIGHT)).floatValue();
        }
        if (f5 > 0.0f && f6 > 0.0f) {
            f2 = f5;
            f = f6;
        } else if (f6 > 0.0f) {
            f2 = f3 * f6 / f4;
            f = f6;
        } else if (f5 > 0.0f) {
            f2 = f5;
            f = f4 * f5 / f3;
        } else {
            f2 = f3;
            f = f4;
        }
        String string3 = null;
        try {
            string3 = new URL(string).getRef();
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            affineTransform = ViewBox.getViewTransform((String)string3, (Element)sVGSVGElement, (float)f2, (float)f);
        }
        catch (BridgeException bridgeException) {
            throw new TranscoderException((Exception)((Object)bridgeException));
        }
        if (affineTransform.isIdentity() && (f2 != f3 || f != f4)) {
            float f7 = Math.max(f3, f4);
            float f8 = Math.max(f2, f);
            float f9 = f8 / f7;
            affineTransform = AffineTransform.getScaleInstance(f9, f9);
        }
        if (((TranscoderSupport)this).hints.containsKey((Object)ImageTranscoder.KEY_AOI)) {
            Rectangle2D rectangle2D = (Rectangle2D)((TranscoderSupport)this).hints.get((Object)ImageTranscoder.KEY_AOI);
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
            AffineTransform affineTransform3 = new AffineTransform();
            double d = (double)f2 / rectangle2D.getWidth();
            double d2 = (double)f / rectangle2D.getHeight();
            affineTransform3.scale(d, d2);
            double d3 = -rectangle2D.getX();
            double d4 = -rectangle2D.getY();
            affineTransform3.translate(d3, d4);
            affineTransform.preConcatenate(affineTransform3);
        }
        int n = (int)f2;
        int n2 = (int)f;
        PDFDocumentGraphics2D pDFDocumentGraphics2D = new PDFDocumentGraphics2D(bl, transcoderOutput.getOutputStream(), n, n2);
        pDFDocumentGraphics2D.setSVGDimension(f3, f4);
        affineTransform2.setTransform(1.0, 0.0, 0.0, -1.0, 0.0, f);
        if (!bl) {
            object = new PDFTextPainter(pDFDocumentGraphics2D.getFontState());
            bridgeContext.setTextPainter((TextPainter)object);
        }
        if (((TranscoderSupport)this).hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
            pDFDocumentGraphics2D.setBackgroundColor((Color)((TranscoderSupport)this).hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
        }
        pDFDocumentGraphics2D.setGraphicContext(new GraphicContext());
        graphicsNode.paint((Graphics2D)((Object)pDFDocumentGraphics2D));
        try {
            pDFDocumentGraphics2D.finish();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TranscoderException(exception);
        }
    }

    protected class ImageTranscoderUserAgent
    implements UserAgent {
        protected ImageTranscoderUserAgent() {
        }

        public void displayError(Exception exception) {
            try {
                PDFTranscoder.this.getErrorHandler().error(new TranscoderException(exception));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayError(String string) {
            try {
                PDFTranscoder.this.getErrorHandler().error(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String string) {
            try {
                PDFTranscoder.this.getErrorHandler().warning(new TranscoderException(string));
            }
            catch (TranscoderException transcoderException) {
                throw new RuntimeException();
            }
        }

        public Point getClientAreaLocationOnScreen() {
            return new Point();
        }

        public EventDispatcher getEventDispatcher() {
            return null;
        }

        public String getLanguages() {
            if (PDFTranscoder.this.getTranscodingHints().containsKey((Object)ImageTranscoder.KEY_LANGUAGE)) {
                return (String)PDFTranscoder.this.getTranscodingHints().get((Object)ImageTranscoder.KEY_LANGUAGE);
            }
            return "en";
        }

        public String getMedia() {
            return "";
        }

        public float getPixelToMM() {
            if (PDFTranscoder.this.getTranscodingHints().containsKey((Object)ImageTranscoder.KEY_PIXEL_TO_MM)) {
                return ((Float)PDFTranscoder.this.getTranscodingHints().get((Object)ImageTranscoder.KEY_PIXEL_TO_MM)).floatValue();
            }
            return 0.26458332f;
        }

        public AffineTransform getTransform() {
            return null;
        }

        public String getUserStyleSheetURI() {
            return (String)PDFTranscoder.this.getTranscodingHints().get((Object)ImageTranscoder.KEY_USER_STYLESHEET_URI);
        }

        public Dimension2D getViewportSize() {
            return new Dimension(400, 400);
        }

        public String getXMLParserClassName() {
            if (PDFTranscoder.this.getTranscodingHints().containsKey((Object)XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME)) {
                return (String)PDFTranscoder.this.getTranscodingHints().get((Object)XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public void handleElement(Element element, Object object) {
        }

        public boolean hasFeature(String string) {
            return FEATURES.contains(string);
        }

        public boolean isXMLParserValidating() {
            return true;
        }

        public void openLink(SVGAElement sVGAElement) {
        }

        public void registerExtension(BridgeExtension bridgeExtension) {
        }

        public void runThread(Thread thread) {
        }

        public void setSVGCursor(Cursor cursor) {
        }

        public boolean supportExtension(String string) {
            return false;
        }
    }
}

