/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.apps.FOPException;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.PDFGraphics2D;

public class PDFDocumentGraphics2D
extends PDFGraphics2D {
    OutputStream stream;
    PDFStream pdfStream;
    int width;
    int height;
    FontInfo fontInfo = null;

    public PDFDocumentGraphics2D(PDFDocumentGraphics2D pDFDocumentGraphics2D) {
        super(pDFDocumentGraphics2D);
    }

    public PDFDocumentGraphics2D(boolean bl, OutputStream outputStream, int n, int n2) {
        super(bl);
        if (!bl) {
            this.fontInfo = new FontInfo();
            FontSetup.setup(this.fontInfo);
            try {
                this.fontState = new FontState(this.fontInfo, "Helvetica", "normal", "normal", 12, 0);
            }
            catch (FOPException fOPException) {}
        }
        this.standalone = true;
        this.stream = outputStream;
        this.pdfDoc = new PDFDocument();
        this.pdfDoc.setProducer("FOP SVG Renderer");
        this.pdfStream = this.pdfDoc.makeStream();
        this.width = n;
        this.height = n2;
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.currentYPosition = 0;
        this.currentXPosition = 0;
        this.currentStream.write("1 0 0 -1 0 " + n2 + " cm\n");
    }

    public Graphics create() {
        return new PDFDocumentGraphics2D(this);
    }

    public void drawString(String string, float f, float f2) {
        if (this.textAsShapes) {
            Font font = super.getFont();
            FontRenderContext fontRenderContext = super.getFontRenderContext();
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string);
            Shape shape = glyphVector.getOutline(f, f2);
            super.fill(shape);
        } else {
            super.drawString(string, f, f2);
        }
    }

    public void finish() throws IOException {
        this.pdfStream.add(this.getString());
        PDFResources pDFResources = this.pdfDoc.getResources();
        PDFPage pDFPage = this.pdfDoc.makePage(pDFResources, this.pdfStream, this.width, this.height, null);
        if (this.currentAnnotList != null) {
            pDFPage.setAnnotList(this.currentAnnotList);
        }
        if (this.fontInfo != null) {
            FontSetup.addToResources(this.pdfDoc, this.fontInfo);
        }
        this.pdfDoc.outputHeader(this.stream);
        this.pdfDoc.output(this.stream);
        this.pdfDoc.outputTrailer(this.stream);
    }

    public FontState getFontState() {
        return this.fontState;
    }

    public PDFDocument getPDFDocument() {
        return this.pdfDoc;
    }

    public void setBackgroundColor(Color color) {
        Color color2 = color;
        this.currentColour = new PDFColor(color2.getRed(), color2.getGreen(), color2.getBlue());
        this.currentStream.write("q\n");
        this.currentStream.write(this.currentColour.getColorSpaceOut(true));
        this.currentStream.write("0 0 " + this.width + " " + this.height + " re\n");
        this.currentStream.write("f\n");
        this.currentStream.write("Q\n");
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        this.gc = graphicContext;
    }

    public void setSVGDimension(float f, float f2) {
        this.currentStream.write(PDFNumber.doubleOut((float)this.width / f) + " 0 0 " + PDFNumber.doubleOut((float)this.height / f2) + " 0 0 cm\n");
    }
}

