/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Graphics2D;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.FontInfo;
import org.apache.fop.configuration.FontTriplet;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.awt.FontMetricsMapper;

public class FontSetup {
    private static int normal = 0;
    private static int bold = 1;
    private static int italic = 2;
    private static int bolditalic = 3;

    public static void addConfiguredFonts(org.apache.fop.layout.FontInfo fontInfo, int n, Graphics2D graphics2D) {
        String string = null;
        Vector vector = Configuration.getFonts();
        if (vector == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            FontInfo fontInfo2 = (FontInfo)enumeration.nextElement();
            try {
                String string2 = fontInfo2.getMetricsFile();
                if (string2 == null) continue;
                string = "F" + n;
                ++n;
                Vector vector2 = fontInfo2.getFontTriplets();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    FontTriplet fontTriplet = (FontTriplet)enumeration2.nextElement();
                    boolean bl = fontInfo2.getEmbedFile() != null;
                    String string3 = bl ? fontTriplet.getName() : "Dialog";
                    FontMetricsMapper fontMetricsMapper = new FontMetricsMapper(string3, FontSetup.getFontMetrics(fontTriplet), graphics2D);
                    if (bl) {
                        fontMetricsMapper.setEmbedFont(fontInfo2.getEmbedFile());
                    }
                    fontInfo.addMetrics(string, fontMetricsMapper);
                    fontInfo.addFontProperties(string, fontTriplet.getName(), fontTriplet.getStyle(), fontTriplet.getWeight());
                }
            }
            catch (Exception exception) {
                MessageHandler.error("Failed to read font metrics file " + fontInfo2.getMetricsFile() + " : " + exception.getMessage());
            }
        }
    }

    private static int getFontMetrics(FontTriplet fontTriplet) {
        boolean bl = "bold".equalsIgnoreCase(fontTriplet.getWeight());
        boolean bl2 = "italic".equalsIgnoreCase(fontTriplet.getStyle());
        if (bl && bl2) {
            return bolditalic;
        }
        if (bl) {
            return bold;
        }
        if (bl2) {
            return italic;
        }
        return normal;
    }

    public static void setup(org.apache.fop.layout.FontInfo fontInfo, Graphics2D graphics2D) {
        MessageHandler.logln("setting up fonts");
        FontMetricsMapper fontMetricsMapper = new FontMetricsMapper("SansSerif", normal, graphics2D);
        fontInfo.addMetrics("F1", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("SansSerif", italic, graphics2D);
        fontInfo.addMetrics("F2", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("SansSerif", bold, graphics2D);
        fontInfo.addMetrics("F3", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("SansSerif", bolditalic, graphics2D);
        fontInfo.addMetrics("F4", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("Serif", normal, graphics2D);
        fontInfo.addMetrics("F5", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("Serif", italic, graphics2D);
        fontInfo.addMetrics("F6", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("Serif", bold, graphics2D);
        fontInfo.addMetrics("F7", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("Serif", bolditalic, graphics2D);
        fontInfo.addMetrics("F8", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("MonoSpaced", normal, graphics2D);
        fontInfo.addMetrics("F9", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("MonoSpaced", italic, graphics2D);
        fontInfo.addMetrics("F10", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("MonoSpaced", bold, graphics2D);
        fontInfo.addMetrics("F11", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("MonoSpaced", bolditalic, graphics2D);
        fontInfo.addMetrics("F12", fontMetricsMapper);
        fontMetricsMapper = new FontMetricsMapper("Symbol", bolditalic, graphics2D);
        fontInfo.addMetrics("F13", fontMetricsMapper);
        fontInfo.addMetrics("F14", fontMetricsMapper);
        fontInfo.addFontProperties("F5", "any", "normal", "normal");
        fontInfo.addFontProperties("F6", "any", "italic", "normal");
        fontInfo.addFontProperties("F6", "any", "oblique", "normal");
        fontInfo.addFontProperties("F7", "any", "normal", "bold");
        fontInfo.addFontProperties("F8", "any", "italic", "bold");
        fontInfo.addFontProperties("F8", "any", "oblique", "bold");
        fontInfo.addFontProperties("F1", "sans-serif", "normal", "normal");
        fontInfo.addFontProperties("F2", "sans-serif", "oblique", "normal");
        fontInfo.addFontProperties("F2", "sans-serif", "italic", "normal");
        fontInfo.addFontProperties("F3", "sans-serif", "normal", "bold");
        fontInfo.addFontProperties("F4", "sans-serif", "oblique", "bold");
        fontInfo.addFontProperties("F4", "sans-serif", "italic", "bold");
        fontInfo.addFontProperties("F5", "serif", "normal", "normal");
        fontInfo.addFontProperties("F6", "serif", "oblique", "normal");
        fontInfo.addFontProperties("F6", "serif", "italic", "normal");
        fontInfo.addFontProperties("F7", "serif", "normal", "bold");
        fontInfo.addFontProperties("F8", "serif", "oblique", "bold");
        fontInfo.addFontProperties("F8", "serif", "italic", "bold");
        fontInfo.addFontProperties("F9", "monospace", "normal", "normal");
        fontInfo.addFontProperties("F10", "monospace", "oblique", "normal");
        fontInfo.addFontProperties("F10", "monospace", "italic", "normal");
        fontInfo.addFontProperties("F11", "monospace", "normal", "bold");
        fontInfo.addFontProperties("F12", "monospace", "oblique", "bold");
        fontInfo.addFontProperties("F12", "monospace", "italic", "bold");
        fontInfo.addFontProperties("F1", "Helvetica", "normal", "normal");
        fontInfo.addFontProperties("F2", "Helvetica", "oblique", "normal");
        fontInfo.addFontProperties("F2", "Helvetica", "italic", "normal");
        fontInfo.addFontProperties("F3", "Helvetica", "normal", "bold");
        fontInfo.addFontProperties("F4", "Helvetica", "oblique", "bold");
        fontInfo.addFontProperties("F4", "Helvetica", "italic", "bold");
        fontInfo.addFontProperties("F5", "Times", "normal", "normal");
        fontInfo.addFontProperties("F6", "Times", "oblique", "normal");
        fontInfo.addFontProperties("F6", "Times", "italic", "normal");
        fontInfo.addFontProperties("F7", "Times", "normal", "bold");
        fontInfo.addFontProperties("F8", "Times", "oblique", "bold");
        fontInfo.addFontProperties("F8", "Times", "italic", "bold");
        fontInfo.addFontProperties("F9", "Courier", "normal", "normal");
        fontInfo.addFontProperties("F10", "Courier", "oblique", "normal");
        fontInfo.addFontProperties("F10", "Courier", "italic", "normal");
        fontInfo.addFontProperties("F11", "Courier", "normal", "bold");
        fontInfo.addFontProperties("F12", "Courier", "oblique", "bold");
        fontInfo.addFontProperties("F12", "Courier", "italic", "bold");
        fontInfo.addFontProperties("F13", "Symbol", "normal", "normal");
        fontInfo.addFontProperties("F14", "ZapfDingbats", "normal", "normal");
        fontInfo.addFontProperties("F5", "Times-Roman", "normal", "normal");
        fontInfo.addFontProperties("F6", "Times-Roman", "oblique", "normal");
        fontInfo.addFontProperties("F6", "Times-Roman", "italic", "normal");
        fontInfo.addFontProperties("F7", "Times-Roman", "normal", "bold");
        fontInfo.addFontProperties("F8", "Times-Roman", "oblique", "bold");
        fontInfo.addFontProperties("F8", "Times-Roman", "italic", "bold");
        fontInfo.addFontProperties("F5", "Times Roman", "normal", "normal");
        fontInfo.addFontProperties("F6", "Times Roman", "oblique", "normal");
        fontInfo.addFontProperties("F6", "Times Roman", "italic", "normal");
        fontInfo.addFontProperties("F7", "Times Roman", "normal", "bold");
        fontInfo.addFontProperties("F8", "Times Roman", "oblique", "bold");
        fontInfo.addFontProperties("F8", "Times Roman", "italic", "bold");
        fontInfo.addFontProperties("F9", "Computer-Modern-Typewriter", "normal", "normal");
        FontSetup.addConfiguredFonts(fontInfo, 15, graphics2D);
    }
}

