/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.fop.messaging.MessageHandler;

public class AWTFontMetrics {
    public static final int FONT_SIZE = 1;
    public static final int FONT_FACTOR = 1000000;
    private int[] width = null;
    private int xHeight = 0;
    private Font f1 = null;
    private String family = "";
    private int style = 0;
    private float size = 0.0f;
    private FontMetrics fmt = null;
    Graphics2D graphics;
    private Hashtable embedFontList = null;
    private Hashtable fontCash = null;

    public AWTFontMetrics(Graphics2D graphics2D) {
        this.graphics = graphics2D;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Font createFont(String string, int n, int n2) {
        Font font;
        String string2;
        block10: {
            string2 = null;
            if (this.embedFontList != null) {
                string2 = (String)this.embedFontList.get(String.valueOf(string) + n);
            }
            if (string2 == null) {
                return new Font(string, n, n2);
            }
            if (this.fontCash == null) {
                this.fontCash = new Hashtable();
            }
            if ((font = (Font)this.fontCash.get(string2)) != null) return font.deriveFont(n, n2);
            Object object = null;
            try {
                try {
                    MessageHandler.logln("create embedFont " + string2);
                    object = new FileInputStream(string2);
                    font = Font.createFont(0, (InputStream)object);
                }
                catch (Throwable throwable) {
                    MessageHandler.error("Failed to create embedFont " + string2 + " : " + throwable.toString());
                    font = new Font("Dialog", n, n2);
                }
                Object var8_8 = null;
                if (object == null) break block10;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (object == null) throw throwable;
                try {
                    ((FileInputStream)object).close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            ((FileInputStream)object).close();
        }
        this.fontCash.put(string2, font);
        return font.deriveFont(n, n2);
    }

    public int getAscender(String string, int n, int n2) {
        this.setFont(string, n, n2);
        int n3 = this.fmt.getAscent() - (this.fmt.getDescent() + this.fmt.getLeading());
        return 1000000 * n3;
    }

    public int getCapHeight(String string, int n, int n2) {
        return this.getAscender(string, n, n2);
    }

    public int getDescender(String string, int n, int n2) {
        this.setFont(string, n, n2);
        return -1000000 * this.fmt.getDescent();
    }

    public Font getFont(String string, int n, int n2) {
        this.setFont(string, n, n2);
        return this.f1;
    }

    public int[] getWidths(String string, int n, int n2) {
        if (this.width == null) {
            this.width = new int[256];
        }
        this.setFont(string, n, n2);
        int n3 = 0;
        while (n3 < 256) {
            this.width[n3] = 1000000 * this.fmt.charWidth(n3);
            ++n3;
        }
        return this.width;
    }

    public int getXHeight(String string, int n, int n2) {
        this.setFont(string, n, n2);
        return 1000000 * this.xHeight;
    }

    public void setEmbedFont(String string, int n, String string2) {
        if (this.embedFontList == null) {
            this.embedFontList = new Hashtable();
        }
        this.embedFontList.put(String.valueOf(string) + n, string2);
    }

    private boolean setFont(String string, int n, int n2) {
        boolean bl = false;
        int n3 = (int)((float)n2 / 1000.0f);
        if (this.f1 == null) {
            this.f1 = this.createFont(string, n, n3);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            bl = true;
        } else if (this.style != n || !this.family.equals(string) || this.size != (float)n3) {
            this.f1 = string.equals(this.family) ? this.f1.deriveFont(n, n3) : this.createFont(string, n, n3);
            this.fmt = this.graphics.getFontMetrics(this.f1);
            bl = true;
        }
        if (bl) {
            TextLayout textLayout = new TextLayout("m", this.f1, this.graphics.getFontRenderContext());
            Rectangle2D rectangle2D = textLayout.getBounds();
            this.xHeight = (int)rectangle2D.getHeight();
        }
        this.family = string;
        this.style = n;
        this.size = n3;
        return bl;
    }

    public int width(int n, String string, int n2, int n3) {
        this.setFont(string, n2, n3);
        int n4 = n <= 32 ? (int)(1.4 * (double)this.fmt.charWidth(n) * 1000000.0) : this.fmt.charWidth(n) * 1000000;
        return n4;
    }
}

