/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.Vector;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;

public class PDFShading
extends PDFObject {
    protected String shadingName = null;
    protected int shadingType = 3;
    protected ColorSpace colorSpace = null;
    protected Vector background = null;
    protected Vector bBox = null;
    protected boolean antiAlias = false;
    protected Vector domain = null;
    protected Vector matrix = null;
    protected PDFFunction function = null;
    protected Vector coords = null;
    protected Vector extend = null;
    protected int bitsPerCoordinate = 0;
    protected int bitsPerFlag = 0;
    protected Vector decode = null;
    protected int bitsPerComponent = 0;
    protected int verticesPerRow = 0;

    public PDFShading(int n, String string, int n2, ColorSpace colorSpace, Vector vector, Vector vector2, boolean bl, int n3, int n4, int n5, Vector vector3, PDFFunction pDFFunction) {
        super(n);
        this.shadingType = n2;
        this.colorSpace = colorSpace;
        this.background = vector;
        this.bBox = vector2;
        this.antiAlias = bl;
        this.bitsPerCoordinate = n3;
        this.bitsPerComponent = n4;
        this.bitsPerFlag = n5;
        this.decode = vector3;
        this.function = pDFFunction;
    }

    public PDFShading(int n, String string, int n2, ColorSpace colorSpace, Vector vector, Vector vector2, boolean bl, int n3, int n4, Vector vector3, int n5, PDFFunction pDFFunction) {
        super(n);
        this.shadingName = string;
        this.shadingType = n2;
        this.colorSpace = colorSpace;
        this.background = vector;
        this.bBox = vector2;
        this.antiAlias = bl;
        this.bitsPerCoordinate = n3;
        this.bitsPerComponent = n4;
        this.decode = vector3;
        this.verticesPerRow = n5;
        this.function = pDFFunction;
    }

    public PDFShading(int n, String string, int n2, ColorSpace colorSpace, Vector vector, Vector vector2, boolean bl, Vector vector3, Vector vector4, PDFFunction pDFFunction) {
        super(n);
        this.shadingName = string;
        this.shadingType = n2;
        this.colorSpace = colorSpace;
        this.background = vector;
        this.bBox = vector2;
        this.antiAlias = bl;
        this.domain = vector3;
        this.matrix = vector4;
        this.function = pDFFunction;
    }

    public PDFShading(int n, String string, int n2, ColorSpace colorSpace, Vector vector, Vector vector2, boolean bl, Vector vector3, Vector vector4, PDFFunction pDFFunction, Vector vector5) {
        super(n);
        this.shadingName = string;
        this.shadingType = n2;
        this.colorSpace = colorSpace;
        this.background = vector;
        this.bBox = vector2;
        this.antiAlias = bl;
        this.coords = vector3;
        this.domain = vector4;
        this.function = pDFFunction;
        this.extend = vector5;
    }

    public String getName() {
        return this.shadingName;
    }

    public byte[] toPDF() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.number) + " " + this.generation + " obj\n<< \n/ShadingType " + this.shadingType + " \n");
        if (this.colorSpace != null) {
            stringBuffer.append("/ColorSpace /" + this.colorSpace.getColorSpacePDFString() + " \n");
        }
        if (this.background != null) {
            stringBuffer.append("/Background [ ");
            n2 = this.background.size();
            n = 0;
            while (n < n2) {
                stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.background.elementAt(n))) + " ");
                ++n;
            }
            stringBuffer.append("] \n");
        }
        if (this.bBox != null) {
            stringBuffer.append("/BBox [ ");
            n2 = this.bBox.size();
            n = 0;
            while (n < n2) {
                stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.bBox.elementAt(n))) + " ");
                ++n;
            }
            stringBuffer.append("] \n");
        }
        if (this.antiAlias) {
            stringBuffer.append("/AntiAlias " + this.antiAlias + " \n");
        }
        if (this.shadingType == 1) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n2 = this.domain.size();
                n = 0;
                while (n < n2) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.domain.elementAt(n))) + " ");
                    ++n;
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.matrix != null) {
                stringBuffer.append("/Matrix [ ");
                n2 = this.matrix.size();
                n = 0;
                while (n < n2) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.matrix.elementAt(n))) + " ");
                    ++n;
                }
                stringBuffer.append("] \n");
            }
            if (this.function != null) {
                stringBuffer.append("/Function ");
                stringBuffer.append(String.valueOf(this.function.referencePDF()) + " \n");
            }
        } else if (this.shadingType == 2 || this.shadingType == 3) {
            if (this.coords != null) {
                stringBuffer.append("/Coords [ ");
                n2 = this.coords.size();
                n = 0;
                while (n < n2) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.coords.elementAt(n))) + " ");
                    ++n;
                }
                stringBuffer.append("] \n");
            }
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n2 = this.domain.size();
                n = 0;
                while (n < n2) {
                    stringBuffer.append(String.valueOf(PDFNumber.doubleOut((Double)this.domain.elementAt(n))) + " ");
                    ++n;
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.extend != null) {
                stringBuffer.append("/Extend [ ");
                n2 = this.extend.size();
                n = 0;
                while (n < n2) {
                    stringBuffer.append(String.valueOf(String.valueOf((Boolean)this.extend.elementAt(n))) + " ");
                    ++n;
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Extend [ true true ] \n");
            }
            if (this.function != null) {
                stringBuffer.append("/Function ");
                stringBuffer.append(String.valueOf(this.function.referencePDF()) + " \n");
            }
        } else if (this.shadingType == 4 || this.shadingType == 6 || this.shadingType == 7) {
            if (this.bitsPerCoordinate > 0) {
                stringBuffer.append("/BitsPerCoordinate " + this.bitsPerCoordinate + " \n");
            } else {
                stringBuffer.append("/BitsPerCoordinate 1 \n");
            }
            if (this.bitsPerComponent > 0) {
                stringBuffer.append("/BitsPerComponent " + this.bitsPerComponent + " \n");
            } else {
                stringBuffer.append("/BitsPerComponent 1 \n");
            }
            if (this.bitsPerFlag > 0) {
                stringBuffer.append("/BitsPerFlag " + this.bitsPerFlag + " \n");
            } else {
                stringBuffer.append("/BitsPerFlag 2 \n");
            }
            if (this.decode != null) {
                stringBuffer.append("/Decode [ ");
                n2 = this.decode.size();
                n = 0;
                while (n < n2) {
                    stringBuffer.append(String.valueOf(String.valueOf((Boolean)this.decode.elementAt(n))) + " ");
                    ++n;
                }
                stringBuffer.append("] \n");
            }
            if (this.function != null) {
                stringBuffer.append("/Function ");
                stringBuffer.append(String.valueOf(this.function.referencePDF()) + " \n");
            }
        } else if (this.shadingType == 5) {
            if (this.bitsPerCoordinate > 0) {
                stringBuffer.append("/BitsPerCoordinate " + this.bitsPerCoordinate + " \n");
            } else {
                stringBuffer.append("/BitsPerCoordinate 1 \n");
            }
            if (this.bitsPerComponent > 0) {
                stringBuffer.append("/BitsPerComponent " + this.bitsPerComponent + " \n");
            } else {
                stringBuffer.append("/BitsPerComponent 1 \n");
            }
            if (this.decode != null) {
                stringBuffer.append("/Decode [ ");
                n2 = this.decode.size();
                n = 0;
                while (n < n2) {
                    stringBuffer.append(String.valueOf(String.valueOf((Boolean)this.decode.elementAt(n))) + " ");
                    ++n;
                }
                stringBuffer.append("] \n");
            }
            if (this.function != null) {
                stringBuffer.append("/Function ");
                stringBuffer.append(String.valueOf(this.function.referencePDF()) + " \n");
            }
            if (this.verticesPerRow > 0) {
                stringBuffer.append("/VerticesPerRow " + this.verticesPerRow + " \n");
            } else {
                stringBuffer.append("/VerticesPerRow 2 \n");
            }
        }
        stringBuffer.append(">> \nendobj\n");
        return stringBuffer.toString().getBytes();
    }
}

