/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFStream;

public class PDFFontDescriptor
extends PDFObject {
    protected int ascent;
    protected int capHeight;
    protected int descent;
    protected int flags;
    protected PDFRectangle fontBBox;
    protected String basefont;
    protected int italicAngle;
    protected int stemV;
    protected int stemH = 0;
    protected int xHeight = 0;
    protected int leading = 0;
    protected int avgWidth = 0;
    protected int maxWidth = 0;
    protected int missingWidth = 0;
    protected PDFStream fontfile;
    protected byte subtype;

    public PDFFontDescriptor(int n, String string, int n2, int n3, int n4, int n5, PDFRectangle pDFRectangle, int n6, int n7) {
        super(n);
        this.basefont = string;
        this.ascent = n2;
        this.descent = n3;
        this.capHeight = n4;
        this.flags = n5;
        this.fontBBox = pDFRectangle;
        this.italicAngle = n6;
        this.stemV = n7;
    }

    protected void fillInPDF(StringBuffer stringBuffer) {
    }

    public void setFontFile(byte by, PDFStream pDFStream) {
        this.subtype = by;
        this.fontfile = pDFStream;
    }

    public void setMetrics(int n, int n2, int n3, int n4, int n5, int n6) {
        this.avgWidth = n;
        this.maxWidth = n2;
        this.missingWidth = n3;
        this.leading = n4;
        this.stemH = n5;
        this.xHeight = n6;
    }

    public byte[] toPDF() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.number) + " " + this.generation + " obj\n<< /Type /FontDescriptor" + "\n/FontName /" + this.basefont);
        stringBuffer.append("\n/FontBBox ");
        stringBuffer.append(this.fontBBox.toPDFString());
        stringBuffer.append("\n/Flags ");
        stringBuffer.append(this.flags);
        stringBuffer.append("\n/CapHeight ");
        stringBuffer.append(this.capHeight);
        stringBuffer.append("\n/Ascent ");
        stringBuffer.append(this.ascent);
        stringBuffer.append("\n/Descent ");
        stringBuffer.append(this.descent);
        stringBuffer.append("\n/ItalicAngle ");
        stringBuffer.append(this.italicAngle);
        stringBuffer.append("\n/StemV ");
        stringBuffer.append(this.stemV);
        if (this.stemH != 0) {
            stringBuffer.append("\n/StemH ");
            stringBuffer.append(this.stemH);
        }
        if (this.xHeight != 0) {
            stringBuffer.append("\n/XHeight ");
            stringBuffer.append(this.xHeight);
        }
        if (this.avgWidth != 0) {
            stringBuffer.append("\n/AvgWidth ");
            stringBuffer.append(this.avgWidth);
        }
        if (this.maxWidth != 0) {
            stringBuffer.append("\n/MaxWidth ");
            stringBuffer.append(this.maxWidth);
        }
        if (this.missingWidth != 0) {
            stringBuffer.append("\n/MissingWidth ");
            stringBuffer.append(this.missingWidth);
        }
        if (this.leading != 0) {
            stringBuffer.append("\n/Leading ");
            stringBuffer.append(this.leading);
        }
        if (this.fontfile != null) {
            switch (this.subtype) {
                case 1: {
                    stringBuffer.append("\n/FontFile ");
                    break;
                }
                case 4: {
                    stringBuffer.append("\n/FontFile2 ");
                    break;
                }
                case 0: {
                    stringBuffer.append("\n/FontFile2 ");
                    break;
                }
                default: {
                    stringBuffer.append("\n/FontFile2 ");
                }
            }
            stringBuffer.append(this.fontfile.referencePDF());
        }
        this.fillInPDF(stringBuffer);
        stringBuffer.append("\n >>\nendobj\n");
        return stringBuffer.toString().getBytes();
    }
}

