/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout.hyphenation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.layout.hyphenation.Hyphenation;
import org.apache.fop.layout.hyphenation.HyphenationException;
import org.apache.fop.layout.hyphenation.HyphenationTree;
import org.apache.fop.messaging.MessageHandler;

public class Hyphenator {
    static Hashtable hyphenTrees = new Hashtable();
    private HyphenationTree hyphenTree = null;
    private int remainCharCount = 2;
    private int pushCharCount = 2;
    private static boolean errorDump = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$fop$layout$hyphenation$Hyphenator;

    public Hyphenator(String string, String string2, int n, int n2) {
        this.hyphenTree = Hyphenator.getHyphenationTree(string, string2);
        this.remainCharCount = n;
        this.pushCharCount = n2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HyphenationTree getFopHyphenationTree(String var0) {
        block15: {
            block14: {
                block13: {
                    var1_1 = null;
                    var2_2 = null;
                    var3_3 = null;
                    try {
                        try {
                            block16: {
                                block17: {
                                    var3_3 = Hyphenator.getResourceStream(var0);
                                    if (var3_3 != null) break block16;
                                    if (var0.length() != 5) break block17;
                                    var3_3 = Hyphenator.getResourceStream(var0.substring(0, 2));
                                    if (var3_3 != null) {
                                        MessageHandler.errorln("Couldn't find hyphenation pattern  " + var0 + "\nusing general language pattern " + var0.substring(0, 2) + " instead.");
                                        break block16;
                                    } else {
                                        if (Hyphenator.errorDump) {
                                            MessageHandler.errorln("Couldn't find precompiled fop hyphenation pattern " + var0 + ".hyp");
                                        }
                                        var4_4 = null;
                                        var6_6 = null;
                                        if (var2_2 == null) return var4_4;
                                        break block13;
                                    }
                                }
                                if (Hyphenator.errorDump) {
                                    MessageHandler.errorln("Couldn't find precompiled fop hyphenation pattern " + var0 + ".hyp");
                                }
                                var4_5 = null;
                                break block14;
                            }
                            var2_2 = new ObjectInputStream(var3_3);
                            var1_1 = (HyphenationTree)var2_2.readObject();
                        }
                        catch (Exception var7_10) {
                            var7_10.printStackTrace();
                        }
                        break block15;
                    }
                    catch (Throwable var5_11) {
                        var6_9 = null;
                        if (var2_2 == null) throw var5_11;
                        try {
                            var2_2.close();
                            throw var5_11;
                        }
                        catch (IOException v0) {
                            MessageHandler.errorln("can't close hyphenation object stream");
                        }
                        throw var5_11;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [2 : 206->213)] { 
lbl46:
                // 1 sources

                var2_2.close();
                return var4_4;
lbl48:
                // 1 sources

                catch (IOException v1) {
                    MessageHandler.errorln("can't close hyphenation object stream");
                }
                return var4_4;
            }
            var6_7 = null;
            if (var2_2 == null) return var4_5;
            ** try [egrp 2[TRYBLOCK] [2 : 206->213)] { 
lbl55:
            // 1 sources

            var2_2.close();
            return var4_5;
lbl57:
            // 1 sources

            catch (IOException v2) {
                MessageHandler.errorln("can't close hyphenation object stream");
            }
            return var4_5;
        }
        var6_8 = null;
        if (var2_2 == null) return var1_1;
        try {}
        catch (IOException v3) {
            MessageHandler.errorln("can't close hyphenation object stream");
            return var1_1;
        }
        var2_2.close();
        return var1_1;
    }

    public static HyphenationTree getHyphenationTree(String string, String string2) {
        String string3;
        String string4 = string;
        if (string2 != null && !string2.equals("none")) {
            string4 = String.valueOf(string4) + "_" + string2;
        }
        if (hyphenTrees.containsKey(string4)) {
            return (HyphenationTree)hyphenTrees.get(string4);
        }
        if (hyphenTrees.containsKey(string)) {
            return (HyphenationTree)hyphenTrees.get(string);
        }
        HyphenationTree hyphenationTree = Hyphenator.getFopHyphenationTree(string4);
        if (hyphenationTree == null && (string3 = Configuration.getStringValue("hyphenation-dir")) != null) {
            hyphenationTree = Hyphenator.getUserHyphenationTree(string4, string3);
        }
        if (hyphenationTree != null) {
            hyphenTrees.put(string4, hyphenationTree);
        } else {
            MessageHandler.errorln("Couldn't find hyphenation pattern " + string4);
        }
        return hyphenationTree;
    }

    private static InputStream getResourceStream(String string) {
        InputStream inputStream = null;
        try {
            Method method = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = Hyphenator.class$("java.lang.Thread"))).getMethod("getContextClassLoader", new Class[0]);
            if (method != null) {
                ClassLoader classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
                inputStream = classLoader.getResourceAsStream("hyph/" + string + ".hyp");
            }
        }
        catch (Exception exception) {}
        if (inputStream == null) {
            inputStream = (class$org$apache$fop$layout$hyphenation$Hyphenator != null ? class$org$apache$fop$layout$hyphenation$Hyphenator : (class$org$apache$fop$layout$hyphenation$Hyphenator = Hyphenator.class$("org.apache.fop.layout.hyphenation.Hyphenator"))).getResourceAsStream("/hyph/" + string + ".hyp");
        }
        return inputStream;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenationTree getUserHyphenationTree(String string, String string2) {
        HyphenationTree hyphenationTree = null;
        File file = new File(string2, String.valueOf(string) + ".hyp");
        if (file.exists()) {
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    hyphenationTree = (HyphenationTree)objectInputStream.readObject();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var6_6 = null;
                if (objectInputStream == null) return hyphenationTree;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (objectInputStream == null) throw throwable;
                try {
                    objectInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                objectInputStream.close();
                return hyphenationTree;
            }
            catch (IOException iOException) {}
            return hyphenationTree;
        }
        file = new File(string2, String.valueOf(string) + ".xml");
        if (file.exists()) {
            hyphenationTree = new HyphenationTree();
            if (errorDump) {
                MessageHandler.errorln("reading " + string2 + string + ".xml");
            }
            try {
                hyphenationTree.loadPatterns(file.getPath());
                if (!errorDump) return hyphenationTree;
                System.out.println("Stats: ");
                hyphenationTree.printStats();
                return hyphenationTree;
            }
            catch (HyphenationException hyphenationException) {
                if (!errorDump) return null;
                MessageHandler.errorln("Can't load user patterns from xml file " + string2 + string + ".xml");
                return null;
            }
        }
        if (!errorDump) return null;
        MessageHandler.errorln("Tried to load " + file.toString() + "\nCannot find compiled nor xml file for " + "hyphenation pattern" + string);
        return null;
    }

    public Hyphenation hyphenate(String string) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(string, this.remainCharCount, this.pushCharCount);
    }

    public static Hyphenation hyphenate(String string, String string2, String string3, int n, int n2) {
        HyphenationTree hyphenationTree = Hyphenator.getHyphenationTree(string, string2);
        if (hyphenationTree == null) {
            MessageHandler.errorln("Error building hyphenation tree for language " + string);
            return null;
        }
        return hyphenationTree.hyphenate(string3, n, n2);
    }

    public static Hyphenation hyphenate(String string, String string2, char[] cArray, int n, int n2, int n3, int n4) {
        HyphenationTree hyphenationTree = Hyphenator.getHyphenationTree(string, string2);
        if (hyphenationTree == null) {
            MessageHandler.errorln("Error building hyphenation tree for language " + string);
            return null;
        }
        return hyphenationTree.hyphenate(cArray, n, n2, n3, n4);
    }

    public Hyphenation hyphenate(char[] cArray, int n, int n2) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(cArray, n, n2, this.remainCharCount, this.pushCharCount);
    }

    public void setLanguage(String string, String string2) {
        this.hyphenTree = Hyphenator.getHyphenationTree(string, string2);
    }

    public void setMinPushCharCount(int n) {
        this.pushCharCount = n;
    }

    public void setMinRemainCharCount(int n) {
        this.remainCharCount = n;
    }
}

