/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.InlineSpace;

public abstract class Area
extends Box {
    protected FontState fontState;
    protected BorderAndPadding bp = null;
    protected Vector children = new Vector();
    protected int maxHeight;
    protected int currentHeight = 0;
    protected int tableCellXOffset = 0;
    private int absoluteHeight = 0;
    protected int contentRectangleWidth;
    protected int allocationWidth;
    protected Page page;
    protected ColorType backgroundColor;
    private IDReferences idReferences;
    protected Vector markers;
    protected FObj generatedBy;
    protected Hashtable returnedBy;
    protected String areaClass;
    protected boolean isFirst = false;
    protected boolean isLast = false;
    public FObj foCreator;

    public Area(FontState fontState) {
        this.setFontState(fontState);
        this.markers = new Vector();
        this.returnedBy = new Hashtable();
    }

    public Area(FontState fontState, int n, int n2) {
        this.setFontState(fontState);
        this.allocationWidth = n;
        this.contentRectangleWidth = n;
        this.maxHeight = n2;
        this.markers = new Vector();
        this.returnedBy = new Hashtable();
    }

    public void addChild(Box box) {
        this.children.addElement(box);
        box.parent = this;
    }

    public void addChildAtStart(Box box) {
        this.children.insertElementAt(box, 0);
        box.parent = this;
    }

    public void addDisplaySpace(int n) {
        this.addChild(new DisplaySpace(n));
        this.absoluteHeight += n;
        this.currentHeight += n;
    }

    public void addInlineSpace(int n) {
        this.addChild(new InlineSpace(n));
    }

    public void addLineagePair(FObj fObj, int n) {
        this.returnedBy.put(fObj, new Integer(n));
    }

    public void addMarker(Marker marker) {
        this.markers.addElement(marker);
    }

    public void addMarkers(Vector vector) {
        vector.addAll(vector);
    }

    public void end() {
    }

    public int getAbsoluteHeight() {
        return this.absoluteHeight;
    }

    public int getAllocationWidth() {
        return this.allocationWidth;
    }

    public ColorType getBackgroundColor() {
        return this.backgroundColor;
    }

    public BorderAndPadding getBorderAndPadding() {
        return this.bp;
    }

    public int getBorderBottomWidth() {
        return this.bp == null ? 0 : this.bp.getBorderBottomWidth(false);
    }

    public int getBorderLeftWidth() {
        return this.bp == null ? 0 : this.bp.getBorderLeftWidth(false);
    }

    public int getBorderRightWidth() {
        return this.bp == null ? 0 : this.bp.getBorderRightWidth(false);
    }

    public int getBorderTopWidth() {
        return this.bp == null ? 0 : this.bp.getBorderTopWidth(false);
    }

    public Vector getChildren() {
        return this.children;
    }

    public int getContentHeight() {
        return this.currentHeight;
    }

    public int getContentWidth() {
        return this.contentRectangleWidth;
    }

    public FontInfo getFontInfo() {
        return this.page.getFontInfo();
    }

    public FontState getFontState() {
        return this.fontState;
    }

    public FObj getGeneratedBy() {
        return this.generatedBy;
    }

    public int getHeight() {
        return this.currentHeight + this.getPaddingTop() + this.getPaddingBottom() + this.getBorderTopWidth() + this.getBorderBottomWidth();
    }

    public IDReferences getIDReferences() {
        return this.idReferences;
    }

    public Vector getMarkers() {
        return this.markers;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public AreaContainer getNearestAncestorAreaContainer() {
        Area area = this.getParent();
        while (!(area instanceof AreaContainer)) {
            area = area.getParent();
        }
        return (AreaContainer)area;
    }

    public int getPaddingBottom() {
        return this.bp == null ? 0 : this.bp.getPaddingBottom(false);
    }

    public int getPaddingLeft() {
        return this.bp == null ? 0 : this.bp.getPaddingLeft(false);
    }

    public int getPaddingRight() {
        return this.bp == null ? 0 : this.bp.getPaddingRight(false);
    }

    public int getPaddingTop() {
        return this.bp == null ? 0 : this.bp.getPaddingTop(false);
    }

    public Page getPage() {
        return this.page;
    }

    public Area getParent() {
        return this.parent;
    }

    public int getTableCellXOffset() {
        return this.tableCellXOffset;
    }

    public FObj getfoCreator() {
        return this.foCreator;
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public void increaseAbsoluteHeight(int n) {
        this.absoluteHeight += n;
    }

    public void increaseHeight(int n) {
        this.currentHeight += n;
        this.absoluteHeight += n;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void isFirst(boolean bl) {
        this.isFirst = bl;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public void isLast(boolean bl) {
        this.isLast = bl;
    }

    public void remove() {
        this.parent.removeChild(this);
    }

    public void removeChild(Area area) {
        this.currentHeight -= area.getHeight();
        this.absoluteHeight -= area.getHeight();
        this.children.removeElement(area);
    }

    public void removeChild(DisplaySpace displaySpace) {
        this.currentHeight -= displaySpace.getSize();
        this.absoluteHeight -= displaySpace.getSize();
        this.children.removeElement(displaySpace);
    }

    public void setAbsoluteHeight(int n) {
        this.absoluteHeight = n;
    }

    public void setAllocationWidth(int n) {
        this.contentRectangleWidth = this.allocationWidth = n;
    }

    public void setBackgroundColor(ColorType colorType) {
        this.backgroundColor = colorType;
    }

    public void setBorderAndPadding(BorderAndPadding borderAndPadding) {
        this.bp = borderAndPadding;
    }

    private void setFontState(FontState fontState) {
        this.fontState = fontState;
    }

    public void setGeneratedBy(FObj fObj) {
        this.generatedBy = fObj;
    }

    public void setHeight(int n) {
        int n2 = this.currentHeight;
        if (n > this.currentHeight) {
            this.currentHeight = n;
        }
        if (this.currentHeight > this.getMaxHeight()) {
            this.currentHeight = this.getMaxHeight();
        }
        this.absoluteHeight += this.currentHeight - n2;
    }

    public void setIDReferences(IDReferences iDReferences) {
        this.idReferences = iDReferences;
    }

    public void setMaxHeight(int n) {
        this.maxHeight = n;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public void setParent(Area area) {
        this.parent = area;
    }

    public void setTableCellXOffset(int n) {
        this.tableCellXOffset = n;
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
    }
}

