/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.fop.image.analyser.AbstractImageReader;

public class EPSReader
extends AbstractImageReader {
    private long[] bbox;
    private boolean isAscii;
    long psStart = 0L;
    long psLength = 0L;
    long wmfStart = 0L;
    long wmfLength = 0L;
    long tiffStart = 0L;
    long tiffLength = 0L;
    private byte[] rawEps;
    private byte[] epsFile;
    private byte[] preview = null;

    public int[] getBBox() {
        int[] nArray = new int[]{(int)this.bbox[0], (int)this.bbox[1], (int)this.bbox[2], (int)this.bbox[3]};
        return nArray;
    }

    public byte[] getEpsFile() {
        return this.epsFile;
    }

    private long getLong(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        int n5 = byArray[n + 3] & 0xFF;
        return n5 << 24 | n4 << 16 | n3 << 8 | n2;
    }

    public String getMimeType() {
        return "image/eps";
    }

    public byte[] getPreview() {
        Object var1_1 = null;
        if (this.preview == null && this.tiffLength > 0L) {
            this.preview = new byte[(int)this.tiffLength];
            System.arraycopy(this.rawEps, (int)this.tiffStart, this.preview, 0, (int)this.tiffLength);
        }
        return this.preview;
    }

    private long[] readBBox() {
        long[] lArray = null;
        int n = 0;
        byte[] byArray = "%%BoundingBox: ".getBytes();
        boolean bl = false;
        while (!bl && this.epsFile.length > n + byArray.length) {
            boolean bl2 = true;
            int n2 = n;
            n2 = n;
            while (bl2 && n2 - n < byArray.length) {
                if (byArray[n2 - n] != this.epsFile[n2]) {
                    bl2 = false;
                }
                ++n2;
            }
            if (bl2) {
                bl = true;
                n = n2;
                continue;
            }
            ++n;
        }
        if (!bl) {
            return lArray;
        }
        lArray = new long[4];
        n += this.readLongString(lArray, 0, n);
        n += this.readLongString(lArray, 1, n);
        n += this.readLongString(lArray, 2, n);
        n += this.readLongString(lArray, 3, n);
        return lArray;
    }

    private void readEPSImage(BufferedInputStream bufferedInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[20480];
        boolean bl = false;
        boolean bl2 = true;
        try {
            int n;
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new IOException("Error while loading EPS image " + iOException.getMessage());
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (this.isAscii) {
            this.rawEps = null;
            this.epsFile = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.epsFile, 0, this.epsFile.length);
        } else {
            this.rawEps = new byte[byArray2.length];
            this.epsFile = new byte[(int)this.psLength];
            System.arraycopy(byArray2, 0, this.rawEps, 0, this.rawEps.length);
            System.arraycopy(this.rawEps, (int)this.psStart, this.epsFile, 0, (int)this.psLength);
        }
    }

    private int readLongString(long[] lArray, int n, int n2) {
        while (n2 < this.epsFile.length && this.epsFile[n2] == 32) {
            ++n2;
        }
        int n3 = n2;
        while (n3 < this.epsFile.length && this.epsFile[n3] >= 48 && this.epsFile[n3] <= 57) {
            ++n3;
        }
        byte[] byArray = new byte[n3 - n2];
        System.arraycopy(this.epsFile, n2, byArray, 0, n3 - n2);
        String string = new String(byArray);
        lArray[n] = Long.parseLong(string);
        return 1 + n3 - n2;
    }

    public boolean verifySignature(String string, BufferedInputStream bufferedInputStream) throws IOException {
        boolean bl = false;
        this.imageStream = bufferedInputStream;
        bufferedInputStream.mark(32);
        byte[] byArray = new byte[30];
        bufferedInputStream.read(byArray, 0, 30);
        bufferedInputStream.reset();
        if (this.getLong(byArray, 0) == -959196987L) {
            this.isAscii = false;
            bl = true;
            this.psStart = this.getLong(byArray, 4);
            this.psLength = this.getLong(byArray, 8);
            this.wmfStart = this.getLong(byArray, 12);
            this.wmfLength = this.getLong(byArray, 16);
            this.tiffStart = this.getLong(byArray, 20);
            this.tiffLength = this.getLong(byArray, 24);
        } else {
            byte[] byArray2 = "%!PS".getBytes();
            if (byArray2[0] == byArray[0] && byArray2[1] == byArray[1] && byArray2[2] == byArray[2] && byArray2[3] == byArray[3]) {
                this.isAscii = true;
                bl = true;
            }
        }
        if (bl) {
            this.readEPSImage(bufferedInputStream);
            this.bbox = this.readBBox();
            if (this.bbox != null) {
                this.width = (int)(this.bbox[2] - this.bbox[0]);
                this.height = (int)(this.bbox[3] - this.bbox[1]);
            } else {
                bl = false;
            }
        }
        return bl;
    }
}

