/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.net.URL;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.EPSReader;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.messaging.MessageHandler;

public class EPSImage
extends AbstractFopImage {
    private String docName;
    private int[] bbox;
    private byte[] epsImage = null;
    private EPSReader epsReader = null;

    public EPSImage(URL uRL) throws FopImageException {
        super(uRL);
        this.init(uRL);
    }

    public EPSImage(URL uRL, ImageReader imageReader) throws FopImageException {
        super(uRL, imageReader);
        this.init(uRL);
        if (imageReader instanceof EPSReader) {
            EPSReader ePSReader;
            this.epsReader = ePSReader = (EPSReader)imageReader;
            this.epsImage = ePSReader.getEpsFile();
            this.m_bitmaps = this.epsImage;
            this.bbox = ePSReader.getBBox();
        }
    }

    public int[] getBBox() {
        return this.bbox;
    }

    public String getDocName() {
        return this.docName;
    }

    public byte[] getEPSImage() throws FopImageException {
        if (this.epsImage == null) {
            MessageHandler.errorln("ERROR LOADING EXTERNAL EPS");
        }
        return this.epsImage;
    }

    private void init(URL uRL) {
        this.bbox = new int[4];
        this.bbox[0] = 0;
        this.bbox[1] = 0;
        this.bbox[2] = 0;
        this.bbox[3] = 0;
        this.docName = uRL.toString();
    }

    protected void loadImage() throws FopImageException {
    }
}

