/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageSequence;

public class Root
extends FObj {
    LayoutMasterSet layoutMasterSet;
    Vector pageSequences;
    private int runningPageNumberCounter = 0;

    protected Root(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:root";
        this.pageSequences = new Vector();
        if (fObj != null) {
            throw new FOPException("root must be root element");
        }
    }

    public void addPageSequence(PageSequence pageSequence) {
        this.pageSequences.addElement(pageSequence);
    }

    public LayoutMasterSet getLayoutMasterSet() {
        return this.layoutMasterSet;
    }

    public int getPageSequenceCount() {
        return this.pageSequences.size();
    }

    protected int getRunningPageNumberCounter() {
        return this.runningPageNumberCounter;
    }

    public PageSequence getSucceedingPageSequence(PageSequence pageSequence) {
        int n = this.pageSequences.indexOf(pageSequence);
        if (n == -1) {
            return null;
        }
        if (n < this.pageSequences.size() - 1) {
            return (PageSequence)this.pageSequences.elementAt(n + 1);
        }
        return null;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setLayoutMasterSet(LayoutMasterSet layoutMasterSet) {
        this.layoutMasterSet = layoutMasterSet;
    }

    protected void setRunningPageNumberCounter(int n) {
        this.runningPageNumberCounter = n;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Root(fObj, propertyList);
        }
    }
}

