/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.LengthRange;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableFooter;
import org.apache.fop.fo.flow.TableHeader;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;

public class Table
extends FObj {
    private static final int MINCOLWIDTH = 10000;
    int breakBefore;
    int breakAfter;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    LengthRange ipd;
    int height;
    String id;
    TableHeader tableHeader = null;
    TableFooter tableFooter = null;
    boolean omitHeaderAtBreak = false;
    boolean omitFooterAtBreak = false;
    Vector columns = new Vector();
    int bodyCount = 0;
    private boolean bAutoLayout = false;
    private int contentWidth = 0;
    private int optIPD;
    private int minIPD;
    private int maxIPD;
    AreaContainer areaContainer;

    public Table(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table";
    }

    private int calcFixedColumnWidths(int n) {
        int n2;
        Object object;
        int n3 = 1;
        int n4 = 0;
        double d = 0.0;
        int n5 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 100000.0;
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (tableColumn == null) {
                this.log.warn("No table-column specification for column " + n3);
                ++n4;
            } else {
                object = tableColumn.getColumnWidthAsLength();
                double d5 = ((Length)object).getTableUnits();
                if (d5 > 0.0 && d5 < d4 && ((Length)object).mvalue() == 0) {
                    d4 = d5;
                }
                d += d5;
                n5 += ((Length)object).mvalue();
            }
            ++n3;
        }
        this.setIPD(d > 0.0, n);
        if (d > 0.0) {
            n2 = 0;
            n2 = this.optIPD > n5 ? this.optIPD - n5 : (this.maxIPD > n5 ? this.maxIPD - n5 : n - n5);
            if (n2 > 0) {
                d3 = (double)n2 / d;
            } else {
                this.log.error("Sum of fixed column widths " + n5 + " greater than maximum available IPD " + n + "; no space for " + d + " proportional units.");
                d3 = 10000.0 / d4;
            }
        } else {
            n2 = n5;
            if (this.minIPD > n5) {
                n2 = this.minIPD;
                d2 = (double)this.minIPD / (double)n5;
            } else if (this.maxIPD < n5) {
                this.log.warn("Sum of fixed column widths " + n5 + " greater than maximum specified IPD " + this.maxIPD);
            } else if (this.optIPD != -1 && n5 != this.optIPD) {
                this.log.warn("Sum of fixed column widths " + n5 + " differs from specified optimum IPD " + this.optIPD);
            }
        }
        n2 = 0;
        enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            int n6;
            object = (TableColumn)enumeration.nextElement();
            if (object == null) continue;
            ((TableColumn)object).setColumnOffset(n2);
            Length length = ((TableColumn)object).getColumnWidthAsLength();
            if (d3 > 0.0) {
                length.resolveTableUnit(d3);
            }
            if ((n6 = length.mvalue()) <= 0) {
                this.log.warn("Zero-width table column!");
            }
            if (d2 > 0.0) {
                n6 = (int)((double)n6 * d2);
            }
            ((TableColumn)object).setColumnWidth(n6);
            n2 += n6;
        }
        return n2;
    }

    private void findColumns(Area area) throws FOPException {
        int n = 1;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            FONode fONode = (FONode)enumeration.nextElement();
            if (!(fONode instanceof TableColumn)) continue;
            TableColumn tableColumn = (TableColumn)fONode;
            tableColumn.doSetup(area);
            int n2 = tableColumn.getNumColumnsRepeated();
            int n3 = tableColumn.getColumnNumber();
            if (n3 == 0) {
                n3 = n;
            }
            int n4 = 0;
            while (n4 < n2) {
                if (n3 > this.columns.size()) {
                    this.columns.setSize(n3);
                }
                if (this.columns.elementAt(n3 - 1) != null) {
                    this.log.warn("More than one column object assigned to column " + n3);
                }
                this.columns.setElementAt(tableColumn, n3 - 1);
                ++n3;
                ++n4;
            }
            n = n3;
        }
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    public int getContentWidth() {
        if (this.areaContainer != null) {
            return this.areaContainer.getContentWidth();
        }
        return 0;
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
            AuralProps auralProps = this.propMgr.getAuralProps();
            BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
            BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
            MarginProps marginProps = this.propMgr.getMarginProps();
            object = this.propMgr.getRelativePositionProps();
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.ipd = this.properties.get("inline-progression-dimension").getLengthRange();
            this.height = this.properties.get("height").getLength().mvalue();
            this.bAutoLayout = this.properties.get("table-layout").getEnum() == 7;
            this.id = this.properties.get("id").getString();
            this.omitHeaderAtBreak = this.properties.get("table-omit-header-at-break").getEnum() == 81;
            boolean bl = this.omitFooterAtBreak = this.properties.get("table-omit-footer-at-break").getEnum() == 81;
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.areaContainer == null) {
                area.getIDReferences().createID(this.id);
            }
            this.marker = 0;
            if (this.breakBefore == 58) {
                return new Status(4);
            }
            if (this.breakBefore == 55) {
                return new Status(6);
            }
            if (this.breakBefore == 26) {
                return new Status(5);
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.marker == 0 && this.areaContainer == null) {
            area.getIDReferences().configureID(this.id, area);
        }
        int n = area.spaceLeft();
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), 0, 0, area.getAllocationWidth(), area.spaceLeft(), 73);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.children.size();
        if (this.columns.size() == 0) {
            this.findColumns(this.areaContainer);
            if (this.bAutoLayout) {
                this.log.warn("table-layout=auto is not supported, using fixed!");
            }
            this.contentWidth = this.calcFixedColumnWidths(this.areaContainer.getAllocationWidth());
        }
        this.areaContainer.setAllocationWidth(this.contentWidth);
        this.layoutColumns(this.areaContainer);
        int n3 = this.marker;
        while (n3 < n2) {
            object = (FONode)this.children.elementAt(n3);
            if (object instanceof TableHeader) {
                if (this.columns.size() == 0) {
                    this.log.warn("current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                this.tableHeader = (TableHeader)object;
                this.tableHeader.setColumns(this.columns);
            } else if (object instanceof TableFooter) {
                if (this.columns.size() == 0) {
                    this.log.warn("current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                this.tableFooter = (TableFooter)object;
                this.tableFooter.setColumns(this.columns);
            } else if (object instanceof TableBody) {
                Status status;
                if (this.columns.size() == 0) {
                    this.log.warn("current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                if (this.tableHeader != null && !bl) {
                    status = this.tableHeader.layout(this.areaContainer);
                    if (status.isIncomplete()) {
                        this.tableHeader.resetMarker();
                        return new Status(2);
                    }
                    bl = true;
                    this.tableHeader.resetMarker();
                    area.setMaxHeight(area.getMaxHeight() - n + this.areaContainer.getMaxHeight());
                }
                if (this.tableFooter != null && !this.omitFooterAtBreak && !bl2) {
                    status = this.tableFooter.layout(this.areaContainer);
                    if (status.isIncomplete()) {
                        return new Status(2);
                    }
                    bl2 = true;
                    this.tableFooter.resetMarker();
                }
                ((FONode)object).setWidows(this.widows);
                ((FONode)object).setOrphans(this.orphans);
                ((TableBody)object).setColumns(this.columns);
                status = ((FONode)object).layout(this.areaContainer);
                if (status.isIncomplete()) {
                    this.marker = n3;
                    if (this.bodyCount == 0 && status.getCode() == 2) {
                        if (this.tableHeader != null) {
                            this.tableHeader.removeLayout(this.areaContainer);
                        }
                        if (this.tableFooter != null) {
                            this.tableFooter.removeLayout(this.areaContainer);
                        }
                        this.resetMarker();
                    }
                    if (this.areaContainer.getContentHeight() > 0) {
                        area.addChild(this.areaContainer);
                        area.increaseHeight(this.areaContainer.getHeight());
                        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                        if (this.omitHeaderAtBreak) {
                            this.tableHeader = null;
                        }
                        if (this.tableFooter != null && !this.omitFooterAtBreak) {
                            ((TableBody)object).setYPosition(this.tableFooter.getYPosition());
                            this.tableFooter.setYPosition(this.tableFooter.getYPosition() + ((TableBody)object).getHeight());
                        }
                        this.setupColumnHeights();
                        status = new Status(3);
                    }
                    return status;
                }
                ++this.bodyCount;
                area.setMaxHeight(area.getMaxHeight() - n + this.areaContainer.getMaxHeight());
                if (this.tableFooter != null && !this.omitFooterAtBreak) {
                    ((TableBody)object).setYPosition(this.tableFooter.getYPosition());
                    this.tableFooter.setYPosition(this.tableFooter.getYPosition() + ((TableBody)object).getHeight());
                }
            }
            ++n3;
        }
        if (this.tableFooter != null && this.omitFooterAtBreak && this.tableFooter.layout(this.areaContainer).isIncomplete()) {
            this.log.warn("footer could not fit on page, moving last body row to next page");
            area.addChild(this.areaContainer);
            area.increaseHeight(this.areaContainer.getHeight());
            area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
            if (this.omitHeaderAtBreak) {
                this.tableHeader = null;
            }
            this.tableFooter.removeLayout(this.areaContainer);
            this.tableFooter.resetMarker();
            return new Status(3);
        }
        if (this.height != 0) {
            this.areaContainer.setHeight(this.height);
        }
        this.setupColumnHeights();
        this.areaContainer.end();
        area.addChild(this.areaContainer);
        area.increaseHeight(this.areaContainer.getHeight());
        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 58) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 55) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 26) {
            this.marker = -1001;
            return new Status(5);
        }
        return new Status(1);
    }

    private void layoutColumns(Area area) throws FOPException {
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (tableColumn == null) continue;
            tableColumn.layout(area);
        }
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    private void setIPD(boolean bl, int n) {
        boolean bl2 = this.ipd.getMaximum().getLength().isAuto() ^ true;
        this.maxIPD = bl2 ? this.ipd.getMaximum().getLength().mvalue() : n;
        this.optIPD = this.ipd.getOptimum().getLength().isAuto() ? -1 : this.ipd.getMaximum().getLength().mvalue();
        this.minIPD = this.ipd.getMinimum().getLength().isAuto() ? -1 : this.ipd.getMinimum().getLength().mvalue();
        if (bl && this.optIPD < 0) {
            if (this.minIPD > 0) {
                this.optIPD = bl2 ? (this.minIPD + this.maxIPD) / 2 : this.minIPD;
            } else if (bl2) {
                this.optIPD = this.maxIPD;
            } else {
                this.log.error("At least one of minimum, optimum, or maximum IPD must be specified on table.");
                this.optIPD = this.maxIPD;
            }
        }
    }

    protected void setupColumnHeights() {
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (tableColumn == null) continue;
            tableColumn.setHeight(this.areaContainer.getContentHeight());
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Table(fObj, propertyList);
        }
    }
}

