/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layout.inline.ForeignObjectArea;

public class InstreamForeignObject
extends FObj {
    int breakBefore;
    int breakAfter;
    int scaling;
    int width;
    int height;
    int contwidth;
    int contheight;
    boolean wauto;
    boolean hauto;
    boolean cwauto;
    boolean chauto;
    int spaceBefore;
    int spaceAfter;
    int startIndent;
    int endIndent;
    ForeignObjectArea areaCurrent;

    public InstreamForeignObject(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:instream-foreign-object";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            object2 = this.propMgr.getAccessibilityProps();
            object = this.propMgr.getAuralProps();
            BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
            BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
            MarginInlineProps marginInlineProps = this.propMgr.getMarginInlineProps();
            RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
            String string = this.properties.get("id").getString();
            int n = this.properties.get("text-align").getEnum();
            int n2 = this.properties.get("vertical-align").getEnum();
            int n3 = this.properties.get("overflow").getEnum();
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.contwidth = this.properties.get("content-width").getLength().mvalue();
            this.contheight = this.properties.get("content-height").getLength().mvalue();
            this.wauto = this.properties.get("width").getLength().isAuto();
            this.hauto = this.properties.get("height").getLength().isAuto();
            this.cwauto = this.properties.get("content-width").getLength().isAuto();
            this.chauto = this.properties.get("content-height").getLength().isAuto();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.scaling = this.properties.get("scaling").getEnum();
            area.getIDReferences().createID(string);
            if (this.areaCurrent == null) {
                this.areaCurrent = new ForeignObjectArea(this.propMgr.getFontState(area.getFontInfo()), area.getAllocationWidth());
                this.areaCurrent.start();
                this.areaCurrent.setWidth(this.width);
                this.areaCurrent.setHeight(this.height);
                this.areaCurrent.setContentWidth(this.contwidth);
                this.areaCurrent.setContentHeight(this.contheight);
                this.areaCurrent.setScaling(this.scaling);
                this.areaCurrent.setAlign(n);
                this.areaCurrent.setVerticalAlign(n2);
                this.areaCurrent.setOverflow(n3);
                this.areaCurrent.setSizeAuto(this.wauto, this.hauto);
                this.areaCurrent.setContentSizeAuto(this.cwauto, this.chauto);
                this.areaCurrent.setPage(area.getPage());
                int n4 = this.children.size();
                if (n4 > 1) {
                    throw new FOPException("Only one child element is allowed in an instream-foreign-object");
                }
                if (this.children.size() > 0) {
                    FONode fONode = (FONode)this.children.elementAt(0);
                    Status status = fONode.layout(this.areaCurrent);
                    if (status.isIncomplete()) {
                        return status;
                    }
                    this.areaCurrent.end();
                }
            }
            this.marker = 0;
            if (this.breakBefore == 58 || this.spaceBefore + this.areaCurrent.getEffectiveHeight() > area.spaceLeft()) {
                return new Status(4);
            }
            if (this.breakBefore == 55) {
                return new Status(6);
            }
            if (this.breakBefore == 26) {
                return new Status(5);
            }
        }
        if (this.areaCurrent == null) {
            return new Status(1);
        }
        if (area instanceof BlockArea) {
            object2 = (BlockArea)area;
            object = ((BlockArea)object2).getCurrentLineArea();
            if (object == null) {
                return new Status(2);
            }
            ((LineArea)object).addPending();
            if (this.areaCurrent.getEffectiveWidth() > ((LineArea)object).getRemainingWidth() && (object = ((BlockArea)object2).createNextLineArea()) == null) {
                return new Status(2);
            }
            ((LineArea)object).addInlineArea(this.areaCurrent);
        } else {
            area.addChild(this.areaCurrent);
            area.increaseHeight(this.areaCurrent.getEffectiveHeight());
        }
        if (this.isInTableCell) {
            this.startIndent += this.forcedStartOffset;
        }
        this.areaCurrent.setStartIndent(this.startIndent);
        this.areaCurrent.setPage(area.getPage());
        if (this.breakAfter == 58) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 55) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 26) {
            this.marker = -1001;
            return new Status(5);
        }
        this.areaCurrent = null;
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new InstreamForeignObject(fObj, propertyList);
        }
    }
}

