/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.StreamRenderer;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.fo.DirectPropertyListBuilder;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyListBuilder;
import org.apache.fop.fo.TreeBuilder;
import org.apache.fop.fo.Unknown;
import org.apache.fop.fo.UnknownXMLObj;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.system.BufferManager;
import org.apache.log.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FOTreeBuilder
extends DefaultHandler
implements TreeBuilder {
    protected HashMap fobjTable = new HashMap();
    protected Vector namespaces = new Vector();
    protected HashMap propertylistTable = new HashMap();
    protected FObj currentFObj = null;
    protected FObj rootFObj = null;
    public BufferManager bufferManager;
    protected HashMap unknownFOs = new HashMap();
    private StreamRenderer streamRenderer;
    private Logger log;

    public void addElementPropertyList(String string, String string2, HashMap hashMap) {
        PropertyListBuilder propertyListBuilder = (PropertyListBuilder)this.propertylistTable.get(string);
        if (propertyListBuilder == null) {
            propertyListBuilder = new PropertyListBuilder();
            propertyListBuilder.addElementList(string2, hashMap);
            this.propertylistTable.put(string, propertyListBuilder);
        } else {
            propertyListBuilder.addElementList(string2, hashMap);
        }
    }

    public void addMapping(String string, HashMap hashMap) {
        this.fobjTable.put(string, hashMap);
        this.namespaces.addElement(string.intern());
    }

    public void addPropertyList(String string, HashMap hashMap) {
        PropertyListBuilder propertyListBuilder = (PropertyListBuilder)this.propertylistTable.get(string);
        if (propertyListBuilder == null) {
            propertyListBuilder = new PropertyListBuilder();
            propertyListBuilder.addList(hashMap);
            this.propertylistTable.put(string, propertyListBuilder);
        } else {
            propertyListBuilder.addList(hashMap);
        }
    }

    public void addPropertyListBuilder(String string, PropertyListBuilder propertyListBuilder) {
        PropertyListBuilder propertyListBuilder2 = (PropertyListBuilder)this.propertylistTable.get(string);
        if (propertyListBuilder2 == null) {
            this.propertylistTable.put(string, propertyListBuilder);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.currentFObj != null) {
            this.currentFObj.addCharacters(cArray, n, n + n2);
        }
    }

    public void endDocument() throws SAXException {
        this.log.info("Parsing of document complete, stopping renderer");
        this.streamRenderer.stopRenderer();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.currentFObj.end();
        if (this.currentFObj instanceof PageSequence) {
            this.streamRenderer.render((PageSequence)this.currentFObj);
        } else if (this.currentFObj instanceof ExtensionObj && !(this.currentFObj.getParent() instanceof ExtensionObj)) {
            this.streamRenderer.addExtension((ExtensionObj)this.currentFObj);
        }
        this.currentFObj = this.currentFObj.getParent();
    }

    public StreamRenderer getStreamRenderer() {
        return this.streamRenderer;
    }

    public boolean hasData() {
        return this.rootFObj != null;
    }

    public void reset() {
        this.currentFObj = null;
        this.rootFObj = null;
        this.streamRenderer = null;
    }

    public void setBufferManager(BufferManager bufferManager) {
        this.bufferManager = bufferManager;
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void setStreamRenderer(StreamRenderer streamRenderer) {
        this.streamRenderer = streamRenderer;
    }

    public void startDocument() throws SAXException {
        this.rootFObj = null;
        this.log.info("building formatting object tree");
        this.streamRenderer.startRenderer();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        FObj fObj;
        Object object;
        FObj.Maker maker = null;
        HashMap hashMap = (HashMap)this.fobjTable.get(string);
        if (hashMap != null) {
            maker = (FObj.Maker)hashMap.get(string2);
        }
        PropertyListBuilder propertyListBuilder = (PropertyListBuilder)this.propertylistTable.get(string);
        boolean bl = false;
        if (maker == null) {
            object = String.valueOf(string) + "^" + string2;
            if (!this.unknownFOs.containsKey(object)) {
                this.unknownFOs.put(object, "");
                this.log.error("Unknown formatting object " + (String)object);
            }
            if (this.namespaces.contains(string.intern())) {
                maker = new Unknown.Maker();
            } else {
                maker = new UnknownXMLObj.Maker(string, string2);
                bl = true;
            }
        }
        try {
            object = null;
            if (propertyListBuilder != null) {
                object = propertyListBuilder.makeList(string, string2, attributes, this.currentFObj == null ? null : this.currentFObj.properties, this.currentFObj);
            } else if (bl) {
                object = new DirectPropertyListBuilder.AttrPropertyList(attributes);
            } else {
                if (this.currentFObj == null) {
                    throw new FOPException("Invalid XML or missing namespace");
                }
                object = this.currentFObj.properties;
            }
            fObj = maker.make(this.currentFObj, (PropertyList)object);
            fObj.setLogger(this.log);
        }
        catch (FOPException fOPException) {
            throw new SAXException(fOPException);
        }
        if (this.rootFObj == null) {
            this.rootFObj = fObj;
            this.rootFObj.setBufferManager(this.bufferManager);
            if (!fObj.getName().equals("fo:root")) {
                throw new SAXException(new FOPException("Root element must be root, not " + fObj.getName()));
            }
        } else if (!(fObj instanceof PageSequence)) {
            this.currentFObj.addChild(fObj);
        }
        this.currentFObj = fObj;
    }
}

